/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.ImplementedBy;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.ConstantFactory;
import com.google.inject.internal.ConstructorBindingImpl;
import com.google.inject.internal.ConstructorInjectorStore;
import com.google.inject.internal.DeferredLookups;
import com.google.inject.internal.DelayedInitialize;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.FactoryProxy;
import com.google.inject.internal.Initializables;
import com.google.inject.internal.InstanceBindingImpl;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.InternalFactory;
import com.google.inject.internal.InternalInjectorCreator;
import com.google.inject.internal.InternalProvisionException;
import com.google.inject.internal.LinkedBindingImpl;
import com.google.inject.internal.LinkedProviderBindingImpl;
import com.google.inject.internal.Lookups;
import com.google.inject.internal.MembersInjectorImpl;
import com.google.inject.internal.MembersInjectorStore;
import com.google.inject.internal.MoreTypes;
import com.google.inject.internal.ProvidedByInternalFactory;
import com.google.inject.internal.ProvisionListenerCallbackStore;
import com.google.inject.internal.Scoping;
import com.google.inject.internal.SingleParameterInjector;
import com.google.inject.internal.State;
import com.google.inject.internal.util.SourceProvider;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class InjectorImpl
implements Injector,
Lookups {
    public static final TypeLiteral<String> STRING_TYPE = TypeLiteral.get(String.class);
    final State state;
    final InjectorImpl parent;
    final ListMultimap<TypeLiteral<?>, Binding<?>> bindingsMultimap = ArrayListMultimap.create();
    final InjectorOptions options;
    final Map<Key<?>, BindingImpl<?>> jitBindings = Maps.newHashMap();
    final Set<Key<?>> failedJitBindings = Sets.newHashSet();
    Lookups lookups = new DeferredLookups(this);
    final ConstructorInjectorStore constructors = new ConstructorInjectorStore(this);
    MembersInjectorStore membersInjectorStore;
    ProvisionListenerCallbackStore provisionListenerStore;
    private final ThreadLocal<Object[]> localContext;

    InjectorImpl(InjectorImpl parent2, State state, InjectorOptions injectorOptions) {
        this.parent = parent2;
        this.state = state;
        this.options = injectorOptions;
        this.localContext = parent2 != null ? parent2.localContext : new ThreadLocal();
    }

    void index() {
        for (Binding<?> binding2 : this.state.getExplicitBindingsThisLevel().values()) {
            this.bindingsMultimap.put(binding2.getKey().getTypeLiteral(), binding2);
        }
    }

    @Override
    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type2) {
        List<Binding<?>> list = this.bindingsMultimap.get(type2);
        return Collections.unmodifiableList(list);
    }

    public <T> BindingImpl<T> getBinding(Key<T> key2) {
        Errors errors = new Errors(key2);
        try {
            BindingImpl<T> result = this.getBindingOrThrow(key2, errors, JitLimitation.EXISTING_JIT);
            errors.throwConfigurationExceptionIfErrorsExist();
            return result;
        }
        catch (ErrorsException e2) {
            throw new ConfigurationException(errors.merge(e2.getErrors()).getMessages());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BindingImpl<T> getExistingBinding(Key<T> key2) {
        BindingImpl<T> explicitBinding = this.state.getExplicitBinding(key2);
        if (explicitBinding != null) {
            return explicitBinding;
        }
        Object object = this.state.lock();
        synchronized (object) {
            InjectorImpl injector = this;
            while (injector != null) {
                BindingImpl<?> jitBinding = injector.jitBindings.get(key2);
                if (jitBinding != null) {
                    return jitBinding;
                }
                injector = injector.parent;
            }
        }
        if (InjectorImpl.isProvider(key2)) {
            try {
                Key<T> providedKey = InjectorImpl.getProvidedKey(key2, new Errors());
                if (this.getExistingBinding((Key)providedKey) != null) {
                    return this.getBinding((Key)key2);
                }
            }
            catch (ErrorsException e2) {
                throw new ConfigurationException(e2.getErrors().getMessages());
            }
        }
        return null;
    }

    <T> BindingImpl<T> getBindingOrThrow(Key<T> key2, Errors errors, JitLimitation jitType) throws ErrorsException {
        BindingImpl<T> binding2 = this.state.getExplicitBinding(key2);
        if (binding2 != null) {
            return binding2;
        }
        return this.getJustInTimeBinding(key2, errors, jitType);
    }

    @Override
    public <T> Binding<T> getBinding(Class<T> type2) {
        return this.getBinding((Key)Key.get(type2));
    }

    @Override
    public Injector getParent() {
        return this.parent;
    }

    @Override
    public Injector createChildInjector(Iterable<? extends Module> modules) {
        return new InternalInjectorCreator().parentInjector(this).addModules(modules).build();
    }

    @Override
    public Injector createChildInjector(Module ... modules) {
        return this.createChildInjector(ImmutableList.copyOf(modules));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BindingImpl<T> getJustInTimeBinding(Key<T> key2, Errors errors, JitLimitation jitType) throws ErrorsException {
        boolean jitOverride = InjectorImpl.isProvider(key2) || InjectorImpl.isTypeLiteral(key2) || InjectorImpl.isMembersInjector(key2);
        Object object = this.state.lock();
        synchronized (object) {
            InjectorImpl injector = this;
            while (injector != null) {
                BindingImpl<?> binding2 = injector.jitBindings.get(key2);
                if (binding2 != null) {
                    if (this.options.jitDisabled && jitType == JitLimitation.NO_JIT && !jitOverride && !(binding2 instanceof ConvertedConstantBindingImpl)) {
                        throw errors.jitDisabled(key2).toException();
                    }
                    return binding2;
                }
                injector = injector.parent;
            }
            if (this.failedJitBindings.contains(key2) && errors.hasErrors()) {
                throw errors.toException();
            }
            return this.createJustInTimeBindingRecursive(key2, errors, this.options.jitDisabled, jitType);
        }
    }

    private static boolean isProvider(Key<?> key2) {
        return key2.getTypeLiteral().getRawType().equals(Provider.class);
    }

    private static boolean isTypeLiteral(Key<?> key2) {
        return key2.getTypeLiteral().getRawType().equals(TypeLiteral.class);
    }

    private static <T> Key<T> getProvidedKey(Key<Provider<T>> key2, Errors errors) throws ErrorsException {
        Type providerType = key2.getTypeLiteral().getType();
        if (!(providerType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawProvider().toException();
        }
        Type entryType = ((ParameterizedType)providerType).getActualTypeArguments()[0];
        Key<?> providedKey = key2.ofType(entryType);
        return providedKey;
    }

    private static boolean isMembersInjector(Key<?> key2) {
        return key2.getTypeLiteral().getRawType().equals(MembersInjector.class) && key2.getAnnotationType() == null;
    }

    private <T> BindingImpl<MembersInjector<T>> createMembersInjectorBinding(Key<MembersInjector<T>> key2, Errors errors) throws ErrorsException {
        Type membersInjectorType = key2.getTypeLiteral().getType();
        if (!(membersInjectorType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawMembersInjector().toException();
        }
        TypeLiteral<?> instanceType = TypeLiteral.get(((ParameterizedType)membersInjectorType).getActualTypeArguments()[0]);
        MembersInjectorImpl<?> membersInjector = this.membersInjectorStore.get(instanceType, errors);
        ConstantFactory factory = new ConstantFactory(Initializables.of(membersInjector));
        return new InstanceBindingImpl<MembersInjector<T>>(this, key2, SourceProvider.UNKNOWN_SOURCE, factory, ImmutableSet.of(), membersInjector);
    }

    private <T> BindingImpl<Provider<T>> createProviderBinding(Key<Provider<T>> key2, Errors errors) throws ErrorsException {
        Key<T> providedKey = InjectorImpl.getProvidedKey(key2, errors);
        BindingImpl<T> delegate = this.getBindingOrThrow(providedKey, errors, JitLimitation.NO_JIT);
        return new ProviderBindingImpl<T>(this, key2, delegate);
    }

    private <T> BindingImpl<T> convertConstantStringBinding(Key<T> key2, Errors errors) throws ErrorsException {
        Key<String> stringKey = key2.ofType(STRING_TYPE);
        BindingImpl<String> stringBinding = this.state.getExplicitBinding(stringKey);
        if (stringBinding == null || !stringBinding.isConstant()) {
            return null;
        }
        String stringValue = (String)((InstanceBinding)((Object)stringBinding)).getInstance();
        Object source2 = stringBinding.getSource();
        TypeLiteral<T> type2 = key2.getTypeLiteral();
        TypeConverterBinding typeConverterBinding = this.state.getConverter(stringValue, type2, errors, source2);
        if (typeConverterBinding == null) {
            return null;
        }
        try {
            Object converted = typeConverterBinding.getTypeConverter().convert(stringValue, type2);
            if (converted == null) {
                throw errors.converterReturnedNull(stringValue, source2, type2, typeConverterBinding).toException();
            }
            if (!type2.getRawType().isInstance(converted)) {
                throw errors.conversionTypeError(stringValue, source2, type2, typeConverterBinding, converted).toException();
            }
            return new ConvertedConstantBindingImpl<Object>(this, key2, converted, stringBinding, typeConverterBinding);
        }
        catch (ErrorsException e2) {
            throw e2;
        }
        catch (RuntimeException e3) {
            throw errors.conversionError(stringValue, source2, type2, typeConverterBinding, e3).toException();
        }
    }

    <T> void initializeBinding(BindingImpl<T> binding2, Errors errors) throws ErrorsException {
        if (binding2 instanceof DelayedInitialize) {
            ((DelayedInitialize)((Object)binding2)).initialize(this, errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void initializeJitBinding(BindingImpl<T> binding2, Errors errors) throws ErrorsException {
        if (binding2 instanceof DelayedInitialize) {
            Key<T> key2 = binding2.getKey();
            this.jitBindings.put(key2, binding2);
            boolean successful = false;
            DelayedInitialize delayed = (DelayedInitialize)((Object)binding2);
            try {
                delayed.initialize(this, errors);
                successful = true;
            }
            finally {
                if (!successful) {
                    this.removeFailedJitBinding(binding2, null);
                    this.cleanup(binding2, new HashSet<Key>());
                }
            }
        }
    }

    private boolean cleanup(BindingImpl<?> binding2, Set<Key> encountered) {
        boolean bindingFailed = false;
        Set<Dependency<?>> deps = this.getInternalDependencies(binding2);
        for (Dependency<?> dep : deps) {
            Key<?> depKey = dep.getKey();
            InjectionPoint ip = dep.getInjectionPoint();
            if (!encountered.add(depKey)) continue;
            BindingImpl<?> depBinding = this.jitBindings.get(depKey);
            if (depBinding != null) {
                boolean failed = this.cleanup(depBinding, encountered);
                if (depBinding instanceof ConstructorBindingImpl) {
                    ConstructorBindingImpl ctorBinding = (ConstructorBindingImpl)depBinding;
                    ip = ctorBinding.getInternalConstructor();
                    if (!ctorBinding.isInitialized()) {
                        failed = true;
                    }
                }
                if (!failed) continue;
                this.removeFailedJitBinding(depBinding, ip);
                bindingFailed = true;
                continue;
            }
            if (this.state.getExplicitBinding(depKey) != null) continue;
            bindingFailed = true;
        }
        return bindingFailed;
    }

    private void removeFailedJitBinding(Binding<?> binding2, InjectionPoint ip) {
        this.failedJitBindings.add(binding2.getKey());
        this.jitBindings.remove(binding2.getKey());
        this.membersInjectorStore.remove(binding2.getKey().getTypeLiteral());
        this.provisionListenerStore.remove(binding2);
        if (ip != null) {
            this.constructors.remove(ip);
        }
    }

    private Set<Dependency<?>> getInternalDependencies(BindingImpl<?> binding2) {
        if (binding2 instanceof ConstructorBindingImpl) {
            return ((ConstructorBindingImpl)binding2).getInternalDependencies();
        }
        if (binding2 instanceof HasDependencies) {
            return ((HasDependencies)((Object)binding2)).getDependencies();
        }
        return ImmutableSet.of();
    }

    <T> BindingImpl<T> createUninitializedBinding(Key<T> key2, Scoping scoping, Object source2, Errors errors, boolean jitBinding) throws ErrorsException {
        Class<T> rawType = key2.getTypeLiteral().getRawType();
        ImplementedBy implementedBy = rawType.getAnnotation(ImplementedBy.class);
        if (rawType.isArray() || rawType.isEnum() && implementedBy != null) {
            throw errors.missingImplementationWithHint(key2, this).toException();
        }
        if (rawType == TypeLiteral.class) {
            BindingImpl<TypeLiteral<T>> binding2 = this.createTypeLiteralBinding(key2, errors);
            return binding2;
        }
        if (implementedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source2, errors);
            return this.createImplementedByBinding(key2, scoping, implementedBy, errors);
        }
        ProvidedBy providedBy = rawType.getAnnotation(ProvidedBy.class);
        if (providedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source2, errors);
            return this.createProvidedByBinding(key2, scoping, providedBy, errors);
        }
        return ConstructorBindingImpl.create(this, key2, null, source2, scoping, errors, jitBinding && this.options.jitDisabled, this.options.atInjectRequired);
    }

    private <T> BindingImpl<TypeLiteral<T>> createTypeLiteralBinding(Key<TypeLiteral<T>> key2, Errors errors) throws ErrorsException {
        Type typeLiteralType = key2.getTypeLiteral().getType();
        if (!(typeLiteralType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawTypeLiteral().toException();
        }
        ParameterizedType parameterizedType = (ParameterizedType)typeLiteralType;
        Type innerType = parameterizedType.getActualTypeArguments()[0];
        if (!(innerType instanceof Class || innerType instanceof GenericArrayType || innerType instanceof ParameterizedType)) {
            throw errors.cannotInjectTypeLiteralOf(innerType).toException();
        }
        TypeLiteral<?> value = TypeLiteral.get(innerType);
        ConstantFactory factory = new ConstantFactory(Initializables.of(value));
        return new InstanceBindingImpl<TypeLiteral<T>>(this, key2, SourceProvider.UNKNOWN_SOURCE, factory, ImmutableSet.of(), value);
    }

    <T> BindingImpl<T> createProvidedByBinding(Key<T> key2, Scoping scoping, ProvidedBy providedBy, Errors errors) throws ErrorsException {
        Class<T> rawType = key2.getTypeLiteral().getRawType();
        Class<? extends javax.inject.Provider<?>> providerType = providedBy.value();
        if (providerType == rawType) {
            throw errors.recursiveProviderType().toException();
        }
        Key<? extends javax.inject.Provider<?>> providerKey = Key.get(providerType);
        ProvidedByInternalFactory<T> internalFactory = new ProvidedByInternalFactory<T>(rawType, providerType, providerKey);
        Class<T> source2 = rawType;
        LinkedProviderBindingImpl<T> binding2 = LinkedProviderBindingImpl.createWithInitializer(this, key2, source2, Scoping.scope(key2, this, internalFactory, source2, scoping), scoping, providerKey, internalFactory);
        internalFactory.setProvisionListenerCallback(this.provisionListenerStore.get(binding2));
        return binding2;
    }

    private <T> BindingImpl<T> createImplementedByBinding(Key<T> key2, Scoping scoping, ImplementedBy implementedBy, Errors errors) throws ErrorsException {
        Class<T> rawType = key2.getTypeLiteral().getRawType();
        Class<?> implementationType = implementedBy.value();
        if (implementationType == rawType) {
            throw errors.recursiveImplementationType().toException();
        }
        if (!rawType.isAssignableFrom(implementationType)) {
            throw errors.notASubtype(implementationType, rawType).toException();
        }
        Class<?> subclass = implementationType;
        Key<?> targetKey = Key.get(subclass);
        Class<T> source2 = rawType;
        FactoryProxy<T> factory = new FactoryProxy<T>(this, key2, targetKey, source2);
        factory.notify(errors);
        return new LinkedBindingImpl<T>(this, key2, source2, Scoping.scope(key2, this, factory, source2, scoping), scoping, targetKey);
    }

    private <T> BindingImpl<T> createJustInTimeBindingRecursive(Key<T> key2, Errors errors, boolean jitDisabled, JitLimitation jitType) throws ErrorsException {
        if (this.parent != null) {
            if (jitType == JitLimitation.NEW_OR_EXISTING_JIT && jitDisabled && !this.parent.options.jitDisabled) {
                throw errors.jitDisabledInParent(key2).toException();
            }
            try {
                return this.parent.createJustInTimeBindingRecursive(key2, new Errors(), jitDisabled, this.parent.options.jitDisabled ? JitLimitation.NO_JIT : jitType);
            }
            catch (ErrorsException errorsException) {
                // empty catch block
            }
        }
        Set<Object> sources = this.state.getSourcesForBlacklistedKey(key2);
        if (this.state.isBlacklisted(key2)) {
            throw errors.childBindingAlreadySet(key2, sources).toException();
        }
        key2 = MoreTypes.canonicalizeKey(key2);
        BindingImpl<T> binding2 = this.createJustInTimeBinding(key2, errors, jitDisabled, jitType);
        this.state.parent().blacklist(key2, this.state, binding2.getSource());
        this.jitBindings.put(key2, binding2);
        return binding2;
    }

    private <T> BindingImpl<T> createJustInTimeBinding(Key<T> key2, Errors errors, boolean jitDisabled, JitLimitation jitType) throws ErrorsException {
        int numErrorsBefore = errors.size();
        Set<Object> sources = this.state.getSourcesForBlacklistedKey(key2);
        if (this.state.isBlacklisted(key2)) {
            throw errors.childBindingAlreadySet(key2, sources).toException();
        }
        if (InjectorImpl.isProvider(key2)) {
            BindingImpl<Provider<T>> binding2 = this.createProviderBinding(key2, errors);
            return binding2;
        }
        if (InjectorImpl.isMembersInjector(key2)) {
            BindingImpl<MembersInjector<T>> binding3 = this.createMembersInjectorBinding(key2, errors);
            return binding3;
        }
        BindingImpl<Provider<T>> convertedBinding = this.convertConstantStringBinding(key2, errors);
        if (convertedBinding != null) {
            return convertedBinding;
        }
        if (!InjectorImpl.isTypeLiteral(key2) && jitDisabled && jitType != JitLimitation.NEW_OR_EXISTING_JIT) {
            throw errors.jitDisabled(key2).toException();
        }
        if (key2.getAnnotationType() != null) {
            if (key2.hasAttributes() && !this.options.exactBindingAnnotationsRequired) {
                try {
                    Errors ignored = new Errors();
                    return this.getBindingOrThrow(key2.withoutAttributes(), ignored, JitLimitation.NO_JIT);
                }
                catch (ErrorsException ignored) {
                    // empty catch block
                }
            }
            throw errors.missingImplementationWithHint(key2, this).toException();
        }
        Class<Provider<T>> source2 = key2.getTypeLiteral().getRawType();
        BindingImpl<Provider<T>> binding4 = this.createUninitializedBinding(key2, Scoping.UNSCOPED, source2, errors, true);
        errors.throwIfNewErrors(numErrorsBefore);
        this.initializeJitBinding(binding4, errors);
        return binding4;
    }

    <T> InternalFactory<? extends T> getInternalFactory(Key<T> key2, Errors errors, JitLimitation jitType) throws ErrorsException {
        return this.getBindingOrThrow(key2, errors, jitType).getInternalFactory();
    }

    @Override
    public Map<Key<?>, Binding<?>> getBindings() {
        return this.state.getExplicitBindingsThisLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Key<?>, Binding<?>> getAllBindings() {
        Object object = this.state.lock();
        synchronized (object) {
            return new ImmutableMap.Builder().putAll(this.state.getExplicitBindingsThisLevel()).putAll(this.jitBindings).build();
        }
    }

    @Override
    public Map<Class<? extends Annotation>, Scope> getScopeBindings() {
        return ImmutableMap.copyOf(this.state.getScopes());
    }

    @Override
    public Set<TypeConverterBinding> getTypeConverterBindings() {
        return ImmutableSet.copyOf(this.state.getConvertersThisLevel());
    }

    SingleParameterInjector<?>[] getParametersInjectors(List<Dependency<?>> parameters, Errors errors) throws ErrorsException {
        if (parameters.isEmpty()) {
            return null;
        }
        int numErrorsBefore = errors.size();
        SingleParameterInjector[] result = new SingleParameterInjector[parameters.size()];
        int i = 0;
        for (Dependency<?> parameter : parameters) {
            try {
                result[i++] = this.createParameterInjector(parameter, errors.withSource(parameter));
            }
            catch (ErrorsException errorsException) {}
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return result;
    }

    <T> SingleParameterInjector<T> createParameterInjector(Dependency<T> dependency, Errors errors) throws ErrorsException {
        BindingImpl<T> binding2 = this.getBindingOrThrow(dependency.getKey(), errors, JitLimitation.NO_JIT);
        return new SingleParameterInjector<T>(dependency, binding2);
    }

    @Override
    public void injectMembers(Object instance) {
        MembersInjector<?> membersInjector = this.getMembersInjector(instance.getClass());
        membersInjector.injectMembers(instance);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        Errors errors = new Errors(typeLiteral);
        try {
            return this.membersInjectorStore.get(typeLiteral, errors);
        }
        catch (ErrorsException e2) {
            throw new ConfigurationException(errors.merge(e2.getErrors()).getMessages());
        }
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type2) {
        return this.getMembersInjector(TypeLiteral.get(type2));
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type2) {
        return this.getProvider(Key.get(type2));
    }

    <T> Provider<T> getProviderOrThrow(final Dependency<T> dependency, Errors errors) throws ErrorsException {
        Key<T> key2 = dependency.getKey();
        BindingImpl<T> binding2 = this.getBindingOrThrow(key2, errors, JitLimitation.NO_JIT);
        final InternalFactory<T> internalFactory = binding2.getInternalFactory();
        final Object source2 = binding2.getSource();
        return new Provider<T>(){

            @Override
            public T get() {
                InternalContext currentContext = InjectorImpl.this.enterContext();
                Dependency<?> previous = currentContext.pushDependency(dependency, source2);
                try {
                    Object t;
                    Object t2 = t = internalFactory.get(currentContext, dependency, false);
                    return t2;
                }
                catch (InternalProvisionException e2) {
                    throw e2.addSource(dependency).toProvisionException();
                }
                finally {
                    currentContext.popStateAndSetDependency(previous);
                    currentContext.close();
                }
            }

            public String toString() {
                return internalFactory.toString();
            }
        };
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key2) {
        Errors errors = new Errors(key2);
        try {
            Provider<T> result = this.getProviderOrThrow(Dependency.get(key2), errors);
            errors.throwIfNewErrors(0);
            return result;
        }
        catch (ErrorsException e2) {
            throw new ConfigurationException(errors.merge(e2.getErrors()).getMessages());
        }
    }

    @Override
    public <T> T getInstance(Key<T> key2) {
        return this.getProvider(key2).get();
    }

    @Override
    public <T> T getInstance(Class<T> type2) {
        return this.getProvider(type2).get();
    }

    InternalContext getLocalContext() {
        return (InternalContext)this.localContext.get()[0];
    }

    InternalContext enterContext() {
        InternalContext ctx;
        Object[] reference = this.localContext.get();
        if (reference == null) {
            reference = new Object[1];
            this.localContext.set(reference);
        }
        if ((ctx = (InternalContext)reference[0]) == null) {
            ctx = new InternalContext(this.options, reference);
            reference[0] = ctx;
        } else {
            ctx.enter();
        }
        return ctx;
    }

    public String toString() {
        return MoreObjects.toStringHelper(Injector.class).add("bindings", this.state.getExplicitBindingsThisLevel().values()).toString();
    }

    static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2) throws IllegalAccessException, InvocationTargetException;
    }

    private static class ConvertedConstantBindingImpl<T>
    extends BindingImpl<T>
    implements ConvertedConstantBinding<T> {
        final T value;
        final Provider<T> provider;
        final Binding<String> originalBinding;
        final TypeConverterBinding typeConverterBinding;

        ConvertedConstantBindingImpl(InjectorImpl injector, Key<T> key2, T value, Binding<String> originalBinding, TypeConverterBinding typeConverterBinding) {
            super(injector, key2, originalBinding.getSource(), new ConstantFactory<T>(Initializables.of(value)), Scoping.UNSCOPED);
            this.value = value;
            this.provider = Providers.of(value);
            this.originalBinding = originalBinding;
            this.typeConverterBinding = typeConverterBinding;
        }

        @Override
        public Provider<T> getProvider() {
            return this.provider;
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
            return visitor.visit(this);
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public TypeConverterBinding getTypeConverterBinding() {
            return this.typeConverterBinding;
        }

        @Override
        public Key<String> getSourceKey() {
            return this.originalBinding.getKey();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return ImmutableSet.of(Dependency.get(this.getSourceKey()));
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(ConvertedConstantBinding.class).add("key", this.getKey()).add("sourceKey", this.getSourceKey()).add("value", this.value).toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConvertedConstantBindingImpl) {
                ConvertedConstantBindingImpl o = (ConvertedConstantBindingImpl)obj;
                return this.getKey().equals(o.getKey()) && this.getScoping().equals(o.getScoping()) && Objects.equal(this.value, o.value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.getKey(), this.getScoping(), this.value);
        }
    }

    private static class ProviderBindingImpl<T>
    extends BindingImpl<Provider<T>>
    implements ProviderBinding<Provider<T>>,
    HasDependencies {
        final BindingImpl<T> providedBinding;

        ProviderBindingImpl(InjectorImpl injector, Key<Provider<T>> key2, Binding<T> providedBinding) {
            super(injector, key2, providedBinding.getSource(), ProviderBindingImpl.createInternalFactory(providedBinding), Scoping.UNSCOPED);
            this.providedBinding = (BindingImpl)providedBinding;
        }

        static <T> InternalFactory<Provider<T>> createInternalFactory(Binding<T> providedBinding) {
            final Provider<T> provider = providedBinding.getProvider();
            return new InternalFactory<Provider<T>>(){

                @Override
                public Provider<T> get(InternalContext context, Dependency<?> dependency, boolean linked) {
                    return provider;
                }
            };
        }

        @Override
        public Key<? extends T> getProvidedKey() {
            return this.providedBinding.getKey();
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super Provider<T>, V> visitor) {
            return visitor.visit(this);
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(ProviderBinding.class).add("key", this.getKey()).add("providedKey", this.getProvidedKey()).toString();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return ImmutableSet.of(Dependency.get(this.getProvidedKey()));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProviderBindingImpl) {
                ProviderBindingImpl o = (ProviderBindingImpl)obj;
                return this.getKey().equals(o.getKey()) && this.getScoping().equals(o.getScoping()) && Objects.equal(this.providedBinding, o.providedBinding);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.getKey(), this.getScoping(), this.providedBinding);
        }
    }

    static enum JitLimitation {
        NO_JIT,
        EXISTING_JIT,
        NEW_OR_EXISTING_JIT;

    }

    static class InjectorOptions {
        final Stage stage;
        final boolean jitDisabled;
        final boolean disableCircularProxies;
        final boolean atInjectRequired;
        final boolean exactBindingAnnotationsRequired;

        InjectorOptions(Stage stage, boolean jitDisabled, boolean disableCircularProxies, boolean atInjectRequired, boolean exactBindingAnnotationsRequired) {
            this.stage = stage;
            this.jitDisabled = jitDisabled;
            this.disableCircularProxies = disableCircularProxies;
            this.atInjectRequired = atInjectRequired;
            this.exactBindingAnnotationsRequired = exactBindingAnnotationsRequired;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("stage", (Object)this.stage).add("jitDisabled", this.jitDisabled).add("disableCircularProxies", this.disableCircularProxies).add("atInjectRequired", this.atInjectRequired).add("exactBindingAnnotationsRequired", this.exactBindingAnnotationsRequired).toString();
        }
    }
}

