/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@NullableDecl String string2) {
        return Platform.nullToEmpty(string2);
    }

    @NullableDecl
    public static String emptyToNull(@NullableDecl String string2) {
        return Platform.emptyToNull(string2);
    }

    public static boolean isNullOrEmpty(@NullableDecl String string2) {
        return Platform.stringIsNullOrEmpty(string2);
    }

    public static String padStart(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string2.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string2);
        return sb.toString();
    }

    public static String padEnd(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string2);
        for (int i = string2.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string2, int count2) {
        int n;
        Preconditions.checkNotNull(string2);
        if (count2 <= 1) {
            Preconditions.checkArgument(count2 >= 0, "invalid count: %s", count2);
            return count2 == 0 ? "" : string2;
        }
        int len = string2.length();
        long longSize = (long)len * (long)count2;
        int size2 = (int)longSize;
        if ((long)size2 != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] array2 = new char[size2];
        string2.getChars(0, len, array2, 0);
        for (n = len; n < size2 - n; n <<= 1) {
            System.arraycopy(array2, 0, array2, n, n);
        }
        System.arraycopy(array2, 0, array2, n, size2 - n);
        return new String(array2);
    }

    public static String commonPrefix(CharSequence a, CharSequence b) {
        int p;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxPrefixLength = Math.min(a.length(), b.length());
        for (p = 0; p < maxPrefixLength && a.charAt(p) == b.charAt(p); ++p) {
        }
        if (Strings.validSurrogatePairAt(a, p - 1) || Strings.validSurrogatePairAt(b, p - 1)) {
            --p;
        }
        return a.subSequence(0, p).toString();
    }

    public static String commonSuffix(CharSequence a, CharSequence b) {
        int s;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxSuffixLength = Math.min(a.length(), b.length());
        for (s = 0; s < maxSuffixLength && a.charAt(a.length() - s - 1) == b.charAt(b.length() - s - 1); ++s) {
        }
        if (Strings.validSurrogatePairAt(a, a.length() - s - 1) || Strings.validSurrogatePairAt(b, b.length() - s - 1)) {
            --s;
        }
        return a.subSequence(a.length() - s, a.length()).toString();
    }

    public static String lenientFormat(@NullableDecl String template2, Object ... args) {
        int placeholderStart;
        Object[] objectArray;
        template2 = String.valueOf(template2);
        if (args == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "(Object[])null";
        } else {
            objectArray = args;
        }
        args = objectArray;
        StringBuilder builder = new StringBuilder(template2.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template2.indexOf("%s", templateStart)) != -1) {
            builder.append(template2, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template2, templateStart, template2.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string2, int index2) {
        return index2 >= 0 && index2 <= string2.length() - 2 && Character.isHighSurrogate(string2.charAt(index2)) && Character.isLowSurrogate(string2.charAt(index2 + 1));
    }
}

