/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.APersistentVector;
import clojure.lang.ASeq;
import clojure.lang.ArrayChunk;
import clojure.lang.Counted;
import clojure.lang.IChunk;
import clojure.lang.IChunkedSeq;
import clojure.lang.IDeref;
import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IKVReduce;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.IReduceInit;
import clojure.lang.ISeq;
import clojure.lang.ITransientAssociative2;
import clojure.lang.ITransientVector;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

public class PersistentVector
extends APersistentVector
implements IObj,
IEditableCollection,
IReduce,
IKVReduce {
    static final AtomicReference<Thread> NOEDIT = new AtomicReference<Object>(null);
    public static final Node EMPTY_NODE = new Node(NOEDIT, new Object[32]);
    final int cnt;
    public final int shift;
    public final Node root;
    public final Object[] tail;
    final IPersistentMap _meta;
    public static final PersistentVector EMPTY = new PersistentVector(0, 5, EMPTY_NODE, new Object[0]);
    private static final IFn TRANSIENT_VECTOR_CONJ = new AFn(){

        @Override
        public Object invoke(Object coll, Object val2) {
            return ((ITransientVector)coll).conj(val2);
        }

        @Override
        public Object invoke(Object coll) {
            return coll;
        }
    };

    public static PersistentVector adopt(Object[] items) {
        return new PersistentVector(items.length, 5, EMPTY_NODE, items);
    }

    public static PersistentVector create(IReduceInit items) {
        TransientVector ret = EMPTY.asTransient();
        items.reduce(TRANSIENT_VECTOR_CONJ, ret);
        return ret.persistent();
    }

    public static PersistentVector create(ISeq items) {
        Object[] arr = new Object[32];
        int i = 0;
        while (items != null && i < 32) {
            arr[i++] = items.first();
            items = items.next();
        }
        if (items != null) {
            PersistentVector start = new PersistentVector(32, 5, EMPTY_NODE, arr);
            TransientVector ret = start.asTransient();
            while (items != null) {
                ret = ret.conj(items.first());
                items = items.next();
            }
            return ret.persistent();
        }
        if (i == 32) {
            return new PersistentVector(32, 5, EMPTY_NODE, arr);
        }
        Object[] arr2 = new Object[i];
        System.arraycopy(arr, 0, arr2, 0, i);
        return new PersistentVector(i, 5, EMPTY_NODE, arr2);
    }

    public static PersistentVector create(List list) {
        int size2 = list.size();
        if (size2 <= 32) {
            return new PersistentVector(size2, 5, EMPTY_NODE, list.toArray());
        }
        TransientVector ret = EMPTY.asTransient();
        for (int i = 0; i < size2; ++i) {
            ret = ret.conj(list.get(i));
        }
        return ret.persistent();
    }

    public static PersistentVector create(Iterable items) {
        if (items instanceof ArrayList) {
            return PersistentVector.create((ArrayList)items);
        }
        Iterator iter = items.iterator();
        TransientVector ret = EMPTY.asTransient();
        while (iter.hasNext()) {
            ret = ret.conj(iter.next());
        }
        return ret.persistent();
    }

    public static PersistentVector create(Object ... items) {
        TransientVector ret = EMPTY.asTransient();
        for (Object item : items) {
            ret = ret.conj(item);
        }
        return ret.persistent();
    }

    PersistentVector(int cnt, int shift, Node root2, Object[] tail) {
        this._meta = null;
        this.cnt = cnt;
        this.shift = shift;
        this.root = root2;
        this.tail = tail;
    }

    PersistentVector(IPersistentMap meta, int cnt, int shift, Node root2, Object[] tail) {
        this._meta = meta;
        this.cnt = cnt;
        this.shift = shift;
        this.root = root2;
        this.tail = tail;
    }

    @Override
    public TransientVector asTransient() {
        return new TransientVector(this);
    }

    final int tailoff() {
        if (this.cnt < 32) {
            return 0;
        }
        return this.cnt - 1 >>> 5 << 5;
    }

    public Object[] arrayFor(int i) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailoff()) {
                return this.tail;
            }
            Node node2 = this.root;
            for (int level = this.shift; level > 0; level -= 5) {
                node2 = (Node)node2.array[i >>> level & 0x1F];
            }
            return node2.array;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object nth(int i) {
        Object[] node2 = this.arrayFor(i);
        return node2[i & 0x1F];
    }

    @Override
    public Object nth(int i, Object notFound) {
        if (i >= 0 && i < this.cnt) {
            return this.nth(i);
        }
        return notFound;
    }

    @Override
    public PersistentVector assocN(int i, Object val2) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailoff()) {
                Object[] newTail = new Object[this.tail.length];
                System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
                newTail[i & 0x1F] = val2;
                return new PersistentVector(this.meta(), this.cnt, this.shift, this.root, newTail);
            }
            return new PersistentVector(this.meta(), this.cnt, this.shift, PersistentVector.doAssoc(this.shift, this.root, i, val2), this.tail);
        }
        if (i == this.cnt) {
            return this.cons(val2);
        }
        throw new IndexOutOfBoundsException();
    }

    private static Node doAssoc(int level, Node node2, int i, Object val2) {
        Node ret = new Node(node2.edit, (Object[])node2.array.clone());
        if (level == 0) {
            ret.array[i & 0x1F] = val2;
        } else {
            int subidx = i >>> level & 0x1F;
            ret.array[subidx] = PersistentVector.doAssoc(level - 5, (Node)node2.array[subidx], i, val2);
        }
        return ret;
    }

    @Override
    public int count() {
        return this.cnt;
    }

    @Override
    public PersistentVector withMeta(IPersistentMap meta) {
        if (this.meta() == meta) {
            return this;
        }
        return new PersistentVector(meta, this.cnt, this.shift, this.root, this.tail);
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    @Override
    public PersistentVector cons(Object val2) {
        Node newroot;
        if (this.cnt - this.tailoff() < 32) {
            Object[] newTail = new Object[this.tail.length + 1];
            System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
            newTail[this.tail.length] = val2;
            return new PersistentVector(this.meta(), this.cnt + 1, this.shift, this.root, newTail);
        }
        Node tailnode = new Node(this.root.edit, this.tail);
        int newshift = this.shift;
        if (this.cnt >>> 5 > 1 << this.shift) {
            newroot = new Node(this.root.edit);
            newroot.array[0] = this.root;
            newroot.array[1] = PersistentVector.newPath(this.root.edit, this.shift, tailnode);
            newshift += 5;
        } else {
            newroot = this.pushTail(this.shift, this.root, tailnode);
        }
        return new PersistentVector(this.meta(), this.cnt + 1, newshift, newroot, new Object[]{val2});
    }

    private Node pushTail(int level, Node parent2, Node tailnode) {
        Node child;
        int subidx = this.cnt - 1 >>> level & 0x1F;
        Node ret = new Node(parent2.edit, (Object[])parent2.array.clone());
        Node nodeToInsert = level == 5 ? tailnode : ((child = (Node)parent2.array[subidx]) != null ? this.pushTail(level - 5, child, tailnode) : PersistentVector.newPath(this.root.edit, level - 5, tailnode));
        ret.array[subidx] = nodeToInsert;
        return ret;
    }

    private static Node newPath(AtomicReference<Thread> edit2, int level, Node node2) {
        if (level == 0) {
            return node2;
        }
        Node ret = new Node(edit2);
        ret.array[0] = PersistentVector.newPath(edit2, level - 5, node2);
        return ret;
    }

    public IChunkedSeq chunkedSeq() {
        if (this.count() == 0) {
            return null;
        }
        return new ChunkedSeq(this, 0, 0);
    }

    @Override
    public ISeq seq() {
        return this.chunkedSeq();
    }

    @Override
    Iterator rangedIterator(final int start, final int end) {
        return new Iterator(){
            int i;
            int base;
            Object[] array;
            {
                this.i = start;
                this.base = this.i - this.i % 32;
                this.array = start < PersistentVector.this.count() ? PersistentVector.this.arrayFor(this.i) : null;
            }

            @Override
            public boolean hasNext() {
                return this.i < end;
            }

            public Object next() {
                if (this.i < end) {
                    if (this.i - this.base == 32) {
                        this.array = PersistentVector.this.arrayFor(this.i);
                        this.base += 32;
                    }
                    return this.array[this.i++ & 0x1F];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator iterator() {
        return this.rangedIterator(0, this.count());
    }

    @Override
    public Object reduce(IFn f) {
        if (this.cnt <= 0) {
            return f.invoke();
        }
        Object init = this.arrayFor(0)[0];
        int step = 0;
        for (int i = 0; i < this.cnt; i += step) {
            int j;
            Object[] array2 = this.arrayFor(i);
            int n = j = i == 0 ? 1 : 0;
            while (j < array2.length) {
                if (RT.isReduced(init = f.invoke(init, array2[j]))) {
                    return ((IDeref)init).deref();
                }
                ++j;
            }
            step = array2.length;
        }
        return init;
    }

    @Override
    public Object reduce(IFn f, Object init) {
        int step = 0;
        for (int i = 0; i < this.cnt; i += step) {
            Object[] array2 = this.arrayFor(i);
            for (int j = 0; j < array2.length; ++j) {
                if (!RT.isReduced(init = f.invoke(init, array2[j]))) continue;
                return ((IDeref)init).deref();
            }
            step = array2.length;
        }
        return init;
    }

    @Override
    public Object kvreduce(IFn f, Object init) {
        int step = 0;
        for (int i = 0; i < this.cnt; i += step) {
            Object[] array2 = this.arrayFor(i);
            for (int j = 0; j < array2.length; ++j) {
                if (!RT.isReduced(init = f.invoke(init, j + i, array2[j]))) continue;
                return ((IDeref)init).deref();
            }
            step = array2.length;
        }
        return init;
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentVector pop() {
        if (this.cnt == 0) {
            throw new IllegalStateException("Can't pop empty vector");
        }
        if (this.cnt == 1) {
            return EMPTY.withMeta(this.meta());
        }
        if (this.cnt - this.tailoff() > 1) {
            Object[] newTail = new Object[this.tail.length - 1];
            System.arraycopy(this.tail, 0, newTail, 0, newTail.length);
            return new PersistentVector(this.meta(), this.cnt - 1, this.shift, this.root, newTail);
        }
        Object[] newtail = this.arrayFor(this.cnt - 2);
        Node newroot = this.popTail(this.shift, this.root);
        int newshift = this.shift;
        if (newroot == null) {
            newroot = EMPTY_NODE;
        }
        if (this.shift > 5 && newroot.array[1] == null) {
            newroot = (Node)newroot.array[0];
            newshift -= 5;
        }
        return new PersistentVector(this.meta(), this.cnt - 1, newshift, newroot, newtail);
    }

    private Node popTail(int level, Node node2) {
        int subidx = this.cnt - 2 >>> level & 0x1F;
        if (level > 5) {
            Node newchild = this.popTail(level - 5, (Node)node2.array[subidx]);
            if (newchild == null && subidx == 0) {
                return null;
            }
            Node ret = new Node(this.root.edit, (Object[])node2.array.clone());
            ret.array[subidx] = newchild;
            return ret;
        }
        if (subidx == 0) {
            return null;
        }
        Node ret = new Node(this.root.edit, (Object[])node2.array.clone());
        ret.array[subidx] = null;
        return ret;
    }

    static final class TransientVector
    extends AFn
    implements ITransientVector,
    ITransientAssociative2,
    Counted {
        volatile int cnt;
        volatile int shift;
        volatile Node root;
        volatile Object[] tail;
        private static final Object NOT_FOUND = new Object();

        TransientVector(int cnt, int shift, Node root2, Object[] tail) {
            this.cnt = cnt;
            this.shift = shift;
            this.root = root2;
            this.tail = tail;
        }

        TransientVector(PersistentVector v) {
            this(v.cnt, v.shift, TransientVector.editableRoot(v.root), TransientVector.editableTail(v.tail));
        }

        @Override
        public int count() {
            this.ensureEditable();
            return this.cnt;
        }

        Node ensureEditable(Node node2) {
            if (node2.edit == this.root.edit) {
                return node2;
            }
            return new Node(this.root.edit, (Object[])node2.array.clone());
        }

        void ensureEditable() {
            if (this.root.edit.get() == null) {
                throw new IllegalAccessError("Transient used after persistent! call");
            }
        }

        static Node editableRoot(Node node2) {
            return new Node(new AtomicReference<Thread>(Thread.currentThread()), (Object[])node2.array.clone());
        }

        @Override
        public PersistentVector persistent() {
            this.ensureEditable();
            this.root.edit.set(null);
            Object[] trimmedTail = new Object[this.cnt - this.tailoff()];
            System.arraycopy(this.tail, 0, trimmedTail, 0, trimmedTail.length);
            return new PersistentVector(this.cnt, this.shift, this.root, trimmedTail);
        }

        static Object[] editableTail(Object[] tl) {
            Object[] ret = new Object[32];
            System.arraycopy(tl, 0, ret, 0, tl.length);
            return ret;
        }

        @Override
        public TransientVector conj(Object val2) {
            Node newroot;
            this.ensureEditable();
            int i = this.cnt++;
            if (i - this.tailoff() < 32) {
                this.tail[i & 0x1F] = val2;
                return this;
            }
            Node tailnode = new Node(this.root.edit, this.tail);
            this.tail = new Object[32];
            this.tail[0] = val2;
            int newshift = this.shift;
            if (this.cnt >>> 5 > 1 << this.shift) {
                newroot = new Node(this.root.edit);
                newroot.array[0] = this.root;
                newroot.array[1] = PersistentVector.newPath(this.root.edit, this.shift, tailnode);
                newshift += 5;
            } else {
                newroot = this.pushTail(this.shift, this.root, tailnode);
            }
            this.root = newroot;
            this.shift = newshift;
            ++this.cnt;
            return this;
        }

        private Node pushTail(int level, Node parent2, Node tailnode) {
            Node child;
            parent2 = this.ensureEditable(parent2);
            int subidx = this.cnt - 1 >>> level & 0x1F;
            Node ret = parent2;
            Node nodeToInsert = level == 5 ? tailnode : ((child = (Node)parent2.array[subidx]) != null ? this.pushTail(level - 5, child, tailnode) : PersistentVector.newPath(this.root.edit, level - 5, tailnode));
            ret.array[subidx] = nodeToInsert;
            return ret;
        }

        private final int tailoff() {
            if (this.cnt < 32) {
                return 0;
            }
            return this.cnt - 1 >>> 5 << 5;
        }

        private Object[] arrayFor(int i) {
            if (i >= 0 && i < this.cnt) {
                if (i >= this.tailoff()) {
                    return this.tail;
                }
                Node node2 = this.root;
                for (int level = this.shift; level > 0; level -= 5) {
                    node2 = (Node)node2.array[i >>> level & 0x1F];
                }
                return node2.array;
            }
            throw new IndexOutOfBoundsException();
        }

        private Object[] editableArrayFor(int i) {
            if (i >= 0 && i < this.cnt) {
                if (i >= this.tailoff()) {
                    return this.tail;
                }
                Node node2 = this.root;
                for (int level = this.shift; level > 0; level -= 5) {
                    node2 = this.ensureEditable((Node)node2.array[i >>> level & 0x1F]);
                }
                return node2.array;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object valAt(Object key2) {
            return this.valAt(key2, null);
        }

        @Override
        public Object valAt(Object key2, Object notFound) {
            int i;
            this.ensureEditable();
            if (Util.isInteger(key2) && (i = ((Number)key2).intValue()) >= 0 && i < this.cnt) {
                return this.nth(i);
            }
            return notFound;
        }

        @Override
        public final boolean containsKey(Object key2) {
            return this.valAt(key2, NOT_FOUND) != NOT_FOUND;
        }

        @Override
        public final IMapEntry entryAt(Object key2) {
            Object v = this.valAt(key2, NOT_FOUND);
            if (v != NOT_FOUND) {
                return MapEntry.create(key2, v);
            }
            return null;
        }

        @Override
        public Object invoke(Object arg1) {
            if (Util.isInteger(arg1)) {
                return this.nth(((Number)arg1).intValue());
            }
            throw new IllegalArgumentException("Key must be integer");
        }

        @Override
        public Object nth(int i) {
            this.ensureEditable();
            Object[] node2 = this.arrayFor(i);
            return node2[i & 0x1F];
        }

        @Override
        public Object nth(int i, Object notFound) {
            if (i >= 0 && i < this.count()) {
                return this.nth(i);
            }
            return notFound;
        }

        @Override
        public TransientVector assocN(int i, Object val2) {
            this.ensureEditable();
            if (i >= 0 && i < this.cnt) {
                if (i >= this.tailoff()) {
                    this.tail[i & 0x1F] = val2;
                    return this;
                }
                this.root = this.doAssoc(this.shift, this.root, i, val2);
                return this;
            }
            if (i == this.cnt) {
                return this.conj(val2);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public TransientVector assoc(Object key2, Object val2) {
            if (Util.isInteger(key2)) {
                int i = ((Number)key2).intValue();
                return this.assocN(i, val2);
            }
            throw new IllegalArgumentException("Key must be integer");
        }

        private Node doAssoc(int level, Node node2, int i, Object val2) {
            Node ret = node2 = this.ensureEditable(node2);
            if (level == 0) {
                ret.array[i & 0x1F] = val2;
            } else {
                int subidx = i >>> level & 0x1F;
                ret.array[subidx] = this.doAssoc(level - 5, (Node)node2.array[subidx], i, val2);
            }
            return ret;
        }

        @Override
        public TransientVector pop() {
            this.ensureEditable();
            if (this.cnt == 0) {
                throw new IllegalStateException("Can't pop empty vector");
            }
            if (this.cnt == 1) {
                this.cnt = 0;
                return this;
            }
            int i = this.cnt - 1;
            if ((i & 0x1F) > 0) {
                --this.cnt;
                return this;
            }
            Object[] newtail = this.editableArrayFor(this.cnt - 2);
            Node newroot = this.popTail(this.shift, this.root);
            int newshift = this.shift;
            if (newroot == null) {
                newroot = new Node(this.root.edit);
            }
            if (this.shift > 5 && newroot.array[1] == null) {
                newroot = this.ensureEditable((Node)newroot.array[0]);
                newshift -= 5;
            }
            this.root = newroot;
            this.shift = newshift;
            --this.cnt;
            this.tail = newtail;
            return this;
        }

        private Node popTail(int level, Node node2) {
            node2 = this.ensureEditable(node2);
            int subidx = this.cnt - 2 >>> level & 0x1F;
            if (level > 5) {
                Node newchild = this.popTail(level - 5, (Node)node2.array[subidx]);
                if (newchild == null && subidx == 0) {
                    return null;
                }
                Node ret = node2;
                ret.array[subidx] = newchild;
                return ret;
            }
            if (subidx == 0) {
                return null;
            }
            Node ret = node2;
            ret.array[subidx] = null;
            return ret;
        }
    }

    public static final class ChunkedSeq
    extends ASeq
    implements IChunkedSeq,
    Counted {
        public final PersistentVector vec;
        final Object[] node;
        final int i;
        public final int offset;

        public ChunkedSeq(PersistentVector vec2, int i, int offset) {
            this.vec = vec2;
            this.i = i;
            this.offset = offset;
            this.node = vec2.arrayFor(i);
        }

        ChunkedSeq(IPersistentMap meta, PersistentVector vec2, Object[] node2, int i, int offset) {
            super(meta);
            this.vec = vec2;
            this.node = node2;
            this.i = i;
            this.offset = offset;
        }

        ChunkedSeq(PersistentVector vec2, Object[] node2, int i, int offset) {
            this.vec = vec2;
            this.node = node2;
            this.i = i;
            this.offset = offset;
        }

        @Override
        public IChunk chunkedFirst() {
            return new ArrayChunk(this.node, this.offset);
        }

        @Override
        public ISeq chunkedNext() {
            if (this.i + this.node.length < this.vec.cnt) {
                return new ChunkedSeq(this.vec, this.i + this.node.length, 0);
            }
            return null;
        }

        @Override
        public ISeq chunkedMore() {
            ISeq s = this.chunkedNext();
            if (s == null) {
                return PersistentList.EMPTY;
            }
            return s;
        }

        @Override
        public Obj withMeta(IPersistentMap meta) {
            if (meta == this._meta) {
                return this;
            }
            return new ChunkedSeq(meta, this.vec, this.node, this.i, this.offset);
        }

        @Override
        public Object first() {
            return this.node[this.offset];
        }

        @Override
        public ISeq next() {
            if (this.offset + 1 < this.node.length) {
                return new ChunkedSeq(this.vec, this.node, this.i, this.offset + 1);
            }
            return this.chunkedNext();
        }

        @Override
        public int count() {
            return this.vec.cnt - (this.i + this.offset);
        }
    }

    public static class Node
    implements Serializable {
        public final transient AtomicReference<Thread> edit;
        public final Object[] array;

        public Node(AtomicReference<Thread> edit2, Object[] array2) {
            this.edit = edit2;
            this.array = array2;
        }

        Node(AtomicReference<Thread> edit2) {
            this.edit = edit2;
            this.array = new Object[32];
        }
    }
}

