# polvo/utils

A Clojure library providing some utilities related to cryptoasset markets and exchanges.
Currently, this project holds clients for Binance and Deribit.

## Usage

Add the following to `:dependencies` in your `project.clj`:  

```clojure 
[polvo/utils "0.1.0-SNAPSHOT"]
```

## Binance client

### REST and Withdrawl APIs

```clojure
(require '[polvo.utils.binance :as binance])
```

#### `binance/routes`

Correspondence between keywords and endpoints.

#### `binance/request [route & params]`

A direct interface allowing access to the APIs. Kebab-case params on request are automatically
converted to camel case params (for instance, `:stop-price` becomes `"stopPrice"`).

```clojure
(binance/request :time)
(binance/request :time :as-is?)
(binance/request :account :api-key "<API-KEY>" :api-secret "<API-SECRET>")
(binance/request :ticker-24hr :params {:symbol "BTCUSDT"})
```

#### `binance/client [param-dict & _ :as params]`

A more convenient interface allowing pre-specification of `:api-key`, `:api-secret` 
and `:as-is?` options.

```clojure
(def cli (binance/client :api-key "<API-KEY>" :api-secret "<API-SECRET>"))
(cli :account)
(cli :ticker-24hr {:symbol "BTCUSDT"}) ; passing parameters as a map
(cli :ticker-24hr :symbol "BTCUSDT") ; with a client you can use keyword parameters also

```

### Websocket API

#### `binance/stream [name & opts]`

Connects to a single stream by name. Options are passed to `gniazdo.core/client` (see
[stalefruits/gniazdo](https://github.com/stalefruits/gniazdo)).

```clojure
(binance/stream "btcusdt@depth10" :on-receive f)
```

#### `binance/expand [x]`

Helper for generating multiple stream names. It's used by `binance/streams'

```clojure
(expand [:depth :btcusdt 10])
; => ("btcusdt@depth10")
(expand [:depth [:ethbtc :btcusdt] [5 10]])
; => ("ethbtc@depth5" "ethbtc@depth10" "btcusdt@depth5" "btcusdt@depth10")
```

#### `binance/streams [names & opts]`

Creates a multiplex streams. 

```clojure
(binance/streams ["!miniTicker@arr" "btcusdt@depth"] :on-receive f)
(binance/streams ["!miniTicker@arr" ``
                  [:kline [:btcusdt :ethbtc] [:1m :1h :1d]]] 
                  :on-receive f)
```

#### `binance/user-stream [client & opts]`

A thin wrapper around `binance/stream` that creates a user-stream and
sends a keep-alive every 30 minutes, 47 times. Returns a map with
a `:stream` (as returned by `binance/stream`) and a `:listen-key`.

```clojure
(def cli (binance/client :api-key "<API-KEY>" :api-secret "<API-SECRET>"))
(binance/user-stream cli :on-receive f)
```

## Deribit client

Work in progress...

## License

Copyright © 2019 Polvo Capital. This project is [MIT LICENSED](https://github.com/polvocapital/polvo-utils/blob/master/LICENSE).