(ns polvo.utils.exchanges.mercado-bitcoin
  (:require [clojure.string :as s]
            [clojure.data.json :as json]
            [aleph.http :as http]
            [camel-snake-kebab
             [core :as csk]]
            [manifold
             [deferred :as d]
             [stream :as st]]
            [byte-streams :as bs]))

(def ^:const ^:private base-endpoint "https://www.mercadobitcoin.net/")

(def ^:const coins ["BTC" "LTC" "BCH" "XRP" "ETH"])

(def ^:const routes
  {::ticker      (fn [{:keys [coin] :as m}]
                   (str "api/" (s/upper-case coin) "/ticker/"))

   ::order-book  (fn [{:keys [coin]}]
                   (str "api/" (s/upper-case coin) "/orderbook/"))

   ::trades      (fn [{:keys [coin tid since from to]}]
                   (cond
                     (and from to)
                     (str "api/" (s/upper-case coin) "/trades/" from "/" to)

                     from
                     (str "api/" (s/upper-case coin) "/trades/" from)

                     tid
                     (str "api/" (s/upper-case coin) "/trades/?tid=" tid)

                     since
                     (str "api/" (s/upper-case coin) "/trades/?since=" since)))

   ::day-summary (fn [{:keys [coin year month day]}]
                   (str "api/" (s/upper-case coin) "/day-summary/" year "/" month "/" day))})

(defn- ->key-fn [as-is?] (if as-is? identity csk/->kebab-case-keyword))

(defn http-request
  [route params {:keys [as-is?] :or {as-is? false}}]
  (let [url-fn (routes route)
        url    (str base-endpoint (url-fn params))
        key-fn (->key-fn as-is?)]
    (d/chain (http/get url)
             :body
             bs/to-string
             #(json/read-str % :key-fn key-fn))))

(defn client
  ([]
   (client {}))
  ([opts]
   (fn [route params]
     (http-request route params opts))))