# exchange-utils

[![Clojars Project](https://img.shields.io/clojars/v/polvo/exchange-utils.svg)](https://clojars.org/polvo/exchange-utils)
[![cljdoc badge](https://cljdoc.org/badge/polvo/exchange-utils)](https://cljdoc.org/d/polvo/exchange-utils/CURRENT)

Provides easy-to-use, idiomatic clojure clients for cryptocurrency exchanges.

Right now we have clients for BitMEX, Binance and Deribit.

## General guidelines

This lib leverages [aleph][1] and [manifold][2]. All http/rest client calls return Manifold 
deferreds. All clients have an `as-is?` parameter that control whether to keep response data
as is or to kebab-case transform keys, defaulting to `false`.
 
Http clients take a keyword identifying endpoints and a map of parameters (two for BitMEX). Keywords on requests
will be properly transformed, so you can always use kebab case keywords. Correspondence
between keywords and routes can be found at each namespace's `routes` map.

Websocket clients are manifold duplex streams, so you can send data using `manifold.stream/put!`.
Since it takes some time to establish a connection, websocket client factories return deferreds.

## License

Copyright © 2020 Polvo Technologies.

Distributed under the MIT License.

[1]: https://github.com/ztellman/aleph
[2]: https://github.com/ztellman/manifold