(defproject pleasetrythisathome/tao "0.1.2"
  :description "Two way data binding for browser history"
  :url "http://github.com/pleasetrythisathome/tao"
  :author "Dylan Butman"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :lein-release {:deploy-via :clojars}

  :jvm-opts ^:replace ["-Xms512m" "-Xmx512m" "-server"]

  :source-paths  ["src"]

  :dependencies [[org.clojure/clojure "1.5.1"]
                 [org.clojure/clojurescript "0.0-2173"]
                 [org.clojure/core.async "0.1.278.0-76b25b-alpha"]
                 [secretary "1.1.0"]]

  :cljsbuild {:builds []}
  :profiles {:dev {:resource-paths ["examples"]
                   :source-paths ["examples/tools/http" "examples/tools/repl"]
                   :dependencies [[ring "1.2.1"]
                                  [compojure "1.1.6"]
                                  [enlive "1.1.5"]
                                  [om "0.6.2"]
                                  [sablono "0.2.16"]]
                   :plugins [[lein-cljsbuild "1.0.2"]
                             [com.cemerick/austin "0.1.3"]]
                   :hooks [leiningen.cljsbuild]
                   :cljsbuild {:builds [{:id "basic"
                                         :source-paths ["src"
                                                        "examples/tools/http"
                                                        "examples/basic/src"]
                                         :compiler {:output-to "examples/basic/main.js"
                                                    :output-dir "examples/basic/out"
                                                    :source-map true
                                                    :optimizations :none}}
                                        {:id "om"
                                         :source-paths ["src"
                                                        "examples/tools/http"
                                                        "examples/om/src"]
                                         :compiler {:output-to "examples/om/main.js"
                                                    :output-dir "examples/om/out"
                                                    :source-map true
                                                    :optimizations :none}}]}
                   :injections [(require '[ring.server :as http :refer [run]]
                                         'cemerick.austin.repls)
                                (defn browser-repl-env []
                                  (reset! cemerick.austin.repls/browser-repl-env
                                          (cemerick.austin/repl-env)))
                                (defn browser-repl []
                                  (cemerick.austin.repls/cljs-repl
                                   (browser-repl-env)))]}})
