/*
 * Decompiled with CFR 0.152.
 */
package piotr_yuxuan;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class closeable_map$fn__878
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"piotr-yuxuan.closeable-map")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "# `closeable-map`\n\n[![Build status](https://img.shields.io/github/workflow/status/piotr-yuxuan/closeable-map/Walter%20CD)](https://github.com/piotr-yuxuan/closeable-map/actions/workflows/walter-cd.yml)\n[![Clojars badge](https://img.shields.io/clojars/v/piotr-yuxuan/closeable-map.svg)](https://clojars.org/piotr-yuxuan/closeable-map)\n[![Clojars downloads](https://img.shields.io/clojars/dt/piotr-yuxuan/closeable-map)](https://clojars.org/piotr-yuxuan/closeable-map)\n[![cljdoc badge](https://cljdoc.org/badge/piotr-yuxuan/closeable-map)](https://cljdoc.org/d/piotr-yuxuan/closeable-map/CURRENT)\n[![GitHub license](https://img.shields.io/github/license/piotr-yuxuan/closeable-map)](https://github.com/piotr-yuxuan/closeable-map/blob/main/LICENSE)\n[![GitHub issues](https://img.shields.io/github/issues/piotr-yuxuan/closeable-map)](https://github.com/piotr-yuxuan/closeable-map/issues)\n\n`<scherz>`Think about Zelda: when hens are free to propagate\neverywhere, they attack you and it becomes a mess. Your application\nstate is like your hens: it's safe when it is securely contained in a\ncoop with automated doors to prevent run-aways.`</scherz>`\n\n![](./doc/automatische-huehnerklappe.jpg)\n\nThis small Clojure library tries to get as close as possible to the\nbare essential complexity of state management in code. It defines a\nnew type of Clojure map that you may `(.close m)`. `<scherz>`See it in\naction above`</scherz>`.\n\nThis library defines a new type of map that you may use like any other\nmap. This map may contain stateful Java objects like a server, a Kafka\nproducer, a file output stream. When you want to clean your state, you\njust `.close` the map and all nested stateful objects will be closed\nrecursively.\n\nIt is a tiny alternative to more capable projects:\n\n- Application state management in a map: [juxt/clip](https://github.com/juxt/clip)\n- Simple library to initialise an app stack: [sathyavijayan/upit](https://github.com/sathyavijayan/upit)\n- Application state management:\n  [stuartsierra/component](https://github.com/stuartsierra/component),\n  [weavejester/integrant](weavejester/integrant),\n  [tolitius/mount](https://github.com/tolitius/mount), _et al_.\n- Extension of `with-open`:\n  [jarohen/with-open](https://github.com/jarohen/with-open)\n- Representing state in a map:\n  [robertluo/fun-map](https://github.com/robertluo/fun-map)\n\n## Usage\n\nIn your project, require:\n\n``` clojure\n(require '[piotr-yuxuan.closeable-map :as closeable-map :refer [close-with with-tag close!]])\n```\n\nDefine an application that can be started, and closed.\n\n``` clojure\n(defn start\n  \"Return a map describing a running application, and which values may\n  be closed.\"\n  [config]\n  (closeable-map/closeable-map\n    {;; Kafka producers/consumers are `java.io.Closeable`.\n     :producer (kafka-producer config)\n     :consumer (kafka-consumer config)}))\n```\n\nYou can start/stop the app in the repl with:\n\n``` clojure\n(comment\n  (def config (load-config))\n  (def system (start config))\n\n  ;; Stop/close all processes/resources with:\n  (.close system)\n  )\n```\n\nIt can be used in conjunction with `with-open` in test file to create\nwell-contained, independent tests:\n\n``` clojure\n(with-open [{:keys [consumer] :as app} (start config)]\n  (testing \"unit test with isolated, repeatable context\"\n    (is (= :yay/\ud83d\ude80 (some-business/function consumer)))))\n```\n\nYou could also use thi library while live-coding to stop and restart\nyour application whenever a file is changed.\n\n## More details\n\n``` clojure\n(defn start\n  \"Return a map describing a running application, and which values may\n  be closed.\"\n  [config]\n  (closeable-map/closeable-map\n    {;; Kafka producers/consumers are `java.io.Closeable`.\n     :producer (kafka-producer config)\n     :consumer (kafka-consumer config)\n\n     ;; File streams are `java.io.Closeable` too:\n     :logfile (io/output-stream (io/file \"/tmp/log.txt\"))\n\n     ;; Closeable maps can be nested. Nested maps will be closed before the outer map.\n     :backend/api {:response-executor (close-with (memfn ^ExecutorService .shutdown)\n                                        (flow/utilization-executor (:executor config)))\n                   :connection-pool (close-with (memfn ^IPool .shutdown)\n                                      (http/connection-pool {:pool-opts config}))\n\n                   ;; These functions receive their map as argument.\n                   ::closeable-map/before-close (fn [m] (backend/give-up-leadership config m))\n                   ::closeable-map/after-close (fn [m] (backend/close-connection config m))}\n\n     ;; Any exception when closing this nested map will be swallowed\n     ;; and not bubbled up.\n     :db ^::closeable-map/swallow {;; Connection are `java.io.Closeable`, too:\n                                   :db-conn (jdbc/get-connection (:db config))}\n\n     ;; Some libs return a zero-argument function which when called\n     ;; stops the server, like:\n     :server (with-tag ::closeable-map/fn (http/start-server (api config) (:server config)))\n     ;; Gotcha: Clojure meta data can only be attached on 'concrete'\n     ;; objects; they are lost on literal forms (see above).\n     :forensic ^::closeable-map/fn #(metrics/report-death!)\n\n     ::closeable-map/ex-handler\n     (fn [ex]\n       ;; Will be called for all exceptions thrown when closing this\n       ;; map and nested items.\n       (println (ex-message ex)))}))\n```\n\nWhen `(.close system)` is executed, it will:\n\n  - Recursively close all instances of `java.io.Closeable` and\n    `java.lang.AutoCloseable`;\n  - Recursively call all stop zero-argument functions tagged with\n    `^::closeable-map/fn`;\n  - Skip all nested `Closeable` under a `^::closeable-map/ignore`;\n  - Silently swallow any exception with `^::closeable-map/swallow`;\n  - Exceptions to optional `::closeable-map/ex-handler` in key or\n    metadata;\n  - If keys (or metadata) `::closeable-map/before-close` or\n    `::closeable-map/after-close` are present, they will be assumed as\n    a function which takes one argument (the map itself) and used run\n    additional closing logic:\n\n    ``` clojure\n    (closeable-map\n      {;; This function will be executed before the auto close.\n       ::closeable-map/before-close (fn [this-map] (flush!))\n\n       ;; Kafka producers/consumers are java.io.Closeable\n       :producer (kafka-producer config)\n       :consumer (kafka-consumer config)\n\n       ;; This function will be executed after the auto close.\n       ::closeable-map/after-close (fn [this-map] (garbage/collect!))})\n    ```\n\nSome classes do not implement `java.lang.AutoCloseable` but present\nsome similar method. For example instances of\n`java.util.concurrent.ExecutorService` can't be closed but they can be\n`.shutdown`:\n\n``` clojure\n{:response-executor (close-with (memfn ^ExecutorService .shutdown)\n                      (flow/utilization-executor (:executor config)))\n :connection-pool (close-with (memfn ^IPool .shutdown)\n                    (http/connection-pool {:pool-opts config}))}\n```\n\n## Java objects\n\nA Java object does not implement interface `clojure.lang.IObj` so it\nis unable to carry Clojure metadata. As such, you can't give a it a\ntag like `::closeable-map/fn`. You may also extend this library by\ngiving new dispatch values to multimethod `close!`. Once evaluated,\nthis will work accross all your code. The multimethod is dispatched on\nthe concrete class of its argument:\n\n``` clojure\n(import '(java.util.concurrent ExecutorService))\n(defmethod close! ExecutorService\n  [x]\n  (.shutdown ^ExecutorService x))\n\n(import '(io.aleph.dirigiste IPool))\n(defmethod close! IPool\n  [x]\n  (.shutdown ^IPool x))\n\n(import '(clojure.lang Atom))\n(defmethod close! Atom\n  [x]\n  (reset! x nil))\n\n(import '(clojure.core.async.impl.protocols Channel))\n(defmethod close! Channel\n  [x]\n  (async/close! x))\n```\n\nA Java object may be wrapped as a `closeable*`.\n\n## All or nothing\n\n### No half-broken closeable map\n\nYou may also avoid partially open state when an exception is thrown\nwhen creating a `CloseableMap`. This is where `closeable-map*` comes\nhandy. It outcome in one of the following:\n\n- Either everything went right, and all inner forms wrapped by\n  `closeable` correctly return a value; you get an open instance of `CloseableMap`.\n\n- Either some inner form wrapped by `closeable` didn't return a\n  closeable object but threw an exception instead. Then all\n  `closeable` forms are closed, and finally the exception is\n  bubbled up.\n\n``` clojure\n(closeable-map*\n  {:server (closeable* (http/start-server (api config)))\n   :kafka {:consumer (closeable* (kafka-consumer config))\n           :producer (closeable* (kafka-producer config))\n           :schema.registry.url \"https://localhost\"}})\n```\n\nCloseable objects not directly within the map may still be closed if\nwrapped in `closeable*`:\n\n``` clojure\n(closeable-map*\n  (closeable* (kafka-consumer config))\n  (closeable* (kafka-producer config))\n  {:server (closeable* (http/start-server (api config)))\n   :schema.registry.url \"https://localhost\"})\n```\n\n### No half-broken state in general code\n\nIn some circumstances you may need to handle exception on the creation\nof a closeable map. If an exception happens during the creation of the\nmap, values already evaluated will be closed. No closeable objects\nwill be left open with no references to them.\n\nFor instance, this form would throw an exception:\n\n``` clojure\n(closeable-map/closeable-map {:server (http/start-server (api config))\n                              :kafka {:consumer (kafka-consumer config)\n                                      :producer (throw (ex-info \"Exception\" {}))}})\n;; => (ex-info \"Exception\" {})\n```\n\n`with-closeable*` prevents that kind of broken, partially open states for its bindings:\n\n``` clojure\n(with-closeable* [server (http/start-server (api config))\n                  consumer (kafka-consumer config)\n                  producer (throw (ex-info \"Exception\" {}))]\n  ;; Your code goes here.\n)\n;; Close consumer,\n;; close server,\n;; finally throw `(ex-info \"Exception\" {})`.\n```\n\nYou now have the guarantee that your code will only be executed if\nall these closeable are open. In the latter example an exception is\nthrown when `producer` is evaluated, so `consumer` is closed, then\n`server` is closed, and finally the exception is bubbled up. Your\ncode is not evaluated. In the next example the body is evaluated,\nbut throws an exception: all bindings are closed.\n\n``` clojure\n(with-closeable* [server (http/start-server (api config))\n                  consumer (kafka-consumer config)\n                  producer (kafka-producer config)]\n  ;; Your code goes here.\n  (throw (ex-info \"Exception\" {})))\n;; Close producer,\n;; close consumer,\n;; close server,\n;; finally throw `(ex-info \"Exception\" {})`.\n```\n\nWhen no exception is thrown, leave bindings open and return like a\nnormal `let` form. If you prefer to close bindings, use `with-open` as\nusual.\n\n``` clojure\n(with-closeable* [server (http/start-server (api config))\n                  consumer (kafka-consumer config)\n                  producer (kafka-producer config)]\n  ;; Your code goes here.\n  )\n;; All closeable in bindings stay open.\n;; => result\n```\n\n## Technicalities\n\nSome Clojure datastructures implement `IFn`:\n\n``` clojure\n({:a 1} :a) ;; => 1\n(remove #{:a} [:a :b :c]) ;; => '(:b :c)\n([:a :b :c] 1) ;; => :b\n```\n\nClojure maps (`IPersistentMap`) implement `IFn`, for `invoke()` of one\nargument (a key) with an optional second argument (a default value),\ni.e. maps are functions of their keys. `nil` keys and values are fine.\n\nThis library defines a new data strucure, CloseableMap. It is exposed\nas an instance of `java.io.Closeable` which is a subinterface of\n`java.lang.AutoCloseable`. When trying to close its values, it looks\nfor instances of the latter. As such, it tries to be most general.\n\n``` clojure\n(require '[clojure.data])\n\n(clojure.data/diff\n  (ancestors (class {}))\n  (ancestors CloseableMap))\n\n;; =>\n[;; Ancestors of Clojure map only but not CloseableMap.\n #{clojure.lang.AFn ; Concrete type, but see below for IFn.\n   clojure.lang.APersistentMap\n   clojure.lang.IEditableCollection\n   clojure.lang.IKVReduce\n   clojure.lang.IMapIterable\n   java.io.Serializable}\n\n ;; Ancestors of CloseableMap only.\n #{clojure.lang.IType\n   java.io.Closeable\n   java.lang.AutoCloseable\n   java.util.Iterator\n   potemkin.collections.PotemkinMap\n   potemkin.types.PotemkinType}\n\n ;; Ancestors common to both types.\n #{clojure.lang.Associative\n   clojure.lang.Counted\n   clojure.lang.IFn\n   clojure.lang.IHashEq\n   clojure.lang.ILookup\n   clojure.lang.IMeta\n   clojure.lang.IObj\n   clojure.lang.IPersistentCollection\n   clojure.lang.IPersistentMap\n   clojure.lang.MapEquivalence\n   clojure.lang.Seqable\n   java.lang.Iterable\n   java.lang.Object\n   java.lang.Runnable\n   java.util.Map\n   java.util.concurrent.Callable}]\n```\n"}));

    public static Object invokeStatic() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }

    public Object invoke() {
        return closeable_map$fn__878.invokeStatic();
    }
}

