(ns debug.print
  (:require
   #?(:clj [clojure.pprint :refer [pprint]])))

(defn pretty-print
  [arg]
  #?(:clj  (pprint arg)
     :cljs (js/console.log (clj->js arg)))
  arg)

(defn spy
  [arg]
  (pretty-print (type arg))
  (pretty-print arg))

(defn group-begin
  [name]
  #?(:clj  (println "<<<" name)
     :cljs (js/console.group name)))

(defn group-begin-collapsed
  [name]
  #?(:clj  (println "<<<" name)
     :cljs (js/console.groupCollapsed name)))

(defn group-end
  [name]
  #?(:clj  (println ">>>" name)
     :cljs (js/console.groupEnd)))

(defn print-group
  [label arg]
  (group-begin-collapsed label)
  (pretty-print arg)
  (group-end label)
  arg)
