(ns debug.hooks
  (:require
   [debug.print :refer [pretty-print
                        group-begin group-end]]))

(defn hook-display-input
  [{:keys [label args]}]
  (print label "input: ")
  (pretty-print args))

(defn hook-display-output
  [{:keys [label result]}]
  (print label "output: ")
  (pretty-print result))

(defn hook-group-begin
  [{:keys [label]}]
  (group-begin label))

(defn hook-group-end
  [{:keys [label]}]
  (group-end label))
