(ns leiningen.new.piggieback
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "piggieback"))

(defn piggieback
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data 
             ["project.clj" (render "project.clj" data)]
             ["README.md"   (render "README.md")]
             ["index.html"  (render "index.html")]
             ["piggieback_browser.cljs" (render "piggieback_browser.cljs")]
             )))
