(ns yoostan-lib.lifecycle)

(defprotocol lifecycle
  "A Lifecycle applies to a resources and govern how each becomes available, ready, in use and finally decommed again. (https://pieterbreed.gitbooks.io/this-and-that/content/)"

  (plant [x env & opts] "This is like planting a seed. It represents the least amount of work needed to _accept_ a handle to a resource. Does not actually do anything with it yet. This is like being notified that your purchase of a new car have been approved or like registering the car in your name.")

  (prepare [x env & opts] "This is like germination. The initial work required to prepare a resource for use. This is like putting a spoiler on your car to increase downforce, because you bought the car for use on the race track.")

  (awaken [x env & opts] "This is like entering consiousness. Ensures that the resource has been _woken up_ and is ready to start being useful. Like turning the ignition of a car.")

  (retire [x env & opts] "An ordered process for end-of-life preparation. Allows for graceful handover of precious resources. The logical opposite of prepare.")

  (uproot [x env & opts]  "This is like chopping down a tree. The logical opposite of accept."))


;; ----------------------------------------

(defprotocol resource-pool
  "A protocol that allows resources to be consumed and discarded."
  (request [type])
  (return [type]))

;; ----------------------------------------

(defrecord system [path]
  lifecycle
  (plant [x env & opts] )

  (prepare [x env & opts])

  (awaken [x env & opts] )

  (retire [x env & opts] )

  (uproot [x env & opts] ))

;; ----------------------------------------


(derive ::vm ::resource)

(defmulti request
  "A method to acquire resources of a certain type from the system"
  (fn [x & _] (class x)))

(defmethod request :default [x]
  (-> (str "Don't know how to request '"
           x
           "' of type '"
           (type x)
           "'.")
      Exception.
      throw))



;; ----------------------------------------

(def resource-manager)

;; ----------------------------------------

(def dev-recipe
  {:resources {::vm 1
               ::datomic-license 1}})







































