(ns yoostan-lib.utils
  (:require [clojure.spec :as s]
            [clojure.spec.gen :as gen]
            [me.raynes.conch :as conch]))

(defn samples
  "Only a helper function for the repl."
  ([s] (gen/sample (s/gen s)))
  ([s n] (gen/sample (s/gen s)
                     n)))

(defn cmd-is-available
  "Tests whether a UNIX shell command can be found."
  [appname]
  (conch/with-programs [which]
    (let [res (which appname {:throw false
                              :verbose true})]
      (= 0 (deref (:exit-code res))))))

(defn version-of-app-found
  "Runs <command> <-version> and tests the output against a regex"
  [r cmd p]
  (conch/let-programs
      [c cmd]

    (let [res (c p {:throw false
                    :verbose true})
          exit-code (deref (:exit-code res))]
      
      (if (not= 0 exit-code) false
          (boolean (re-find r (:stdout res)))))))


