(ns cljs.debux
  (:require [clojure.string]
            [cljs.pprint] ))

(enable-console-print!)

;;---------
;; caching
;;---------

(def ^:private prev-returns* (atom {}))
 
(defn changed?
  "Checks if prev-returns* contains <args>.
   <args str> the key of prev-returns* map
   <return str> the value of prev-returns* map" 
  [args return]
  (when-not (contains? @prev-returns* args)
    (swap! prev-returns* assoc args ""))

  (and (not= return (@prev-returns* args))
       (swap! prev-returns* assoc args return) ))


;;-------
;; style
;;-------

(def style*
  (atom {:error "background: red; color: white"
         :warn  "background: green; color: white"
         :info  "background: #0000cd; color: white" 
         :debug "background: #ffc125; color: black"

         :text  "color: black"
         :title "color: #8b008b"} ))

(defn merge-style
  "Merges <new-style> into style*.
   <new-style {<style-name kw, style-value str>+}>"
  [new-style]
  (swap! style* merge new-style))

(defn- get-style
  "<styke kw|str> style-name
   <return str?>"
  [style]
  (cond
    (keyword? style)
    (cond
      (#{:error :e} style)
      (:error @style*)

      (#{:warn :w} style)
      (:warn @style*)

      (#{:info :i} style)
      (:info @style*)

      (#{:debug :d} style)
      (:debug @style*)

      :else
      (get @style* style))

    (string? style)
    style))


;;-------
;; print 
;;-------

(defn print-log
  "<header str>
   <form-style str>
   <body str>
   <js bool>
   <return any>"
  [header form-style body js return] 
  (.group js/console header (:title @style*)
                    (get-style form-style) (:text @style*))
  (if js 
    (.log js/console body return)
    (.log js/console body))
  (.groupEnd js/console))

 
