(ns yipgo-parser.core
  (:require [clojure.string :as str]
            [instaparse.core :as insta]))

(def yip-shape
  (insta/parser
   (str/join "\n"
             ["S = ( text-block | list-item | heading )*"

              ;; lists and that
              "list-item = list-level <ws> anything <eol?>"
              "list-level = #' {0,3}\\*'"

              ;; headings and shit
              "heading = ( heading-text | heading-date-text ) <eol?>"
              "heading-text = heading-level <ws> anything"
              "heading-date-text = heading-level <ws> heading-date <ws> anything"
              "heading-level = #'#{1,6}'"
              "heading-date = <'<'> #'[\\d-:]+' <'>'>"

              "text-block = anything*"

              "anything = #'[^\n]+' <eol?>"
              "<eol> = '\\r'? '\\n'"
              "<ws> = #'\\s+'"])))

(defn parse [string]
  (let [out (insta/transform {:heading #(hash-map :heading %)
                              :heading-text merge
                              :heading-date-text merge
                              :heading-date #(hash-map :date %)
                              :heading-level #(hash-map :level (count %))

                              :list-level #(hash-map :level (count %))
                              :list-item #(hash-map :list-item (into {} %&))

                              :text-block #(hash-map :text-block %)
                              :anything #(hash-map :text %)}
                             (yip-shape string))]
    (if (= (first out) :S)
      (rest out)
      out)))
