# mig

Simple migration library that assumes nothing about your project
layout, migration targets or your underwear colour.

## Installation

### Lein

    [philjackson/two-probs "0.1.0"]

### Gradle

    compile "philjackson:two-probs:0.1.0"

### Maven

    <dependency>
      <groupId>philjackson</groupId>
      <artifactId>mig</artifactId>
      <version>0.1.0</version>
    </dependency>

## Usage with Leiningen

Add this to your project's plugin section:

    [philjackson/two-probs "0.1.0"]

Then, in the root of your defproject, add something similar to the
below:

    :mig {:base-dir "test/fixtures/test1"
          :init leiningen.mig/init
          :finish clojure.pprint/pprint
          :directives [:up :down]}

The structure above are the defaults, so omit anything there that
suits you.

Here's what those things mean;

 * `base-dir` is where the migrations will be recursively loaded
   from. Make them normal clj files, namespaces and all.
 * `init` and `finish` are functions that are run at the start of the
   process, and the end, respectively.
 * `directives` are the potential names of things to run. `up` and
   `down` are the typical ones we think of for migrations.

### The migration files

Assuming you're interested in the `up` directive for the time being;
add two functions to a new migration file:

    ;; determine whether up has been applied for this namespace
    (defn up-applied? [ctx] ...)

    ;; this function will run if the above predicate returns something
    ;; falsy
    (defn up [ctx] ...)

Here, `up-applied?` is a predicate, and should have no side-affects!

### The context

The `init` function should return something that can be processed by
each stage of the migration. It can be anything and will be threaded
to each stage of each migration, eventually ending up at `finish`.

## License

Copyright © 2015 Phil Jackson

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
