/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import util.Assert;
import util.IDataInputStream;

public final class BufferedDataInputStream
extends FilterInputStream
implements IDataInputStream {
    private byte[] buff;
    private int len;
    private int curr;
    private byte[] temp;

    public BufferedDataInputStream() {
        super(null);
        this.initFields();
    }

    public BufferedDataInputStream(InputStream is2) throws IOException {
        super(is2);
        this.initFields();
        this.len = this.in.read(this.buff);
        Assert.check(this.len != 0, 2135);
    }

    public BufferedDataInputStream(String name2) throws IOException {
        this(new FileInputStream(name2));
    }

    public BufferedDataInputStream(File file2) throws IOException {
        this(new FileInputStream(file2));
    }

    private void initFields() {
        this.buff = new byte[8192];
        this.curr = 0;
        this.temp = new byte[8];
    }

    public void open(InputStream is2) throws IOException {
        Assert.check(this.in == null, 2135);
        this.in = is2;
        this.len = this.in.read(this.buff);
        Assert.check(this.len != 0, 2135);
    }

    public void open(String name2) throws IOException {
        this.open(new FileInputStream(name2));
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    public final boolean atEOF() {
        return this.len < 0;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final int read(byte[] b, int off, int n) throws IOException {
        if (this.len < 0) {
            return -1;
        }
        int offInit = off;
        while (n > 0 && this.len > 0) {
            int toCopy = Math.min(n, this.len - this.curr);
            System.arraycopy(this.buff, this.curr, b, off, toCopy);
            this.curr += toCopy;
            off += toCopy;
            n -= toCopy;
            if (this.curr != this.len) continue;
            this.len = this.in.read(this.buff);
            Assert.check(this.len != 0, 2135);
            this.curr = 0;
        }
        return off - offInit;
    }

    public final void readFully(byte[] b) throws IOException, EOFException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int n) throws IOException, EOFException {
        while (n > 0) {
            int numRead = this.read(b, off, n);
            if (numRead < 0) {
                throw new EOFException();
            }
            off += numRead;
            n -= numRead;
        }
    }

    public final byte readByte() throws IOException, EOFException {
        if (this.len < 0) {
            throw new EOFException();
        }
        byte res2 = this.buff[this.curr++];
        if (this.curr == this.len) {
            this.len = this.in.read(this.buff);
            Assert.check(this.len != 0, 2135);
            this.curr = 0;
        }
        return res2;
    }

    public final boolean readBoolean() throws IOException, EOFException {
        return this.readByte() != 0;
    }

    public final short readShort() throws IOException, EOFException {
        this.readFully(this.temp, 0, 2);
        return (short)(this.temp[0] << 8 | this.temp[1] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException, EOFException {
        this.readFully(this.temp, 0, 4);
        int res2 = this.temp[0];
        res2 <<= 8;
        res2 |= this.temp[1] & 0xFF;
        res2 <<= 8;
        res2 |= this.temp[2] & 0xFF;
        res2 <<= 8;
        return res2 |= this.temp[3] & 0xFF;
    }

    public final long readLong() throws IOException, EOFException {
        this.readFully(this.temp, 0, 8);
        long res2 = this.temp[0];
        res2 <<= 8;
        res2 |= (long)(this.temp[1] & 0xFF);
        res2 <<= 8;
        res2 |= (long)(this.temp[2] & 0xFF);
        res2 <<= 8;
        res2 |= (long)(this.temp[3] & 0xFF);
        res2 <<= 8;
        res2 |= (long)(this.temp[4] & 0xFF);
        res2 <<= 8;
        res2 |= (long)(this.temp[5] & 0xFF);
        res2 <<= 8;
        res2 |= (long)(this.temp[6] & 0xFF);
        res2 <<= 8;
        return res2 |= (long)(this.temp[7] & 0xFF);
    }

    public final String readLine() throws IOException {
        String res2 = null;
        while (this.len > 0) {
            for (int i = this.curr; i < this.len; ++i) {
                if (this.buff[i] != 10 && this.buff[i] != 13) continue;
                byte eol = this.buff[i];
                String s = new String(this.buff, this.curr, i - this.curr);
                res2 = res2 == null ? s : res2 + s;
                this.skip(i + 1 - this.curr);
                if (eol == 13 && this.len > 0 && this.buff[this.curr] == 10) {
                    this.readByte();
                }
                return res2;
            }
            String s = new String(this.buff, this.curr, this.len - this.curr);
            res2 = res2 == null ? s : res2 + s;
            this.skip(this.len - this.curr);
        }
        return res2;
    }

    @Override
    public final String readString(int n) throws IOException {
        char[] b = new char[n];
        int off = 0;
        while (n > 0) {
            if (this.len < 0) {
                throw new EOFException();
            }
            int offInit = off;
            while (n > 0 && this.len > 0) {
                int toCopy = Math.min(n, this.len - this.curr);
                for (int i = 0; i < toCopy; ++i) {
                    b[off + i] = (char)this.buff[this.curr + i];
                }
                this.curr += toCopy;
                off += toCopy;
                n -= toCopy;
                if (this.curr != this.len) continue;
                this.len = this.in.read(this.buff);
                Assert.check(this.len != 0, 2135);
                this.curr = 0;
            }
            int numRead = off - offInit;
            off += numRead;
            n -= numRead;
        }
        return new String(b);
    }

    public final void skip(int n) throws IOException, EOFException {
        while (this.len > 0 && this.curr + n >= this.len) {
            n -= this.len - this.curr;
            this.len = this.in.read(this.buff);
            Assert.check(this.len != 0, 2135);
            this.curr = 0;
        }
        if (n > 0 && this.len < 0) {
            throw new EOFException();
        }
        this.curr += n;
        Assert.check(this.len < 0 || this.curr < this.len, 2134);
    }
}

