/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tla2sany.modanalyzer.ModulePointer;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.Action;
import tlc2.tool.impl.Spec;
import tlc2.util.Context;
import tlc2.value.impl.StringValue;
import util.FilenameToStream;

public class ParameterizedSpecObj
extends SpecObj {
    public static final String POST_CONDITIONS = "POST_CONDITIONS";
    public static final String INVARIANT = "INVARIANT";
    private final Spec spec;
    private final Map<String, Object> params;

    public ParameterizedSpecObj(Spec spec2, FilenameToStream resolver, Map<String, Object> params) {
        super(spec2.rootFile, resolver);
        this.spec = spec2;
        this.params = params;
    }

    @Override
    protected final ParseUnit findOrCreateParsedUnit(String name, Errors errors, boolean firstCall) throws AbortException {
        ModulePointer rootModule;
        ParseUnit pu = super.findOrCreateParsedUnit(name, errors, firstCall);
        if (firstCall && this.params.containsKey(POST_CONDITIONS)) {
            rootModule = pu.getRootModule();
            List pcs = (List)this.params.get(POST_CONDITIONS);
            for (PostCondition pc : pcs) {
                rootModule.getRelatives().addExtendee(pc.module);
            }
        }
        if (firstCall && this.params.containsKey(INVARIANT)) {
            rootModule = pu.getRootModule();
            List invs = (List)this.params.get(INVARIANT);
            for (Invariant inv : invs) {
                rootModule.getRelatives().addExtendee(inv.module);
            }
        }
        return pu;
    }

    @Override
    public List<ExprNode> getPostConditionSpecs() {
        ArrayList<ExprNode> res = new ArrayList<ExprNode>();
        List pcs = this.params.getOrDefault(POST_CONDITIONS, new ArrayList());
        for (PostCondition pc : pcs) {
            ExternalModuleTable mt = this.getExternalModuleTable();
            ModuleNode moduleNode = mt.getModuleNode(pc.module);
            OpDefNode opDef = moduleNode.getOpDef(pc.operator);
            for (Map.Entry<String, String> entry : pc.redefinitions.entrySet()) {
                OpDefNode redefined = moduleNode.getOpDef(entry.getKey());
                redefined.setToolObject(this.spec.getId(), new StringValue(entry.getValue()));
            }
            res.add(opDef.getBody());
        }
        return res;
    }

    @Override
    public List<Action> getInvariants() {
        ArrayList<Action> res = new ArrayList<Action>();
        List invs = this.params.getOrDefault(INVARIANT, new ArrayList());
        for (Invariant inv : invs) {
            ExternalModuleTable mt = this.getExternalModuleTable();
            ModuleNode moduleNode = mt.getModuleNode(inv.module);
            OpDefNode opDef = moduleNode.getOpDef(inv.operator);
            res.add(new Action((SemanticNode)opDef.getBody(), Context.Empty, opDef, false, true));
        }
        return res;
    }

    public static class PostCondition {
        public final String module;
        public final String operator;
        public final Map<String, String> redefinitions;

        public PostCondition(String moduleBangOp) {
            this(moduleBangOp.split("!")[0], moduleBangOp.split("!")[1]);
        }

        public PostCondition(String module, String operator) {
            this(module, operator, new HashMap<String, String>());
        }

        public PostCondition(String module, String operator, String def, String redef) {
            this(module, operator);
            this.redefinitions.put(def, redef);
        }

        public PostCondition(String module, String operator, Map<String, String> redefinitions) {
            this.module = module;
            this.operator = operator;
            this.redefinitions = redefinitions;
        }
    }

    public static class Invariant {
        public final String module;
        public final String operator;

        public Invariant(String module, String operator) {
            this.module = module;
            this.operator = operator;
        }
    }
}

