/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeMap;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.util.Combinatorics;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.KSubsetValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class SubsetValue
extends EnumerableValue
implements Enumerable {
    public Value set;
    protected SetEnumValue pset;
    private final ValueEnumeration emptyEnumeration = new ValueEnumeration(){
        private boolean done = false;

        @Override
        public void reset() {
            this.done = false;
        }

        @Override
        public Value nextElement() {
            if (this.done) {
                return null;
            }
            this.done = true;
            return new SetEnumValue(SubsetValue.this.cm);
        }
    };

    public SubsetValue(Value set) {
        this.set = set;
        this.pset = null;
    }

    public SubsetValue(Value set, CostModel cm) {
        this(set);
        this.cm = cm;
    }

    @Override
    public final byte getKind() {
        return 16;
    }

    @Override
    public int compareTo(Object obj) {
        try {
            if (obj instanceof SubsetValue) {
                return this.set.compareTo(((SubsetValue)obj).set);
            }
            this.convertAndCache();
            return this.pset.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof SubsetValue) {
                return this.set.equals(((SubsetValue)obj).set);
            }
            this.convertAndCache();
            return this.pset.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public boolean member(Value val) {
        try {
            if (val instanceof Enumerable) {
                Value elem;
                ValueEnumeration Enum2 = ((Enumerable)((Object)val)).elements();
                while ((elem = Enum2.nextElement()) != null) {
                    if (this.set.member(elem)) continue;
                    return false;
                }
            } else {
                Assert.fail("Attempted to check if the non-enumerable value\n" + Values.ppr(val.toString()) + "\nis element of\n" + Values.ppr(this.toString()), this.getSource());
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public Value isSubsetEq(Value other) {
        try {
            if (other instanceof SubsetValue && !(other instanceof KSubsetValue) && this.set instanceof Enumerable) {
                SubsetValue sv = (SubsetValue)other;
                return ((Enumerable)((Object)this.set)).isSubsetEq(sv.set);
            }
            return super.isSubsetEq(other);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            return this.set.isFinite();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public int size() {
        try {
            int sz = this.set.size();
            if (sz >= 31) {
                Assert.fail(2178, "the number of elements in:\n" + Values.ppr(this.toString()));
            }
            return 1 << sz;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            return this.pset != null && this.pset != SetEnumValue.DummyEnum && this.pset.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.pset == null || this.pset == SetEnumValue.DummyEnum) {
                this.set.normalize();
            } else {
                this.pset.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            this.set.deepNormalize();
            if (this.pset == null) {
                this.pset = SetEnumValue.DummyEnum;
            } else if (this.pset != SetEnumValue.DummyEnum) {
                this.pset.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.set.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        this.pset.write(vos);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.pset.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.convertAndCache();
            return this.pset.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void convertAndCache() {
        if (this.pset == null) {
            this.pset = (SetEnumValue)this.toSetEnum();
        } else if (this.pset == SetEnumValue.DummyEnum) {
            SetEnumValue val = null;
            SubsetValue subsetValue = this;
            synchronized (subsetValue) {
                if (this.pset == SetEnumValue.DummyEnum) {
                    val = (SetEnumValue)this.toSetEnum();
                    val.deepNormalize();
                }
            }
            subsetValue = this;
            synchronized (subsetValue) {
                if (this.pset == SetEnumValue.DummyEnum) {
                    this.pset = val;
                }
            }
        }
    }

    @Override
    public final Value toSetEnum() {
        Value elem;
        if (this.pset != null && this.pset != SetEnumValue.DummyEnum) {
            return this.pset;
        }
        ValueVec vals = new ValueVec(this.size());
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, true, this.cm);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            boolean unlazy = TLCGlobals.expand;
            try {
                if (unlazy) {
                    unlazy = this.set.size() < 7;
                }
            }
            catch (Throwable e) {
                if (swallow) {
                    unlazy = false;
                }
                throw e;
            }
            if (unlazy) {
                Value val = this.toSetEnum();
                return val.toString(sb, offset, swallow);
            }
            sb = sb.append("SUBSET ");
            if (this.set instanceof IntervalValue) {
                sb.append("(");
                sb = this.set.toString(sb, offset, swallow);
                sb.append(")");
            } else {
                sb = this.set.toString(sb, offset, swallow);
            }
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public Unrank getUnrank(int kSubset) {
        SetEnumValue convert = (SetEnumValue)this.set.toSetEnum();
        convert.normalize();
        ValueVec elems = convert.elems;
        return new Unrank(kSubset, Combinatorics.bigSumChoose(elems.size(), kSubset).longValueExact(), Combinatorics.pascalTableUpTo(elems.size(), kSubset), elems, kSubset);
    }

    public Enumerable getRandomSetOfSubsets(int numOfSubsetsRequested, int maxLengthOfSubsets) {
        SetEnumValue convert = (SetEnumValue)this.set.toSetEnum();
        convert.normalize();
        ValueVec elems = convert.elems;
        int size = elems.size();
        long[] kss = new long[maxLengthOfSubsets + 1];
        kss[0] = 1L;
        BigInteger sum = BigInteger.ONE;
        for (int i = 1; i <= maxLengthOfSubsets; ++i) {
            kss[i] = Combinatorics.bigChoose(size, i).longValueExact();
            sum = sum.add(BigInteger.valueOf(kss[i]));
        }
        assert (sum.equals(Combinatorics.bigSumChoose(size, maxLengthOfSubsets)));
        long[] ppt = Combinatorics.pascalTableUpTo(size, maxLengthOfSubsets);
        ValueVec vec = new ValueVec(numOfSubsetsRequested);
        for (int rank = 0; rank < kss.length; ++rank) {
            Value subset;
            BigDecimal divide = BigDecimal.valueOf(kss[rank]).divide(new BigDecimal(sum), 32, 5);
            long n = divide.multiply(BigDecimal.valueOf(numOfSubsetsRequested)).max(BigDecimal.ONE).toBigInteger().longValueExact();
            RandomUnrank unrank = new RandomUnrank(rank, rank == kss.length - 1 ? (long)(numOfSubsetsRequested - vec.size()) : n, ppt, elems, maxLengthOfSubsets, RandomEnumerableValues.get());
            while ((subset = unrank.randomSubset()) != null && vec.size() < numOfSubsetsRequested) {
                vec.addElement(subset);
            }
        }
        assert (vec.size() == numOfSubsetsRequested);
        return new SetEnumValue(vec, false, this.cm);
    }

    public EnumerableValue getRandomSetOfSubsets(int numOfPicks, double probability) {
        Value val;
        CoinTossingSubsetEnumerator enumerator = new CoinTossingSubsetEnumerator(numOfPicks, probability);
        int estimated = (int)((double)numOfPicks * probability);
        HashSet<Value> sets = new HashSet<Value>(estimated);
        while ((val = enumerator.nextElement()) != null) {
            sets.add(val);
        }
        return new SetEnumValue(new ValueVec(sets), false, this.cm);
    }

    final ValueEnumeration elementsNormalized() {
        final int n = this.set.size();
        if (n == 0) {
            this.emptyEnumeration.reset();
            return this.emptyEnumeration;
        }
        final ValueVec elems = ((SetEnumValue)this.set.toSetEnum().normalize()).elems;
        return new ValueEnumeration(){
            private int k = 0;
            private final int[] indices = new int[n];

            @Override
            public void reset() {
                this.reset(0);
            }

            private void reset(int k) {
                this.k = k;
                if (k > n) {
                    return;
                }
                for (int i = 0; i < k; ++i) {
                    this.indices[i] = i;
                }
            }

            @Override
            public Value nextElement() {
                int i;
                if (this.k > n) {
                    return null;
                }
                if (this.k == 0) {
                    this.reset(this.k + 1);
                    return new SetEnumValue(SubsetValue.this.cm);
                }
                ValueVec vals = new ValueVec(this.k);
                for (int j = i = this.k - 1; j >= 0; --j) {
                    vals.addElementAt(elems.elementAt(this.indices[j]), j);
                    if (this.indices[j] + this.k - j != n) continue;
                    i = j - 1;
                }
                SetEnumValue result = new SetEnumValue(vals, true, SubsetValue.this.cm);
                if (this.indices[0] == n - this.k) {
                    this.reset(this.k + 1);
                    return result;
                }
                int n2 = i++;
                this.indices[n2] = this.indices[n2] + 1;
                while (i < this.k) {
                    this.indices[i] = this.indices[i - 1] + 1;
                    ++i;
                }
                return result;
            }
        };
    }

    public final long numberOfKElements(int k) {
        int size = this.set.size();
        if (k < 0 || size < k || size > 63) {
            throw new IllegalArgumentException(String.format("k=%s and n=%s", k, size));
        }
        if (k == 0 || k == size) {
            return 1L;
        }
        return Combinatorics.choose(size, k);
    }

    public final ValueEnumeration kElements(int k) {
        if (k < 0 || this.set.size() < k) {
            throw new IllegalArgumentException();
        }
        if (k == 0) {
            this.emptyEnumeration.reset();
            return this.emptyEnumeration;
        }
        return new KElementEnumerator(k);
    }

    public final Value kSubset(int k) {
        return this.kElements(k).asSet();
    }

    @Override
    public ValueEnumeration elements(Enumerable.Ordering ordering) {
        if (ordering == Enumerable.Ordering.RANDOMIZED) {
            return ((SetEnumValue)this.toSetEnum()).elements(ordering);
        }
        return this.elements();
    }

    @Override
    public ValueEnumeration elements() {
        try {
            if (this.pset == null || this.pset == SetEnumValue.DummyEnum) {
                return this.elementsNormalized();
            }
            return this.pset.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final ValueEnumeration elementsLexicographic() {
        return new Enumerator();
    }

    @Override
    public ValueEnumeration elements(int k) {
        int sz = this.set.size();
        if (sz >= 31 || k > 65536) {
            return new CoinTossingSubsetEnumerator(k);
        }
        return new SubsetEnumerator(k);
    }

    public class RandomSubsetGenerator
    implements ValueEnumeration {
        private final int k;
        private final Random random;
        private final SetEnumValue s;
        private int n;

        public RandomSubsetGenerator(int k) {
            this.k = k;
            this.s = (SetEnumValue)SubsetValue.this.set.toSetEnum();
            this.s.normalize();
            this.n = this.s.elems.size();
            if (k < 0 || k > this.n) {
                throw new IllegalArgumentException(String.format("k=%s and n=%s", k, this.n));
            }
            this.random = RandomEnumerableValues.get();
        }

        @Override
        public void reset() {
        }

        @Override
        public Value nextElement() {
            ValueVec vec = new ValueVec(this.k);
            for (int t = 0; t < this.n; ++t) {
                double p = (double)(this.k - vec.size()) / ((double)(this.n - t) * 1.0);
                if (this.random.nextDouble() <= p) {
                    vec.addElement(this.s.elems.elementAt(t));
                }
                if (vec.size() == this.k) break;
            }
            assert (vec.size() == this.k);
            return new SetEnumValue(vec, false);
        }
    }

    class CoinTossingSubsetEnumerator
    implements ValueEnumeration {
        private final ValueVec elems;
        private final double probability;
        private final int numOfPicks;
        private int i = 0;

        public CoinTossingSubsetEnumerator(int numOfPicks) {
            this(numOfPicks, 0.5);
        }

        public CoinTossingSubsetEnumerator(int numOfPicks, double probability) {
            this.numOfPicks = numOfPicks;
            this.probability = probability;
            SetEnumValue convert = (SetEnumValue)SubsetValue.this.set.toSetEnum();
            convert.normalize();
            this.elems = convert.elems;
        }

        @Override
        public Value nextElement() {
            if (!this.hasNext()) {
                return null;
            }
            ValueVec vals = new ValueVec(this.elems.size());
            for (int i = 0; i < this.elems.size(); ++i) {
                if (!(RandomEnumerableValues.get().nextDouble() < this.probability)) continue;
                vals.addElement(this.elems.elementAt(i));
            }
            ++this.i;
            return new SetEnumValue(vals, false, SubsetValue.this.cm);
        }

        private boolean hasNext() {
            return this.i < this.numOfPicks;
        }

        @Override
        public void reset() {
            this.i = 0;
        }

        int getNumOfPicks() {
            return this.numOfPicks;
        }
    }

    class SubsetEnumerator
    extends EnumerableValue.SubsetEnumerator {
        private final ValueVec elems;

        SubsetEnumerator(int k) {
            super(k, 1 << SubsetValue.this.set.size());
            SetEnumValue convert = (SetEnumValue)SubsetValue.this.set.toSetEnum();
            convert.normalize();
            this.elems = convert.elems;
        }

        @Override
        public Value nextElement() {
            if (!this.hasNext()) {
                return null;
            }
            int bits = this.nextIndex();
            ValueVec vals = new ValueVec(Integer.bitCount(bits));
            for (int i = 0; bits > 0 && i < this.elems.size(); bits >>>= 1, ++i) {
                if ((bits & 1) <= 0) continue;
                vals.addElement(this.elems.elementAt(i));
            }
            return new SetEnumValue(vals, false, SubsetValue.this.cm);
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        private ValueVec elems;
        private BitSet descriptor;

        public Enumerator() {
            SubsetValue.this.set = SubsetValue.this.set.toSetEnum();
            SubsetValue.this.set.normalize();
            this.elems = ((SetEnumValue)SubsetValue.this.set).elems;
            this.descriptor = new BitSet(this.elems.size());
        }

        @Override
        public final void reset() {
            this.descriptor = new BitSet(this.elems.size());
        }

        @Override
        public final Value nextElement() {
            ValueVec vals;
            if (this.descriptor == null) {
                return null;
            }
            int sz = this.elems.size();
            if (sz == 0) {
                vals = new ValueVec(0);
                this.descriptor = null;
            } else {
                int i;
                vals = new ValueVec(this.descriptor.cardinality());
                for (i = 0; i < sz; ++i) {
                    if (!this.descriptor.get(i)) continue;
                    vals.addElement(this.elems.elementAt(i));
                }
                for (i = 0; i < sz; ++i) {
                    if (this.descriptor.get(i)) {
                        this.descriptor.clear(i);
                        if (i < sz - 1) continue;
                        this.descriptor = null;
                        break;
                    }
                    this.descriptor.set(i);
                    break;
                }
            }
            if (Value.coverage) {
                SubsetValue.this.cm.incSecondary(vals.size());
            }
            return new SetEnumValue(vals, true, SubsetValue.this.cm);
        }
    }

    public final class KElementEnumerator
    implements ValueEnumeration {
        private final ValueVec elems;
        private final int numKSubsetElems;
        private final int k;
        private long index;
        private int cnt;

        public KElementEnumerator(int k) {
            this.k = k;
            this.numKSubsetElems = (int)SubsetValue.this.numberOfKElements(k);
            if (this.numKSubsetElems < 0) {
                throw new IllegalArgumentException("Subset too large.");
            }
            SetEnumValue convert = (SetEnumValue)SubsetValue.this.set.toSetEnum();
            convert.normalize();
            this.elems = convert.elems;
            this.reset();
        }

        @Override
        public void reset() {
            this.index = (1L << this.k) - 1L;
            this.cnt = 0;
        }

        private long nextIndex() {
            long oldIdx = this.index;
            long t = (this.index | this.index - 1L) + 1L;
            this.index = t | ((t & -t) / (this.index & -this.index) >> 1) - 1L;
            return oldIdx;
        }

        @Override
        public Value nextElement() {
            if (this.cnt >= this.numKSubsetElems) {
                return null;
            }
            ++this.cnt;
            long bits = this.nextIndex();
            ValueVec vals = new ValueVec(Long.bitCount(bits));
            for (int i = 0; bits > 0L && i < this.elems.size(); bits >>>= 1, ++i) {
                if ((bits & 1L) <= 0L) continue;
                vals.addElement(this.elems.elementAt(i));
            }
            assert (vals.size() == this.k);
            return new SetEnumValue(vals, false, SubsetValue.this.cm);
        }

        public KElementEnumerator sort() {
            this.elems.sort(true);
            return this;
        }

        @Override
        public SetEnumValue asSet() {
            Value elem;
            ValueVec vv = new ValueVec(this.numKSubsetElems);
            while ((elem = this.nextElement()) != null) {
                vv.addElement(elem);
            }
            return new SetEnumValue(vv, false);
        }
    }

    private class RandomUnrank
    extends Unrank {
        private static final long x = 34359738337L;
        private final long n;
        private final long a;
        private long i;

        public RandomUnrank(int k, long n, long[] ppt, ValueVec elems, int maxK, Random random) {
            super(k, n, ppt, elems, maxK);
            this.n = n;
            this.a = Math.abs(random.nextLong()) % n;
        }

        public Value randomSubset() {
            if (this.i < this.n) {
                return this.subsetAt((34359738337L * this.i++ + this.a) % this.n);
            }
            return null;
        }
    }

    public class Unrank {
        private final TreeMap<Long, Integer> sums = new TreeMap();
        private final long[] partialPascalTable;
        private final int maxK;
        private final ValueVec elems;
        private final int k;

        public Unrank(int k, long n, long[] ppt, ValueVec elems, int maxK) {
            this.k = k;
            this.elems = elems;
            this.partialPascalTable = ppt;
            this.maxK = maxK - 1;
            int choice = Math.max(k - 1, 0);
            this.sums.put(-1L, choice);
            long bin = 0L;
            while ((bin = this.memoizedBinomial(choice, k)) < n) {
                this.sums.put(bin, ++choice);
            }
        }

        public Value subsetAt(long idx) {
            ValueVec vec = new ValueVec(this.k);
            int y = this.k;
            for (int choice = this.sums.lowerEntry(idx).getValue().intValue(); choice >= 0 && this.k > 0; --choice) {
                long c = this.memoizedBinomial(choice, y);
                if (c > idx) continue;
                idx -= c;
                --y;
                vec.addElement(this.elems.elementAt(choice));
            }
            return new SetEnumValue(vec, false, SubsetValue.this.cm);
        }

        protected long memoizedBinomial(int n, int k) {
            if (k == 0 || k == n) {
                return 1L;
            }
            if (k == 1 || k == n - 1) {
                return n;
            }
            if (n == 0 || k > n) {
                return 0L;
            }
            int pti = Combinatorics.choosePairToInt(n, k);
            if (pti < Combinatorics.CHOOSETABLE.length) {
                return Combinatorics.choose(n, k);
            }
            return this.partialPascalTable[(n - 62 - 1) * this.maxK + k - 2];
        }
    }
}

