/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.util.List;
import java.util.Optional;
import tlc2.model.MCError;
import tlc2.model.MCState;
import tlc2.output.IMessagePrinterRecorder;
import tlc2.tool.TLCStateInfo;

public class ErrorTraceMessagePrinterRecorder
implements IMessagePrinterRecorder {
    private Optional<MCError> errorTrace = Optional.empty();
    private boolean traceFinished = false;

    public Optional<MCError> getMCErrorTrace() {
        return this.errorTrace;
    }

    @Override
    public void record(int code, Object ... objects) {
        if (!this.traceFinished) {
            switch (code) {
                case 2217: {
                    if (objects.length < 2 || !(objects[0] instanceof TLCStateInfo) || !(objects[1] instanceof Integer)) break;
                    TLCStateInfo stateInfo = (TLCStateInfo)objects[0];
                    Integer stateOrdinal = (Integer)objects[1];
                    stateInfo.stateNumber = stateOrdinal.intValue();
                    this.errorTrace = Optional.of(this.errorTrace.orElse(new MCError()));
                    MCState state = new MCState(stateInfo);
                    this.errorTrace.ifPresent(trace -> trace.addState(state));
                    break;
                }
                case 2218: {
                    this.traceFinished = true;
                    this.errorTrace.ifPresent(trace -> {
                        List<MCState> states = trace.getStates();
                        if (states.size() > 0) {
                            MCState finalState = states.get(states.size() - 1);
                            MCState stutteringState = new MCState(finalState, true, false);
                            trace.addState(stutteringState);
                        }
                    });
                    break;
                }
                case 2122: {
                    Optional<Integer> stateOrdinal = Optional.empty();
                    if (objects.length >= 2 && objects[0] instanceof TLCStateInfo && objects[1] instanceof Integer) {
                        stateOrdinal = Optional.of((Integer)objects[1]);
                    } else if (objects.length >= 2 && objects[0] instanceof String && objects[1] instanceof String) {
                        try {
                            stateOrdinal = Optional.of(Integer.parseInt((String)objects[0]));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    stateOrdinal.ifPresent(ord -> {
                        this.traceFinished = true;
                        this.errorTrace.ifPresent(trace -> {
                            List<MCState> states = trace.getStates();
                            if (0 < ord && ord <= states.size()) {
                                MCState finalState = states.get(ord - 1);
                                MCState lassoState = new MCState(finalState, false, true);
                                trace.addState(lassoState);
                            }
                        });
                    });
                }
            }
        }
    }
}

