/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.modanalyzer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import pcal.Validator;
import tla2sany.modanalyzer.ModuleContext;
import tla2sany.modanalyzer.ModulePointer;
import tla2sany.modanalyzer.ModuleRelationships;
import tla2sany.modanalyzer.ModuleRelatives;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Vector;
import util.FileUtil;
import util.FilenameToStream;
import util.NamedInputStream;
import util.ToolIO;

public class SpecObj {
    String primaryFileName;
    final ExternalModuleTable externalModuleTable = new ExternalModuleTable();
    public Vector semanticAnalysisVector = new Vector();
    public Hashtable<String, ParseUnit> parseUnitContext = new Hashtable();
    private ModuleRelationships moduleRelationshipsSpec = new ModuleRelationships();
    private FilenameToStream resolver = null;
    ParseUnit rootParseUnit = null;
    ModulePointer rootModule = null;
    String rootModuleName;
    public Errors initErrors = new Errors();
    public Errors parseErrors = new Errors();
    private Errors globalContextErrors = new Errors();
    public Errors semanticErrors = new Errors();
    public int errorLevel = 0;
    String nextParseUnitName = "";
    ModulePointer nextExtenderOrInstancerModule = null;
    boolean extentionFound;
    boolean instantiationFound;

    public SpecObj(String pfn) {
        this(pfn, null);
    }

    public SpecObj(String pfn, FilenameToStream ntfis) {
        if (ntfis == null) {
            ntfis = ToolIO.getDefaultResolver();
        }
        this.primaryFileName = pfn;
        this.resolver = ntfis;
    }

    public final int getErrorLevel() {
        return this.errorLevel;
    }

    public final String getName() {
        return this.rootModuleName;
    }

    public final void setName(String name) {
        this.rootModuleName = name;
    }

    public final String getFileName() {
        return this.primaryFileName;
    }

    public final ModuleNode getRootModule() {
        return this.getExternalModuleTable().getRootModule();
    }

    public final ExternalModuleTable getExternalModuleTable() {
        return this.externalModuleTable;
    }

    public final Errors getInitErrors() {
        return this.initErrors;
    }

    public final Errors getParseErrors() {
        return this.parseErrors;
    }

    public final Errors getGlobalContextErrors() {
        return this.globalContextErrors;
    }

    public final Errors getSemanticErrors() {
        return this.semanticErrors;
    }

    public Set<String> getModuleNames() {
        HashSet<String> s = new HashSet<String>();
        Enumeration<ModulePointer> modules = this.getModules();
        while (modules.hasMoreElements()) {
            s.add(modules.nextElement().getName());
        }
        return s;
    }

    public final Enumeration<ModulePointer> getModules() {
        return this.moduleRelationshipsSpec.getKeys();
    }

    final ModuleRelationships getModuleRelationships() {
        return this.moduleRelationshipsSpec;
    }

    public final void printParseUnitContext() {
        Enumeration<String> enumerate = this.parseUnitContext.keys();
        ToolIO.out.println("parseUnitContext =");
        while (enumerate.hasMoreElements()) {
            String key = enumerate.nextElement();
            ToolIO.out.println("  " + key + "-->" + this.parseUnitContext.get(key).getName());
        }
    }

    private final ParseUnit findOrCreateParsedUnit(String name, Errors errors, boolean firstCall) throws AbortException {
        ParseUnit parseUnit = this.parseUnitContext.get(name);
        if (parseUnit == null) {
            NamedInputStream nis = this.rootParseUnit != null ? FileUtil.createNamedInputStream(name, this.resolver, this.rootParseUnit.getNis()) : FileUtil.createNamedInputStream(name, this.resolver);
            if (nis != null) {
                parseUnit = new ParseUnit(this, nis);
                this.parseUnitContext.put(parseUnit.getName(), parseUnit);
            } else {
                errors.addAbort("Cannot find source file for module " + name + (this.nextExtenderOrInstancerModule == null ? "" : " imported in module " + this.nextExtenderOrInstancerModule.getName()) + ".");
            }
        }
        parseUnit.parseFile(errors, firstCall, name, this.rootParseUnit);
        return parseUnit;
    }

    private void calculateDependencies(ParseUnit currentParseUnit) {
        int i;
        Vector extendees = currentParseUnit.getExtendees();
        Vector instancees = currentParseUnit.getInstancees();
        for (i = 0; i < extendees.size(); ++i) {
            this.calculateDependencies((ParseUnit)extendees.elementAt(i));
        }
        for (i = 0; i < instancees.size(); ++i) {
            this.calculateDependencies((ParseUnit)instancees.elementAt(i));
        }
        if (!this.semanticAnalysisVector.contains(currentParseUnit.getName())) {
            this.semanticAnalysisVector.addElement(currentParseUnit.getName());
        }
    }

    private String pathToString(Vector path) {
        String ret = "";
        for (int i = 0; i < path.size(); ++i) {
            ret = ret + ((ParseUnit)path.elementAt(i)).getFileName() + " --> ";
        }
        return ret + ((ParseUnit)path.elementAt(0)).getFileName();
    }

    private void nonCircularityTest(ParseUnit parseUnit, Errors errors) throws AbortException {
        HashSet<ParseUnit> alreadyVisited = new HashSet<ParseUnit>();
        Vector<ParseUnit> circularPath = new Vector<ParseUnit>();
        circularPath.addElement(parseUnit);
        this.nonCircularityBody(parseUnit, parseUnit, errors, alreadyVisited, circularPath);
    }

    private void nonCircularityBody(ParseUnit parseUnit, ParseUnit candidate, Errors errors, Set<ParseUnit> alreadyVisited, Vector circularPath) throws AbortException {
        if (alreadyVisited.contains(candidate)) {
            return;
        }
        alreadyVisited.add(candidate);
        Vector referencees = candidate.getExtendees();
        referencees.appendNoRepeats(candidate.getInstancees());
        for (int i = 0; i < referencees.size(); ++i) {
            ParseUnit referencee = (ParseUnit)referencees.elementAt(i);
            if (referencee == parseUnit) {
                errors.addAbort("Circular dependency among .tla files; dependency cycle is:\n\n  " + this.pathToString(circularPath));
                continue;
            }
            circularPath.addElement(referencee);
            this.nonCircularityBody(parseUnit, referencee, errors, alreadyVisited, circularPath);
            circularPath.removeElementAt(circularPath.size() - 1);
        }
    }

    private boolean findNextUnresolvedExtention(ModulePointer currentModule) {
        HashSet alreadyVisited = new HashSet();
        return this.findNextUnresolvedExtentionBody(currentModule, alreadyVisited);
    }

    private boolean findNextUnresolvedExtentionBody(ModulePointer currentModule, HashSet alreadyVisited) {
        int i;
        if (alreadyVisited.contains(currentModule)) {
            this.extentionFound = false;
            return false;
        }
        alreadyVisited.add(currentModule);
        ModuleContext currentContext = currentModule.getContext();
        Vector extendees = currentModule.getNamesOfModulesExtended();
        Vector instancees = currentModule.getNamesOfModulesInstantiated();
        for (i = 0; i < extendees.size(); ++i) {
            if (currentContext.resolve((String)extendees.elementAt(i)) != null) continue;
            this.nextParseUnitName = (String)extendees.elementAt(i);
            this.nextExtenderOrInstancerModule = currentModule;
            this.extentionFound = true;
            return true;
        }
        for (i = 0; i < extendees.size(); ++i) {
            if (!this.findNextUnresolvedExtentionBody(currentContext.resolve((String)extendees.elementAt(i)), alreadyVisited)) continue;
            this.extentionFound = true;
            return true;
        }
        for (i = 0; i < instancees.size(); ++i) {
            if (currentContext.resolve((String)instancees.elementAt(i)) == null || !this.findNextUnresolvedExtentionBody(currentContext.resolve((String)instancees.elementAt(i)), alreadyVisited)) continue;
            this.extentionFound = true;
            return true;
        }
        Vector innerModules = currentModule.getDirectInnerModules();
        for (int i2 = 0; i2 < innerModules.size(); ++i2) {
            if (!this.findNextUnresolvedExtentionBody((ModulePointer)innerModules.elementAt(i2), alreadyVisited)) continue;
            this.extentionFound = true;
            return true;
        }
        this.extentionFound = false;
        return false;
    }

    private boolean findNextUnresolvedInstantiation(ModulePointer currentModule) {
        HashSet alreadyVisited = new HashSet();
        return this.findNextUnresolvedInstantiationBody(currentModule, alreadyVisited);
    }

    private boolean instanceResolvesToInternalModule(ModulePointer currentModule, String instanceeName) {
        TreeNode body = currentModule.getBody();
        HashSet<String> internalModulesSeen = new HashSet<String>();
        for (int i = 0; i < body.heirs().length; ++i) {
            int nonLocalInstanceNodeIX;
            TreeNode[] instanceHeirs;
            String instanceModuleName;
            TreeNode def = body.heirs()[i];
            if (def.getImage().equals("N_Module")) {
                String innerModuleName = def.heirs()[0].heirs()[1].getImage();
                internalModulesSeen.add(innerModuleName);
                continue;
            }
            if (!(def.getImage().equals("N_Instance") ? (instanceModuleName = instanceHeirs[nonLocalInstanceNodeIX = (instanceHeirs = def.heirs())[0].getImage().equals("LOCAL") ? 1 : 0].heirs()[1].getImage()).equals(instanceeName) : def.getImage().equals("N_ModuleDefinition") && (instanceModuleName = instanceHeirs[nonLocalInstanceNodeIX = (instanceHeirs = def.heirs())[0].getImage().equals("LOCAL") ? 3 : 2].heirs()[1].getImage()).equals(instanceeName))) continue;
            return internalModulesSeen.contains(instanceeName);
        }
        return false;
    }

    private boolean findNextUnresolvedInstantiationBody(ModulePointer currentModule, HashSet alreadyVisited) {
        int i;
        if (alreadyVisited.contains(currentModule)) {
            this.instantiationFound = false;
            return false;
        }
        alreadyVisited.add(currentModule);
        ModuleContext currentContext = currentModule.getContext();
        Vector extendees = currentModule.getNamesOfModulesExtended();
        Vector instancees = currentModule.getNamesOfModulesInstantiated();
        for (i = 0; i < instancees.size(); ++i) {
            if (currentContext.resolve((String)instancees.elementAt(i)) != null || this.instanceResolvesToInternalModule(currentModule, (String)instancees.elementAt(i))) continue;
            this.nextParseUnitName = (String)instancees.elementAt(i);
            this.nextExtenderOrInstancerModule = currentModule;
            this.instantiationFound = true;
            return true;
        }
        for (i = 0; i < extendees.size(); ++i) {
            if (!this.findNextUnresolvedInstantiationBody(currentContext.resolve((String)extendees.elementAt(i)), alreadyVisited)) continue;
            this.instantiationFound = true;
            return true;
        }
        for (i = 0; i < instancees.size(); ++i) {
            if (currentContext.resolve((String)instancees.elementAt(i)) == null || !this.findNextUnresolvedInstantiationBody(currentContext.resolve((String)instancees.elementAt(i)), alreadyVisited)) continue;
            this.instantiationFound = true;
            return true;
        }
        Vector innerModules = currentModule.getDirectInnerModules();
        for (int i2 = 0; i2 < innerModules.size(); ++i2) {
            if (!this.findNextUnresolvedInstantiationBody((ModulePointer)innerModules.elementAt(i2), alreadyVisited)) continue;
            this.instantiationFound = true;
            return true;
        }
        this.instantiationFound = false;
        return false;
    }

    private boolean directlyExtends(ModulePointer mod1, ModulePointer mod2) {
        ModuleRelatives mod1Rels = mod1.getRelatives();
        Vector extendees = mod1Rels.directlyExtendedModuleNames;
        ModuleContext mod1Context = mod1Rels.context;
        for (int i = 0; i < extendees.size(); ++i) {
            if (mod1Context.resolve((String)extendees.elementAt(i)) != mod2) continue;
            return true;
        }
        return false;
    }

    private Vector getModulesIndirectlyExtending(ModulePointer module) {
        Vector<ModulePointer> extenders = new Vector<ModulePointer>();
        extenders.addElement(module);
        boolean additions = true;
        int lastAdditionsStart = 0;
        int lastAdditionsEnd = extenders.size();
        while (additions) {
            additions = false;
            for (int i = lastAdditionsStart; i < lastAdditionsEnd; ++i) {
                Enumeration<ModulePointer> enumModules = this.getModules();
                while (enumModules.hasMoreElements()) {
                    ModulePointer modPointer = enumModules.nextElement();
                    if (!this.directlyExtends(modPointer, (ModulePointer)extenders.elementAt(i))) continue;
                    if (!additions) {
                        lastAdditionsStart = lastAdditionsEnd;
                    }
                    extenders.addElement(modPointer);
                    additions = true;
                }
                lastAdditionsStart = lastAdditionsEnd;
                lastAdditionsEnd = extenders.size();
            }
        }
        return extenders;
    }

    private void resolveNamesBetweenSpecAndInstantiation(ModulePointer instancer, ParseUnit instancee) {
        ModuleContext instancerContext = instancer.getRelatives().context;
        instancerContext.bindIfNotBound(instancee.getName(), instancee.getRootModule());
    }

    private void resolveNamesBetweenSpecAndExtention(ModulePointer extender, ParseUnit extendee) {
        ModuleContext extenderContext = extender.getRelatives().context;
        extenderContext.bindIfNotBound(extendee.getName(), extendee.getRootModule());
        Vector modulesIndirectlyExtending = this.getModulesIndirectlyExtending(extender);
        for (int i = 0; i < modulesIndirectlyExtending.size(); ++i) {
            this.resolveNamesBetweenModuleAndExtention((ModulePointer)modulesIndirectlyExtending.elementAt(i), extendee);
        }
    }

    private void resolveNamesBetweenModuleAndExtention(ModulePointer extenderModule, ParseUnit extendeeParseUnit) {
        String extendeeInnerName;
        ModulePointer extendeeInnerModule;
        int j;
        Vector extendeeInnerModules;
        int i;
        ModuleRelatives extenderRelatives = extenderModule.getRelatives();
        ModuleContext extenderContext = extenderRelatives.context;
        Vector instantiatedNames = extenderRelatives.directlyInstantiatedModuleNames;
        Vector extendedNames = extenderRelatives.directlyExtendedModuleNames;
        block0: for (i = 0; i < extendedNames.size(); ++i) {
            String extendedName = (String)extendedNames.elementAt(i);
            extendeeInnerModules = extendeeParseUnit.getRootModule().getDirectInnerModules();
            for (j = 0; j < extendeeInnerModules.size(); ++j) {
                extendeeInnerModule = (ModulePointer)extendeeInnerModules.elementAt(j);
                extendeeInnerName = extendeeInnerModule.getName();
                if (!extendedName.equals(extendeeInnerName)) continue;
                extenderContext.bindIfNotBound(extendedName, extendeeInnerModule);
                continue block0;
            }
        }
        block2: for (i = 0; i < instantiatedNames.size(); ++i) {
            String instanceName = (String)instantiatedNames.elementAt(i);
            extendeeInnerModules = extendeeParseUnit.getRootModule().getDirectInnerModules();
            for (j = 0; j < extendeeInnerModules.size(); ++j) {
                extendeeInnerModule = (ModulePointer)extendeeInnerModules.elementAt(j);
                extendeeInnerName = extendeeInnerModule.getName();
                if (!instanceName.equals(extendeeInnerName)) continue;
                extenderContext.bindIfNotBound(instanceName, extendeeInnerModule);
                continue block2;
            }
        }
        Vector extenderInnerModules = extenderRelatives.directInnerModules;
        for (int i2 = 0; i2 < extenderInnerModules.size(); ++i2) {
            ModulePointer nextInner = (ModulePointer)extenderInnerModules.elementAt(i2);
            this.resolveNamesBetweenModuleAndExtention(nextInner, extendeeParseUnit);
        }
    }

    public boolean loadSpec(String rootExternalModuleName, Errors errors) throws AbortException {
        return this.loadSpec(rootExternalModuleName, errors, false);
    }

    public boolean loadSpec(String rootExternalModuleName, Errors errors, boolean validateParseUnits) throws AbortException {
        this.rootParseUnit = this.findOrCreateParsedUnit(rootExternalModuleName, errors, true);
        this.rootModule = this.rootParseUnit.getRootModule();
        if (validateParseUnits) {
            this.validateParseUnit(this.rootParseUnit);
        }
        ParseUnit nextExtentionOrInstantiationParseUnit = null;
        while (this.findNextUnresolvedExtention(this.rootModule) || this.findNextUnresolvedInstantiation(this.rootModule)) {
            nextExtentionOrInstantiationParseUnit = this.parseUnitContext.get(this.nextParseUnitName) == null ? this.findOrCreateParsedUnit(this.nextParseUnitName, errors, false) : this.parseUnitContext.get(this.nextParseUnitName);
            ParseUnit extenderOrInstancerParseUnit = this.nextExtenderOrInstancerModule.getParseUnit();
            if (this.extentionFound) {
                if (validateParseUnits) {
                    this.validateParseUnit(nextExtentionOrInstantiationParseUnit);
                }
                extenderOrInstancerParseUnit.addExtendee(nextExtentionOrInstantiationParseUnit);
                nextExtentionOrInstantiationParseUnit.addExtendedBy(extenderOrInstancerParseUnit);
            }
            if (this.instantiationFound) {
                extenderOrInstancerParseUnit.addInstancee(nextExtentionOrInstantiationParseUnit);
                nextExtentionOrInstantiationParseUnit.addInstancedBy(extenderOrInstancerParseUnit);
            }
            this.nonCircularityTest(nextExtentionOrInstantiationParseUnit, errors);
            if (this.extentionFound) {
                this.resolveNamesBetweenSpecAndExtention(this.nextExtenderOrInstancerModule, nextExtentionOrInstantiationParseUnit);
            }
            if (!this.instantiationFound) continue;
            this.resolveNamesBetweenSpecAndInstantiation(this.nextExtenderOrInstancerModule, nextExtentionOrInstantiationParseUnit);
        }
        this.calculateDependencies(this.rootParseUnit);
        return true;
    }

    private void validateParseUnit(ParseUnit parseUnit) {
        File f = parseUnit.getNis().sourceFile();
        try (FileInputStream fis = new FileInputStream(f);){
            Set<Validator.ValidationResult> results = Validator.validate(parseUnit, fis);
            if (results.contains((Object)Validator.ValidationResult.TLA_DIVERGENCE_EXISTS) && results.contains((Object)Validator.ValidationResult.PCAL_DIVERGENCE_EXISTS)) {
                ToolIO.out.println(String.format("!! WARNING: The PlusCal algorithm and its TLA+ translation in module %s filename since the last translation.", parseUnit.getName()));
            } else if (results.contains((Object)Validator.ValidationResult.TLA_DIVERGENCE_EXISTS)) {
                ToolIO.out.println(String.format("!! WARNING: The TLA+ translation in module %s has changed since its last translation.", parseUnit.getName()));
            } else if (results.contains((Object)Validator.ValidationResult.PCAL_DIVERGENCE_EXISTS)) {
                ToolIO.out.println(String.format("!! WARNING: The PlusCal algorithm in module %s has changed since its last translation.", parseUnit.getName()));
            } else if (results.contains((Object)Validator.ValidationResult.ERROR_ENCOUNTERED)) {
                ToolIO.err.println("A unexpected problem was encountered attempting to validate the specification for " + parseUnit.getName());
            }
        }
        catch (IOException e) {
            ToolIO.err.println("Encountered an exception while attempt to validate " + f.getAbsolutePath() + " - " + e.getMessage());
        }
    }

    public FilenameToStream getResolver() {
        return this.resolver;
    }

    public void setGlobalContextErrors(Errors globalContextErrors) {
        this.globalContextErrors = globalContextErrors;
    }

    public ParseUnit getRootParseUnit() {
        return this.parseUnitContext.get(this.getName());
    }
}

