/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.BEGraphNode;
import tlc2.tool.liveness.BTGraphNode;

public final class NodeTable {
    private int count = 0;
    private int length;
    private int thresh;
    private Object[] elems;
    private boolean isBT;

    public NodeTable(int size, boolean isBT) {
        this.length = size;
        this.thresh = size / 2;
        this.elems = new Object[size];
        this.isBT = isBT;
    }

    private final void grow() {
        Object[] oldElems = this.elems;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.elems = new Object[this.length];
        for (int i = 0; i < oldElems.length; ++i) {
            Object elem = oldElems[i];
            if (elem == null) continue;
            if (this.isBT) {
                this.putBTNodes(elem);
                continue;
            }
            this.putBENode((BEGraphNode)elem);
        }
    }

    public final int size() {
        return this.count;
    }

    public final int putBENode(BEGraphNode node) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        long k = node.stateFP;
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (true) {
            BEGraphNode node1;
            if ((node1 = (BEGraphNode)this.elems[loc]) == null) {
                this.elems[loc] = node;
                ++this.count;
                return loc;
            }
            if (node1.stateFP == k) {
                this.elems[loc] = node;
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final BEGraphNode getBENode(long k) {
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        BEGraphNode node;
        while ((node = (BEGraphNode)this.elems[loc]) != null) {
            if (node.stateFP == k) {
                return node;
            }
            loc = (loc + 1) % this.length;
        }
        return null;
    }

    private final int putBTNodes(Object nodes) {
        long k = nodes instanceof BTGraphNode ? ((BTGraphNode)nodes).stateFP : ((BTGraphNode[])nodes)[0].stateFP;
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (this.elems[loc] != null) {
            loc = (loc + 1) % this.length;
        }
        this.elems[loc] = nodes;
        ++this.count;
        return loc;
    }

    public final int putBTNode(BTGraphNode node) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        long k1 = node.stateFP;
        int k2 = node.getIndex();
        int loc = ((int)k1 & Integer.MAX_VALUE) % this.length;
        while (true) {
            Object elem;
            if ((elem = this.elems[loc]) == null) {
                this.elems[loc] = node;
                ++this.count;
                return loc;
            }
            if (elem instanceof BTGraphNode) {
                BTGraphNode btnode = (BTGraphNode)elem;
                if (btnode.stateFP == k1) {
                    if (btnode.isDummy()) {
                        this.elems[loc] = node;
                    } else if (btnode.getIndex() != k2) {
                        BTGraphNode[] newElem = new BTGraphNode[]{btnode, node};
                        this.elems[loc] = newElem;
                    }
                    return loc;
                }
            } else {
                BTGraphNode[] nodes = (BTGraphNode[])elem;
                if (nodes[0].stateFP == k1) {
                    for (int i = 0; i < nodes.length; ++i) {
                        if (nodes[i].getIndex() != k2) continue;
                        return loc;
                    }
                    BTGraphNode[] newElem = new BTGraphNode[nodes.length + 1];
                    for (int i = 0; i < nodes.length; ++i) {
                        newElem[i] = nodes[i];
                    }
                    newElem[nodes.length] = node;
                    this.elems[loc] = newElem;
                    return loc;
                }
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final BTGraphNode[] getBTNode(long k) {
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        Object elem;
        while ((elem = this.elems[loc]) != null) {
            if (elem instanceof BTGraphNode) {
                BTGraphNode btnode = (BTGraphNode)elem;
                if (btnode.stateFP == k) {
                    if (btnode.isDummy()) {
                        return null;
                    }
                    BTGraphNode[] nodes = new BTGraphNode[]{btnode};
                    return nodes;
                }
            } else {
                BTGraphNode[] nodes = (BTGraphNode[])elem;
                if (nodes[0].stateFP == k) {
                    return nodes;
                }
            }
            loc = (loc + 1) % this.length;
        }
        return null;
    }

    public final BTGraphNode[] getBTNodeWithHint(long k, int hintLoc) {
        Object elem = this.elems[hintLoc];
        if (elem != null) {
            if (elem instanceof BTGraphNode) {
                BTGraphNode btnode = (BTGraphNode)elem;
                if (btnode.stateFP == k) {
                    if (btnode.isDummy()) {
                        return null;
                    }
                    BTGraphNode[] nodes = new BTGraphNode[]{btnode};
                    return nodes;
                }
            } else {
                BTGraphNode[] nodes = (BTGraphNode[])elem;
                if (nodes[0].stateFP == k) {
                    return nodes;
                }
            }
        }
        return this.getBTNode(k);
    }

    public final BTGraphNode getBTNode(long k1, int k2) {
        int loc = ((int)k1 & Integer.MAX_VALUE) % this.length;
        Object elem;
        while ((elem = this.elems[loc]) != null) {
            if (elem instanceof BTGraphNode) {
                BTGraphNode node = (BTGraphNode)elem;
                if (node.stateFP == k1) {
                    if (node.isDummy() || node.getIndex() != k2) {
                        return null;
                    }
                    return node;
                }
            } else {
                BTGraphNode[] nodes = (BTGraphNode[])elem;
                if (nodes[0].stateFP == k1) {
                    for (int i = 0; i < nodes.length; ++i) {
                        BTGraphNode node = nodes[i];
                        if (node.getIndex() != k2) continue;
                        return node;
                    }
                    return null;
                }
            }
            loc = (loc + 1) % this.length;
        }
        return null;
    }

    public final boolean isDone(int loc) {
        Object elem = this.elems[loc];
        if (elem == null) {
            return false;
        }
        if (elem instanceof BTGraphNode) {
            return ((BTGraphNode)elem).isDone();
        }
        return ((BTGraphNode[])elem)[0].isDone();
    }

    public final void setDone(long k) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        if (!this.isBT) {
            return;
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (true) {
            Object elem;
            if ((elem = this.elems[loc]) == null) {
                this.elems[loc] = BTGraphNode.makeDummy(k);
                ++this.count;
                return;
            }
            if (elem instanceof BTGraphNode) {
                BTGraphNode node = (BTGraphNode)elem;
                if (node.stateFP == k) {
                    node.setDone();
                    return;
                }
            } else {
                BTGraphNode[] nodes = (BTGraphNode[])elem;
                if (nodes[0].stateFP == k) {
                    ((BTGraphNode[])elem)[0].setDone();
                    return;
                }
            }
            loc = (loc + 1) % this.length;
        }
    }
}

