/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util.statistics;

import java.util.Map;
import java.util.NavigableMap;
import javax.management.NotCompliantMBeanException;
import tlc2.output.MP;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.util.statistics.IBucketStatistics;
import tlc2.util.statistics.management.BucketStatisticsMXWrapper;

public abstract class AbstractBucketStatistics
implements IBucketStatistics {
    protected final String title;

    public AbstractBucketStatistics(String aTitle) {
        this.title = aTitle;
    }

    public AbstractBucketStatistics(String aTitle, String pkg, String name) {
        this(aTitle);
        try {
            new BucketStatisticsMXWrapper(this, name, pkg);
        }
        catch (NotCompliantMBeanException e) {
            MP.printWarning(1000, "Failed to create MBean wrapper for BucketStatistics. No statistics/metrics will be avaiable.", e);
            TLCStandardMBean.getNullTLCStandardMBean();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("============================%n");
        buf.append("=" + this.title + "=%n");
        buf.append("============================%n");
        buf.append(String.format("Observations: %d%n", this.getObservations()));
        buf.append(String.format("Min: %d%n", this.getMin()));
        buf.append(String.format("Max: %d%n", this.getMax()));
        buf.append(String.format("Mean: %.2f%n", this.getMean()));
        buf.append(String.format("Median: %d%n", this.getMedian()));
        buf.append(String.format("Standard deviation: %.2f%n", this.getStdDev()));
        buf.append(String.format("75%%: %.2f%n", this.getPercentile(0.75)));
        buf.append(String.format("95%%: %.2f%n", this.getPercentile(0.95)));
        buf.append(String.format("98%%: %.2f%n", this.getPercentile(0.98)));
        buf.append(String.format("99%%: %.2f%n", this.getPercentile(0.99)));
        buf.append(String.format("99.9%%: %.2f%n", this.getPercentile(0.999)));
        buf.append("numEdges/occurrences (log scale)%n");
        buf.append("--------------------------------%n");
        for (Map.Entry next : this.getSamples().entrySet()) {
            long amount = (Long)next.getValue();
            int i = (Integer)next.getKey();
            buf.append(String.format("%02d", i));
            buf.append(":");
            buf.append(String.format("%02d", amount));
            buf.append(" ");
            int j = 0;
            while ((double)j < Math.log(amount)) {
                buf.append("#");
                ++j;
            }
            buf.append("%n");
        }
        buf.append("============================");
        return buf.toString();
    }

    @Override
    public int getMedian() {
        long l = this.getObservations();
        if (l <= 0L) {
            return -1;
        }
        long sum = 0L;
        for (Map.Entry next : this.getSamples().entrySet()) {
            if ((sum += ((Long)next.getValue()).longValue()) <= l / 2L) continue;
            return (Integer)next.getKey();
        }
        throw new RuntimeException("bug, shoud not get here");
    }

    @Override
    public double getMean() {
        long sum = 0L;
        for (Map.Entry next : this.getSamples().entrySet()) {
            long value = (Long)next.getValue();
            int i = (Integer)next.getKey();
            sum += value * (long)i;
        }
        if (this.getObservations() > 0L) {
            return (double)sum / ((double)this.getObservations() * 1.0);
        }
        return -1.0;
    }

    @Override
    public int getMin() {
        if (this.getObservations() <= 0L) {
            return -1;
        }
        return (Integer)this.getSamples().firstKey();
    }

    @Override
    public int getMax() {
        if (this.getObservations() <= 0L) {
            return -1;
        }
        return (Integer)this.getSamples().lastKey();
    }

    @Override
    public double getStdDev() {
        long N = this.getObservations();
        if (N <= 0L) {
            return -1.0;
        }
        double mean = this.getMean() * 1.0;
        double sum = 0.0;
        for (Map.Entry next : this.getSamples().entrySet()) {
            double Xi = (double)((Integer)next.getKey()).intValue() * 1.0;
            double diff = Xi - mean;
            sum += diff * diff * ((double)((Long)next.getValue()).longValue() * 1.0);
        }
        double variance = sum / ((double)N * 1.0);
        double stdDev = Math.sqrt(variance);
        return stdDev;
    }

    @Override
    public double getPercentile(double quantile) {
        if (Double.isNaN(quantile)) {
            throw new IllegalArgumentException("NaN");
        }
        long obsv = this.getObservations();
        if (obsv <= 0L) {
            return -1.0;
        }
        quantile = Math.min(1.0, quantile);
        quantile = Math.max(0.0, quantile);
        NavigableMap<Integer, Long> samples = this.getSamples();
        int pos = (int)((double)obsv * 1.0 * quantile);
        if ((long)pos > obsv) {
            return samples.size();
        }
        if (pos < 0) {
            return 0.0;
        }
        long cnt = 0L;
        for (Map.Entry next : samples.entrySet()) {
            int i = (Integer)next.getKey();
            if ((cnt += ((Long)next.getValue()).longValue()) <= (long)pos) continue;
            return i;
        }
        return quantile;
    }
}

