/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tlc2.output.AbstractCopier;
import tlc2.output.SpecWriterUtilities;

public class CFGCopier
extends AbstractCopier {
    private static final String SPECIFICATION_COMMENT_REGEX = "^\\\\\\* SPECIFICATION.*$?";
    private static final Pattern SPECIFICATION_COMMENT_PATTERN = Pattern.compile("^\\\\\\* SPECIFICATION.*$?");
    private static final String INIT_COMMENT_REGEX = "^\\\\\\* INIT.*$?";
    private static final Pattern INIT_COMMENT_PATTERN = Pattern.compile("^\\\\\\* INIT.*$?");
    private static final String NEXT_COMMENT_REGEX = "^\\\\\\* NEXT.*$?";
    private static final Pattern NEXT_COMMENT_PATTERN = Pattern.compile("^\\\\\\* NEXT.*$?");
    private boolean skipNextLine = false;
    private final String initNextConfiguration;

    public CFGCopier(String originalName, String newName, File sourceLocation, String initNextCFG) {
        super(originalName, newName, sourceLocation);
        this.initNextConfiguration = initNextCFG;
    }

    @Override
    protected String getFileExtension() {
        return ".cfg";
    }

    @Override
    protected void copyLine(BufferedWriter writer, String originalLine, int lineNumber) throws IOException {
        Matcher next;
        Matcher init;
        if (this.skipNextLine) {
            this.skipNextLine = false;
            return;
        }
        Matcher comment = SPECIFICATION_COMMENT_PATTERN.matcher(originalLine);
        if (!(comment.matches() || (init = INIT_COMMENT_PATTERN.matcher(originalLine)).matches() || (next = NEXT_COMMENT_PATTERN.matcher(originalLine)).matches())) {
            String trimmed = originalLine.trim();
            if ("SPECIFICATION".equals(trimmed) || "INIT".equals(trimmed) || "NEXT".equals(trimmed)) {
                this.skipNextLine = true;
            } else if (!(trimmed.startsWith("SPECIFICATION") || trimmed.startsWith("INIT") || trimmed.startsWith("NEXT") || trimmed.startsWith("\\* Generated on "))) {
                writer.write(originalLine + '\n');
            }
        }
    }

    @Override
    protected void allInputHasBeenConsumed(BufferedWriter writer) throws IOException {
        writer.write(this.initNextConfiguration + '\n');
        writer.write(SpecWriterUtilities.getGeneratedTimeStampCommentLine().toString() + '\n');
    }

    public static void main(String[] args) throws Exception {
        String initNext = "INIT\ninit_abc_ldq\n\nNEXT\nnext_abc_ldq";
        CFGCopier copier = new CFGCopier("MC", "TTrace", new File(args[0]), "INIT\ninit_abc_ldq\n\nNEXT\nnext_abc_ldq");
        copier.copy();
    }
}

