/*
 * Decompiled with CFR 0.152.
 */
package tlc2.input;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tlc2.input.MCOutputMessage;
import tlc2.model.MCError;
import tlc2.model.MCState;

abstract class AbstractMCOutputConsumer {
    private static final int MAX_READ_RETRIES = 60;
    private static final long SLEEP_BETWEEN_RETRIES = 500L;
    private static final String START_MESSAGE_REGEX = "@!@!@STARTMSG ([0-9]{4}):([0-9]{1,2}) @!@!@";
    private static final String END_MESSAGE_REGEX = "@!@!@ENDMSG [0-9]{4} @!@!@";
    protected static final Pattern START_MESSAGE_PATTERN = Pattern.compile("@!@!@STARTMSG ([0-9]{4}):([0-9]{1,2}) @!@!@");
    protected static final Pattern END_MESSAGE_PATTERN = Pattern.compile("@!@!@ENDMSG [0-9]{4} @!@!@");
    private MCError error;

    AbstractMCOutputConsumer() {
    }

    public MCError getError() {
        return this.error;
    }

    protected void handleUnknownReadLine(String line) throws IOException {
    }

    protected void consumeErrorMessageAndStates(BufferedReader reader, MCOutputMessage errorMessage) throws IOException {
        MCError currentError = null;
        currentError = this.error == null ? (this.error = new MCError(null, errorMessage.getBody())) : new MCError(currentError != null ? currentError : this.error, errorMessage.getBody());
        MCOutputMessage message = this.parseChunk(reader);
        if (message == null || message.getType() != 1) {
            throw new IOException("Expected an error message like 'The behavior up to this point is...' but didn't find one after[" + currentError.getMessage() + "]");
        }
        boolean inStateTrace = true;
        while (inStateTrace) {
            message = this.parseChunk(reader);
            if (message == null) {
                throw new IOException("Unexpected end of the log during state consumption for [" + currentError.getMessage() + "]");
            }
            if (message.getType() == 4) {
                currentError.addState(MCState.parseState(message.getBody()));
                continue;
            }
            inStateTrace = false;
        }
    }

    protected MCOutputMessage parseChunk(BufferedReader reader) throws IOException {
        MCOutputMessage message = null;
        String startLine = null;
        while (startLine == null) {
            String line = this.blockingReadLine(reader, true);
            if (line == null) {
                return null;
            }
            Matcher m = START_MESSAGE_PATTERN.matcher(line);
            if (m.find()) {
                message = new MCOutputMessage(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
                startLine = line;
                continue;
            }
            this.handleUnknownReadLine(line);
        }
        boolean chunkEndEncountered = false;
        StringBuilder sb = new StringBuilder();
        while (!chunkEndEncountered) {
            String line = this.blockingReadLine(reader, false);
            Matcher m = END_MESSAGE_PATTERN.matcher(line);
            if (m.find()) {
                message.setBody(sb);
                chunkEndEncountered = true;
                continue;
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        return message;
    }

    private String blockingReadLine(BufferedReader reader, boolean eofOK) throws IOException {
        int retry = 0;
        String line = reader.readLine();
        while (line == null) {
            if (++retry == 60) {
                if (eofOK) {
                    return null;
                }
                throw new IOException("We ran out of input unexpectedly.");
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            line = reader.readLine();
        }
        return line;
    }
}

