/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tlc2.TLCGlobals;
import tlc2.debug.IDebugTarget;
import tlc2.tool.Action;
import tlc2.tool.EvalControl;
import tlc2.tool.EvalException;
import tlc2.tool.IActionItemList;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.IStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateFun;
import tlc2.tool.TLCStateMutExt;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.ActionItemList;
import tlc2.tool.impl.FastTool;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.impl.Value;
import util.Assert;
import util.FilenameToStream;

public class DebugTool
extends Tool {
    private static final Set<Integer> KINDS = new HashSet<Integer>(Arrays.asList(16, 17, 18));
    private final IDebugTarget target;
    private final FastTool fastTool;
    private final Tool.Mode toolMode;
    private EvalMode mode = EvalMode.Const;

    public DebugTool(String mainFile, String configFile, FilenameToStream resolver, IDebugTarget target) {
        this(mainFile, configFile, resolver, Tool.Mode.MC_DEBUG, target);
    }

    public DebugTool(String mainFile, String configFile, FilenameToStream resolver, Tool.Mode mode, IDebugTarget target) {
        super(mainFile, configFile, resolver, mode);
        this.toolMode = mode;
        this.fastTool = new FastTool(this);
        TLCStateMutExt.setTool(this.fastTool);
        this.target = target.setTool(this);
    }

    @Override
    public boolean isValid(Action act, TLCState state) {
        this.mode = EvalMode.State;
        return this.isValid(act, state, TLCState.Empty);
    }

    @Override
    public final IValue eval(SemanticNode expr, Context ctxt) {
        this.mode = EvalMode.Const;
        return this.evalImpl(expr, Context.Empty, TLCState.Empty, TLCState.Empty, 0, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final IValue eval(SemanticNode expr, Context c, TLCState s0) {
        return this.eval(expr, c, s0, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final IValue eval(SemanticNode expr, Context c, TLCState s0, CostModel cm) {
        this.mode = EvalMode.State;
        return this.evalImpl(expr, c, s0, TLCState.Empty, 0, cm);
    }

    @Override
    public final Value eval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        if (this.mode == EvalMode.Debugger) {
            return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
        }
        if (s1 == null || EvalControl.isPrimed(control) || EvalControl.isEnabled(control)) {
            return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
        }
        if (this.mode == EvalMode.Action && s1.getAction() == null) {
            return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
        }
        if (EvalControl.isInit(control)) {
            this.mode = EvalMode.State;
            return this.evalImpl(expr, c, s0, s1, control, cm);
        }
        if (EvalControl.isConst(control)) {
            this.mode = EvalMode.Const;
            return this.evalImpl(expr, c, s0, s1, control, cm);
        }
        if (this.mode == EvalMode.State && s1 != null && s1.noneAssigned()) {
            return this.evalImpl(expr, c, s0, s1, control, cm);
        }
        if (this.mode == EvalMode.Const && s0.noneAssigned() && s1.noneAssigned()) {
            return this.evalImpl(expr, c, s0, s1, control, cm);
        }
        this.mode = EvalMode.Action;
        return this.evalImpl(expr, c, s0, s1, control, cm);
    }

    @Override
    protected final Value evalImpl(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        if (this.isInitialize()) {
            return super.evalImpl(expr, c, s0, s1, control, cm);
        }
        if (this.isLiveness(control, s0, s1) || this.isLeaf(expr) || this.isBoring(expr, c)) {
            return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
        }
        if (this.mode == EvalMode.Debugger) {
            return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
        }
        if (this.mode == EvalMode.Const) {
            assert (s0.noneAssigned() && s1.noneAssigned());
            return this.constLevelEval(expr, c, s0, s1, control, cm);
        }
        if (this.mode == EvalMode.State) {
            assert (s1 == null || s1.noneAssigned());
            return this.stateLevelEval(expr, c, s0, s1, control, cm);
        }
        return this.actionLevelEval(expr, c, s0, s1, control, cm);
    }

    private boolean isLeaf(SemanticNode expr) {
        return KINDS.contains(expr.getKind());
    }

    private boolean isInitialize() {
        return this.target == null || TLCGlobals.mainChecker == null && TLCGlobals.simulator == null;
    }

    private boolean isLiveness(int control, TLCState s0, TLCState s1) {
        if (EvalControl.isEnabled(control) || EvalControl.isPrimed(control)) {
            return true;
        }
        return s0 instanceof TLCStateFun || s1 instanceof TLCStateFun;
    }

    private boolean isBoring(SemanticNode expr, Context c) {
        return false;
    }

    private Value actionLevelEval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            this.target.pushFrame(this, expr, c, s0, s1.getAction(), s1);
            Value v = super.evalImpl(expr, c, s0, s1, control, cm);
            this.target.popFrame(this, expr, c, v, s0, s1);
            return v;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.target.pushExceptionFrame(this, expr, c, s0, s1.getAction(), s1, e);
            throw e;
        }
    }

    private Value stateLevelEval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            this.target.pushFrame(this, expr, c, s0);
            Value v = super.evalImpl(expr, c, s0, s1, control, cm);
            this.target.popFrame((Tool)this, expr, c, v, s0);
            return v;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.target.pushExceptionFrame(this, expr, c, s0, e);
            throw e;
        }
    }

    private Value constLevelEval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            this.target.pushFrame(this, expr, c);
            Value v = super.evalImpl(expr, c, s0, s1, control, cm);
            this.target.popFrame((Tool)this, expr, c, v);
            return v;
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            this.target.pushExceptionFrame(this, expr, c, e);
            throw e;
        }
    }

    @Override
    protected final Value evalAppl(OpApplNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        return this.evalApplImpl(expr, c, s0, s1, control, cm);
    }

    @Override
    protected final Value setSource(SemanticNode expr, Value value) {
        return value;
    }

    @Override
    public final TLCState enabled(SemanticNode pred, IActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        return this.enabledImpl(pred, (ActionItemList)acts, c, s0, s1, cm);
    }

    @Override
    protected final TLCState enabledAppl(OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        return this.enabledApplImpl(pred, acts, c, s0, s1, cm);
    }

    @Override
    protected final TLCState enabledUnchanged(SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        return this.enabledUnchangedImpl(expr, acts, c, s0, s1, cm);
    }

    @Override
    protected final TLCState getNextStates(Action action, SemanticNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        if (this.mode == EvalMode.Debugger) {
            return this.fastTool.getNextStatesImpl(action, pred, acts, c, s0, s1, nss, cm);
        }
        this.mode = EvalMode.Action;
        return this.getNextStatesImpl(action, pred, acts, c, s0, s1.setPredecessor(s0).setAction(action), nss, cm);
    }

    @Override
    protected final TLCState getNextStatesAppl(Action action, OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        if (this.mode == EvalMode.Debugger) {
            return this.fastTool.getNextStatesApplImpl(action, pred, acts, c, s0, s1, nss, cm);
        }
        this.mode = EvalMode.Action;
        this.target.pushFrame(this, pred, c, s0, action, s1);
        TLCState s = this.getNextStatesApplImpl(action, pred, acts, c, s0, s1, nss, cm);
        this.target.popFrame((Tool)this, (SemanticNode)pred, c, s0, s1);
        return s;
    }

    @Override
    protected final TLCState processUnchanged(Action action, SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        return this.processUnchangedImpl(action, expr, acts, c, s0, s1, nss, cm);
    }

    @Override
    protected void getInitStates(SemanticNode init, ActionItemList acts, Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        if (this.mode == EvalMode.Debugger) {
            this.fastTool.getInitStates(init, acts, c, ps, states, cm);
        } else {
            this.mode = EvalMode.State;
            if (states instanceof WrapperStateFunctor) {
                super.getInitStates(init, acts, c, ps, states, cm);
            } else {
                super.getInitStates(init, acts, c, ps, new WrapperStateFunctor(states, this.target), cm);
            }
        }
    }

    @Override
    protected void getInitStatesAppl(OpApplNode init, ActionItemList acts, Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        if (this.mode == EvalMode.Debugger) {
            this.fastTool.getInitStatesAppl(init, acts, c, ps, states, cm);
        } else {
            this.mode = EvalMode.State;
            this.target.pushFrame(this, init, c, ps);
            super.getInitStatesAppl(init, acts, c, ps, states, cm);
            this.target.popFrame((Tool)this, (SemanticNode)init, c, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getNextStates(INextStateFunctor functor, TLCState state) {
        if (this.mode == EvalMode.Debugger) {
            this.fastTool.getNextStates(functor, state);
        }
        this.mode = EvalMode.Action;
        try {
            if (functor instanceof WrapperNextStateFunctor) {
                boolean bl = super.getNextStates(functor, state);
                return bl;
            }
            boolean bl = super.getNextStates(new WrapperNextStateFunctor(functor, this.target), state);
            return bl;
        }
        finally {
            if (this.toolMode == Tool.Mode.MC_DEBUG) {
                state.unsetPredecessor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T eval(Supplier<T> supplier) {
        EvalMode old = this.setDebugger();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.mode = old;
        }
    }

    public EvalMode setDebugger() {
        EvalMode old = this.mode;
        this.mode = EvalMode.Debugger;
        return old;
    }

    @Override
    public ITool getLiveness() {
        return this.fastTool;
    }

    private static class WrapperNextStateFunctor
    extends WrapperStateFunctor
    implements INextStateFunctor {
        WrapperNextStateFunctor(INextStateFunctor functor, IDebugTarget target) {
            super(functor, target);
        }

        @Override
        public Object addElement(TLCState predecessor, Action a, TLCState state) {
            this.target.pushFrame(predecessor, a, state);
            Object addElement = ((INextStateFunctor)this.functor).addElement(predecessor, a, state);
            this.target.popFrame(predecessor, state);
            return addElement;
        }
    }

    private static class WrapperStateFunctor
    implements IStateFunctor {
        protected final IStateFunctor functor;
        protected final IDebugTarget target;

        WrapperStateFunctor(IStateFunctor functor, IDebugTarget target) {
            this.functor = functor;
            this.target = target;
        }

        @Override
        public Object addElement(TLCState state) {
            this.target.pushFrame(state);
            Object addElement = this.functor.addElement(state);
            this.target.popFrame(state);
            return addElement;
        }
    }

    public static enum EvalMode {
        Const,
        State,
        Action,
        Debugger;

    }
}

