/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.stream.Stream;
import tla2sany.parser.Operators;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.parser.TLAplusParserConstants;
import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.AssumeProveNode;
import tla2sany.semantic.AtNode;
import tla2sany.semantic.Context;
import tla2sany.semantic.DecimalNode;
import tla2sany.semantic.DefStepNode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LeafProofNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.LevelConstants;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NewSymbNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.NumeralNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.OpDefOrLabelNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.StringNode;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.semantic.TheoremNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.semantic.UseOrHideNode;
import tla2sany.st.SyntaxTreeConstants;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Stack;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tlc2.output.MP;
import util.UniqueString;
import util.WrongInvocationException;

public class Generator
implements ASTConstants,
SyntaxTreeConstants,
LevelConstants,
TLAplusParserConstants {
    private Context context;
    private SymbolTable symbolTable;
    private ExternalModuleTable moduleTable;
    public Errors errors;
    private Stack excStack;
    private Stack excSpecStack;
    private SubstInNode nullSubstIn;
    private FormalParamNode[] nullParam;
    private OpDefNode nullODN;
    protected OpApplNode nullOAN;
    protected LabelNode nullLabelNode;
    protected OpArgNode nullOpArg;
    private static final UniqueString S_e = UniqueString.uniqueStringOf("\\E");
    private static final UniqueString S_ex = UniqueString.uniqueStringOf("\\exists");
    private static final UniqueString S_f = UniqueString.uniqueStringOf("\\A");
    private static final UniqueString S_fx = UniqueString.uniqueStringOf("\\always");
    private static final UniqueString S_te = UniqueString.uniqueStringOf("\\EE");
    private static final UniqueString S_tf = UniqueString.uniqueStringOf("\\AA");
    private static final UniqueString S_a = UniqueString.uniqueStringOf("<<");
    private static final UniqueString S_brack = UniqueString.uniqueStringOf("[");
    private static final UniqueString S_sf = UniqueString.uniqueStringOf("SF_");
    private static final UniqueString S_wf = UniqueString.uniqueStringOf("WF_");
    private static final UniqueString S_at = UniqueString.uniqueStringOf("@");
    private static final UniqueString S_lambda = UniqueString.uniqueStringOf("LAMBDA");
    private static final UniqueString S_subexpression = UniqueString.uniqueStringOf("$Subexpression");
    Function functions = new Function();
    final UniqueString AtUS = UniqueString.uniqueStringOf("@");
    final int NameSel = -1;
    final int NullSel = -2;
    final int GGSel = -3;
    final int LLSel = -4;
    final int ColonSel = -5;
    final int AtSel = -6;
    private final int FindingOpName = 11;
    private final int FollowingLabels = 22;
    private final int FindingSubExpr = 33;
    private int assumeProveDepth = 0;
    private ThmOrAssumpDefNode currentGoal = null;
    private int currentGoalClause;
    private static final int maxAPDepth = 100;
    private boolean[] inScopeOfAPDecl = new boolean[100];
    private static final UniqueString S_InAssume = UniqueString.uniqueStringOf("$$InAssume");
    private static final OpDeclNode InAssumeDummyNode = new OpDeclNode(S_InAssume, 0, 0, 0, null, null, null);
    Vector LSlabels = new Vector();
    Vector LSparamSeq = new Vector();
    final int MaxLetInLevel = 100;
    int curLevel = 0;
    int[] unresolvedCnt = new int[100];
    int unresolvedSum = 0;
    int recursiveSectionCount = 0;
    int max_dfs = 0;
    Vector nstack = new Vector(10);
    int moduleNestingLevel = -1;

    private Selector genIdToSelector(SyntaxTreeNode genId) throws AbortException {
        Selector retval = new Selector(genId);
        TreeNode prefix = genId.heirs()[0];
        TreeNode[] prefixElts = prefix.heirs();
        SyntaxTreeNode lastOp = (SyntaxTreeNode)genId.heirs()[1];
        block4: for (int i = 0; i < prefixElts.length; ++i) {
            TreeNode[] pe = prefixElts[i].heirs();
            if (pe.length == 0) {
                this.errors.addError(genId.getLocation(), "Was expecting a GeneralId.");
                break;
            }
            SyntaxTreeNode thisPrefix = (SyntaxTreeNode)pe[0];
            switch (thisPrefix.getKind()) {
                case 388: {
                    retval.addSelector(thisPrefix, thisPrefix);
                    continue block4;
                }
                case 433: {
                    retval.addSelector(thisPrefix, null);
                    continue block4;
                }
                default: {
                    if (prefixElts[i].heirs().length == 2) {
                        retval.addSelector(thisPrefix, null);
                        continue block4;
                    }
                    if (prefixElts[i].heirs().length != 3) {
                        this.errors.addAbort(prefixElts[i].getLocation(), "Internal error: IdPrefixElement has other than 2 or 3 heirs.");
                    }
                    retval.addSelector(thisPrefix, (SyntaxTreeNode)prefixElts[i].heirs()[1]);
                }
            }
        }
        if (lastOp.getKind() == 388) {
            retval.addSelector(lastOp, lastOp);
        } else {
            retval.addSelector(lastOp, null);
        }
        retval.finish();
        return retval;
    }

    private final int ArgNum(int op, int arity) {
        if (op > 0) {
            if (op <= arity) {
                return op;
            }
            return -1;
        }
        if (op == -4) {
            return arity > 0 ? 1 : -1;
        }
        if (op == -3 && arity == 2) {
            return 2;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    LevelNode selectorToNode(Selector sel, int expectedArity, boolean isFact, boolean isDef, ModuleNode cm) throws AbortException {
        substInPrefix = new Vector<LevelNode>();
        params = new Vector<FormalParamNode>();
        allArgs = new Vector<E>();
        curName = null;
        newName = null;
        curNode = null;
        mode = 11;
        prevMode = -999;
        letInContext = null;
        opDefArityFound = 0;
        opDefArgs = new Vector<ExprOrOpArgNode>();
        firstFindingOpName = true;
        subExprOf = null;
        inAPsuffices = false;
        block9: for (idx = 0; idx < sel.args.length; ++idx) {
            if ((sel.ops[idx] != -1 && sel.ops[idx] != -2 || expectedArity != 0) && sel.args[idx] != null) {
                this.errors.addError(sel.opsSTN[idx].getLocation(), "Selector `" + Generator.selectorItemToString(sel, idx) + "' should not have argument(s).");
                return this.nullOAN;
            }
            if (sel.args[idx] != null && sel.args[idx].getKind() != 388) {
                this.errors.addAbort(sel.args[idx].getLocation(), "Internal error: Unexpected syntax node kind.");
            }
            switch (mode) {
                case 11: {
                    newSymbolNode = null;
                    tempArgs = new Vector<TreeNode>();
                    while (newSymbolNode == null && idx < sel.args.length) {
                        newName = sel.ops[idx] == -1 ? (curName == null ? Operators.resolveSynonym(sel.opNames[idx]) : UniqueString.uniqueStringOf(curName.toString() + "!" + Operators.resolveSynonym(sel.opNames[idx]).toString())) : null;
                        if (curName == null && sel.ops[idx] != -1) {
                            if (idx == 0) {
                                this.errors.addError(sel.opsSTN[idx].getLocation(), "Need name or step number here, not `" + sel.opNames[idx] + "'.");
                                return this.nullOAN;
                            }
                            this.errors.addAbort(sel.opsSTN[idx].getLocation(), "Internal error: should have name here.");
                        }
                        if (newName != null) {
                            newSymbolNode = letInContext == null ? this.symbolTable.resolveSymbol(newName) : letInContext.getSymbol(newName);
                        }
                        if (newSymbolNode != null) continue;
                        curName = newName;
                        if (sel.args[idx] != null) {
                            numOfOpArgs = (sel.args[idx].heirs().length - 1) / 2;
                            for (i = 0; i < numOfOpArgs; ++i) {
                                tempArgs.addElement(sel.args[idx].heirs()[2 * i + 1]);
                            }
                        }
                        ++idx;
                    }
                    if (newSymbolNode == null) {
                        eidx = idx < sel.args.length ? idx : sel.args.length - 1;
                        this.errors.addError(sel.opsSTN[eidx].getLocation(), "Unknown operator: `" + Generator.selectorItemToString(sel, eidx) + "'.");
                        return this.nullOAN;
                    }
                    if (newSymbolNode.getKind() == 1) {
                        this.errors.addError(sel.opsSTN[idx].getLocation(), "Module name (" + sel.opNames[idx].toString() + ") not allowed here.");
                        return this.nullOAN;
                    }
                    curNode = newSymbolNode;
                    curSymbolNode = newSymbolNode;
                    curName = newName;
                    switch (curSymbolNode.getKind()) {
                        case 2: 
                        case 3: 
                        case 7: 
                        case 11: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 37: {
                            if (idx == 0) ** GOTO lbl58
                            this.errors.addAbort(sel.selSTN.getLocation(), "Internal error: impossible naming of declaration.");
                            ** GOTO lbl61
lbl58:
                            // 1 sources

                            if (sel.ops.length != 1) {
                                this.errors.addError(sel.opsSTN[idx].getLocation(), "Cannot take subexpression of `" + curName.toString() + "'.");
                                return this.nullOAN;
                            }
                        }
lbl61:
                        // 4 sources

                        case 5: 
                        case 6: 
                        case 23: {
                            nodeArity = curSymbolNode.getArity();
                            if (expectedArity == 0) {
                                opArgs = sel.args[idx];
                                numOfOpArgs = 0;
                                if (opArgs != null) {
                                    numOfOpArgs = (opArgs.heirs().length - 1) / 2;
                                    for (i = 0; i < numOfOpArgs; ++i) {
                                        tempArgs.addElement(sel.args[idx].heirs()[2 * i + 1]);
                                    }
                                }
                                if (opDefArityFound + tempArgs.size() != nodeArity) {
                                    this.errors.addError(opArgs == null ? sel.selSTN.getLocation() : sel.args[idx].getLocation(), "The operator " + curName.toString() + " requires " + (nodeArity - opDefArityFound) + " arguments.");
                                    return this.nullOAN;
                                }
                                opArgNodes = new ExprOrOpArgNode[tempArgs.size()];
                                for (i = 0; i < tempArgs.size(); ++i) {
                                    opDefArgs.addElement(this.generateExprOrOpArg((SymbolNode)curSymbolNode, sel.opsSTN[idx], i + opDefArityFound, (TreeNode)tempArgs.elementAt(i), cm));
                                }
                            } else if (expectedArity > 0) {
                                // empty if block
                            }
                            opDefArityFound = nodeArity;
                            if (curNode.getKind() == 6) {
                                if (idx == sel.ops.length - 1 && !isDef && !isFact) {
                                    this.errors.addError(sel.opsSTN[idx].getLocation(), "Operator name " + curName.toString() + " is incomplete.");
                                    return this.nullOAN;
                                }
                            } else {
                                if (curNode.getKind() == 5 && !((OpDefNode)curNode).isDefined && sel.ops.length != 1) {
                                    this.errors.addError(sel.opsSTN[idx].getLocation(), "Subexpression of  `" + curName.toString() + "' used inside the operator's definition.");
                                    return this.nullOAN;
                                }
                                if (firstFindingOpName && (curNode.getKind() == 5 || curNode.getKind() == 23)) {
                                    subExprOf = (SymbolNode)curNode;
                                }
                                if (idx != sel.ops.length - 1) {
                                    if (curNode.getKind() == 5) {
                                        opParams = ((OpDefNode)curNode).getParams();
                                        newNode = ((OpDefNode)curNode).getBody();
                                    } else {
                                        opParams = ((ThmOrAssumpDefNode)curNode).getParams();
                                        newNode = ((ThmOrAssumpDefNode)curNode).getBody();
                                    }
                                    for (i = 0; i < opParams.length; ++i) {
                                        params.addElement(opParams[i]);
                                    }
                                    curName = null;
                                    mode = sel.ops[idx + 1] == -1 ? 22 : 33;
                                    for (i = 0; i < opDefArgs.size(); ++i) {
                                        allArgs.addElement(opDefArgs.elementAt(i));
                                    }
                                    opDefArityFound = 0;
                                    opDefArgs = new Vector<E>();
                                    if (newNode != null) {
                                        while (newNode.getKind() == 13) {
                                            substInPrefix.addElement(newNode);
                                            newNode = ((SubstInNode)newNode).getBody();
                                        }
                                        while (newNode.getKind() == 30) {
                                            substInPrefix.addElement(newNode);
                                            newNode = ((APSubstInNode)newNode).getBody();
                                        }
                                    }
                                    if (mode == 33) {
                                        curNode = newNode;
                                    }
                                }
                            }
                            prevMode = 11;
                            continue block9;
                        }
                    }
                    this.errors.addAbort(sel.opsSTN[idx].getLocation(), "Internal error: unexpected node kind.");
                    continue block9;
                }
                case 22: {
                    if (prevMode == 11 && curNode.getKind() != 5 && curNode.getKind() != 23 || prevMode != 11 && curNode.getKind() != 29) {
                        this.errors.addAbort(sel.selSTN.getLocation(), "Unexpected node kind in FollowingLabels mode.");
                    }
                    if ((newLabelNode = ((OpDefOrLabelNode)curNode).getLabel(sel.opNames[idx])) == null) {
                        this.errors.addError(sel.opsSTN[idx].getLocation(), "Cannot find label `" + sel.opNames[idx].toString() + "'.");
                        return this.nullOAN;
                    }
                    curNode = newLabelNode;
                    if (this.illegalLabelRef(newLabelNode, sel.opsSTN[idx])) {
                        this.errors.addError(sel.opsSTN[idx].getLocation(), "Accessing subexpression labeled `" + sel.opNames[idx].toString() + "' of ASSUME/PROVE clause within the scope of a declaration\n from outside that declaration's scope.");
                        return this.nullOAN;
                    }
                    if (expectedArity == 0) {
                        if (newLabelNode.getArity() != (sel.args[idx] == null ? 0 : (sel.args[idx].heirs().length - 1) / 2)) {
                            this.errors.addError(sel.opsSTN[idx].getLocation(), "Label `" + sel.opNames[idx].toString() + "' used with wrong number of arguments.");
                            return this.nullOAN;
                        }
                        for (i = 0; i < newLabelNode.getArity(); ++i) {
                            allArgs.addElement(this.generateExpression(sel.args[idx].heirs()[2 * i + 1], cm));
                        }
                    }
                    for (i = 0; i < newLabelNode.getArity(); ++i) {
                        pdecl = newLabelNode.params[i];
                        params.addElement(pdecl);
                    }
                    if (idx < sel.ops.length - 1 && sel.ops[idx + 1] != -1) {
                        mode = 33;
                    }
                    if (mode == 33 || idx == sel.ops.length) {
                        curNode = newLabelNode.getBody();
                    }
                    prevMode = 22;
                    continue block9;
                }
                case 33: {
                    if (sel.ops[idx] != -5) ** GOTO lbl157
                    if (prevMode == 33 || (idx != sel.ops.length - 1 || prevMode != 11) && (idx >= sel.ops.length - 1 || sel.ops[idx + 1] != -1)) {
                        this.errors.addError(sel.opsSTN[idx].getLocation(), "`!:' can be used only after a name and either at the end after an\noperator name or before an operator name.");
                        return this.nullOAN;
                    }
                    ** GOTO lbl328
lbl157:
                    // 1 sources

                    if (curNode == null) {
                        this.errors.addError(sel.opsSTN[idx].getLocation(), "Subexpression selection failed, probably due to an error in the selected expression.");
                        return this.nullOAN;
                    }
                    if (curNode.getKind() != 10) ** GOTO lbl166
                    if (this.ArgNum(sel.ops[idx], 1) != 1) ** GOTO lbl164
                    curNode = ((LetInNode)curNode).getBody();
                    ** GOTO lbl328
lbl164:
                    // 1 sources

                    this.errors.addError(sel.opsSTN[idx].getLocation(), "A LET/IN expression has only one operand.");
                    return this.nullOAN;
lbl166:
                    // 1 sources

                    if (curNode.getKind() != 9) ** GOTO lbl269
                    curOpApplNode = (OpApplNode)curNode;
                    curArgs = curOpApplNode.getArgs();
                    opNode = curOpApplNode.getOperator();
                    if (opNode.getKind() == 11 || opNode.getKind() == 2 || opNode.getKind() == 5) {
                        temp = this.ArgNum(sel.ops[idx], opNode.getArity());
                        if (temp == -1) {
                            this.reportSelectorError(sel, idx);
                            return this.nullOAN;
                        }
                        curNode = curArgs[temp - 1];
                    } else if (opNode.getKind() == 7) {
                        if (opNode.getName() == Generator.OP_rc || opNode.getName() == Generator.OP_sor) {
                            temp = this.ArgNum(sel.ops[idx], curArgs.length);
                            if (temp == -1) {
                                this.reportSelectorError(sel, idx);
                                return this.nullOAN;
                            }
                            curOpApplNode = (OpApplNode)curArgs[temp - 1];
                            if (curOpApplNode.getOperator().getName() != Generator.OP_pair) {
                                this.errors.addAbort(sel.opsSTN[idx].getLocation(), "Internal error: Expecting $Pair and didn't find it.");
                            }
                            curNode = curOpApplNode.getArgs()[1];
                        } else if (opNode.getName() == Generator.OP_case) {
                            if (idx == sel.ops.length - 1) {
                                this.errors.addError(sel.opsSTN[idx].getLocation(), "Subexpression of CASE must have form !i!j.");
                                return this.nullOAN;
                            }
                            temp = this.ArgNum(sel.ops[idx], curArgs.length);
                            if (temp == -1) {
                                this.reportSelectorError(sel, idx);
                                return this.nullOAN;
                            }
                            curOpApplNode = (OpApplNode)curArgs[temp - 1];
                            if (curOpApplNode.getOperator().getName() != Generator.OP_pair) {
                                this.errors.addAbort(sel.opsSTN[idx].getLocation(), "Internal error: Expecting $Pair and didn't find it.");
                            }
                            if ((temp = this.ArgNum(sel.ops[++idx], 2)) == -1) {
                                this.errors.addError(sel.opsSTN[idx].getLocation(), "Second selector for CASE subexpression must specify  one of two operands.");
                                return this.nullOAN;
                            }
                            curNode = curOpApplNode.getArgs()[temp - 1];
                            if (curNode == null) {
                                this.errors.addError(sel.opsSTN[idx].getLocation(), "Selecting OTHER in a CASE statement.");
                                return this.nullOAN;
                            }
                        } else if (opNode.getName() == Generator.OP_exc) {
                            temp = this.ArgNum(sel.ops[idx], curArgs.length);
                            if (temp == -1) {
                                this.reportSelectorError(sel, idx);
                                return this.nullOAN;
                            }
                            if (temp > 1) {
                                this.errors.addError(sel.opsSTN[idx].getLocation(), "Selecting subexpression of an EXCEPT not yet implemented.");
                                return this.nullOAN;
                            }
                            curNode = curArgs[temp - 1];
                            if (this.isNullSelection(curNode, sel, idx)) {
                                return this.nullOAN;
                            }
                            if (temp > 1) {
                                curOpApplNode = (OpApplNode)curNode;
                                if (curOpApplNode.getOperator().getName() != Generator.OP_pair) {
                                    this.errors.addAbort(sel.opsSTN[idx].getLocation(), "Internal error: Expecting $Pair and didn't find it.");
                                }
                                curNode = curOpApplNode.getArgs()[1];
                            }
                        } else if (curOpApplNode.getNumberOfBoundedBoundSymbols() == 0 && (curOpApplNode.getUnbdedQuantSymbols() == null || curOpApplNode.getUnbdedQuantSymbols().length == 0)) {
                            temp = this.ArgNum(sel.ops[idx], curOpApplNode.getArgs().length);
                            if (temp == -1) {
                                this.reportSelectorError(sel, idx);
                                return this.nullOAN;
                            }
                            curNode = curOpApplNode.getArgs()[temp - 1];
                        } else if (sel.ops[idx] == -2 || sel.ops[idx] == -6) {
                            if (curOpApplNode.getNumberOfBoundedBoundSymbols() > 0) {
                                symbs = curOpApplNode.getBdedQuantSymbolLists();
                                numSymbs = 0;
                                for (i = 0; i < symbs.length; ++i) {
                                    numSymbs += symbs[i].length;
                                }
                                temp = new FormalParamNode[numSymbs];
                                k = 0;
                                for (i = 0; i < symbs.length; ++i) {
                                    for (j = 0; j < symbs[i].length; ++j) {
                                        temp[k] = symbs[i][j];
                                        ++k;
                                    }
                                }
                            } else {
                                temp = curOpApplNode.getUnbdedQuantSymbols();
                            }
                            for (i = 0; i < temp.length; ++i) {
                                params.addElement(temp[i]);
                            }
                            if (sel.ops[idx] == -2) {
                                numOfArgs = (sel.args[idx].heirs().length - 1) / 2;
                                if (temp.length != numOfArgs) {
                                    this.errors.addError(sel.opsSTN[idx].getLocation(), "Selector with " + numOfArgs + " argument(s) used for quantifier with " + temp.length + " bound identifier(s).");
                                    return this.nullOAN;
                                }
                                for (i = 0; i < numOfArgs; ++i) {
                                    allArgs.addElement(this.generateExpression(sel.args[idx].heirs()[2 * i + 1], cm));
                                }
                            }
                            curNode = curOpApplNode.getArgs()[0];
                        } else {
                            temp = this.ArgNum(sel.ops[idx], curOpApplNode.getBdedQuantBounds().length);
                            if (temp == -1) {
                                this.reportSelectorError(sel, idx);
                                return this.nullOAN;
                            }
                            curNode = curOpApplNode.getBdedQuantBounds()[temp - 1];
                        }
                    } else {
                        this.errors.addError(sel.opsSTN[idx].getLocation(), "Choosing operand `" + Generator.selectorItemToString(sel, idx) + "' of subexpression with no operands.");
                        return this.nullOAN;
lbl269:
                        // 1 sources

                        if (curNode.getKind() == 14) {
                            curAPNode = (AssumeProveNode)curNode;
                            if (curAPNode.isSuffices() && !inAPsuffices) {
                                if (this.ArgNum(sel.ops[idx], 1) != 1) {
                                    this.errors.addError(sel.opsSTN[idx].getLocation(), "Accessing non-existent subexpression of a SUFFICES");
                                    return this.nullOAN;
                                }
                                inAPsuffices = true;
                            } else {
                                inAPsuffices = false;
                                temp = this.ArgNum(sel.ops[idx], 1 + curAPNode.getAssumes().length);
                                if (temp == -1) {
                                    this.reportSelectorError(sel, idx);
                                    return this.nullOAN;
                                }
                                if (this.illegalAPPosRef(curAPNode, temp)) {
                                    this.errors.addError(sel.opsSTN[idx].getLocation(), "Accessing ASSUME/PROVE clause within the scope of a declaration\n from outside that declaration's scope.");
                                    return this.nullOAN;
                                }
                                if (temp <= curAPNode.getAssumes().length) {
                                    curNode = curAPNode.getAssumes()[temp - 1];
                                    if (this.isNullSelection(curNode, sel, idx)) {
                                        return this.nullOAN;
                                    }
                                    if (curNode.getKind() == 22 && idx != sel.args.length - 1) {
                                        this.errors.addError(sel.opsSTN[idx].getLocation(), "Selected a subexpression of a NEW clause of an ASSUME.");
                                        return this.nullOAN;
                                    }
                                } else {
                                    curNode = curAPNode.getProve();
                                }
                            }
                        } else if (curNode.getKind() == 8) {
                            opNode = ((OpArgNode)curNode).getOp();
                            if (opNode.getKind() != 5 || opNode.getName() != Generator.S_lambda) {
                                this.errors.addError(sel.opsSTN[idx].getLocation(), "Trying to select subexpression of an operator argument.");
                                return this.nullOAN;
                            }
                            opDefOpNode = (OpDefNode)opNode;
                            if (sel.ops[idx] != -2 && sel.ops[idx] != -6) {
                                this.errors.addError(sel.opsSTN[idx].getLocation(), "Cannot use !" + sel.opNames[idx].toString() + " to select subexpression of a LAMBDA.");
                                return this.nullOAN;
                            }
                            if (sel.ops[idx] == -2) {
                                numOfArgs = (sel.args[idx].heirs().length - 1) / 2;
                                if (opDefOpNode.getArity() != numOfArgs) {
                                    this.errors.addError(sel.opsSTN[idx].getLocation(), "Selector with " + numOfArgs + "arguments used for LAMBDA expression taking " + opDefOpNode.getArity() + " arguments.");
                                    return this.nullOAN;
                                }
                                for (i = 0; i < numOfArgs; ++i) {
                                    allArgs.addElement(this.generateExpression(sel.args[idx].heirs()[2 * i + 1], cm));
                                }
                            }
                            for (i = 0; i < opDefOpNode.getArity(); ++i) {
                                params.addElement(opDefOpNode.getParams()[i]);
                            }
                            curNode = opDefOpNode.getBody();
                        } else if (curNode.getKind() == 5 || curNode.getKind() == 7 || curNode.getKind() == 37) {
                            this.errors.addAbort(sel.opsSTN[idx].getLocation(), "Internal error:  Should not have been able to select this node.");
                        } else {
                            if (curNode.getKind() == 19 || curNode.getKind() == 17 || curNode.getKind() == 16 || curNode.getKind() == 18 || curNode.getKind() == 11 || curNode.getKind() == 2 || curNode.getKind() == 3 || curNode.getKind() == 4) {
                                this.errors.addError(sel.opsSTN[idx].getLocation(), "Selecting subexpression of expression that has none.");
                                return this.nullOAN;
                            }
                            if (curNode.getKind() == 29) {
                                curNode = ((LabelNode)curNode).getBody();
                                --idx;
                            } else {
                                this.errors.addAbort(sel.opsSTN[idx].getLocation(), "Internal error:  Unknown node kind.");
                            }
                        }
                    }
lbl328:
                    // 16 sources

                    if (this.isNullSelection(curNode, sel, idx)) {
                        return this.nullOAN;
                    }
                    if (idx == sel.ops.length - 1) ** GOTO lbl345
                    if (sel.ops[idx + 1] != -1) ** GOTO lbl342
                    while (curNode.getKind() == 29) {
                        if (!this.isNullSelection(curNode = ((LabelNode)curNode).getBody(), sel, idx)) continue;
                        return this.nullOAN;
                    }
                    if (curNode.getKind() == 10) {
                        letInContext = ((LetInNode)curNode).context;
                        mode = 11;
                        firstFindingOpName = false;
                    } else {
                        this.errors.addError(sel.opsSTN[idx].getLocation(), "A name selector here must be from a LET clause.");
                        return this.nullOAN;
lbl342:
                        // 1 sources

                        if (sel.ops[idx + 1] == -5) {
                            this.errors.addError(sel.opsSTN[idx].getLocation(), "!: should not follow an operand selector.");
                            return this.nullOAN;
                        }
                    }
lbl345:
                    // 4 sources

                    prevMode = 33;
                    continue block9;
                }
                default: {
                    this.errors.addAbort(sel.selSTN.getLocation(), "Internal error: Unexpected mode");
                }
            }
        }
        if (curNode.getKind() == 14) {
            if (isFact) {
                return (AssumeProveNode)curNode;
            }
            this.errors.addError(sel.selSTN.getLocation(), "Selected ASSUME/PROVE instead of expression.");
            return this.nullOAN;
        }
        if (curNode.getKind() == 22) {
            if (isFact) {
                return (LevelNode)curNode;
            }
            this.errors.addError(sel.selSTN.getLocation(), "Selected a NEW declaration as an expression or operator.");
            return this.nullOAN;
        }
        if (expectedArity < 0) {
            if (prevMode != 11 || curNode.getKind() != 5 && curNode.getKind() != 23 && curNode.getKind() != 37 && (curNode.getKind() != 6 || !isDef)) {
                this.errors.addError(sel.selSTN.getLocation(), "DEF clause entry should describe a defined operator.");
                return this.nullOAN;
            }
            if (curNode.getKind() == 37 && ((OpDefNode)curNode).getStepNode().getKind() != 36) {
                this.errors.addError(sel.selSTN.getLocation(), "DEF clause entry refers to a non-definition step.");
                return this.nullOAN;
            }
            return (LevelNode)curNode;
        }
        if (curNode.getKind() == 37) {
            this.errors.addError(sel.selSTN.getLocation(), isFact != false ? "Step number of non-fact used as a fact" : "Step number of non-expression step used as an expression.");
            return this.nullOAN;
        }
        if (expectedArity > 0) {
            temp = params.size();
            if (curNode.getKind() == 8) {
                temp += ((OpArgNode)curNode).getArity();
            } else if (prevMode == 11) {
                temp += ((SymbolNode)curNode).getArity();
            }
            if (expectedArity != temp) {
                this.errors.addError(sel.selSTN.getLocation(), "Expected arity " + expectedArity + " but found operator of arity " + temp + ".");
                return this.nullOAN;
            }
        }
        opDefArgArray = new ExprOrOpArgNode[opDefArgs.size()];
        for (i = 0; i < opDefArgs.size(); ++i) {
            opDefArgArray[i] = (ExprOrOpArgNode)opDefArgs.elementAt(i);
        }
        if (prevMode == 11 && params.size() + substInPrefix.size() > 0) {
            nodeParams = null;
            if (curNode.getKind() == 5) {
                nodeParams = ((OpDefNode)curNode).getParams();
            } else {
                if (curNode.getKind() != 23) {
                    this.errors.addAbort(sel.opsSTN[sel.opsSTN.length - 1].getLocation(), "Internal Error:  Found unexpected node kind after FindingOpName");
                }
                nodeParams = ((ThmOrAssumpDefNode)curNode).getParams();
            }
            for (i = 0; i < opDefArgs.size(); ++i) {
                allArgs.addElement(opDefArgArray[i]);
            }
            temp = new ExprOrOpArgNode[nodeParams.length];
            for (i = 0; i < nodeParams.length; ++i) {
                pm = nodeParams[i];
                newpm = new FormalParamNode(pm.getName(), pm.getArity(), pm.stn, null, cm);
                eoag /* !! */  = null;
                eoag /* !! */  = pm.getArity() == 0 ? new OpApplNode(newpm, (ExprOrOpArgNode[])new ExprNode[0], (TreeNode)sel.selSTN, cm) : new OpArgNode(newpm, sel.selSTN, cm);
                temp[i] = eoag /* !! */ ;
                params.addElement(newpm);
            }
            curSymNode = (SymbolNode)curNode;
            curNode = new OpApplNode(curSymNode, temp, (TreeNode)sel.selSTN, cm);
        }
        if (curNode.getKind() == 8) {
            curOpArgNode = (OpArgNode)curNode;
            if (expectedArity == 0) {
                this.errors.addError(sel.selSTN.getLocation(), "Selected operator argument when expression expected.");
                return this.nullOAN;
            }
            temp = params.size() + curOpArgNode.getArity();
            if (expectedArity != temp) {
                this.errors.addError(sel.selSTN.getLocation(), "Expected operator of arity " + expectedArity + " but selected operator has arity " + temp + ".");
                return this.nullOAN;
            }
            if (params.size() + substInPrefix.size() > 0) {
                temp2 = new FormalParamNode[curOpArgNode.getArity()];
                for (i = 0; i < temp2.length; ++i) {
                    temp3 = UniqueString.uniqueStringOf("NewParam" + i);
                    temp2[i] = new FormalParamNode(temp3, 0, new SyntaxTreeNode(temp3), null, cm);
                    params.addElement(temp2[i]);
                }
                curNode = new OpApplNode(curOpArgNode.getOp(), opDefArgArray, (TreeNode)sel.selSTN, cm);
            }
        }
        if (!isFact && (curNode.getKind() == 23 && ((ThmOrAssumpDefNode)curNode).getBody().getKind() == 14 || curNode.getKind() == 29 && ((LabelNode)curNode).isAssumeProve)) {
            this.errors.addError(sel.selSTN.getLocation(), "ASSUME/PROVE used where an expression is required.");
            return this.nullOAN;
        }
        if (!isFact && curNode.getKind() == 23 && ((ThmOrAssumpDefNode)curNode).getBody().getKind() == 9) {
            opName = ((OpApplNode)((ThmOrAssumpDefNode)curNode).getBody()).getOperator().getName();
            exprType = null;
            if (opName == Generator.OP_qed) {
                exprType = "QED step";
            } else if (opName == Generator.OP_pfcase) {
                exprType = "CASE";
            } else if (opName == Generator.OP_have) {
                exprType = "HAVE";
            } else if (opName == Generator.OP_take) {
                exprType = "TAKE";
            } else if (opName == Generator.OP_pick) {
                exprType = "PICK";
            } else if (opName == Generator.OP_witness) {
                exprType = "WITNESS";
            } else if (opName == Generator.OP_suffices) {
                exprType = "SUFFICES";
            }
            if (exprType != null) {
                this.errors.addError(sel.selSTN.getLocation(), exprType + " proof step selected instead of expression.");
                return this.nullOAN;
            }
        }
        if (curNode.getKind() == 5 || curNode.getKind() == 2 || curNode.getKind() == 3 || curNode.getKind() == 11 || curNode.getKind() == 7 || curNode.getKind() == 4 || curNode.getKind() == 23 || curNode.getKind() == 24 || curNode.getKind() == 25 || curNode.getKind() == 26 || curNode.getKind() == 27 || curNode.getKind() == 28) {
            curSymbolNode = (SymbolNode)curNode;
            if (expectedArity > 0) {
                return new OpArgNode(curSymbolNode, sel.selSTN, cm);
            }
            oan = new OpApplNode(curSymbolNode, opDefArgArray, (TreeNode)sel.selSTN, cm);
            oan.subExpressionOf = subExprOf;
            return oan;
        }
        if (curNode.getKind() == 8) {
            return (OpArgNode)curNode;
        }
        if (curNode.getKind() == 6) {
            if (isFact || isDef) {
                return (OpDefNode)curNode;
            }
            this.errors.addError(sel.selSTN.getLocation(), "Module instantiation selected instead of expression.");
            return this.nullOAN;
        }
        if (!(curNode instanceof ExprNode)) {
            this.errors.addAbort(sel.selSTN.getLocation(), "Internal error: Expected expression node.");
        }
        curExprNode = (ExprNode)curNode;
        for (temp = substInPrefix.size(); temp > 0; --temp) {
            substOb = substInPrefix.elementAt(temp - 1);
            if (substOb instanceof SubstInNode) {
                subst = (SubstInNode)substOb;
                curExprNode = new SubstInNode(subst.stn, subst.getSubsts(), curExprNode, subst.getInstantiatingModule(), subst.getInstantiatedModule());
                continue;
            }
            subst = (APSubstInNode)substOb;
            curExprNode = new SubstInNode(subst.stn, subst.getSubsts(), curExprNode, subst.getInstantiatingModule(), subst.getInstantiatedModule());
        }
        paramsArray = new FormalParamNode[params.size()];
        for (i = 0; i < params.size(); ++i) {
            paramsArray[i] = (FormalParamNode)params.elementAt(i);
        }
        newLambda = null;
        if (paramsArray.length > 0) {
            newLambda = new OpDefNode(Generator.S_lambda, 5, paramsArray, false, curExprNode, cm, null, sel.selSTN, true, null);
        }
        if (expectedArity > 0) {
            if (paramsArray.length != expectedArity) {
                this.errors.addError(sel.selSTN.getLocation(), "Expected operator argument with arity " + expectedArity + " but found one of arity " + paramsArray.length + ".");
                return this.nullOAN;
            }
            return new OpArgNode(newLambda, sel.selSTN, cm);
        }
        if (paramsArray.length != allArgs.size()) {
            this.errors.addError(sel.selSTN.getLocation(), "Expected " + paramsArray.length + " arguments but found " + allArgs.size() + ".");
            return this.nullOAN;
        }
        if (paramsArray.length == 0) {
            args = new ExprOrOpArgNode[]{curExprNode};
            ln = new OpApplNode(Generator.OP_nop, args, (TreeNode)sel.selSTN, cm);
            ln.subExpressionOf = subExprOf;
            return ln;
        }
        allArgsArray = new ExprOrOpArgNode[allArgs.size()];
        for (i = 0; i < allArgs.size(); ++i) {
            allArgsArray[i] = (ExprOrOpArgNode)allArgs.elementAt(i);
        }
        oan = new OpApplNode(newLambda, allArgsArray, (TreeNode)sel.selSTN, cm);
        oan.subExpressionOf = subExprOf;
        return oan;
    }

    private static String selectorItemToString(Selector sel, int idx) {
        String selStr = sel.opNames[idx].toString();
        if (selStr.equals("N_StructOp")) {
            selStr = "argument selector " + sel.opsSTN[idx].heirs()[0].heirs()[0].getImage();
        } else if (selStr.equals("N_OpArgs")) {
            selStr = "!(...)";
        }
        return selStr;
    }

    private void reportSelectorError(Selector sel, int idx) {
        this.errors.addError(sel.opsSTN[idx].getLocation(), "Nonexistent operand specified by `" + Generator.selectorItemToString(sel, idx) + "'.");
    }

    private boolean isNullSelection(SemanticNode node, Selector sel, int idx) {
        boolean val;
        boolean bl = val = node == null;
        if (val) {
            this.errors.addError(sel.opsSTN[idx].getLocation(), "An unexpected null node specified by " + Generator.selectorItemToString(sel, idx) + "'.\nThis is probably due to a previous error.");
        }
        return val;
    }

    public Generator(ExternalModuleTable moduleTable, Errors errs) {
        this.nullParam = new FormalParamNode[0];
        this.nullODN = new OpDefNode(UniqueString.uniqueStringOf("nullODN"));
        this.nullOAN = new OpApplNode(this.nullODN);
        this.nullOpArg = new OpArgNode(UniqueString.uniqueStringOf("nullOpArg"));
        this.nullLabelNode = new LabelNode(this.nullOAN);
        this.errors = errs;
        this.moduleTable = moduleTable;
        this.symbolTable = new SymbolTable(moduleTable, this.errors);
        this.excStack = new Stack();
        this.excSpecStack = new Stack();
    }

    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public final ModuleNode generate(TreeNode treeNode) throws AbortException {
        if (treeNode.isKind(382)) {
            this.context = this.symbolTable.getContext();
            return this.generateModule(treeNode, null);
        }
        return null;
    }

    private final Context getContext(UniqueString us) {
        ModuleNode symbolNode = this.symbolTable.resolveModule(us);
        if (symbolNode == null) {
            return this.moduleTable.getContext(us);
        }
        return symbolNode.getContext();
    }

    private final ModuleNode generateModule(TreeNode treeNode, ModuleNode parent) throws AbortException {
        ++this.moduleNestingLevel;
        TreeNode[] children = treeNode.heirs();
        TreeNode[] definitions = null;
        TreeNode[] ss = children[0].heirs();
        String moduleName = ss[1].getImage();
        ModuleNode currentModule = new ModuleNode(ss[1].getUS(), this.context, treeNode);
        currentModule.nestingLevel = this.moduleNestingLevel;
        if (parent != null) {
            parent.appendDef(currentModule);
        }
        this.symbolTable.setModuleNode(currentModule);
        this.processExtendsList(children[1].heirs(), currentModule);
        definitions = children[2].heirs();
        block15: for (int lvi = 0; lvi < definitions.length; ++lvi) {
            switch (definitions[lvi].getKind()) {
                case 426: {
                    this.checkIfInRecursiveSection(definitions[lvi], "A VARIABLE declaration");
                    this.processVariables(definitions[lvi].heirs(), currentModule);
                    continue block15;
                }
                case 392: {
                    this.checkIfInRecursiveSection(definitions[lvi], "A declaration");
                    this.processParameters(definitions[lvi].heirs(), currentModule);
                    continue block15;
                }
                case 389: {
                    this.processOperator(definitions[lvi], null, currentModule);
                    continue block15;
                }
                case 356: {
                    this.processFunction(definitions[lvi], null, currentModule);
                    continue block15;
                }
                case 383: {
                    this.processModuleDefinition(definitions[lvi], null, null, currentModule);
                    continue block15;
                }
                case 382: {
                    this.checkIfInRecursiveSection(definitions[lvi], "A MODULE ");
                    SymbolTable oldSt = this.symbolTable;
                    this.symbolTable = new SymbolTable(this.moduleTable, this.errors, oldSt);
                    this.context = new Context(this.moduleTable, this.errors);
                    this.symbolTable.pushContext(this.context);
                    ModuleNode mn = this.generateModule(definitions[lvi], currentModule);
                    this.symbolTable.popContext();
                    this.symbolTable = oldSt;
                    this.symbolTable.addModule(mn.getName(), mn);
                    for (int i = 0; i < mn.opDefsInRecursiveSection.size(); ++i) {
                        currentModule.opDefsInRecursiveSection.addElement(mn.opDefsInRecursiveSection.elementAt(i));
                    }
                    continue block15;
                }
                case 375: {
                    this.generateInstance(definitions[lvi], currentModule, true);
                    continue block15;
                }
                case 402: {
                    this.checkIfInRecursiveSection(definitions[lvi], "A proof");
                    continue block15;
                }
                case 422: {
                    this.checkIfInRecursiveSection(definitions[lvi], "A THEOREM");
                    this.processTheorem(definitions[lvi], currentModule);
                    continue block15;
                }
                case 332: {
                    this.checkIfInRecursiveSection(definitions[lvi], "An ASSUME");
                    this.processAssumption(definitions[lvi], currentModule);
                    continue block15;
                }
                case 436: {
                    this.checkIfInRecursiveSection(definitions[lvi], "A USE or HIDE");
                    UseOrHideNode uohn = this.generateUseOrHide(definitions[lvi], currentModule);
                    uohn.factCheck();
                    if (uohn.facts.length + uohn.defs.length == 0) {
                        this.errors.addError(definitions[lvi].getLocation(), "Empty USE or HIDE statement.");
                    }
                    currentModule.addTopLevel(uohn);
                    continue block15;
                }
                case 35: {
                    continue block15;
                }
                case 431: {
                    this.processRecursive(definitions[lvi], currentModule);
                    continue block15;
                }
                default: {
                    this.errors.addAbort(definitions[lvi].getLocation(), "Internal error: Syntax node of kind " + definitions[lvi].getKind() + " unsupported " + definitions[lvi].getImage(), true);
                }
            }
        }
        this.checkForUndefinedRecursiveOps(currentModule);
        Vector vec = currentModule.recursiveOpDefNodes;
        for (int i = 0; i < vec.size(); ++i) {
            OpDefNode opDefNode = (OpDefNode)vec.elementAt(i);
        }
        --this.moduleNestingLevel;
        return currentModule;
    }

    private final void processExtendsList(TreeNode[] treeNodes, ModuleNode cm) throws AbortException {
        Vector<ModuleNode> extendeeVector = new Vector<ModuleNode>(2);
        if (treeNodes != null) {
            for (int lvi = 1; lvi < treeNodes.length; lvi += 2) {
                UniqueString extendeeID = treeNodes[lvi].getUS();
                ModuleNode extendee = this.symbolTable.resolveModule(extendeeID);
                if (extendee == null && (extendee = this.moduleTable.getModuleNode(extendeeID)) == null) {
                    this.errors.addAbort(treeNodes[lvi].getLocation(), "Could not find module " + extendeeID, false);
                }
                extendeeVector.addElement(extendee);
                Context context = this.getContext(extendeeID);
                if (context != null) {
                    this.symbolTable.getContext().mergeExtendContext(context);
                } else {
                    this.errors.addError(treeNodes[lvi].getLocation(), "Couldn't find context for module `" + extendeeID + "'.");
                }
                cm.copyAssumes(extendee);
                cm.copyTheorems(extendee);
                cm.copyTopLevel(extendee);
            }
        }
        cm.createExtendeeArray(extendeeVector);
    }

    private final void processVariables(TreeNode[] treeNodes, ModuleNode cm) {
        for (int lvi = 1; lvi < treeNodes.length; lvi += 2) {
            UniqueString us = treeNodes[lvi].getUS();
            if (us == S_at) {
                this.errors.addError(treeNodes[lvi].getLocation(), "Attempted to declare '@' as a variable.");
            }
            new OpDeclNode(us, 3, 1, 0, cm, this.symbolTable, treeNodes[lvi]);
        }
    }

    private final OpDeclNode buildParameter(TreeNode treeNode, int declKind, int declLevel, ModuleNode cm, boolean declare) {
        UniqueString us = null;
        int arity = 0;
        TreeNode[] ss = treeNode.heirs();
        if (treeNode.isKind(363)) {
            us = ss[0].getUS();
            arity = (ss.length - 1) / 2;
        } else if (treeNode.isKind(398)) {
            us = ss[0].getUS();
            arity = 1;
        } else if (treeNode.isKind(370)) {
            us = ss[1].getUS();
            arity = 2;
        } else if (treeNode.isKind(394)) {
            us = ss[1].getUS();
            arity = 1;
        } else {
            this.errors.addError(treeNode.getLocation(), "Unknown parameter declaration `" + treeNode.getUS() + "'.");
        }
        SymbolTable st = null;
        if (declare) {
            st = this.symbolTable;
        }
        return new OpDeclNode(Operators.resolveSynonym(us), declKind, declLevel, arity, cm, st, treeNode);
    }

    private final void processParameters(TreeNode[] treeNodes, ModuleNode cm) {
        for (int lvi = 1; lvi < treeNodes.length; lvi += 2) {
            if (treeNodes[lvi].getUS() == S_at) {
                this.errors.addError(treeNodes[lvi].getLocation(), "Attempted to declare '@' as a constant.");
            }
            OpDeclNode opDeclNode = this.buildParameter(treeNodes[lvi], 2, 0, cm, true);
        }
    }

    private final void processOperator(TreeNode treeNode, Vector defs, ModuleNode cm) throws AbortException {
        TreeNode syntaxTreeNode = treeNode;
        UniqueString name = null;
        int arity = 0;
        boolean local = syntaxTreeNode.zero() != null;
        TreeNode[] children = syntaxTreeNode.one();
        TreeNode[] ss = children[0].heirs();
        FormalParamNode[] params = null;
        Context ctxt = new Context(this.moduleTable, this.errors);
        boolean isRecursive = false;
        this.symbolTable.pushContext(ctxt);
        if (children[0].isKind(366)) {
            if (ss.length > 2) {
                params = new FormalParamNode[(ss.length - 2) / 2];
                for (int lvi = 2; lvi < ss.length; lvi += 2) {
                    TreeNode[] sss = ss[lvi].heirs();
                    if (ss[lvi].isKind(363)) {
                        name = sss[0].getUS();
                        arity = (sss.length - 1) / 2;
                    } else if (ss[lvi].isKind(370)) {
                        name = sss[1].getUS();
                        name = Operators.resolveSynonym(name);
                        arity = 2;
                    } else if (ss[lvi].isKind(398)) {
                        name = sss[0].getUS();
                        arity = 1;
                    } else {
                        if (!ss[lvi].isKind(394)) {
                            throw new WrongInvocationException(MP.getMessage(2136));
                        }
                        name = sss[1].getUS();
                        arity = 1;
                    }
                    params[(lvi - 2) / 2] = new FormalParamNode(name, arity, ss[lvi], this.symbolTable, cm);
                }
            } else {
                params = new FormalParamNode[]{};
            }
            name = ss[0].getUS();
        } else if (children[0].isKind(400)) {
            params = new FormalParamNode[]{new FormalParamNode(ss[1].getUS(), 0, ss[1], this.symbolTable, cm)};
            name = Operators.resolveSynonym(ss[0].getUS());
        } else if (children[0].isKind(372)) {
            params = new FormalParamNode[]{new FormalParamNode(ss[0].getUS(), 0, ss[0], this.symbolTable, cm), new FormalParamNode(ss[2].getUS(), 0, ss[2], this.symbolTable, cm)};
            name = Operators.resolveSynonym(ss[1].getUS());
        } else if (children[0].isKind(396)) {
            params = new FormalParamNode[]{new FormalParamNode(ss[0].getUS(), 0, ss[0], this.symbolTable, cm)};
            name = Operators.resolveSynonym(ss[1].getUS());
        } else {
            this.errors.addError(children[0].getLocation(), "Unknown parameter declaration `" + children[0].getUS() + "'.");
        }
        OpDefNode odn = null;
        SymbolNode symbolNode = this.symbolTable.resolveSymbol(name);
        if (symbolNode != null) {
            if (symbolNode instanceof OpDefNode) {
                odn = (OpDefNode)symbolNode;
            }
            if (odn != null && odn.inRecursive && !odn.isDefined) {
                if (odn.letInLevel == this.curLevel) {
                    boolean paramsMatch;
                    isRecursive = true;
                    boolean bl = paramsMatch = odn.getParams().length == params.length;
                    if (paramsMatch) {
                        for (int i = 0; i < params.length; ++i) {
                            paramsMatch = params[i].getArity() == 0;
                        }
                    }
                    if (!paramsMatch) {
                        this.errors.addError(treeNode.getLocation(), "Definition of " + odn.getName() + " has different arity than its RECURSIVE declaration.");
                    }
                    odn.setParams(params);
                } else {
                    this.errors.addError(treeNode.getLocation(), "Recursive operator " + name.toString() + " defined at wrong LET/IN level.");
                    odn = null;
                }
            } else {
                this.errors.addError(treeNode.getLocation(), "Operator " + name.toString() + " already defined or declared.");
            }
        }
        this.pushLS();
        ExprNode exp = this.generateExpression(children[2], cm);
        this.symbolTable.popContext();
        if (isRecursive) {
            this.endOpDefNode(odn, exp, syntaxTreeNode);
        } else {
            odn = new OpDefNode(name, 5, params, local, exp, cm, this.symbolTable, syntaxTreeNode, true, null);
            symbolNode = odn;
            this.setOpDefNodeRecursionFields(odn, cm);
        }
        Hashtable ht = this.popLabelNodeSet();
        if (odn != null) {
            odn.setLabels(ht);
        }
        cm.appendDef(symbolNode);
        if (defs != null) {
            defs.addElement(symbolNode);
        }
    }

    private final void processQuantBoundArgs(TreeNode[] treeNodeA, int offset, FormalParamNode[][] odna, boolean[] bt, ExprNode[] ena, ModuleNode cm) throws AbortException {
        int lvi;
        for (lvi = 0; lvi < bt.length; ++lvi) {
            TreeNode[] ss = treeNodeA[offset + 2 * lvi].heirs();
            ena[lvi] = this.generateExpression(ss[ss.length - 1], cm);
        }
        for (lvi = 0; lvi < bt.length; ++lvi) {
            TreeNode treeNode = treeNodeA[offset + 2 * lvi];
            TreeNode[] ss = treeNode.heirs();
            if (ss[0].isKind(365)) {
                bt[lvi] = true;
                TreeNode[] sss = ss[0].heirs();
                odna[lvi] = new FormalParamNode[sss.length / 2];
                for (int lvj = 0; lvj < sss.length / 2; ++lvj) {
                    odna[lvi][lvj] = new FormalParamNode(sss[2 * lvj + 1].getUS(), 0, sss[2 * lvj + 1], this.symbolTable, cm);
                }
                continue;
            }
            bt[lvi] = false;
            odna[lvi] = new FormalParamNode[(ss.length - 1) / 2];
            for (int lvj = 0; lvj < (ss.length - 1) / 2; ++lvj) {
                odna[lvi][lvj] = new FormalParamNode(ss[2 * lvj].getUS(), 0, ss[2 * lvj], this.symbolTable, cm);
            }
        }
    }

    private final void processFunction(TreeNode treeNode, Vector defs, ModuleNode cm) throws AbortException {
        TreeNode syntaxTreeNode = treeNode;
        boolean local = syntaxTreeNode.zero() != null;
        TreeNode[] ss = syntaxTreeNode.one();
        int ql = (ss.length - 4) / 2;
        OpDefNode odn = null;
        FormalParamNode[][] quants = new FormalParamNode[ql][0];
        FormalParamNode[] fcnDeclForRecursion = new FormalParamNode[1];
        boolean[] tuples = new boolean[ql];
        ExprNode[] domains = new ExprNode[ql];
        ExprOrOpArgNode[] lhs = new ExprNode[1];
        Context newContext = new Context(this.moduleTable, this.errors);
        boolean isRecursive = false;
        this.symbolTable.pushContext(newContext);
        this.processQuantBoundArgs(ss, 2, quants, tuples, domains, cm);
        UniqueString name = ss[0].getUS();
        SymbolNode symbolNode = this.symbolTable.resolveSymbol(name);
        SymbolTable st = null;
        if (symbolNode == null) {
            st = this.symbolTable;
        }
        fcnDeclForRecursion[0] = new FormalParamNode(name, 0, treeNode, st, cm);
        this.symbolTable.popContext();
        OpApplNode oan = new OpApplNode(OP_nrfs, fcnDeclForRecursion, new ExprNode[0], quants, tuples, domains, syntaxTreeNode, cm);
        if (symbolNode == null) {
            odn = new OpDefNode(ss[0].getUS(), 5, this.nullParam, local, oan, cm, this.symbolTable, syntaxTreeNode, true, null);
            this.setOpDefNodeRecursionFields(odn, cm);
        } else {
            if (symbolNode instanceof OpDefNode) {
                odn = (OpDefNode)symbolNode;
            }
            if (odn != null && odn.inRecursive && !odn.isDefined) {
                if (odn.letInLevel == this.curLevel) {
                    isRecursive = true;
                    if (odn.getArity() == 0) {
                        this.endOpDefNode(odn, oan, syntaxTreeNode);
                    } else {
                        this.errors.addError(treeNode.getLocation(), "Function " + odn.getName() + " has operator arguments in its RECURSIVE declaration.");
                    }
                } else {
                    this.errors.addError(treeNode.getLocation(), "Recursive function " + name.toString() + " defined at wrong LET/IN level.");
                    odn = null;
                }
            } else {
                this.errors.addError(treeNode.getLocation(), "Function name `" + name.toString() + "' already defined or declared.");
            }
        }
        if (odn != null) {
            cm.appendDef(odn);
            if (defs != null) {
                defs.addElement(odn);
            }
            this.symbolTable.pushContext(newContext);
        }
        this.functions.push(ss[0].getUS(), oan);
        this.pushLS();
        this.pushFormalParams(this.flattenParams(quants));
        lhs[0] = this.generateExpression(ss[ss.length - 1], cm);
        this.popFormalParams();
        Hashtable ht = this.popLabelNodeSet();
        if (odn != null) {
            odn.setLabels(ht);
        }
        this.functions.pop();
        oan.setArgs(lhs);
        if (odn != null) {
            this.symbolTable.popContext();
        }
        if (oan.getOperator().getName() == OP_nrfs) {
            oan.makeNonRecursive();
        }
    }

    private final ExprNode processLetIn(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        TreeNode[] syntaxTreeNode = children[1].heirs();
        Vector defVec = new Vector(4);
        Vector instVec = new Vector(1);
        Context letCtxt = new Context(this.moduleTable, this.errors);
        this.symbolTable.pushContext(letCtxt);
        if (this.curLevel < 100) {
            ++this.curLevel;
        } else {
            this.errors.addAbort(treeNode.getLocation(), "LETs nested more than 100 deep.");
        }
        this.unresolvedCnt[this.curLevel] = 0;
        block6: for (int lvi = 0; lvi < syntaxTreeNode.length; ++lvi) {
            switch (syntaxTreeNode[lvi].getKind()) {
                case 389: {
                    this.processOperator(syntaxTreeNode[lvi], defVec, cm);
                    continue block6;
                }
                case 356: {
                    this.processFunction(syntaxTreeNode[lvi], defVec, cm);
                    continue block6;
                }
                case 383: {
                    this.processModuleDefinition(syntaxTreeNode[lvi], defVec, instVec, cm);
                    continue block6;
                }
                case 431: {
                    this.processRecursive(syntaxTreeNode[lvi], cm);
                    continue block6;
                }
                default: {
                    this.errors.addAbort(syntaxTreeNode[lvi].getLocation(), "Internal error: found unexpected syntax tree node in LET.");
                }
            }
        }
        this.checkForUndefinedRecursiveOps(cm);
        --this.curLevel;
        if (this.curLevel < 0) {
            this.curLevel = 0;
        }
        ExprNode body = this.generateExpression(children[3], cm);
        SymbolNode[] opDefs = new SymbolNode[defVec.size()];
        for (int i = 0; i < opDefs.length; ++i) {
            opDefs[i] = (SymbolNode)defVec.elementAt(i);
        }
        InstanceNode[] insts = new InstanceNode[instVec.size()];
        for (int i = 0; i < insts.length; ++i) {
            insts[i] = (InstanceNode)instVec.elementAt(i);
        }
        LetInNode letIn = new LetInNode(treeNode, opDefs, insts, body, letCtxt);
        this.symbolTable.popContext();
        return letIn;
    }

    private final ExprNode generateExpression(TreeNode treeNode, ModuleNode cm) throws AbortException {
        return this.generateExpressionOrLAP(treeNode, cm, false);
    }

    private final ExprNode generateExpressionOrLAP(TreeNode treeNode, ModuleNode cm, boolean allowLabeledAP) throws AbortException {
        TreeNode[] children = treeNode.heirs();
        TreeNode[] ss = null;
        SymbolNode opn = null;
        TreeNode op = null;
        switch (treeNode.getKind()) {
            case 364: {
                return new DecimalNode(children[0].getImage(), children[2].getImage(), treeNode);
            }
            case 385: {
                return new NumeralNode(children[0].getImage(), treeNode);
            }
            case 418: {
                return new StringNode(treeNode, true);
            }
            case 393: {
                return this.generateExpression(children[1], cm);
            }
            case 371: {
                GenID genID = this.generateGenID(children[1], cm);
                ExprOrOpArgNode[] sns = new ExprOrOpArgNode[2];
                opn = this.symbolTable.resolveSymbol(Operators.resolveSynonym(genID.getCompoundIDUS()));
                if (opn == null) {
                    this.errors.addError(treeNode.getLocation(), "Couldn't resolve infix operator symbol `" + genID.getCompoundIDUS() + "'.");
                    return null;
                }
                sns[0] = this.generateExpression(children[0], cm);
                sns[1] = this.generateExpression(children[2], cm);
                return new OpApplNode(opn, sns, treeNode, cm);
            }
            case 399: {
                ss = children[0].heirs();
                op = ss[1];
                GenID genID = this.generateGenID(children[0], cm, true);
                ExprOrOpArgNode[] sns = new ExprOrOpArgNode[1];
                opn = this.symbolTable.resolveSymbol(Operators.resolveSynonym(genID.getCompoundIDUS()));
                if (opn == null) {
                    this.errors.addError(treeNode.getLocation(), "Couldn't resolve prefix operator symbol `" + genID.getCompoundIDUS() + "'.");
                    return null;
                }
                sns[0] = this.generateExpression(children[1], cm);
                return new OpApplNode(opn, sns, treeNode, cm);
            }
            case 395: {
                GenID genID = this.generateGenID(children[1], cm);
                ExprOrOpArgNode[] sns = new ExprNode[1];
                opn = this.symbolTable.resolveSymbol(Operators.resolveSynonym(genID.getCompoundIDUS()));
                if (opn == null) {
                    this.errors.addError(treeNode.getLocation(), "Couldn't resolve postfix operator symbol `" + genID.getCompoundIDUS() + "'.");
                    return null;
                }
                sns[0] = this.generateExpression(children[0], cm);
                return new OpApplNode(opn, sns, treeNode, cm);
            }
            case 349: {
                ExprOrOpArgNode[] sns = new ExprNode[(children.length + 1) / 2];
                for (int lvi = 0; lvi < sns.length; ++lvi) {
                    sns[lvi] = this.generateExpression(children[2 * lvi], cm);
                }
                return new OpApplNode(OP_cp, sns, treeNode, cm);
            }
            case 411: {
                int size = (children.length - 1) / 2;
                ExprOrOpArgNode[] sns = new ExprNode[size];
                for (int lvi = 0; lvi < size; ++lvi) {
                    sns[lvi] = this.generateExpression(children[2 * lvi + 1], cm);
                }
                return new OpApplNode(OP_se, sns, treeNode, cm);
            }
            case 358: {
                SyntaxTreeNode sTreeNode = (SyntaxTreeNode)treeNode;
                if (sTreeNode.heirs()[1].getKind() == 231 && sTreeNode.heirs()[1].getUS() == this.AtUS && ((SyntaxTreeNode)sTreeNode.heirs()[0]).heirs().length == 0) {
                    if (this.excStack.empty() || this.excSpecStack.empty()) {
                        this.errors.addError(sTreeNode.getLocation(), "@ used where its meaning is not defined.");
                        return this.nullOAN;
                    }
                    return new AtNode((OpApplNode)this.excStack.peek(), (OpApplNode)this.excSpecStack.peek());
                }
                ExprNode retVal = (ExprNode)this.selectorToNode(this.genIdToSelector(sTreeNode), 0, false, false, cm);
                if (retVal.getKind() == 9) {
                    this.functions.recursionCheck(((OpApplNode)retVal).getOperator().getName());
                }
                return retVal;
            }
            case 387: {
                SyntaxTreeNode genIdNode = (SyntaxTreeNode)treeNode.heirs()[0];
                SyntaxTreeNode opApplNode = (SyntaxTreeNode)treeNode.heirs()[1];
                if (genIdNode.getKind() != 358 || opApplNode.getKind() != 388) {
                    this.errors.addAbort(treeNode.getLocation(), "Internal error: OpAppl node with unexpected children.", true);
                }
                Selector sel = this.genIdToSelector(genIdNode);
                sel.args[sel.args.length - 1] = opApplNode;
                sel.selSTN = (SyntaxTreeNode)treeNode;
                return (ExprNode)this.selectorToNode(sel, 0, false, false, cm);
            }
            case 423: {
                int size = (children.length - 1) / 2;
                ExprOrOpArgNode[] sns = new ExprNode[size];
                for (int lvi = 0; lvi < size; ++lvi) {
                    sns[lvi] = this.generateExpression(children[2 * lvi + 1], cm);
                }
                return new OpApplNode(OP_tup, sns, treeNode, cm);
            }
            case 352: {
                ExprNode funcBody;
                SymbolNode funcOperator;
                ExprNode fcn;
                int numArgs = (children.length - 2) / 2;
                ExprOrOpArgNode[] sns = new ExprNode[2];
                sns[0] = this.generateExpression(children[0], cm);
                if (sns[0] == null) {
                    return null;
                }
                if (sns[0].getKind() == 9) {
                    this.functions.recursionCheck(((OpApplNode)sns[0]).getOperator().getName());
                }
                if ((fcn = sns[0]) instanceof OpApplNode && (funcOperator = ((OpApplNode)fcn).getOperator()) instanceof OpDefNode && funcOperator.getKind() == 5 && (funcBody = ((OpDefNode)funcOperator).getBody()) instanceof OpApplNode && (((OpApplNode)funcBody).getOperator().getName() == OP_nrfs || ((OpApplNode)funcBody).getOperator().getName() == OP_rfs)) {
                    int numParms = ((OpApplNode)funcBody).getNumberOfBoundedBoundSymbols();
                    if (numArgs >= 2 && numParms != numArgs) {
                        this.errors.addError(treeNode.getLocation(), "Function '" + ((OpApplNode)sns[0]).getOperator().getName() + "' is defined with " + numParms + " parameters, but is applied to " + numArgs + " arguments.");
                        return this.nullOAN;
                    }
                }
                if (numArgs == 1) {
                    sns[1] = this.generateExpression(children[2], cm);
                } else {
                    ExprOrOpArgNode[] exprs = new ExprNode[numArgs];
                    for (int lvi = 0; lvi < numArgs; ++lvi) {
                        exprs[lvi] = this.generateExpression(children[2 + 2 * lvi], cm);
                    }
                    sns[1] = new OpApplNode(OP_tup, exprs, treeNode, cm);
                }
                return new OpApplNode(OP_fa, sns, treeNode, cm);
            }
            case 424: {
                return this.processChoose(treeNode, children, cm);
            }
            case 335: {
                return this.processBoundQuant(treeNode, children, cm);
            }
            case 425: {
                return this.processUnboundQuant(treeNode, children, cm);
            }
            case 369: {
                ExprOrOpArgNode[] sns = new ExprNode[]{this.generateExpression(children[1], cm), this.generateExpression(children[3], cm), this.generateExpression(children[5], cm)};
                return new OpApplNode(OP_ite, sns, treeNode, cm);
            }
            case 336: {
                return this.processCase(treeNode, children, cm);
            }
            case 341: 
            case 344: {
                ExprOrOpArgNode[] sns = new ExprNode[children.length];
                for (int lvi = 0; lvi < sns.length; ++lvi) {
                    sns[lvi] = this.generateExpression(children[lvi].heirs()[1], cm);
                }
                if (treeNode.isKind(344)) {
                    return new OpApplNode(OP_dl, sns, treeNode, cm);
                }
                return new OpApplNode(OP_cl, sns, treeNode, cm);
            }
            case 410: {
                ExprOrOpArgNode[] sns = new ExprNode[]{this.generateExpression(children[0], cm), new StringNode(children[2], false)};
                return new OpApplNode(OP_rs, sns, treeNode, cm);
            }
            case 414: {
                ExprOrOpArgNode[] sns = new ExprNode[]{this.generateExpression(children[1], cm), this.generateExpression(children[3], cm)};
                return new OpApplNode(OP_sof, sns, treeNode, cm);
            }
            case 419: {
                return this.processSubsetOf(treeNode, children, cm);
            }
            case 413: {
                return this.processSetOfAll(treeNode, children, cm);
            }
            case 409: {
                return this.processRcdForms(OP_rc, treeNode, children, cm);
            }
            case 415: {
                return this.processRcdForms(OP_sor, treeNode, children, cm);
            }
            case 353: {
                return this.processFcnConst(treeNode, children, cm);
            }
            case 329: 
            case 351: {
                return this.processAction(treeNode, children, cm);
            }
            case 346: {
                return this.processExcept(treeNode, children, cm);
            }
            case 380: {
                return this.processLetIn(treeNode, children, cm);
            }
            case 430: {
                this.errors.addError(treeNode.getLocation(), "LAMBDA expression used where an expression is required.");
                return null;
            }
            case 432: {
                LabelNode ln = this.generateLabel(treeNode, cm);
                if (ln.isAssumeProve && !allowLabeledAP) {
                    this.errors.addError(treeNode.getLocation(), "Labeled ASSUME/PROVE used where an expression is required.");
                }
                return ln;
            }
        }
        this.errors.addError(treeNode.getLocation(), "Unsupported expression type `" + treeNode.getImage() + "'.");
        return null;
    }

    private boolean noLabelsAllowed() {
        for (int i = 2; i <= this.assumeProveDepth; ++i) {
            if (!this.inScopeOfAPDecl[i]) continue;
            return true;
        }
        return false;
    }

    private final boolean illegalLabelRef(LabelNode ln, SyntaxTreeNode stn) throws AbortException {
        ThmOrAssumpDefNode goal = ln.goal;
        if (goal == null) {
            return false;
        }
        if (goal.getBody() == null || goal.getBody().getKind() != 14) {
            this.errors.addAbort(stn.getLocation(), "Internal error: Expecting label to be in AssumeProveNode, but it's not.");
        }
        AssumeProveNode ap = (AssumeProveNode)goal.getBody();
        return ap.inScopeOfDecl[ln.goalClause] && goal.isSuffices() == ap.inProof;
    }

    private final boolean illegalAPPosRef(AssumeProveNode ap, int pos) {
        return ap.inScopeOfDecl[pos - 1] && (ap.getGoal() == null || ap.getGoal().isSuffices() == ap.inProof);
    }

    private final AssumeProveNode generateAssumeProve(TreeNode treeNode, ModuleNode cm) throws AbortException {
        ThmOrAssumpDefNode cg = null;
        if (this.assumeProveDepth == 0) {
            cg = this.currentGoal;
        }
        ++this.assumeProveDepth;
        AssumeProveNode apn = new AssumeProveNode(treeNode, cg);
        TreeNode[] children = treeNode.heirs();
        int numOfChildren = children.length;
        if (numOfChildren % 2 != 0) {
            throw new WrongInvocationException("AssumeProve has odd number of children");
        }
        int numOfAssumptions = (numOfChildren - 2) / 2;
        boolean isBoxAssumeProve = false;
        String proveString = children[children.length - 2].getImage();
        if (children[0].getImage().equals("[]ASSUME")) {
            isBoxAssumeProve = true;
            if (!proveString.equals("[]PROVE")) {
                this.errors.addError(children[0].getLocation(), "[]ASSUME matched by PROVE instead of []PROVE");
            }
        } else if (!proveString.equals("PROVE")) {
            this.errors.addError(children[0].getLocation(), "ASSUME matched by []PROVE instead of PROVE");
        }
        apn.setIsBoxAssumeProve(isBoxAssumeProve);
        apn.assumes = new LevelNode[numOfAssumptions];
        boolean inDeclScope = false;
        apn.inScopeOfDecl = new boolean[numOfAssumptions + 1];
        apn.inScopeOfDecl[0] = false;
        this.inScopeOfAPDecl[this.assumeProveDepth] = false;
        if (this.assumeProveDepth != 1) {
            this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
        }
        if (isBoxAssumeProve) {
            if (this.symbolTable.resolveSymbol(S_InAssume) != null) {
                this.errors.addError(children[0].getLocation(), "[]ASSUME used within the scope of an ordinary ASSUME's assumptions");
            }
        } else if (this.symbolTable.resolveSymbol(S_InAssume) == null) {
            this.symbolTable.addSymbol(S_InAssume, InAssumeDummyNode);
        }
        if (this.assumeProveDepth == 1) {
            this.currentGoalClause = 0;
        }
        for (int i = 0; i < numOfAssumptions; ++i) {
            apn.inScopeOfDecl[i + 1] = apn.inScopeOfDecl[i];
            TreeNode tn = children[2 * i + 1];
            switch (tn.getKind()) {
                case 331: {
                    apn.assumes[i] = this.generateAssumeProve(tn, cm);
                    break;
                }
                case 429: {
                    apn.assumes[i] = this.generateNewSymb(tn, cm);
                    apn.inScopeOfDecl[i + 1] = true;
                    this.inScopeOfAPDecl[this.assumeProveDepth] = true;
                    OpDeclNode[] odn = new OpDeclNode[]{((NewSymbNode)apn.assumes[i]).getOpDeclNode()};
                    break;
                }
                default: {
                    apn.assumes[i] = this.generateExpressionOrLAP(tn, cm, true);
                }
            }
            if (this.assumeProveDepth != 1) continue;
            ++this.currentGoalClause;
        }
        apn.prove = this.generateExpression(children[numOfChildren - 1], cm);
        if (this.assumeProveDepth != 1) {
            this.symbolTable.popContext();
        }
        --this.assumeProveDepth;
        return apn;
    }

    private final NewSymbNode generateNewSymb(TreeNode treeNode, ModuleNode cm) throws AbortException {
        int declLevel;
        int declKind;
        TreeNode[] children = treeNode.heirs();
        int numOfChildren = children.length;
        ExprNode set = null;
        if (children[numOfChildren - 2].getKind() == 148) {
            set = this.generateExpression(children[numOfChildren - 1], cm);
        }
        int i = 0;
        if (children[0].getKind() == 55) {
            i = 1;
        }
        switch (children[i].getKind()) {
            case 43: {
                declKind = 24;
                declLevel = 0;
                break;
            }
            case 84: {
                declKind = 25;
                declLevel = 1;
                break;
            }
            case 79: {
                declKind = 26;
                declLevel = 1;
                break;
            }
            case 37: {
                declKind = 27;
                declLevel = 2;
                break;
            }
            case 80: {
                declKind = 28;
                declLevel = 3;
                break;
            }
            default: {
                declKind = 24;
                declLevel = 0;
                i = 0;
            }
        }
        return new NewSymbNode(this.buildParameter(children[i + 1], declKind, declLevel, cm, true), set, treeNode);
    }

    private final ExprNode processChoose(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        OpApplNode result;
        ExprOrOpArgNode[] semanticNode = new ExprNode[1];
        TreeNode[] syntaxTreeNode = children[2].heirs();
        this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
        if (syntaxTreeNode == null || syntaxTreeNode.length == 0) {
            FormalParamNode[] odn;
            if (children[1].isKind(365)) {
                syntaxTreeNode = children[1].heirs();
                odn = new FormalParamNode[syntaxTreeNode.length / 2];
                for (int lvj = 0; lvj < syntaxTreeNode.length / 2; ++lvj) {
                    odn[lvj] = new FormalParamNode(syntaxTreeNode[2 * lvj + 1].getUS(), 0, syntaxTreeNode[2 * lvj + 1], this.symbolTable, cm);
                }
                boolean tuple = true;
            } else {
                odn = new FormalParamNode[]{new FormalParamNode(children[1].getUS(), 0, children[0], this.symbolTable, cm)};
                boolean tuple = false;
            }
            this.pushFormalParams(odn);
            semanticNode[0] = this.generateExpression(children[4], cm);
            this.popFormalParams();
            result = new OpApplNode(OP_uc, semanticNode, odn, treeNode, cm);
        } else {
            FormalParamNode[][] odna = new FormalParamNode[1][0];
            boolean[] tuples = new boolean[1];
            ExprNode[] exprs = new ExprNode[]{this.generateExpression(syntaxTreeNode[1], cm)};
            if (children[1].isKind(365)) {
                syntaxTreeNode = children[1].heirs();
                odna[0] = new FormalParamNode[syntaxTreeNode.length / 2];
                for (int lvj = 0; lvj < syntaxTreeNode.length / 2; ++lvj) {
                    odna[0][lvj] = new FormalParamNode(syntaxTreeNode[2 * lvj + 1].getUS(), 0, syntaxTreeNode[2 * lvj + 1], this.symbolTable, cm);
                }
                tuples[0] = true;
            } else {
                odna[0] = new FormalParamNode[1];
                odna[0][0] = new FormalParamNode(children[1].getUS(), 0, children[1], this.symbolTable, cm);
                tuples[0] = false;
            }
            this.pushFormalParams(this.flattenParams(odna));
            semanticNode[0] = this.generateExpression(children[4], cm);
            this.popFormalParams();
            result = new OpApplNode(OP_bc, null, semanticNode, odna, tuples, exprs, treeNode, cm);
        }
        this.symbolTable.popContext();
        return result;
    }

    private final ExprNode processBoundQuant(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        boolean isExists;
        int length = (children.length - 2) / 2;
        FormalParamNode[][] odna = new FormalParamNode[length][0];
        boolean[] bt = new boolean[length];
        ExprNode[] ea = new ExprNode[length];
        this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
        this.processQuantBoundArgs(children, 1, odna, bt, ea, cm);
        ExprOrOpArgNode[] semanticNode = new ExprNode[1];
        this.pushFormalParams(this.flattenParams(odna));
        semanticNode[0] = this.generateExpression(children[children.length - 1], cm);
        this.popFormalParams();
        this.symbolTable.popContext();
        boolean bl = isExists = children[0].getUS().equals(S_e) || children[0].getUS().equals(S_ex);
        if (isExists) {
            return new OpApplNode(OP_be, null, semanticNode, odna, bt, ea, treeNode, cm);
        }
        return new OpApplNode(OP_bf, null, semanticNode, odna, bt, ea, treeNode, cm);
    }

    private final ExprNode processUnboundQuant(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        boolean level;
        UniqueString r_us;
        UniqueString us = children[0].getUS();
        if (us.equals(S_e)) {
            r_us = OP_ue;
            level = false;
        } else if (us.equals(S_ex)) {
            r_us = OP_ue;
            level = false;
        } else if (us.equals(S_f)) {
            r_us = OP_uf;
            level = false;
        } else if (us.equals(S_fx)) {
            r_us = OP_uf;
            level = false;
        } else if (us.equals(S_te)) {
            r_us = OP_te;
            level = true;
        } else {
            r_us = OP_tf;
            level = true;
        }
        int length = (children.length - 2) / 2;
        FormalParamNode[] odn = new FormalParamNode[length];
        this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
        for (int lvi = 0; lvi < length; ++lvi) {
            odn[lvi] = new FormalParamNode(children[2 * lvi + 1].getUS(), 0, children[2 * lvi + 1], this.symbolTable, cm);
        }
        ExprOrOpArgNode[] semanticNode = new ExprNode[1];
        this.pushFormalParams(odn);
        semanticNode[0] = this.generateExpression(children[children.length - 1], cm);
        this.popFormalParams();
        this.symbolTable.popContext();
        return new OpApplNode(r_us, semanticNode, odn, treeNode, cm);
    }

    private final ExprNode processCase(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        int armCount = children.length / 2;
        ExprOrOpArgNode[] casePairs = new ExprNode[armCount];
        for (int lvi = 0; lvi < armCount; ++lvi) {
            TreeNode caseArm = children[2 * lvi + 1];
            TreeNode[] ss = caseArm.heirs();
            ExprOrOpArgNode[] sops = new ExprNode[2];
            if (!caseArm.isKind(390)) {
                sops[0] = this.generateExpression(ss[0], cm);
            }
            sops[1] = this.generateExpression(ss[2], cm);
            casePairs[lvi] = new OpApplNode(OP_pair, sops, caseArm, cm);
        }
        return new OpApplNode(OP_case, casePairs, treeNode, cm);
    }

    private final ExprNode processSubsetOf(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        ExprOrOpArgNode[] ops = new ExprNode[1];
        FormalParamNode[][] odna = new FormalParamNode[1][0];
        boolean[] tuples = new boolean[1];
        ExprNode[] exprs = new ExprNode[]{this.generateExpression(children[3], cm)};
        this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
        if (children[1].isKind(365)) {
            TreeNode[] ss = children[1].heirs();
            odna[0] = new FormalParamNode[ss.length / 2];
            for (int lvj = 0; lvj < ss.length / 2; ++lvj) {
                odna[0][lvj] = new FormalParamNode(ss[2 * lvj + 1].getUS(), 0, ss[2 * lvj + 1], this.symbolTable, cm);
            }
            tuples[0] = true;
        } else {
            odna[0] = new FormalParamNode[1];
            odna[0][0] = new FormalParamNode(children[1].getUS(), 0, children[1], this.symbolTable, cm);
            tuples[0] = false;
        }
        this.pushFormalParams(this.flattenParams(odna));
        ops[0] = this.generateExpression(children[5], cm);
        this.popFormalParams();
        this.symbolTable.popContext();
        return new OpApplNode(OP_sso, null, ops, odna, tuples, exprs, treeNode, cm);
    }

    private final ExprNode processSetOfAll(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        ExprOrOpArgNode[] ops = new ExprNode[1];
        int length = (children.length - 3) / 2;
        FormalParamNode[][] odna = new FormalParamNode[length][0];
        boolean[] tuples = new boolean[length];
        ExprNode[] exprs = new ExprNode[length];
        this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
        this.processQuantBoundArgs(children, 3, odna, tuples, exprs, cm);
        this.pushFormalParams(this.flattenParams(odna));
        ops[0] = this.generateExpression(children[1], cm);
        this.popFormalParams();
        this.symbolTable.popContext();
        return new OpApplNode(OP_soa, null, ops, odna, tuples, exprs, treeNode, cm);
    }

    private final ExprNode processFcnConst(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        ExprOrOpArgNode[] ops = new ExprNode[1];
        int length = (children.length - 3) / 2;
        FormalParamNode[][] odna = new FormalParamNode[length][0];
        boolean[] tuples = new boolean[length];
        ExprNode[] exprs = new ExprNode[length];
        this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
        this.processQuantBoundArgs(children, 1, odna, tuples, exprs, cm);
        this.pushFormalParams(this.flattenParams(odna));
        ops[0] = this.generateExpression(children[children.length - 2], cm);
        this.popFormalParams();
        this.symbolTable.popContext();
        return new OpApplNode(OP_fc, null, ops, odna, tuples, exprs, treeNode, cm);
    }

    private final ExprNode processRcdForms(UniqueString operator, TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        int length = (children.length - 1) / 2;
        ExprOrOpArgNode[] fieldPairs = new ExprNode[length];
        UniqueString[] labels = new UniqueString[length];
        for (int lvi = 0; lvi < length; ++lvi) {
            TreeNode[] syntaxTreeNode = children[2 * lvi + 1].heirs();
            ExprOrOpArgNode[] sops = new ExprNode[2];
            sops[0] = new StringNode(syntaxTreeNode[0], false);
            labels[lvi] = ((StringNode)sops[0]).getRep();
            for (int cmpIndex = 0; cmpIndex < lvi; ++cmpIndex) {
                if (labels[lvi].compareTo(labels[cmpIndex]) != 0) continue;
                this.errors.addError(syntaxTreeNode[0].getLocation(), "Non-unique fields in constructor.");
            }
            sops[1] = this.generateExpression(syntaxTreeNode[2], cm);
            fieldPairs[lvi] = new OpApplNode(OP_pair, sops, children[2 * lvi + 1], cm);
        }
        return new OpApplNode(operator, fieldPairs, treeNode, cm);
    }

    private final ExprNode processAction(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        UniqueString match = children[0].getUS();
        if (match.equals(S_a)) {
            match = OP_aa;
        } else if (match.equals(S_brack)) {
            match = OP_sa;
        } else if (match.equals(S_sf)) {
            match = OP_sf;
        } else if (match.equals(S_wf)) {
            match = OP_wf;
        }
        ExprOrOpArgNode[] ops = new ExprNode[]{this.generateExpression(children[1], cm), this.generateExpression(children[3], cm)};
        return new OpApplNode(match, ops, treeNode, cm);
    }

    private final ExprNode processExcept(TreeNode treeNode, TreeNode[] children, ModuleNode cm) throws AbortException {
        int numExcepts = (children.length - 3) / 2;
        ExprOrOpArgNode[] operands = new ExprNode[numExcepts + 1];
        operands[0] = this.generateExpression(children[1], cm);
        OpApplNode excNode = new OpApplNode(OP_exc, operands, treeNode, cm);
        for (int excSpecIx = 0; excSpecIx < numExcepts; ++excSpecIx) {
            TreeNode[] syntaxTreeNode = children[3 + 2 * excSpecIx].heirs();
            ExprOrOpArgNode[] sops = new ExprNode[2];
            int slength = syntaxTreeNode.length - 3;
            ExprOrOpArgNode[] ssops = new ExprNode[slength];
            for (int excCompIx = 0; excCompIx < slength; ++excCompIx) {
                TreeNode[] subSyntaxTreeNode = syntaxTreeNode[1 + excCompIx].heirs();
                if (subSyntaxTreeNode[0].getUS().equals(S_brack)) {
                    if (subSyntaxTreeNode.length > 3) {
                        int sslength = (subSyntaxTreeNode.length - 1) / 2;
                        ExprOrOpArgNode[] sssops = new ExprNode[sslength];
                        for (int fArgIx = 0; fArgIx < sslength; ++fArgIx) {
                            sssops[fArgIx] = this.generateExpression(subSyntaxTreeNode[1 + 2 * fArgIx], cm);
                        }
                        ssops[excCompIx] = new OpApplNode(OP_tup, sssops, syntaxTreeNode[2 * excCompIx + 1], cm);
                        continue;
                    }
                    ssops[excCompIx] = this.generateExpression(subSyntaxTreeNode[1], cm);
                    continue;
                }
                ssops[excCompIx] = new StringNode(subSyntaxTreeNode[1], false);
            }
            sops[0] = new OpApplNode(OP_seq, ssops, children[3 + 2 * excSpecIx], cm);
            OpApplNode excSpecNode = new OpApplNode(OP_pair, sops, children[3 + 2 * excSpecIx], cm);
            this.excSpecStack.push(excSpecNode);
            this.excStack.push(excNode);
            sops[1] = this.generateExpression(syntaxTreeNode[syntaxTreeNode.length - 1], cm);
            this.excSpecStack.pop();
            this.excStack.pop();
            operands[excSpecIx + 1] = excSpecNode;
        }
        return excNode;
    }

    private ExprOrOpArgNode generateExprOrOpArg(SymbolNode mainOp, TreeNode mainSTN, int argPosition, TreeNode argRoot, ModuleNode mn) throws AbortException {
        SymbolNode argOp = null;
        if (mainOp == null) {
            this.errors.addError(mainSTN.getLocation(), "Unable to generate expression or operator argument; this is probably because of previously reported errors.");
            return this.nullOAN;
        }
        if (mainOp instanceof ModuleNode) {
            this.errors.addError(mainSTN.getLocation(), "Module name '" + mainOp.getName() + "' used as operator.");
            return this.nullOAN;
        }
        if (argPosition + 1 > mainOp.getArity()) {
            this.errors.addError(mainSTN.getLocation(), "Too many arguments for operator '" + mainOp.getName() + "'.  There should be only " + mainOp.getArity() + ".");
            return this.nullOAN;
        }
        int arityExpected = mainOp.getKind() == 5 || mainOp.getKind() == 6 ? ((OpDefNode)mainOp).getParams()[argPosition].getArity() : 0;
        if (arityExpected == 0) {
            return this.generateExpression(argRoot, mn);
        }
        if (!(argRoot.getImage().equals("N_GeneralId") || argRoot.getImage().equals("N_GenInfixOp") || argRoot.getImage().equals("N_GenNonExpPrefixOp") || argRoot.getImage().equals("N_GenPostfixOp") || argRoot.getImage().equals("N_GenPrefixOp") || argRoot.getImage().equals("N_Lambda"))) {
            this.errors.addError(argRoot.getLocation(), "An expression appears as argument number " + (argPosition + 1) + " (counting from 1) to operator '" + mainOp.getName() + "', in a position an operator is required.");
            return this.nullOAN;
        }
        if (argRoot.getKind() == 430) {
            argOp = this.generateLambda(argRoot, mn);
            if (arityExpected == argOp.getArity()) {
                return new OpArgNode(argOp, argRoot, mn);
            }
            this.errors.addError(mainSTN.getLocation(), "Lambda expression with arity " + argOp.getArity() + " used as argument " + (argPosition + 1) + " of operator `" + mainOp.getName() + "', \nbut an operator of arity " + arityExpected + " is required.");
            return this.nullOpArg;
        }
        if (argRoot.getKind() == 358) {
            return (ExprOrOpArgNode)this.selectorToNode(this.genIdToSelector((SyntaxTreeNode)argRoot), arityExpected, false, false, mn);
        }
        GenID genID = this.generateGenID(argRoot, mn);
        argOp = genID.getFullyQualifiedOp();
        if (argOp == null) {
            return this.nullOAN;
        }
        int argArity = argOp.getArity();
        if (arityExpected == argArity && genID.getArgs().length == 0) {
            return new OpArgNode(genID.getFullyQualifiedOp(), argRoot, mn);
        }
        if (genID.getArgs().length > 0) {
            this.errors.addError(mainSTN.getLocation(), "Expression used in argument position " + (argPosition + 1) + " (counting from 1) of operator `" + mainOp.getName() + "', whereas an operator of arity " + arityExpected + " is required.");
            return this.nullOpArg;
        }
        this.errors.addError(mainSTN.getLocation(), "Operator with incorrect arity passed as argument. \nOperator '" + argOp.getName() + "' of arity " + argArity + " is argument number " + (argPosition + 1) + " (counting from 1) to operator `" + mainOp + "', \nbut an operator of arity " + arityExpected + " was expected.");
        return this.nullOpArg;
    }

    private GenID generateGenID(TreeNode syntaxTreeNode, ModuleNode mn) throws AbortException {
        return this.generateGenID(syntaxTreeNode, mn, false);
    }

    private GenID generateGenID(TreeNode syntaxTreeNode, ModuleNode mn, boolean unaryNegKludge) throws AbortException {
        TreeNode[] children = syntaxTreeNode.heirs();
        TreeNode[] prefix = null;
        SyntaxTreeNode[] allArgs = null;
        TreeNode[] argsList = null;
        if (children == null || children.length <= 0) {
            return null;
        }
        prefix = children[0].heirs();
        GenID genID = new GenID(syntaxTreeNode);
        int len = prefix.length;
        allArgs = new SyntaxTreeNode[len];
        for (int i = 0; i < len; ++i) {
            TreeNode[] prefixElt = prefix[i].heirs();
            genID.append(prefixElt[0].getImage());
            genID.append("!");
            allArgs[i] = prefixElt[1];
        }
        genID.finalAppend(children[1].getImage(), unaryNegKludge);
        int iarg = 0;
        for (int i = 0; i < allArgs.length; ++i) {
            if (allArgs[i] == null || !allArgs[i].isKind(388)) continue;
            argsList = allArgs[i].heirs();
            for (int ia = 1; ia < argsList.length; ia += 2) {
                genID.addArg(this.generateExprOrOpArg(genID.getFullyQualifiedOp(), syntaxTreeNode, iarg, argsList[ia], mn));
                ++iarg;
            }
        }
        genID.finalizeID();
        return genID;
    }

    private final OpDefNode generateLambda(TreeNode syntaxTreeNode, ModuleNode cm) throws AbortException {
        TreeNode[] children = syntaxTreeNode.heirs();
        int arity = (children.length - 2) / 2;
        Context ctxt = new Context(this.moduleTable, this.errors);
        this.symbolTable.pushContext(ctxt);
        FormalParamNode[] params = new FormalParamNode[arity];
        int argPos = 1;
        for (int i = 0; i < arity; ++i) {
            params[i] = new FormalParamNode(children[argPos].getUS(), 0, children[argPos], this.symbolTable, cm);
            argPos += 2;
        }
        this.pushFormalParams(params);
        ExprNode body = this.generateExpression(children[children.length - 1], cm);
        this.popFormalParams();
        this.symbolTable.popContext();
        return new OpDefNode(S_lambda, 5, params, false, body, cm, null, syntaxTreeNode, true, null);
    }

    private final ExprNode generateOpAppl(TreeNode syntaxTreeNode, ModuleNode cm) throws AbortException {
        int i;
        TreeNode primaryArgs = null;
        boolean isOpApp = syntaxTreeNode.isKind(387);
        int primaryArgCount = 0;
        TreeNode[] children = syntaxTreeNode.heirs();
        Object allArgs = null;
        int iarg = 0;
        TreeNode[] argsList = null;
        ExprOrOpArgNode[] args = null;
        GenID genID = this.generateGenID(children[0], cm);
        primaryArgs = children[1];
        primaryArgCount = primaryArgs.heirs().length / 2;
        if (genID == null || genID.getFullyQualifiedOp() == null) {
            return this.nullOAN;
        }
        args = new ExprOrOpArgNode[primaryArgCount];
        argsList = primaryArgs.heirs();
        for (int ia = 1; ia < argsList.length; ia += 2) {
            args[iarg] = this.generateExprOrOpArg(genID.getFullyQualifiedOp(), syntaxTreeNode, iarg, argsList[ia], cm);
            ++iarg;
        }
        Vector genIDArgList = genID.getArgsVector();
        ExprOrOpArgNode[] finalArgList = new ExprOrOpArgNode[genIDArgList.size() + iarg];
        for (i = 0; i < genIDArgList.size(); ++i) {
            finalArgList[i] = (ExprOrOpArgNode)genIDArgList.elementAt(i);
        }
        i = 0;
        int j = genIDArgList.size();
        while (i < iarg) {
            finalArgList[j] = args[i];
            ++i;
            ++j;
        }
        return new OpApplNode(genID.getFullyQualifiedOp(), finalArgList, syntaxTreeNode, cm);
    }

    private final OpDefNode processModuleDefinition(TreeNode treeNode, Vector defs, Vector insts, ModuleNode cm) throws AbortException {
        boolean localness = treeNode.zero() != null;
        TreeNode[] children = treeNode.one()[0].heirs();
        UniqueString name = children[0].getUS();
        FormalParamNode[] args = this.nullParam;
        Context parmCtxt = null;
        if (children.length > 1) {
            args = new FormalParamNode[children.length / 2 - 1];
            parmCtxt = new Context(this.moduleTable, this.errors);
            this.symbolTable.pushContext(parmCtxt);
            for (int i = 0; i < args.length; ++i) {
                TreeNode child = children[2 + 2 * i];
                UniqueString id = null;
                int count = 0;
                if (child.isKind(363)) {
                    id = child.heirs()[0].getUS();
                    count = (child.heirs().length - 1) / 2;
                } else if (child.isKind(370)) {
                    id = child.heirs()[1].getUS();
                    count = 2;
                } else if (child.isKind(398)) {
                    id = child.heirs()[0].getUS();
                    count = 1;
                } else if (child.isKind(394)) {
                    id = child.heirs()[1].getUS();
                    count = 1;
                } else {
                    this.errors.addAbort(treeNode.getLocation(), "Internal error: Error in formal params part of parse tree.", true);
                }
                if (id == null) continue;
                args[i] = new FormalParamNode(id, count, child, this.symbolTable, cm);
            }
        }
        children = treeNode.one()[2].heirs();
        Context instanceeCtxt = this.getContext(children[1].getUS());
        ModuleNode instanceeModule = this.symbolTable.resolveModule(children[1].getUS());
        if (instanceeCtxt == null) {
            this.errors.addError(children[1].getLocation(), "Module " + children[1].getImage() + " does not have a context.");
            return this.nullODN;
        }
        if (instanceeModule == null) {
            this.errors.addError(children[1].getLocation(), "Module name " + children[1].getImage() + " is not known in current context.");
            return this.nullODN;
        }
        instanceeModule.setInstantiated(true);
        SubstInNode substIn = this.processSubst(treeNode, children, this.symbolTable, instanceeCtxt, instanceeModule, cm);
        if (parmCtxt != null) {
            this.symbolTable.popContext();
        }
        Vector<SymbolNode> elts = instanceeCtxt.getByClass(OpDefNode.class);
        for (int i = 0; i < elts.size(); ++i) {
            OpDefNode newOdn;
            OpDefNode odn = (OpDefNode)elts.elementAt(i);
            if (odn.isLocal() || odn.getKind() != 5 && odn.getKind() != 6) continue;
            String compoundID = name + "!" + odn.getName();
            UniqueString qualifiedName = UniqueString.uniqueStringOf(compoundID);
            FormalParamNode[] fpn = odn.getParams();
            FormalParamNode[] params = new FormalParamNode[fpn.length + args.length];
            System.arraycopy(args, 0, params, 0, args.length);
            System.arraycopy(fpn, 0, params, args.length, fpn.length);
            if (odn.getKind() == 5) {
                if (substIn.getSubsts().length > 0) {
                    SubstInNode substInNode = new SubstInNode(treeNode, substIn.getSubsts(), odn.getBody(), cm, instanceeModule);
                    UniqueString[] cID = (UniqueString[])Stream.of({name}, odn.getCompoundId()).flatMap(Stream::of).toArray(UniqueString[]::new);
                    newOdn = new OpDefNode(qualifiedName, 5, params, localness, substInNode, cm, this.symbolTable, treeNode, true, odn.getSource(), cID);
                    this.setOpDefNodeRecursionFields(newOdn, cm);
                    newOdn.setLabels(odn.getLabelsHT());
                } else {
                    newOdn = new OpDefNode(qualifiedName, 5, params, localness, odn.getBody(), cm, this.symbolTable, treeNode, true, odn.getSource());
                    this.setOpDefNodeRecursionFields(newOdn, cm);
                    newOdn.setLabels(odn.getLabelsHT());
                }
            } else {
                newOdn = new OpDefNode(qualifiedName, params, localness, odn.getOriginallyDefinedInModuleNode(), this.symbolTable, treeNode, odn.getSource());
            }
            if (defs == null) {
                cm.appendDef(newOdn);
                continue;
            }
            defs.addElement(newOdn);
        }
        Vector<SymbolNode> taelts = instanceeCtxt.getByClass(ThmOrAssumpDefNode.class);
        for (int i = 0; i < taelts.size(); ++i) {
            ThmOrAssumpDefNode newtaOdn;
            ThmOrAssumpDefNode taOdn = (ThmOrAssumpDefNode)taelts.elementAt(i);
            if (taOdn.isLocal()) continue;
            String compoundID = name + "!" + taOdn.getName();
            UniqueString qualifiedName = UniqueString.uniqueStringOf(compoundID);
            FormalParamNode[] fpn = taOdn.getParams();
            FormalParamNode[] params = new FormalParamNode[fpn.length + args.length];
            System.arraycopy(args, 0, params, 0, args.length);
            System.arraycopy(fpn, 0, params, args.length, fpn.length);
            if (substIn.getSubsts().length > 0) {
                APSubstInNode substInNode = new APSubstInNode(treeNode, substIn.getSubsts(), taOdn.getBody(), cm, instanceeModule);
                newtaOdn = new ThmOrAssumpDefNode(qualifiedName, taOdn.isTheorem(), substInNode, cm, this.symbolTable, treeNode, params, instanceeModule, taOdn.getSource());
                newtaOdn.setLocal(localness);
                newtaOdn.setLabels(taOdn.getLabelsHT());
            } else {
                newtaOdn = new ThmOrAssumpDefNode(qualifiedName, taOdn.isTheorem(), taOdn.getBody(), cm, this.symbolTable, treeNode, params, instanceeModule, taOdn.getSource());
                newtaOdn.setLocal(localness);
                newtaOdn.setLabels(taOdn.getLabelsHT());
            }
            if (defs == null) {
                cm.appendDef(newtaOdn);
                continue;
            }
            defs.addElement(newtaOdn);
        }
        InstanceNode inst = new InstanceNode(name, localness, args, instanceeModule, substIn.getSubsts(), treeNode);
        if (insts == null) {
            cm.appendInstance(inst);
        } else {
            insts.addElement(inst);
        }
        return new OpDefNode(name, args, localness, cm, this.symbolTable, treeNode, null);
    }

    private ExprOrOpArgNode generateSubst(Context instanceeCtxt, TreeNode substTarget, TreeNode substValue, ModuleNode mn) throws AbortException {
        ExprOrOpArgNode returnObject;
        SymbolNode targetSymbol = instanceeCtxt.getSymbol(substTarget.getUS());
        if (targetSymbol == null || !(targetSymbol instanceof OpDeclNode)) {
            this.errors.addError(substTarget.getLocation(), "Identifier '" + substTarget.getUS() + "' is not a legal target of a substitution. \nA legal target must be a declared CONSTANT or VARIABLE in the module being instantiated. \n(Also, check for warnings about multiple declarations of this same identifier.)");
            return this.nullOAN;
        }
        if (targetSymbol.getArity() == 0) {
            returnObject = this.generateExpression(substValue, mn);
        } else {
            returnObject = this.generateOpArg(targetSymbol, substValue, mn);
            if (((OpArgNode)returnObject).getArity() != targetSymbol.getArity()) {
                this.errors.addError(substValue.getLocation(), "An operator must be substituted for symbol '" + targetSymbol.getName() + "', and it must have arity " + targetSymbol.getArity() + ".");
            }
        }
        return returnObject;
    }

    private OpArgNode generateOpArg(SymbolNode targetSymbol, TreeNode opArgSyntaxNode, ModuleNode mn) throws AbortException {
        if (opArgSyntaxNode.isKind(430)) {
            return new OpArgNode(this.generateLambda(opArgSyntaxNode, mn), opArgSyntaxNode, mn);
        }
        if (!(opArgSyntaxNode.isKind(358) || opArgSyntaxNode.isKind(359) || opArgSyntaxNode.isKind(362) || opArgSyntaxNode.isKind(360) || opArgSyntaxNode.isKind(361))) {
            this.errors.addError(opArgSyntaxNode.getLocation(), "Arity " + targetSymbol.getArity() + " operator (not an expression) is expected \nto substitute for CONSTANT '" + targetSymbol.getName() + "'.");
            return this.nullOpArg;
        }
        if (opArgSyntaxNode.getKind() == 358) {
            LevelNode ln;
            if (targetSymbol.getArity() <= 0) {
                this.errors.addAbort(opArgSyntaxNode.getLocation(), "Internal error: expected to find arity > 0.", true);
            }
            if (!((ln = this.selectorToNode(this.genIdToSelector((SyntaxTreeNode)opArgSyntaxNode), targetSymbol.getArity(), false, false, mn)) instanceof OpArgNode)) {
                if (this.errors.getNumErrors() > 0) {
                    return this.nullOpArg;
                }
                this.errors.addAbort(opArgSyntaxNode.getLocation(), "Internal error: Expected an operator argument but found something else.");
            }
            return (OpArgNode)ln;
        }
        GenID genID = this.generateGenID(opArgSyntaxNode, mn);
        if (genID.getFullyQualifiedOp() != null && genID.getArgs().length == 0) {
            return new OpArgNode(genID.getFullyQualifiedOp(), opArgSyntaxNode, mn);
        }
        if (genID.getArgs().length > 0) {
            this.errors.addError(opArgSyntaxNode.getLocation(), "Arity " + targetSymbol.getArity() + " operator (not an expression) is expected to substitute for CONSTANT '" + targetSymbol.getName() + "'.");
            return this.nullOpArg;
        }
        return this.nullOpArg;
    }

    private SubstInNode processSubst(TreeNode treeNode, TreeNode[] substNodes, SymbolTable instancerST, Context instanceeCtxt, ModuleNode instanceeModule, ModuleNode mn) throws AbortException {
        Vector<SymbolNode> decls = instanceeCtxt.getByClass(OpDeclNode.class);
        SubstInNode substIn = new SubstInNode(treeNode, instancerST, decls, mn, instanceeModule);
        for (int i = 3; i < substNodes.length; i += 2) {
            TreeNode[] sc = substNodes[i].heirs();
            ExprOrOpArgNode substRHS = this.generateSubst(instanceeCtxt, sc[0], sc[2], mn);
            substIn.addExplicitSubstitute(instanceeCtxt, sc[0].getUS(), sc[2], substRHS);
        }
        substIn.matchAll(decls);
        return substIn;
    }

    private final InstanceNode generateInstance(TreeNode treeNode, ModuleNode cm, boolean topLevel) throws AbortException {
        ModuleNode instanceeModuleNode;
        TreeNode[] children = topLevel ? treeNode.one()[0].heirs() : treeNode.heirs();
        UniqueString moduleId = children[1].getUS();
        boolean localness = treeNode.local();
        Context instanceeCtxt = this.getContext(moduleId);
        if (instanceeCtxt == null) {
            this.errors.addAbort(children[1].getLocation(), "Internal error: No context available for module `" + moduleId.toString() + "'.", true);
        }
        if ((instanceeModuleNode = this.symbolTable.resolveModule(moduleId)) == null) {
            instanceeModuleNode = this.moduleTable.getModuleNode(moduleId);
        }
        if (instanceeModuleNode == null) {
            this.errors.addAbort(children[1].getLocation(), "Could not find module " + moduleId.toString(), false);
        }
        instanceeModuleNode.setInstantiated(true);
        SubstInNode subst = this.processSubst(treeNode, children, this.symbolTable, instanceeCtxt, instanceeModuleNode, cm);
        Vector<SymbolNode> defs = instanceeCtxt.getByClass(OpDefNode.class);
        for (int i = 0; i < defs.size(); ++i) {
            OpDefNode newOdn;
            OpDefNode odn = (OpDefNode)defs.elementAt(i);
            if (odn.getKind() == 7 || odn.getKind() == 6 || odn.isLocal()) continue;
            if (!instanceeModuleNode.isParameterFree()) {
                if (odn.getOriginallyDefinedInModuleNode().isParameterFree()) {
                    if (localness && topLevel) {
                        newOdn = new OpDefNode(odn.getName(), 5, odn.getParams(), localness, odn.getBody(), odn.getOriginallyDefinedInModuleNode(), this.symbolTable, treeNode, true, odn.getSource());
                        newOdn.setLabels(odn.getLabelsHT());
                    } else {
                        newOdn = odn;
                        this.symbolTable.addSymbol(odn.getName(), odn);
                    }
                } else {
                    SubstInNode substInTemplate = new SubstInNode(treeNode, subst.getSubsts(), odn.getBody(), cm, instanceeModuleNode);
                    newOdn = new OpDefNode(odn.getName(), 5, odn.getParams(), localness, substInTemplate, cm, this.symbolTable, treeNode, true, odn.getSource());
                    newOdn.setLabels(odn.getLabelsHT());
                }
            } else if (localness) {
                newOdn = new OpDefNode(odn.getName(), 5, odn.getParams(), localness, odn.getBody(), odn.getOriginallyDefinedInModuleNode(), this.symbolTable, treeNode, true, odn.getSource());
                newOdn.setLabels(odn.getLabelsHT());
            } else {
                newOdn = odn;
                this.symbolTable.addSymbol(odn.getName(), odn);
            }
            cm.appendDef(newOdn);
            this.setOpDefNodeRecursionFields(newOdn, cm);
        }
        Vector<SymbolNode> tadefs = instanceeCtxt.getByClass(ThmOrAssumpDefNode.class);
        for (int i = 0; i < tadefs.size(); ++i) {
            ThmOrAssumpDefNode newTadn;
            ThmOrAssumpDefNode tadn = (ThmOrAssumpDefNode)tadefs.elementAt(i);
            if (tadn.isLocal()) continue;
            if (!instanceeModuleNode.isParameterFree()) {
                if (tadn.getOriginallyDefinedInModuleNode().isParameterFree()) {
                    if (localness && topLevel) {
                        newTadn = new ThmOrAssumpDefNode(tadn.getName(), tadn.isTheorem(), tadn.getBody(), cm, this.symbolTable, treeNode, tadn.getParams(), instanceeModuleNode, tadn.getSource());
                        newTadn.setLocal(true);
                    } else {
                        newTadn = tadn;
                    }
                } else {
                    APSubstInNode tasubstInTemplate = new APSubstInNode(treeNode, subst.getSubsts(), tadn.getBody(), cm, instanceeModuleNode);
                    newTadn = new ThmOrAssumpDefNode(tadn.getName(), tadn.isTheorem(), tasubstInTemplate, cm, this.symbolTable, treeNode, tadn.getParams(), instanceeModuleNode, tadn.getSource());
                    newTadn.setLocal(localness);
                    newTadn.setLabels(tadn.getLabelsHT());
                }
            } else if (localness && topLevel) {
                newTadn = new ThmOrAssumpDefNode(tadn.getName(), tadn.isTheorem(), tadn.getBody(), tadn.getOriginallyDefinedInModuleNode(), this.symbolTable, treeNode, tadn.getParams(), instanceeModuleNode, tadn.getSource());
                newTadn.setLocal(localness);
                newTadn.setLabels(tadn.getLabelsHT());
            } else {
                newTadn = tadn;
                this.symbolTable.addSymbol(tadn.getName(), tadn);
            }
            if (!topLevel) continue;
            cm.appendDef(newTadn);
        }
        InstanceNode inst = new InstanceNode(null, localness, null, instanceeModuleNode, subst.getSubsts(), treeNode);
        if (topLevel) {
            cm.appendInstance(inst);
        }
        return inst;
    }

    private final void processTheorem(TreeNode stn, ModuleNode cm) throws AbortException {
        LevelNode body;
        boolean hasProof;
        ThmOrAssumpDefNode tadn = null;
        ProofNode proof = null;
        int bodyIndex = stn.heirs().length - 1;
        boolean isAssumeProve = false;
        boolean bl = hasProof = stn.heirs()[bodyIndex].getKind() == 402 || stn.heirs()[bodyIndex].getKind() == 435;
        if (hasProof) {
            --bodyIndex;
        }
        if (bodyIndex > 1) {
            this.pushLS();
            UniqueString name = stn.heirs()[1].getUS();
            tadn = new ThmOrAssumpDefNode(name, stn);
        }
        if (stn.zero()[bodyIndex].isKind(331)) {
            this.currentGoal = tadn;
            isAssumeProve = true;
            this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
            body = this.generateAssumeProve(stn.heirs()[bodyIndex], cm);
            this.currentGoal = null;
        } else {
            body = this.generateExpression(stn.heirs()[bodyIndex], cm);
        }
        if (bodyIndex > 1) {
            Context assumeContext = null;
            if (isAssumeProve) {
                assumeContext = this.symbolTable.getContext();
                this.symbolTable.popContext();
            }
            UniqueString name = stn.heirs()[1].getUS();
            tadn.construct(true, body, cm, this.symbolTable, null);
            tadn.setLabels(this.popLabelNodeSet());
            cm.appendDef(tadn);
            if (isAssumeProve) {
                this.symbolTable.pushContext(assumeContext);
            }
        }
        if (hasProof) {
            proof = this.generateProof(stn.heirs()[bodyIndex + 1], cm);
        }
        if (isAssumeProve) {
            this.symbolTable.popContext();
            ((AssumeProveNode)body).inProof = false;
        }
        cm.addTheorem(stn, body, proof, tadn);
    }

    private final void processAssumption(TreeNode stn, ModuleNode cm) throws AbortException {
        ThmOrAssumpDefNode tadn = null;
        int lastIndex = stn.heirs().length - 1;
        if (lastIndex > 1) {
            this.pushLS();
        }
        ExprNode expr = this.generateExpression(stn.heirs()[lastIndex], cm);
        if (lastIndex > 1) {
            UniqueString name = stn.heirs()[1].getUS();
            tadn = new ThmOrAssumpDefNode(name, false, expr, cm, this.symbolTable, stn, null, null, null);
            tadn.setLabels(this.popLabelNodeSet());
            cm.appendDef(tadn);
        }
        cm.addAssumption(stn, expr, this.symbolTable, tadn);
    }

    private final ProofNode generateProof(TreeNode stn, ModuleNode cm) throws AbortException {
        int i;
        int numberOfPops = 0;
        if (stn.getKind() == 435) {
            return this.generateLeafProof(stn, cm);
        }
        Context pfCtxt = new Context(this.moduleTable, this.errors);
        this.symbolTable.pushContext(pfCtxt);
        TreeNode[] heirs = stn.heirs();
        int offset = 0;
        if (heirs[0].getKind() == 74) {
            offset = 1;
        }
        LevelNode[] steps = new LevelNode[heirs.length - offset];
        Vector iVec = new Vector();
        boolean prevIsInfix = false;
        ExprNode prevRHS = null;
        for (int i2 = offset; i2 < heirs.length; ++i2) {
            int stepKind;
            String oimage;
            boolean isAssumeProve = false;
            boolean isSuffices = false;
            Context assumeContext = null;
            boolean isPick = false;
            Context pickContext = null;
            TreeNode pfStepSTN = heirs[i2];
            TreeNode stepNumSTN = pfStepSTN.heirs()[0];
            TreeNode stepBodySTN = pfStepSTN.heirs()[1];
            TreeNode stepPfSTN = null;
            if (pfStepSTN.heirs().length > 2) {
                stepPfSTN = pfStepSTN.heirs()[2];
            }
            LevelNode pfNumNode = null;
            boolean makePfNumNode = true;
            SyntaxTreeNode STN = (SyntaxTreeNode)stepNumSTN;
            if (!(STN.originalImage == null || STN.originalImage == STN.image || (oimage = STN.originalImage.toString()).equals(STN.image.toString()) || oimage.charAt(1) != '*' && oimage.charAt(1) != '+')) {
                this.errors.addError(stepNumSTN.getLocation(), "<*> and <+> cannot be used for a named step.");
            }
            UniqueString stepNum = null;
            switch (stepNumSTN.getKind()) {
                case 232: 
                case 233: {
                    stepNum = stepNumSTN.getUS();
                    break;
                }
                case 234: {
                    String stNum = stepNumSTN.getUS().toString();
                    stepNum = UniqueString.uniqueStringOf(stNum.substring(0, stNum.indexOf(".")));
                    break;
                }
                default: {
                    makePfNumNode = false;
                }
            }
            if (stepNum != null) {
                this.pushLS();
            }
            ThmOrAssumpDefNode tadn = null;
            if (stepNum != null) {
                tadn = new ThmOrAssumpDefNode(stepNum, stepNumSTN);
            }
            if ((stepKind = stepBodySTN.getKind()) != 444) {
                prevIsInfix = false;
            }
            switch (stepKind) {
                case 438: {
                    TreeNode[] defSTNs = stepBodySTN.heirs();
                    int defOffSet = 0;
                    if (defSTNs[0].getKind() == 64) {
                        defOffSet = 1;
                    }
                    OpDefNode[] defs = new OpDefNode[defSTNs.length - defOffSet];
                    for (int j = defOffSet; j < defSTNs.length; ++j) {
                        TreeNode defSTN = defSTNs[j];
                        Vector<OpDefNode> vec = new Vector<OpDefNode>();
                        switch (defSTN.getKind()) {
                            case 356: {
                                this.processFunction(defSTN, vec, cm);
                                break;
                            }
                            case 383: {
                                Vector defsVec = new Vector();
                                vec.addElement(this.processModuleDefinition(defSTN, defsVec, iVec, cm));
                                break;
                            }
                            case 389: {
                                this.processOperator(defSTN, vec, cm);
                            }
                        }
                        defs[j - defOffSet] = (OpDefNode)vec.elementAt(0);
                    }
                    pfNumNode = new DefStepNode(stepBodySTN, stepNum, defs);
                    steps[i2 - offset] = pfNumNode;
                    break;
                }
                case 436: {
                    UseOrHideNode uohn = this.generateUseOrHide(stepBodySTN, cm);
                    uohn.stn = pfStepSTN;
                    uohn.setStepName(stepNum);
                    if (uohn.facts.length + uohn.defs.length == 0) {
                        this.errors.addError(stepBodySTN.getLocation(), "Empty USE or HIDE statement.");
                    }
                    uohn.factCheck();
                    pfNumNode = uohn;
                    steps[i2 - offset] = pfNumNode;
                    break;
                }
                case 376: {
                    InstanceNode inst = this.generateInstance(stepBodySTN, cm, false);
                    inst.setStepName(stepNum);
                    pfNumNode = inst;
                    steps[i2 - offset] = pfNumNode;
                    break;
                }
                default: {
                    makePfNumNode = false;
                    TreeNode[] bodyHeirs = stepBodySTN.heirs();
                    LevelNode body = null;
                    UniqueString op = null;
                    switch (stepBodySTN.getKind()) {
                        case 444: {
                            ExprOrOpArgNode[] args;
                            int bodyNext = 0;
                            if (bodyHeirs[0].getKind() == 83) {
                                bodyNext = 1;
                                isSuffices = true;
                            }
                            if (bodyHeirs[bodyNext].getKind() == 331) {
                                isAssumeProve = true;
                                this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
                                this.currentGoal = tadn;
                                body = this.generateAssumeProve(bodyHeirs[bodyNext], cm);
                                if (isSuffices) {
                                    ((AssumeProveNode)body).setSuffices();
                                }
                                this.currentGoal = null;
                                assumeContext = this.symbolTable.getContext();
                                this.symbolTable.popContext();
                                prevIsInfix = false;
                                break;
                            }
                            TreeNode curExpr = bodyHeirs[bodyNext];
                            if (isSuffices) {
                                args = new ExprNode[]{this.generateExpression(curExpr, cm)};
                                body = new OpApplNode(OP_suffices, args, stepBodySTN, cm);
                                break;
                            }
                            SyntaxTreeNode curLHS = null;
                            if (curExpr.getKind() == 371) {
                                curLHS = (SyntaxTreeNode)curExpr.heirs()[0];
                            }
                            if (prevIsInfix && curLHS != null && curLHS.heirs().length > 0 && ((SyntaxTreeNode)curLHS.heirs()[0]).heirs().length == 0 && curLHS.heirs().length > 1 && curLHS.heirs()[1].getKind() == 231 && curLHS.heirs()[1].getUS() == this.AtUS) {
                                TreeNode[] children = curExpr.heirs();
                                GenID genID = this.generateGenID(children[1], cm);
                                ExprOrOpArgNode[] sns = new ExprNode[2];
                                SymbolNode opn = this.symbolTable.resolveSymbol(Operators.resolveSynonym(genID.getCompoundIDUS()));
                                if (opn == null) {
                                    this.errors.addError(curExpr.getLocation(), "Couldn't resolve infix operator symbol `" + genID.getCompoundIDUS() + "'.");
                                    return null;
                                }
                                sns[1] = this.generateExpression(children[2], cm);
                                ExprOrOpArgNode[] nopArgs = new ExprNode[]{prevRHS};
                                sns[0] = new OpApplNode(OP_nop, nopArgs, (TreeNode)curLHS, cm);
                                body = new OpApplNode(opn, sns, curExpr, cm);
                            } else {
                                body = this.generateExpression(curExpr, cm);
                            }
                            prevIsInfix = false;
                            if (curLHS == null || body == null || body.getKind() != 9 || ((OpApplNode)body).getArgs().length <= 1) break;
                            prevIsInfix = true;
                            prevRHS = (ExprNode)((OpApplNode)body).getArgs()[1];
                            break;
                        }
                        case 439: 
                        case 443: {
                            op = stepBodySTN.getKind() == 439 ? OP_have : OP_pfcase;
                            ExprOrOpArgNode[] args = new ExprNode[]{this.generateExpression(bodyHeirs[1], cm)};
                            body = new OpApplNode(op, args, stepBodySTN, cm);
                            break;
                        }
                        case 440: 
                        case 442: {
                            ExprOrOpArgNode[] args;
                            if (stepBodySTN.getKind() == 440) {
                                op = OP_take;
                            } else {
                                op = OP_pick;
                                isPick = true;
                                this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
                            }
                            if (bodyHeirs[1].getKind() == 408) {
                                int nextTok;
                                int quants = 1;
                                for (nextTok = 2; nextTok < bodyHeirs.length && bodyHeirs[nextTok].getKind() == 87; nextTok += 2) {
                                    ++quants;
                                }
                                FormalParamNode[][] params = new FormalParamNode[quants][0];
                                boolean[] bt = new boolean[quants];
                                ExprNode[] paramBounds = new ExprNode[quants];
                                this.processQuantBoundArgs(bodyHeirs, 1, params, bt, paramBounds, cm);
                                if (isPick) {
                                    pickContext = this.symbolTable.getContext();
                                    args = new ExprNode[1];
                                    this.pushFormalParams(this.flattenParams(params));
                                    args[0] = this.generateExpression(bodyHeirs[++nextTok], cm);
                                    this.popFormalParams();
                                    this.symbolTable.popContext();
                                } else {
                                    args = new ExprNode[]{};
                                }
                                body = new OpApplNode(op, null, args, params, bt, paramBounds, stepBodySTN, cm);
                                break;
                            }
                            int ids = 1;
                            while (2 * ids < bodyHeirs.length && bodyHeirs[2 * ids].getKind() == 87) {
                                ++ids;
                            }
                            FormalParamNode[] params = new FormalParamNode[ids];
                            for (int j = 0; j < ids; ++j) {
                                params[j] = new FormalParamNode(bodyHeirs[2 * j + 1].getUS(), 0, bodyHeirs[2 * j + 1], this.symbolTable, cm);
                            }
                            if (isPick) {
                                pickContext = this.symbolTable.getContext();
                                this.pushFormalParams(params);
                                args = new ExprNode[]{this.generateExpression(bodyHeirs[2 * ids + 1], cm)};
                                this.popFormalParams();
                                this.symbolTable.popContext();
                            } else {
                                args = new ExprNode[]{};
                            }
                            body = new OpApplNode(op, args, params, stepBodySTN, cm);
                            break;
                        }
                        case 441: {
                            int ids = 1;
                            while (2 * ids < bodyHeirs.length && bodyHeirs[2 * ids].getKind() == 87) {
                                ++ids;
                            }
                            ExprOrOpArgNode[] args = new ExprNode[ids];
                            for (int j = 0; j < ids; ++j) {
                                args[j] = this.generateExpression(bodyHeirs[2 * j + 1], cm);
                            }
                            body = new OpApplNode(OP_witness, args, stepBodySTN, cm);
                            break;
                        }
                        case 407: {
                            ExprOrOpArgNode[] args = new ExprNode[]{};
                            body = new OpApplNode(OP_qed, args, stepBodySTN, cm);
                            break;
                        }
                        default: {
                            this.errors.addAbort(stn.getLocation(), "Internal error: Unexpected SyntaxTreeNode kind: " + heirs[i2].getKind());
                        }
                    }
                    if (stepNum != null) {
                        tadn.construct(true, body, cm, this.symbolTable, null);
                        tadn.setLabels(this.popLabelNodeSet());
                        if (isSuffices) {
                            tadn.setSuffices();
                        }
                    }
                    ProofNode proof = null;
                    if (stepPfSTN != null) {
                        if (isAssumeProve && !isSuffices) {
                            this.symbolTable.pushContext(assumeContext);
                        }
                        proof = this.generateProof(stepPfSTN, cm);
                        if (isAssumeProve && !isSuffices) {
                            this.symbolTable.popContext();
                        }
                    }
                    if (isAssumeProve && isSuffices) {
                        ++numberOfPops;
                        this.symbolTable.pushContext(assumeContext);
                    }
                    if (isAssumeProve) {
                        ((AssumeProveNode)body).inProof = false;
                    }
                    TheoremNode thm = new TheoremNode(stepBodySTN, body, cm, proof, tadn);
                    thm.stn = pfStepSTN;
                    thm.suffices = isSuffices;
                    steps[i2 - offset] = thm;
                }
            }
            if (makePfNumNode) {
                OpDefNode nodeMadeOnlyToBePutInSymbolTable = new OpDefNode(stepNum, pfNumNode, cm, this.symbolTable, pfStepSTN);
                nodeMadeOnlyToBePutInSymbolTable.setLabels(this.popLabelNodeSet());
            }
            if (!isPick) continue;
            Enumeration<Context.Pair> e = pickContext.content();
            while (e.hasMoreElements()) {
                SymbolNode sym = e.nextElement().getSymbol();
                this.symbolTable.addSymbol(sym.getName(), sym);
            }
        }
        InstanceNode[] insts = new InstanceNode[iVec.size()];
        for (i = 0; i < insts.length; ++i) {
            insts[i] = (InstanceNode)iVec.elementAt(i);
        }
        for (i = 0; i < numberOfPops; ++i) {
            Context topContext = this.symbolTable.getContext();
            Enumeration<Context.Pair> e = topContext.content();
            while (e.hasMoreElements()) {
                SymbolNode sym = e.nextElement().getSymbol();
                pfCtxt.addSymbolToContext(sym.getName(), sym);
            }
            this.symbolTable.popContext();
        }
        this.symbolTable.popContext();
        return new NonLeafProofNode(stn, steps, insts, pfCtxt);
    }

    private final LevelNode generateNumerableStep(TreeNode stn, ModuleNode cm) throws AbortException {
        this.errors.addAbort(stn.getLocation(), "Uses generateNumerable_Step");
        Object stepNum = null;
        TreeNode[] heirs = stn.heirs();
        int nextTok = 0;
        ThmOrAssumpDefNode tadn = null;
        boolean isSuffices = false;
        boolean isAssumeProve = false;
        Context assumeContext = null;
        LevelNode body = null;
        TreeNode[] savedHeirs = heirs;
        int savedNextTok = nextTok;
        boolean hasNonExprBody = false;
        if (heirs[nextTok].getKind() == 437) {
            heirs = heirs[nextTok].heirs();
            nextTok = 0;
            hasNonExprBody = true;
        }
        if (heirs[nextTok].getKind() == 83) {
            ++nextTok;
            isSuffices = true;
        }
        if (heirs[nextTok].getKind() == 75) {
            ++nextTok;
        }
        UniqueString op = null;
        switch (heirs[nextTok].getKind()) {
            case 77: {
                body = new OpApplNode(OP_qed, (ExprOrOpArgNode[])new ExprNode[0], heirs[nextTok], cm);
                ++nextTok;
                break;
            }
            case 41: 
            case 69: {
                op = OP_have;
                if (heirs[nextTok].getKind() == 41) {
                    op = OP_pfcase;
                }
                ExprOrOpArgNode[] args = new ExprNode[]{this.generateExpression(heirs[++nextTok], cm)};
                body = new OpApplNode(op, args, heirs[nextTok], cm);
                ++nextTok;
                break;
            }
            case 73: 
            case 81: {
                ExprOrOpArgNode[] args;
                op = OP_take;
                if (heirs[nextTok].getKind() == 81) {
                    op = OP_pick;
                }
                if (heirs[++nextTok].getKind() == 408) {
                    int offset = nextTok++;
                    int quants = 1;
                    while (nextTok < heirs.length && heirs[nextTok].getKind() == 87) {
                        ++quants;
                        nextTok += 2;
                    }
                    FormalParamNode[][] params = new FormalParamNode[quants][0];
                    boolean[] bt = new boolean[quants];
                    ExprNode[] paramBounds = new ExprNode[quants];
                    this.processQuantBoundArgs(heirs, offset, params, bt, paramBounds, cm);
                    if (op == OP_pick) {
                        args = new ExprNode[]{this.generateExpression(heirs[++nextTok], cm)};
                        ++nextTok;
                    } else {
                        args = new ExprNode[]{};
                    }
                    body = new OpApplNode(op, null, args, params, bt, paramBounds, stn, cm);
                    break;
                }
                int ids = 1;
                while (nextTok + 2 * ids - 1 < heirs.length && heirs[nextTok + 2 * ids - 1].getKind() == 87) {
                    ++ids;
                }
                FormalParamNode[] params = new FormalParamNode[ids];
                for (int i = 0; i < ids; ++i) {
                    params[i] = new FormalParamNode(heirs[2 * i + nextTok].getUS(), 0, heirs[2 * i + nextTok], this.symbolTable, cm);
                }
                nextTok = nextTok + 2 * ids - 1;
                if (op == OP_pick) {
                    args = new ExprNode[]{this.generateExpression(heirs[++nextTok], cm)};
                    ++nextTok;
                } else {
                    args = new ExprNode[]{};
                }
                body = new OpApplNode(op, args, params, stn, cm);
                break;
            }
            case 82: {
                ++nextTok;
                int ids = 1;
                while (nextTok + 2 * ids - 1 < heirs.length && heirs[nextTok + 2 * ids - 1].getKind() == 87) {
                    ++ids;
                }
                ExprOrOpArgNode[] exprs = new ExprNode[ids];
                for (int i = 0; i < ids; ++i) {
                    exprs[i] = this.generateExpression(heirs[2 * i + nextTok], cm);
                }
                body = new OpApplNode(OP_tup, exprs, stn, cm);
                nextTok = nextTok + 2 * ids - 1;
                break;
            }
            default: {
                if (heirs[nextTok].getKind() == 331) {
                    isAssumeProve = true;
                    if (!isSuffices) {
                        this.symbolTable.pushContext(new Context(this.moduleTable, this.errors));
                    }
                    body = this.generateAssumeProve(heirs[nextTok], cm);
                    if (!isSuffices) {
                        assumeContext = this.symbolTable.getContext();
                        this.symbolTable.popContext();
                    }
                } else {
                    body = this.generateExpression(heirs[nextTok], cm);
                }
                ++nextTok;
            }
        }
        if (stepNum != null) {
            // empty if block
        }
        if (hasNonExprBody) {
            heirs = savedHeirs;
            nextTok = savedNextTok + 1;
        }
        ProofNode proof = null;
        if (heirs.length > nextTok) {
            if (isAssumeProve && !isSuffices) {
                this.symbolTable.pushContext(assumeContext);
            }
            proof = this.generateProof(heirs[nextTok], cm);
            if (isAssumeProve && !isSuffices) {
                this.symbolTable.popContext();
            }
        }
        TheoremNode thm = new TheoremNode(stn, body, cm, proof, tadn);
        thm.suffices = isSuffices;
        return thm;
    }

    private final LeafProofNode generateLeafProof(TreeNode stn, ModuleNode cm) throws AbortException {
        SymbolNode[] defs;
        LevelNode[] facts;
        TreeNode[] heirs = stn.heirs();
        int nextTok = 0;
        boolean omitted = false;
        if (heirs[0].getKind() == 74) {
            ++nextTok;
        }
        boolean isOnly = false;
        if (heirs[nextTok].getKind() == 62) {
            UseOrHideNode uh = this.generateUseOrHide(stn, cm);
            isOnly = uh.isOnly;
            facts = uh.facts;
            defs = uh.defs;
            if (facts.length + defs.length == 0) {
                this.errors.addError(stn.getLocation(), "Empty BY");
            }
        } else {
            facts = new LevelNode[]{};
            defs = new SymbolNode[]{};
            if (heirs[nextTok].getKind() == 71) {
                omitted = true;
            }
        }
        return new LeafProofNode(stn, facts, defs, omitted, isOnly);
    }

    UseOrHideNode generateUseOrHide(TreeNode stn, ModuleNode cm) throws AbortException {
        SymbolNode[] defs;
        int kind = 31;
        TreeNode[] heirs = stn.heirs();
        boolean isOnly = false;
        if (heirs[0].getKind() == 68) {
            kind = 32;
        }
        int nextTok = 1;
        if (heirs[0].getKind() == 74) {
            ++nextTok;
        }
        if (nextTok >= heirs.length) {
            this.errors.addError(stn.getLocation(), "Empty BY, USE, or HIDE");
            return new UseOrHideNode(kind, stn, new LevelNode[0], new SymbolNode[0], isOnly);
        }
        Vector<LevelNode> vec = new Vector<LevelNode>();
        if (heirs[nextTok].getKind() == 63) {
            isOnly = true;
            ++nextTok;
        }
        while (nextTok < heirs.length && heirs[nextTok].getKind() != 65) {
            if (heirs[nextTok].getKind() == 54) {
                UniqueString moduleId;
                ModuleNode moduleNode;
                if ((moduleNode = this.symbolTable.resolveModule(moduleId = heirs[++nextTok].getUS())) == null && moduleId == cm.getName()) {
                    moduleNode = cm;
                }
                if (moduleNode != null) {
                    vec.addElement(moduleNode);
                } else {
                    this.errors.addError(heirs[nextTok].getLocation(), "Module `" + moduleId + "' used without being extended or instantiated.");
                }
            } else if (heirs[nextTok].getKind() == 358) {
                vec.addElement(this.selectorToNode(this.genIdToSelector((SyntaxTreeNode)heirs[nextTok]), 0, true, false, cm));
            } else if (heirs[nextTok].getKind() == 331) {
                vec.addElement(this.generateAssumeProve(heirs[nextTok], cm));
            } else {
                vec.addElement(this.generateExpression(heirs[nextTok], cm));
            }
            if (++nextTok >= heirs.length || heirs[nextTok].getKind() != 87) continue;
            ++nextTok;
        }
        LevelNode[] facts = new LevelNode[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            facts[i] = (LevelNode)vec.elementAt(i);
        }
        if (nextTok >= heirs.length) {
            defs = new SymbolNode[]{};
        } else {
            vec = new Vector();
            ++nextTok;
            while (nextTok < heirs.length) {
                if (heirs[nextTok].getKind() == 54) {
                    UniqueString moduleId;
                    ModuleNode moduleNode;
                    if ((moduleNode = this.symbolTable.resolveModule(moduleId = heirs[++nextTok].getUS())) == null && moduleId == cm.getName()) {
                        moduleNode = cm;
                    }
                    if (moduleNode != null) {
                        vec.addElement(moduleNode);
                    } else {
                        this.errors.addError(heirs[nextTok].getLocation(), "Module `" + moduleId + "' used without being extended or instantiated.");
                    }
                } else {
                    Selector sel = this.genIdToSelector((SyntaxTreeNode)heirs[nextTok]);
                    LevelNode selToNd = this.selectorToNode(sel, -1, false, true, cm);
                    if (selToNd instanceof OpDefNode || selToNd instanceof ThmOrAssumpDefNode && ((ThmOrAssumpDefNode)selToNd).getName().toString().charAt(0) != '<') {
                        SymbolNode def = (SymbolNode)selToNd;
                        vec.addElement(def);
                    } else {
                        this.errors.addError(heirs[nextTok].getLocation(), "DEF clause entry should describe a defined operator.");
                    }
                }
                if (++nextTok >= heirs.length || heirs[nextTok].getKind() != 87) continue;
                ++nextTok;
            }
            defs = new SymbolNode[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                defs[i] = (SymbolNode)vec.elementAt(i);
            }
        }
        return new UseOrHideNode(kind, stn, facts, defs, isOnly);
    }

    void processRecursive(TreeNode tn, ModuleNode cm) {
        TreeNode[] children = tn.heirs();
        if (this.unresolvedSum == 0) {
            ++this.recursiveSectionCount;
        }
        int numOfDecls = children.length / 2;
        this.unresolvedCnt[this.curLevel] = this.unresolvedCnt[this.curLevel] + numOfDecls;
        this.unresolvedSum += numOfDecls;
        for (int i = 1; i < children.length; i += 2) {
            TreeNode declNode = children[i];
            OpDeclNode odn = this.buildParameter(declNode, 2, 0, cm, false);
            FormalParamNode[] params = new FormalParamNode[odn.getArity()];
            for (int ip = 0; ip < params.length; ++ip) {
                params[ip] = new FormalParamNode(null, 0, null, null, cm);
            }
            OpDefNode node = this.startOpDefNode(odn.getName(), declNode, 5, params, false, cm, this.symbolTable);
            cm.recursiveOpDefNodes.addElement(node);
        }
    }

    LabelNode generateLabel(TreeNode stn, ModuleNode cm) throws AbortException {
        FormalParamNode[] params;
        UniqueString name;
        LevelNode body;
        boolean isAssumeProve = false;
        if (!this.inOpDefNode()) {
            this.errors.addError(stn.getLocation(), "Label not in definition or proof step.");
            return this.nullLabelNode;
        }
        if (this.noLabelsAllowed()) {
            this.errors.addError(stn.getLocation(), "Label not allowed within scope of declaration in nested ASSUME/PROVE.");
            return this.nullLabelNode;
        }
        if (!this.excStack.empty() && !this.excSpecStack.empty()) {
            this.errors.addError(stn.getLocation(), "Labels inside EXCEPT clauses are not yet implemented.");
            return this.nullLabelNode;
        }
        TreeNode[] labelExpChildren = stn.heirs();
        this.pushLS();
        if (labelExpChildren[2].getKind() == 331) {
            body = this.generateAssumeProve(labelExpChildren[2], cm);
            isAssumeProve = true;
        } else {
            body = this.generateExpression(labelExpChildren[2], cm);
        }
        Hashtable ht = this.popLabelNodeSet();
        if (labelExpChildren[0].getKind() == 358) {
            name = labelExpChildren[0].heirs()[1].getUS();
            params = new FormalParamNode[]{};
        } else {
            if (labelExpChildren[0].getKind() != 387) {
                throw new WrongInvocationException("Label has unexpected syntax tree kind.");
            }
            TreeNode[] opApplChildren = labelExpChildren[0].heirs();
            name = opApplChildren[0].heirs()[1].getUS();
            TreeNode[] opArgsChildren = opApplChildren[1].heirs();
            int numOfParams = (opArgsChildren.length - 1) / 2;
            params = new FormalParamNode[numOfParams];
            for (int i = 0; i < numOfParams; ++i) {
                TreeNode argSyntaxNode = opArgsChildren[2 * i + 1];
                UniqueString argName = argSyntaxNode.heirs()[1].getUS();
                SymbolNode argNode = this.symbolTable.resolveSymbol(argName);
                FormalParamNode arg = null;
                if (argNode instanceof FormalParamNode) {
                    arg = (FormalParamNode)argNode;
                } else {
                    this.errors.addError(argSyntaxNode.getLocation(), "Illegal parameter " + argName.toString() + " of label `" + name.toString() + "'.");
                    arg = new FormalParamNode(argName, 0, argSyntaxNode, null, cm);
                }
                params[i] = arg;
            }
        }
        ThmOrAssumpDefNode cg = null;
        if (this.assumeProveDepth > 0) {
            cg = this.currentGoal;
        }
        LabelNode retVal = new LabelNode(stn, name, params, this.currentGoal, this.currentGoalClause, body, isAssumeProve);
        retVal.setLabels(ht);
        boolean ignore = this.formalParamsEqual(retVal);
        if (!this.addLabelNodeToSet(retVal)) {
            this.errors.addError(stn.getLocation(), "Duplicate label `" + name.toString() + "'.");
        }
        return retVal;
    }

    void pushLS() {
        this.LSlabels.addElement(null);
        this.LSparamSeq.addElement(new Vector());
    }

    Hashtable popLabelNodeSet() {
        int size = this.LSlabels.size();
        if (size == 0) {
            throw new WrongInvocationException("popLabelNodeSet called on empty stack.");
        }
        Hashtable retVal = (Hashtable)this.LSlabels.elementAt(size - 1);
        this.LSlabels.removeElementAt(size - 1);
        this.LSparamSeq.removeElementAt(size - 1);
        return retVal;
    }

    boolean addLabelNodeToSet(LabelNode ln) {
        boolean retVal;
        int size = this.LSlabels.size();
        if (size == 0) {
            throw new WrongInvocationException("addLabelNodeToSet called on empty stack.");
        }
        Hashtable<UniqueString, LabelNode> ht = (Hashtable<UniqueString, LabelNode>)this.LSlabels.elementAt(size - 1);
        if (ht == null) {
            ht = new Hashtable<UniqueString, LabelNode>();
            this.LSlabels.setElementAt(ht, size - 1);
        }
        boolean bl = retVal = !ht.containsKey(ln.getName());
        if (retVal) {
            ht.put(ln.getName(), ln);
        }
        return retVal;
    }

    void pushFormalParams(FormalParamNode[] odns) {
        if (!this.inOpDefNode()) {
            return;
        }
        Vector lastFormalParams = (Vector)this.LSparamSeq.elementAt(this.LSparamSeq.size() - 1);
        lastFormalParams.addElement(odns);
    }

    void popFormalParams() {
        if (!this.inOpDefNode()) {
            return;
        }
        Vector lastFormalParams = (Vector)this.LSparamSeq.elementAt(this.LSparamSeq.size() - 1);
        int size = lastFormalParams.size();
        if (size == 0) {
            throw new WrongInvocationException("popFormalParams called on empty stack.");
        }
        lastFormalParams.removeElementAt(size - 1);
    }

    boolean formalParamsEqual(LabelNode ln) {
        boolean retVal = true;
        HashSet<FormalParamNode> opParams = new HashSet<FormalParamNode>();
        FormalParamNode[] odns = ln.params;
        for (int i = 0; i < odns.length; ++i) {
            if (opParams.add(odns[i])) continue;
            retVal = false;
            this.errors.addError(ln.stn.getLocation(), "Repeated formal parameter " + odns[i].getName().toString() + " \nin label `" + ln.getName().toString() + "'.");
        }
        Vector lastFormalParams = (Vector)this.LSparamSeq.elementAt(this.LSparamSeq.size() - 1);
        int size = lastFormalParams.size();
        for (int i = 0; i < size; ++i) {
            FormalParamNode[] ops = (FormalParamNode[])lastFormalParams.elementAt(i);
            for (int j = 0; j < ops.length; ++j) {
                if (opParams.remove(ops[j])) continue;
                retVal = false;
                this.errors.addError(ln.stn.getLocation(), "Label " + ln.getName().toString() + " must contain formal parameter `" + ops[j].getName().toString() + "'.");
            }
        }
        if (!opParams.isEmpty()) {
            retVal = false;
            Iterator iter = opParams.iterator();
            String res = "Label " + ln.getName().toString() + " declares extra parameter(s)  ";
            while (iter.hasNext()) {
                FormalParamNode nd = (FormalParamNode)iter.next();
                res = res + nd.getName().toString() + "  ";
            }
            this.errors.addError(ln.stn.getLocation(), res);
        }
        return retVal;
    }

    boolean inOpDefNode() {
        return this.LSlabels.size() > 0;
    }

    FormalParamNode[] flattenParams(FormalParamNode[][] array) {
        int size = 0;
        for (int i = 0; i < array.length; ++i) {
            size += array[i].length;
        }
        FormalParamNode[] res = new FormalParamNode[size];
        int k = 0;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                res[k] = array[i][j];
                ++k;
            }
        }
        return res;
    }

    OpDefNode startOpDefNode(UniqueString us, TreeNode tn, int kind, FormalParamNode[] params, boolean localness, ModuleNode oModNode, SymbolTable st) {
        OpDefNode odn = new OpDefNode(us, 5, params, localness, null, oModNode, st, tn, false, null);
        oModNode.recursiveDecls.addElement(odn);
        odn.letInLevel = this.curLevel;
        odn.inRecursive = true;
        odn.inRecursiveSection = true;
        odn.recursiveSection = this.recursiveSectionCount;
        oModNode.opDefsInRecursiveSection.addElement(odn);
        return odn;
    }

    void endOpDefNode(OpDefNode nd, ExprNode exp, TreeNode stn) {
        nd.isDefined = true;
        nd.setBody(exp);
        nd.stn = stn;
        if (nd.inRecursive) {
            int n = this.curLevel;
            this.unresolvedCnt[n] = this.unresolvedCnt[n] - 1;
            --this.unresolvedSum;
            if (this.unresolvedSum < 0) {
                throw new WrongInvocationException("Defined more recursive operators than were declared in RECURSIVE statements.");
            }
        }
    }

    void setOpDefNodeRecursionFields(OpDefNode odn, ModuleNode cm) {
        odn.letInLevel = this.curLevel;
        if (this.unresolvedSum > 0) {
            odn.recursiveSection = this.recursiveSectionCount;
            odn.inRecursiveSection = this.unresolvedCnt[this.curLevel] > 0;
            cm.opDefsInRecursiveSection.addElement(odn);
        }
    }

    void checkIfInRecursiveSection(TreeNode tn, String type) {
        if (this.unresolvedSum > 0) {
            this.errors.addError(tn.getLocation(), type + " may not appear within a recursive definition section.");
        }
    }

    void checkForUndefinedRecursiveOps(ModuleNode cm) {
        if (this.unresolvedCnt[this.curLevel] > 0) {
            for (int i = 0; i < cm.recursiveDecls.size(); ++i) {
                OpDefNode odn = (OpDefNode)cm.recursiveDecls.elementAt(i);
                if (odn.letInLevel != this.curLevel || !odn.inRecursive || odn.isDefined) continue;
                this.errors.addError(odn.getTreeNode().getLocation(), "Symbol " + odn.getName().toString() + " declared in RECURSIVE statement but not defined.");
            }
            this.unresolvedSum -= this.unresolvedCnt[this.curLevel];
        }
    }

    private class Selector {
        SyntaxTreeNode selSTN;
        private Vector opVec = new Vector();
        private Vector argVec = new Vector();
        int[] ops = null;
        UniqueString[] opNames = null;
        SyntaxTreeNode[] opsSTN = null;
        SyntaxTreeNode[] args = null;
        final UniqueString GGUS = UniqueString.uniqueStringOf(">>");
        final UniqueString LLUS = UniqueString.uniqueStringOf("<<");
        final UniqueString ColonUS = UniqueString.uniqueStringOf(":");

        Selector(SyntaxTreeNode tn) {
            this.selSTN = tn;
        }

        void addSelector(SyntaxTreeNode stn, SyntaxTreeNode opargs) {
            this.opVec.addElement(stn);
            this.argVec.addElement(opargs);
        }

        void finish() throws AbortException {
            int arrayLen = this.opVec.size();
            this.ops = new int[arrayLen];
            this.opNames = new UniqueString[arrayLen];
            this.opsSTN = new SyntaxTreeNode[arrayLen];
            this.args = new SyntaxTreeNode[arrayLen];
            block5: for (int i = 0; i < arrayLen; ++i) {
                SyntaxTreeNode stn;
                this.args[i] = (SyntaxTreeNode)this.argVec.elementAt(i);
                this.opsSTN[i] = stn = (SyntaxTreeNode)this.opVec.elementAt(i);
                this.opNames[i] = stn.getUS();
                switch (stn.getKind()) {
                    case 231: 
                    case 232: 
                    case 233: 
                    case 373: 
                    case 384: 
                    case 397: 
                    case 401: {
                        this.ops[i] = -1;
                        continue block5;
                    }
                    case 433: {
                        if (stn.heirs().length > 0) {
                            TreeNode numNode = stn.heirs()[0].heirs()[0];
                            this.ops[i] = Integer.parseInt(numNode.getImage());
                            continue block5;
                        }
                        UniqueString us = stn.getUS();
                        if (us == this.GGUS) {
                            this.ops[i] = -3;
                            continue block5;
                        }
                        if (us == this.LLUS) {
                            this.ops[i] = -4;
                            continue block5;
                        }
                        if (us == this.ColonUS) {
                            this.ops[i] = -5;
                            continue block5;
                        }
                        if (us == Generator.this.AtUS) {
                            this.ops[i] = -6;
                            continue block5;
                        }
                        Generator.this.errors.addAbort(stn.getLocation(), "Internal error: Unexpected selector `" + stn.getImage() + "'.");
                        continue block5;
                    }
                    case 388: {
                        this.ops[i] = -2;
                        continue block5;
                    }
                    default: {
                        Generator.this.errors.addError(stn.getLocation(), "Unexpected token found.");
                    }
                }
            }
        }

        public String toString() {
            String retval = "Selector object:\n";
            for (int i = 0; i < this.ops.length; ++i) {
                retval = retval + " elt " + i + " : ops = " + this.ops[i] + ", opNames = " + this.opNames[i].toString() + ", opsSTN.kind = " + this.opsSTN[i].getKind() + ", args.kind = " + (this.args[i] == null ? "null" : this.args[i].getKind() + " ") + "\n";
            }
            return retval;
        }
    }

    private class GenID {
        private TreeNode treeNode;
        private StringBuffer compoundID;
        private Vector argsVector = new Vector();
        private UniqueString compoundIDUS;
        private SymbolNode fullyQualifiedOp;
        private ExprOrOpArgNode[] args;

        public GenID(TreeNode node) {
            this.treeNode = node;
            this.compoundID = new StringBuffer("");
            this.compoundIDUS = null;
            this.fullyQualifiedOp = null;
            this.args = null;
        }

        public final UniqueString getCompoundIDUS() {
            return this.compoundIDUS;
        }

        public final SymbolNode getFullyQualifiedOp() {
            return this.fullyQualifiedOp;
        }

        public final ExprOrOpArgNode[] getArgs() {
            return this.args;
        }

        public final Vector getArgsVector() {
            return this.argsVector;
        }

        public final void append(String s) {
            this.compoundID.append(s);
        }

        public final void addArg(ExprOrOpArgNode arg) {
            this.argsVector.addElement(arg);
        }

        public final void finalAppend(String s, boolean unaryNegKludge) {
            if (unaryNegKludge && s.equals("-")) {
                this.compoundID.append("-.");
            } else {
                this.compoundID.append(s);
            }
            this.compoundIDUS = UniqueString.uniqueStringOf(this.compoundID.toString());
            this.fullyQualifiedOp = Generator.this.symbolTable.resolveSymbol(Operators.resolveSynonym(this.compoundIDUS));
            if (this.fullyQualifiedOp == null && this.compoundIDUS != S_at) {
                Generator.this.errors.addError(this.treeNode.getLocation(), "Could not find declaration or definition of symbol '" + UniqueString.uniqueStringOf(this.compoundID.toString()) + "'.");
            }
        }

        public final void finalizeID() {
            this.args = new ExprOrOpArgNode[this.argsVector.size()];
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = (ExprOrOpArgNode)this.argsVector.elementAt(i);
            }
        }

        public final void appendDot() {
            this.compoundIDUS = UniqueString.uniqueStringOf(this.compoundIDUS.toString() + ".");
        }

        public final String toString(int n) {
            String ret = "compound ID: " + this.compoundID.toString() + "\nargs: " + this.args.length + "\n";
            for (int i = 0; i < this.args.length; ++i) {
                ret = ret + Strings.indent(2, this.args[i].toString(n));
            }
            return ret;
        }
    }

    class Function {
        Stack funcStack = new Stack();

        Function() {
        }

        void push(UniqueString uniqueString, OpApplNode oan) {
            this.funcStack.push(new pair(uniqueString, oan));
        }

        void pop() {
            this.funcStack.pop();
        }

        boolean recursionCheck(UniqueString uniqueString) {
            for (int lvi = this.funcStack.size() - 1; lvi >= 0; --lvi) {
                if (!uniqueString.equals(((pair)this.funcStack.elementAt(lvi)).uniqueString())) continue;
                ((pair)this.funcStack.elementAt(lvi)).oan().resetOperator(ASTConstants.OP_rfs);
                return true;
            }
            return false;
        }

        class pair {
            UniqueString a;
            OpApplNode b;

            pair(UniqueString uniqueString, OpApplNode oan) {
                this.a = uniqueString;
                this.b = oan;
            }

            UniqueString uniqueString() {
                return this.a;
            }

            OpApplNode oan() {
                return this.b;
            }
        }
    }
}

