/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBPar;
import util.Assert;

class LNAll
extends LiveExprNode {
    private static final String ALWAYS = "[]";
    private final LiveExprNode body;

    public LNAll(LiveExprNode body) {
        this.body = body;
    }

    public final LiveExprNode getBody() {
        return this.body;
    }

    @Override
    public final int getLevel() {
        return 3;
    }

    @Override
    public final boolean containAction() {
        return this.body.containAction();
    }

    @Override
    public final boolean eval(ITool tool, TLCState s1, TLCState s2) {
        Assert.fail(2251, ALWAYS);
        return false;
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        sb.append(ALWAYS);
        this.getBody().toString(sb, padding + "  ");
    }

    @Override
    public LiveExprNode getAEBody() {
        LiveExprNode allBody = this.getBody();
        if (allBody instanceof LNEven) {
            return ((LNEven)allBody).getBody();
        }
        return super.getAEBody();
    }

    @Override
    public void extractPromises(TBPar promises) {
        this.getBody().extractPromises(promises);
    }

    @Override
    public int tagExpr(int tag) {
        return this.getBody().tagExpr(tag);
    }

    @Override
    public final LiveExprNode makeBinary() {
        return new LNAll(this.getBody().makeBinary());
    }

    @Override
    public LiveExprNode flattenSingleJunctions() {
        return new LNAll(this.getBody().flattenSingleJunctions());
    }

    @Override
    public LiveExprNode simplify() {
        LiveExprNode body1 = this.getBody().simplify();
        if (body1 instanceof LNAll) {
            body1 = ((LNAll)body1).getBody();
        }
        return new LNAll(body1);
    }

    @Override
    public boolean isGeneralTF() {
        LiveExprNode allBody = this.getBody();
        if (allBody instanceof LNEven) {
            return false;
        }
        return super.isGeneralTF();
    }

    @Override
    public LiveExprNode pushNeg() {
        return new LNEven(this.getBody().pushNeg());
    }

    @Override
    public LiveExprNode pushNeg(boolean hasNeg) {
        if (hasNeg) {
            return new LNEven(this.getBody().pushNeg(true));
        }
        return new LNAll(this.getBody().pushNeg(false));
    }

    @Override
    public boolean equals(LiveExprNode exp) {
        if (exp instanceof LNAll) {
            return this.getBody().equals(((LNAll)exp).getBody());
        }
        return false;
    }

    @Override
    public String toDotViz() {
        return ALWAYS + this.getBody().toDotViz();
    }
}

