/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.EvalException;
import tlc2.tool.ITool;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.liveness.AbstractDiskGraph;
import tlc2.tool.liveness.DiskGraph;
import tlc2.tool.liveness.GraphNode;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.ILiveChecker;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.PossibleErrorModel;
import tlc2.tool.liveness.TBPar;
import tlc2.tool.liveness.TableauNodePtrTable;
import tlc2.util.IntStack;
import tlc2.util.LongVec;
import tlc2.util.MemIntQueue;
import tlc2.util.MemIntStack;
import tlc2.util.SynchronousDiskIntStack;
import tlc2.util.statistics.BucketStatistics;
import tlc2.util.statistics.IBucketStatistics;

public class LiveWorker
implements Callable<Boolean> {
    private static final long SCC_MARKER = -42L;
    public static final IBucketStatistics STATS = new BucketStatistics("Histogram SCC sizes", LiveWorker.class.getPackage().getName(), "StronglyConnectedComponent sizes");
    private static int errFoundByThread = -1;
    private static final Object workerLock = new Object();
    private OrderOfSolution oos = null;
    private AbstractDiskGraph dg = null;
    private PossibleErrorModel pem = null;
    private final ILiveCheck liveCheck;
    private final BlockingQueue<ILiveChecker> queue;
    private final boolean isFinalCheck;
    private final int numWorkers;
    private final ITool tool;
    private final int id;

    public LiveWorker(ITool tool, int id, int numWorkers, ILiveCheck liveCheck, BlockingQueue<ILiveChecker> queue, boolean finalCheck) {
        this.id = id;
        this.tool = tool;
        this.numWorkers = numWorkers;
        this.liveCheck = liveCheck;
        this.queue = queue;
        this.isFinalCheck = finalCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasErrFound() {
        Object object = workerLock;
        synchronized (object) {
            return errFoundByThread != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasErrFound(int id) {
        Object object = workerLock;
        synchronized (object) {
            return errFoundByThread == id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setErrFound() {
        Object object = workerLock;
        synchronized (object) {
            if (errFoundByThread == -1) {
                errFoundByThread = this.id;
                return true;
            }
            return errFoundByThread == this.id;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkSccs(ITool tool) throws IOException, InterruptedException, ExecutionException {
        this.dg.makeNodePtrTbl();
        LongVec initNodes = this.dg.getInitNodes();
        int numOfInits = initNodes.size();
        MemIntQueue nodeQueue = new MemIntQueue(this.liveCheck.getMetaDir(), "root", numOfInits / 2 * 5);
        for (int j = 0; j < numOfInits; j += 2) {
            int tidx;
            long state = initNodes.elementAt(j);
            long ptr = this.dg.getLink(state, tidx = (int)initNodes.elementAt(j + 1));
            if (ptr >= 0L) {
                assert (DiskGraph.isFilePointer(ptr));
                nodeQueue.enqueueLong(state);
                nodeQueue.enqueueInt(tidx);
                nodeQueue.enqueueLong(ptr);
                continue;
            }
            assert (!this.isFinalCheck || ptr != -8589934592L);
        }
        int[] eaaction = this.pem.EAAction;
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        Class<LiveWorker> clazz = LiveWorker.class;
        synchronized (LiveWorker.class) {
            IntStack dfsStack = this.getStack(this.liveCheck.getMetaDir(), "dfs" + this.id);
            IntStack comStack = this.getStack(this.liveCheck.getMetaDir(), "com" + this.id);
            // ** MonitorExit[var10_14] (shouldn't be in output)
            while (nodeQueue.size() > 0L) {
                long state = nodeQueue.dequeueLong();
                int tidx = nodeQueue.dequeueInt();
                long loc = nodeQueue.dequeueLong();
                dfsStack.reset();
                dfsStack.pushLong(state);
                dfsStack.pushInt(tidx);
                dfsStack.pushLong(loc);
                dfsStack.pushLong(0x4000000000000000L);
                long newLink = 0x4000000000000000L;
                while (dfsStack.size() >= 7L) {
                    long lowLink = dfsStack.popLong();
                    long curLoc = dfsStack.popLong();
                    int curTidx = dfsStack.popInt();
                    long curState = dfsStack.popLong();
                    assert (DiskGraph.isFilePointer(curLoc));
                    if (curLoc == -42L) {
                        boolean isOK;
                        long curLink = this.dg.getLink(curState, curTidx);
                        assert (curLink < Long.MAX_VALUE);
                        if (curLink == lowLink && !(isOK = this.checkComponent(tool, curState, curTidx, comStack))) {
                            return;
                        }
                        long plowLink = dfsStack.popLong();
                        dfsStack.pushLong(Math.min(plowLink, lowLink));
                        continue;
                    }
                    long link = this.dg.putLink(curState, curTidx, newLink);
                    if (link == -1L) {
                        dfsStack.pushLong(lowLink);
                        dfsStack.pushLong(curState);
                        dfsStack.pushInt(curTidx);
                        dfsStack.pushLong(-42L);
                        comStack.pushLong(curLoc);
                        comStack.pushInt(curTidx);
                        comStack.pushLong(curState);
                        GraphNode gnode = this.dg.getNode(curState, curTidx, curLoc);
                        int succCnt = gnode.succSize();
                        long nextLowLink = newLink++;
                        for (int i = 0; i < succCnt; ++i) {
                            int nextTidx;
                            long nextState = gnode.getStateFP(i);
                            long nextLink = this.dg.getLink(nextState, nextTidx = gnode.getTidx(i));
                            if (nextLink >= 0L) {
                                if (gnode.getCheckAction(slen, alen, i, eaaction)) {
                                    if (DiskGraph.isFilePointer(nextLink)) {
                                        dfsStack.pushLong(nextState);
                                        dfsStack.pushInt(nextTidx);
                                        dfsStack.pushLong(nextLink);
                                        continue;
                                    }
                                    nextLowLink = Math.min(nextLowLink, nextLink);
                                    continue;
                                }
                                if (!DiskGraph.isFilePointer(nextLink)) continue;
                                nodeQueue.enqueueLong(nextState);
                                nodeQueue.enqueueInt(nextTidx);
                                nodeQueue.enqueueLong(nextLink);
                                continue;
                            }
                            assert (!this.isFinalCheck || nextLink != -8589934592L);
                        }
                        dfsStack.pushLong(nextLowLink);
                        continue;
                    }
                    assert (0x4000000000000000L <= link && link <= Long.MAX_VALUE);
                    dfsStack.pushLong(Math.min(lowLink, link));
                }
            }
            assert (comStack.size() == 0L);
            return;
        }
    }

    private IntStack getStack(String metaDir, String name) throws IOException {
        try {
            double freeMemoryInBytes = (double)Runtime.getRuntime().freeMemory() / ((double)this.numWorkers * 1.0);
            long graphSizeInBytes = this.dg.getSizeOnDisk();
            double ratio = (double)graphSizeInBytes / freeMemoryInBytes;
            if (ratio > TLCGlobals.livenessGraphSizeThreshold) {
                int capacityInBytes = 0x800000 << Math.min((int)ratio, 5);
                if ((double)capacityInBytes < freeMemoryInBytes) {
                    return new SynchronousDiskIntStack(metaDir, name, capacityInBytes);
                }
                return new SynchronousDiskIntStack(metaDir, name);
            }
            return new MemIntStack(metaDir, name);
        }
        catch (OutOfMemoryError oom) {
            System.gc();
            SynchronousDiskIntStack sdis = new SynchronousDiskIntStack(metaDir, name, 0x400000);
            MP.printWarning(1000, "Liveness checking will be extremely slow because TLC is running low on memory.\nTry allocating more memory to the Java pool (heap) in future TLC runs.");
            return sdis;
        }
    }

    private boolean checkComponent(ITool tool, long state, int tidx, IntStack comStack) throws IOException, InterruptedException, ExecutionException {
        int i;
        long comStackSize = comStack.size();
        assert (comStackSize >= 5L && comStackSize % 5L == 0L);
        long state1 = comStack.popLong();
        int tidx1 = comStack.popInt();
        long loc1 = comStack.popLong();
        if (state1 == state && tidx1 == tidx && !this.isStuttering(state1, tidx1, loc1)) {
            this.dg.setMaxLink(state, tidx);
            return true;
        }
        TableauNodePtrTable com = new TableauNodePtrTable(128);
        while (true) {
            com.put(state1, tidx1, loc1);
            assert (AbstractDiskGraph.isFilePointer(loc1));
            this.dg.setMaxLink(state1, tidx1);
            if (state == state1 && tidx == tidx1) break;
            state1 = comStack.popLong();
            tidx1 = comStack.popInt();
            loc1 = comStack.popLong();
        }
        assert ((long)com.size() <= comStackSize / 5L);
        STATS.addSample(com.size());
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        int aeslen = this.pem.AEState.length;
        int aealen = this.pem.AEAction.length;
        int plen = this.oos.getPromises().length;
        boolean[] AEStateRes = new boolean[aeslen];
        boolean[] AEActionRes = new boolean[aealen];
        boolean[] promiseRes = new boolean[plen];
        int[] eaaction = this.pem.EAAction;
        int tsz = com.getSize();
        for (int ci = 0; ci < tsz; ++ci) {
            int[] nodes = com.getNodesByLoc(ci);
            if (nodes == null) continue;
            state1 = TableauNodePtrTable.getKey(nodes);
            for (int nidx = 2; nidx < nodes.length; nidx += com.getElemLength()) {
                int i2;
                tidx1 = TableauNodePtrTable.getTidx(nodes, nidx);
                loc1 = TableauNodePtrTable.getElem(nodes, nidx);
                GraphNode curNode = this.dg.getNode(state1, tidx1, loc1);
                for (int i3 = 0; i3 < aeslen; ++i3) {
                    if (AEStateRes[i3]) continue;
                    int idx = this.pem.AEState[i3];
                    AEStateRes[i3] = curNode.getCheckState(idx);
                }
                int succCnt = aealen > 0 ? curNode.succSize() : 0;
                for (i2 = 0; i2 < succCnt; ++i2) {
                    int nextTidx;
                    long nextState = curNode.getStateFP(i2);
                    if (com.getLoc(nextState, nextTidx = curNode.getTidx(i2)) == -1 || !curNode.getCheckAction(slen, alen, i2, eaaction)) continue;
                    for (int j = 0; j < aealen; ++j) {
                        if (AEActionRes[j]) continue;
                        int idx = this.pem.AEAction[j];
                        AEActionRes[j] = curNode.getCheckAction(slen, alen, i2, idx);
                    }
                }
                for (i2 = 0; i2 < plen; ++i2) {
                    LNEven promise = this.oos.getPromises()[i2];
                    TBPar par = curNode.getTNode(this.oos.getTableau()).getPar();
                    if (!par.isFulfilling(promise)) continue;
                    promiseRes[i2] = true;
                }
            }
        }
        for (i = 0; i < aeslen; ++i) {
            if (AEStateRes[i]) continue;
            return true;
        }
        for (i = 0; i < aealen; ++i) {
            if (AEActionRes[i]) continue;
            return true;
        }
        for (i = 0; i < plen; ++i) {
            if (promiseRes[i]) continue;
            return true;
        }
        if (this.setErrFound()) {
            this.printTrace(tool, state, tidx, com);
        }
        return false;
    }

    private boolean isStuttering(long state, int tidx, long loc) throws IOException {
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        GraphNode gnode = this.dg.getNode(state, tidx, loc);
        int succCnt = gnode.succSize();
        for (int i = 0; i < succCnt; ++i) {
            long nextState = gnode.getStateFP(i);
            int nextTidx = gnode.getTidx(i);
            if (state != nextState || tidx != nextTidx) continue;
            return gnode.getCheckAction(slen, alen, i, this.pem.EAAction);
        }
        return false;
    }

    private void printTrace(final ITool tool, final long state, final int tidx, TableauNodePtrTable nodeTbl) throws IOException, InterruptedException, ExecutionException {
        TLCStateInfo cycleState;
        MP.printError(2116);
        MP.printError(2264);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<List<TLCStateInfo>> future = executor.submit(new Callable<List<TLCStateInfo>>(){

            @Override
            public List<TLCStateInfo> call() throws Exception {
                int i;
                LongVec prefix = LiveWorker.this.dg.getPath(state, tidx);
                int plen = prefix.size();
                ArrayList<TLCStateInfo> states = new ArrayList<TLCStateInfo>(plen);
                long fp = prefix.elementAt(plen - 1);
                TLCStateInfo sinfo = tool.getState(fp);
                if (sinfo == null) {
                    throw new EvalException(2123);
                }
                states.add(sinfo);
                for (i = plen - 2; i >= 0; --i) {
                    long curFP = prefix.elementAt(i);
                    if (curFP == fp) continue;
                    sinfo = tool.getState(curFP, sinfo);
                    states.add(sinfo);
                    fp = curFP;
                }
                for (i = 0; i < states.size() - 1; ++i) {
                    StatePrinter.printInvariantViolationStateTraceState(tool.evalAlias((TLCStateInfo)states.get(i), ((TLCStateInfo)states.get((int)(i + 1))).state));
                }
                return states;
            }
        });
        MemIntStack cycleStack = new MemIntStack(this.liveCheck.getMetaDir(), "cycle");
        GraphNode curNode = this.dfsPostFix(state, tidx, nodeTbl, cycleStack);
        LongVec postfix = this.bfsPostFix(state, tidx, nodeTbl, curNode);
        while (cycleStack.size() > 0L) {
            long fp = cycleStack.popLong();
            if (postfix.isEmpty() || postfix.lastElement() != fp) {
                postfix.addElement(fp);
            }
            cycleStack.popInt();
        }
        List<Object> states = new ArrayList(0);
        try {
            states = future.get();
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof EvalException) {
                throw (EvalException)ee.getCause();
            }
            throw ee;
        }
        TLCStateInfo sinfo = cycleState = (TLCStateInfo)states.get(states.size() - 1);
        if (postfix.isEmpty()) {
            StatePrinter.printInvariantViolationStateTraceState(tool.evalAlias(cycleState, cycleState.state));
        } else {
            postfix.pack().removeLastIf(cycleState.fingerPrint());
            for (int i = postfix.size() - 1; i >= 0; --i) {
                long curFP = postfix.elementAt(i);
                TLCStateInfo sucinfo = tool.getState(curFP, sinfo);
                StatePrinter.printInvariantViolationStateTraceState(tool.evalAlias(sinfo, sucinfo.state));
                sinfo = sucinfo;
            }
            StatePrinter.printInvariantViolationStateTraceState(tool.evalAlias(sinfo, cycleState.state));
        }
        int stateNumber = (int)cycleState.stateNumber;
        if (sinfo.fingerPrint() == cycleState.fingerPrint()) {
            StatePrinter.printStutteringState(stateNumber);
        } else {
            sinfo = tool.getState(cycleState.fingerPrint(), sinfo);
            assert (cycleState.state.equals(sinfo.state));
            StatePrinter.printBackToState(sinfo, stateNumber);
        }
    }

    private LongVec bfsPostFix(long state, int tidx, TableauNodePtrTable nodeTbl, GraphNode curNode) throws IOException {
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        int[] eaaction = this.pem.EAAction;
        LongVec postfix = new LongVec(16);
        long startState = curNode.stateFP;
        long startTidx = curNode.tindex;
        if (startState != state || startTidx != (long)tidx) {
            MemIntQueue queue = new MemIntQueue(this.liveCheck.getMetaDir(), null);
            long curState = startState;
            int ploc = -1;
            int curLoc = nodeTbl.getNodesLoc(curState);
            int[] nodes = nodeTbl.getNodesByLoc(curLoc);
            TableauNodePtrTable.setSeen(nodes);
            block0: while (true) {
                int tloc = TableauNodePtrTable.startLoc(nodes);
                while (tloc != -1) {
                    int curTidx = TableauNodePtrTable.getTidx(nodes, tloc);
                    long curPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes, tloc));
                    curNode = this.dg.getNode(curState, curTidx, curPtr);
                    int succCnt = curNode.succSize();
                    for (int j = 0; j < succCnt; ++j) {
                        long nextState = curNode.getStateFP(j);
                        int nextTidx = curNode.getTidx(j);
                        if (curState == nextState && curTidx == nextTidx) {
                            assert (TableauNodePtrTable.isSeen(nodes));
                            continue;
                        }
                        if (!curNode.getCheckAction(slen, alen, j, eaaction)) continue;
                        if (nextState == state && nextTidx == tidx) {
                            while (curState != startState) {
                                postfix.addElement(curState);
                                nodes = nodeTbl.getNodesByLoc(ploc);
                                curState = TableauNodePtrTable.getKey(nodes);
                                ploc = TableauNodePtrTable.getParent(nodes);
                            }
                            postfix.addElement(startState);
                            break block0;
                        }
                        int[] nodes1 = nodeTbl.getNodes(nextState);
                        if (nodes1 == null || TableauNodePtrTable.isSeen(nodes1)) continue;
                        TableauNodePtrTable.setSeen(nodes1);
                        queue.enqueueLong(nextState);
                        queue.enqueueInt(curLoc);
                    }
                    tloc = TableauNodePtrTable.nextLoc(nodes, tloc);
                }
                TableauNodePtrTable.setParent(nodes, ploc);
                curState = queue.dequeueLong();
                ploc = queue.dequeueInt();
                curLoc = nodeTbl.getNodesLoc(curState);
                nodes = nodeTbl.getNodesByLoc(curLoc);
            }
        }
        return postfix;
    }

    private GraphNode dfsPostFix(long state, int tidx, TableauNodePtrTable nodeTbl, MemIntStack cycleStack) throws IOException {
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        boolean[] AEStateRes = new boolean[this.pem.AEState.length];
        boolean[] AEActionRes = new boolean[this.pem.AEAction.length];
        boolean[] promiseRes = new boolean[this.oos.getPromises().length];
        int[] eaaction = this.pem.EAAction;
        int cnt = AEStateRes.length + AEActionRes.length + promiseRes.length;
        int[] nodes = nodeTbl.getNodes(state);
        int tloc = nodeTbl.getIdx(nodes, tidx);
        long ptr = TableauNodePtrTable.getElem(nodes, tloc);
        TableauNodePtrTable.setSeen(nodes, tloc);
        GraphNode curNode = this.dg.getNode(state, tidx, ptr);
        block0: while (cnt > 0) {
            int cnt0 = cnt;
            while (true) {
                int i;
                for (i = 0; i < this.pem.AEState.length; ++i) {
                    int idx = this.pem.AEState[i];
                    if (AEStateRes[i] || !curNode.getCheckState(idx)) continue;
                    AEStateRes[i] = true;
                    --cnt;
                }
                for (i = 0; i < this.oos.getPromises().length; ++i) {
                    LNEven promise = this.oos.getPromises()[i];
                    TBPar par = curNode.getTNode(this.oos.getTableau()).getPar();
                    if (promiseRes[i] || !par.isFulfilling(promise)) continue;
                    promiseRes[i] = true;
                    --cnt;
                }
                if (cnt <= 0) continue block0;
                long nextState1 = 0L;
                long nextState2 = 0L;
                int nextTidx1 = 0;
                int nextTidx2 = 0;
                int tloc1 = -1;
                int tloc2 = -1;
                int[] nodes1 = null;
                int[] nodes2 = null;
                boolean hasUnvisitedSucc = false;
                int cnt1 = cnt;
                int succCnt = curNode.succSize();
                for (int i2 = 0; i2 < succCnt; ++i2) {
                    long nextState = curNode.getStateFP(i2);
                    int nextTidx = curNode.getTidx(i2);
                    nodes = nodeTbl.getNodes(nextState);
                    if (nodes != null) {
                        tloc = nodeTbl.getIdx(nodes, nextTidx);
                        if (tloc == -1 || !curNode.getCheckAction(slen, alen, i2, eaaction)) continue;
                        nextState1 = nextState;
                        nextTidx1 = nextTidx;
                        tloc1 = tloc;
                        nodes1 = nodes;
                        for (int j = 0; j < this.pem.AEAction.length; ++j) {
                            int idx = this.pem.AEAction[j];
                            if (AEActionRes[j] || !curNode.getCheckAction(slen, alen, i2, idx)) continue;
                            AEActionRes[j] = true;
                            --cnt;
                        }
                    }
                    if (cnt < cnt1) {
                        cycleStack.pushInt(curNode.tindex);
                        cycleStack.pushLong(curNode.stateFP);
                        long nextPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes, tloc));
                        curNode = this.dg.getNode(nextState, nextTidx, nextPtr);
                        nodeTbl.resetElems();
                        continue block0;
                    }
                    if (nodes == null || tloc == -1 || TableauNodePtrTable.isSeen(nodes, tloc)) continue;
                    hasUnvisitedSucc = true;
                    nextState2 = nextState;
                    nextTidx2 = nextTidx;
                    tloc2 = tloc;
                    nodes2 = nodes;
                }
                if (cnt < cnt0) {
                    cycleStack.pushInt(curNode.tindex);
                    cycleStack.pushLong(curNode.stateFP);
                    long nextPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes1, tloc1));
                    curNode = this.dg.getNode(nextState1, nextTidx1, nextPtr);
                    nodeTbl.resetElems();
                    continue block0;
                }
                block6: while (!hasUnvisitedSucc) {
                    long curState = cycleStack.popLong();
                    int curTidx = cycleStack.popInt();
                    long curPtr = TableauNodePtrTable.getPtr(nodeTbl.get(curState, curTidx));
                    curNode = this.dg.getNode(curState, curTidx, curPtr);
                    succCnt = curNode.succSize();
                    for (int i3 = 0; i3 < succCnt; ++i3) {
                        nextState2 = curNode.getStateFP(i3);
                        nextTidx2 = curNode.getTidx(i3);
                        nodes2 = nodeTbl.getNodes(nextState2);
                        if (nodes2 == null || (tloc2 = nodeTbl.getIdx(nodes2, nextTidx2)) == -1 || TableauNodePtrTable.isSeen(nodes2, tloc2)) continue;
                        hasUnvisitedSucc = true;
                        continue block6;
                    }
                }
                cycleStack.pushInt(curNode.tindex);
                cycleStack.pushLong(curNode.stateFP);
                long nextPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes2, tloc2));
                curNode = this.dg.getNode(nextState2, nextTidx2, nextPtr);
                TableauNodePtrTable.setSeen(nodes2, tloc2);
            }
        }
        nodeTbl.resetElems();
        return curNode;
    }

    @Override
    public final Boolean call() throws IOException, InterruptedException, ExecutionException {
        ILiveChecker checker;
        while ((checker = (ILiveChecker)this.queue.poll()) != null && !LiveWorker.hasErrFound()) {
            this.oos = checker.getSolution();
            this.dg = checker.getDiskGraph();
            this.dg.createCache();
            PossibleErrorModel[] pems = this.oos.getPems();
            for (int i = 0; i < pems.length; ++i) {
                if (LiveWorker.hasErrFound()) continue;
                this.pem = pems[i];
                this.checkSccs(this.tool);
            }
            this.dg.destroyCache();
            this.dg.recordSize();
            assert (this.dg.checkInvariants(this.oos.getCheckState().length, this.oos.getCheckAction().length));
        }
        return LiveWorker.hasErrFound(this.id);
    }

    public String toDotViz(long state, int tidx, TableauNodePtrTable tnpt) throws IOException {
        StringBuffer sb = new StringBuffer(tnpt.size() * 10);
        sb.append("digraph TableauNodePtrTable {\n");
        sb.append("nodesep = 0.7\n");
        sb.append("rankdir=LR;\n");
        int tsz = tnpt.getSize();
        for (int ci = 0; ci < tsz; ++ci) {
            int[] nodes = tnpt.getNodesByLoc(ci);
            if (nodes == null) continue;
            long state1 = TableauNodePtrTable.getKey(nodes);
            for (int nidx = 2; nidx < nodes.length; nidx += tnpt.getElemLength()) {
                int tidx1 = TableauNodePtrTable.getTidx(nodes, nidx);
                long loc1 = TableauNodePtrTable.getElem(nodes, nidx);
                GraphNode curNode = this.dg.getNode(state1, tidx1, loc1);
                sb.append(curNode.toDotViz(state1 == state && tidx1 == tidx, true, this.oos.getCheckState().length, this.oos.getCheckAction().length, tnpt));
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public void writeDotViz(long state, int tidx, TableauNodePtrTable tnpt, File file) {
        if (tnpt.size() <= 1) {
            return;
        }
        try {
            BufferedWriter bwr = new BufferedWriter(new FileWriter(file));
            bwr.write(this.toDotViz(state, tidx, tnpt));
            bwr.flush();
            bwr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class DFSStackDetailedFormatter {
        public static String toString(MemIntStack dfsStack) {
            int size = (int)dfsStack.size();
            StringBuffer buf = new StringBuffer(size / 7);
            int i = 0;
            while ((long)i < dfsStack.size()) {
                long topElement = dfsStack.peakLong(size - i - 2);
                if (topElement == -42L) {
                    buf.append("node [");
                    buf.append(" fp: ");
                    buf.append(dfsStack.peakLong(size - i - 5));
                    buf.append(" tidx: ");
                    buf.append(dfsStack.peakInt(size - i - 3));
                    buf.append(" lowLink: ");
                    buf.append(dfsStack.peakLong(size - i - 7) - 0x4000000000000000L);
                    buf.append("]\n");
                    i += 7;
                    continue;
                }
                if (DiskGraph.isFilePointer(topElement)) {
                    long location = topElement;
                    buf.append("succ [");
                    buf.append(" fp: ");
                    buf.append(dfsStack.peakLong(size - i - 5));
                    buf.append(" tidx: ");
                    buf.append(dfsStack.peakInt(size - i - 3));
                    buf.append(" location: ");
                    buf.append(location);
                    buf.append("]\n");
                    i += 5;
                    continue;
                }
                if (topElement < 0x4000000000000000L) continue;
                long pLowLink = topElement - 0x4000000000000000L;
                buf.append("pLowLink: ");
                buf.append(pLowLink);
                buf.append("\n");
                i += 2;
            }
            assert (i == size);
            return buf.toString();
        }
    }

    public static class DetailedFormatter {
        public static String toString(MemIntStack comStack) {
            int size = (int)comStack.size();
            StringBuffer buf = new StringBuffer(size / 5);
            int i = 0;
            while ((long)i < comStack.size()) {
                long loc = comStack.peakLong(size - i - 5);
                int tidx = comStack.peakInt(size - i - 3);
                long state = comStack.peakLong(size - i - 2);
                buf.append("state: ");
                buf.append(state);
                buf.append(" tidx: ");
                buf.append(tidx);
                buf.append(" loc: ");
                buf.append(loc);
                buf.append("\n");
                i += 5;
            }
            return buf.toString();
        }
    }
}

