/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.JUnit4;
import org.junit.runners.model.InitializationError;

public class IsolatedTestCaseRunner
extends Runner {
    private final JUnit4 delegate;

    public IsolatedTestCaseRunner(Class<?> testFileClass) throws InitializationError, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        System.gc();
        ClassLoader classLoader = IsolatedTestCaseRunner.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            classLoader = new IsolatedTestCaseClassLoader((URLClassLoader)classLoader);
        }
        this.delegate = new JUnit4(classLoader.loadClass(testFileClass.getName()));
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier notifier) {
        this.delegate.run(notifier);
    }

    private class IsolatedTestCaseClassLoader
    extends URLClassLoader {
        private final Map<String, Class<?>> cache;
        private final Set<String> packages;

        public IsolatedTestCaseClassLoader(URLClassLoader classLoader) {
            super(classLoader.getURLs());
            this.cache = new HashMap();
            this.packages = new HashSet<String>();
            this.packages.add("tla2sany");
            this.packages.add("pcal");
            this.packages.add("util");
            this.packages.add("tla2tex");
            this.packages.add("tlc2");
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.cache.containsKey(name)) {
                return this.cache.get(name);
            }
            for (String pkg : this.packages) {
                if (!name.startsWith(pkg)) continue;
                Class<?> findClass = this.findClass(name);
                this.cache.put(name, findClass);
                return findClass;
            }
            return super.loadClass(name);
        }
    }
}

