/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import tla2sany.semantic.OpDeclNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Action;
import tlc2.tool.ConcurrentTLCTrace;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.IStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.IWorker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.Worker;
import tlc2.tool.WorkerException;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.impl.CallStackTool;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.queue.DiskByteArrayQueue;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.IStateWriter;
import tlc2.util.SetOfStates;
import tlc2.util.statistics.BucketStatistics;
import util.Assert;
import util.DebugPrinter;
import util.FileUtil;
import util.FilenameToStream;
import util.TLAFlightRecorder;
import util.UniqueString;

public class ModelChecker
extends AbstractChecker {
    protected static final boolean coverage = TLCGlobals.isCoverageEnabled();
    public static final boolean VETO_CLEANUP = Boolean.getBoolean(ModelChecker.class.getName() + ".vetoCleanup");
    private long numberOfInitialStates;
    public FPSet theFPSet;
    public IStateQueue theStateQueue = ModelChecker.useByteArrayQueue() ? new DiskByteArrayQueue(this.metadir) : new DiskStateQueue(this.metadir);
    public final ConcurrentTLCTrace trace = new ConcurrentTLCTrace(this.metadir, this.tool.getRootName(), this.tool);
    public long distinctStatesPerMinute;
    public long statesPerMinute = 0L;
    protected long oldNumOfGenStates;
    protected long oldFPSetSize = 0L;
    private double runtimeRatio = 0.0;
    private boolean forceLiveCheck = false;

    public ModelChecker(ITool tool, String metadir, IStateWriter stateWriter, boolean deadlock, String fromChkpt, Future<FPSet> future, long startTime) throws EvalException, IOException, InterruptedException, ExecutionException {
        this(tool, metadir, stateWriter, deadlock, fromChkpt, startTime);
        this.theFPSet = future.get();
        this.workers = new Worker[TLCGlobals.getNumWorkers()];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.trace.addWorker(new Worker(i, this, this.metadir, this.tool.getRootName()));
        }
    }

    public ModelChecker(ITool tool, String metadir, IStateWriter stateWriter, boolean deadlock, String fromChkpt, FPSetConfiguration fpSetConfig, long startTime) throws EvalException, IOException {
        this(tool, metadir, stateWriter, deadlock, fromChkpt, startTime);
        this.theFPSet = FPSetFactory.getFPSet(fpSetConfig).init(TLCGlobals.getNumWorkers(), metadir, tool.getRootName());
        this.workers = new Worker[TLCGlobals.getNumWorkers()];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.trace.addWorker(new Worker(i, this, this.metadir, this.tool.getRootName()));
        }
    }

    private ModelChecker(ITool tool, String metadir, IStateWriter stateWriter, boolean deadlock, String fromChkpt, long startTime) throws EvalException, IOException {
        super(tool, metadir, stateWriter, deadlock, fromChkpt, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected int modelCheckImpl() throws Exception {
        block36: {
            block35: {
                result = 0;
                this.report("entering modelCheck()");
                recovered = this.recover();
                if (!recovered) {
                    if (this.checkLiveness && this.liveCheck.getNumChecker() == 0) {
                        return MP.printError(2253);
                    }
                    result = this.checkAssumptions();
                    if (result != 0) {
                        return result;
                    }
                    try {
                        this.report("doInit(false)");
                        MP.printMessage(2189);
                        result = this.doInit(false);
                        if (result != 0) {
                            this.report("exiting, because init failed");
                            return result;
                        }
                    }
                    catch (Throwable e) {
                        this.report("exception in init");
                        this.report(e);
                        msg = e.getMessage();
                        if (e instanceof StackOverflowError) {
                            msg = "This was a Java StackOverflowError. It was probably the result\nof an incorrect recursive function definition that caused TLC to enter\nan infinite loop when trying to compute the function or its application\nto an element in its putative domain.";
                        }
                        if (msg == null) {
                            msg = e.toString();
                        }
                        if (this.errState != null) {
                            MP.printError(2102, new String[]{msg, this.errState.toString()});
                        } else {
                            MP.printError(1000, msg);
                        }
                        cTool = new CallStackTool(this.tool);
                        try {
                            this.numberOfInitialStates = 0L;
                            this.doInit(cTool, true);
                        }
                        catch (FingerprintException fe) {
                            result = MP.printError(2147, new String[]{fe.getTrace(), fe.getRootCause().getMessage()});
                        }
                        catch (Throwable e1) {
                            result = MP.printError(2103, cTool.toString());
                        }
                        this.printSummary(false, this.startTime);
                        this.cleanup(false);
                        this.report("exiting, because init failed with exception");
                        return result;
                    }
                    statesGenerated = this.getStatesGenerated();
                    v0 = plural = statesGenerated == 1L ? "" : "s";
                    if (statesGenerated == this.theFPSet.size()) {
                        MP.printMessage(2190, new String[]{String.valueOf(statesGenerated), plural});
                    } else {
                        MP.printMessage(2191, new String[]{String.valueOf(statesGenerated), plural, String.valueOf(this.theFPSet.size())});
                    }
                }
                this.report("init processed");
                if (this.tool.getActions().length == 0) {
                    if (this.theStateQueue.isEmpty()) {
                        ModelChecker.reportSuccess(this.theFPSet, this.getStatesGenerated());
                        this.printSummary(true, this.startTime);
                    } else {
                        result = MP.printError(2115);
                    }
                    this.cleanup(true);
                    this.report("exiting with actions.length == 0");
                    return result;
                }
                result = 1000;
                this.report("running TLC");
                result = this.runTLC(0x7FFFFFFF);
                if (result == 0) break block35;
                this.report("TLC terminated with error");
                statesGenerated = result;
                success = result == 0;
                this.printSummary(success, this.startTime);
                if (this.checkLiveness && ModelChecker.LIVENESS_STATS) {
                    System.gc();
                    MP.printStats(this.liveCheck.calculateInDegreeDiskGraphs(new BucketStatistics("Histogram vertex in-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsInDegree")), this.liveCheck.getOutDegreeStatistics());
                }
                this.cleanup(success);
                this.report("exiting modelCheck()");
                return statesGenerated;
            }
            if (this.errState != null) ** GOTO lbl103
            if (!this.checkLiveness) break block36;
            MP.printMessage(2200, new String[]{String.valueOf(this.trace.getLevelForReporting()), MP.format(this.getStatesGenerated()), MP.format(this.theFPSet.size()), MP.format(this.theStateQueue.size())});
            this.report("checking liveness");
            result = this.liveCheck.finalCheck(this.tool);
            this.report("liveness check complete");
            if (result == 0) break block36;
            this.report("exiting error status on liveness check");
            statesGenerated = result;
            success = result == 0;
            this.printSummary(success, this.startTime);
            if (this.checkLiveness && ModelChecker.LIVENESS_STATS) {
                System.gc();
                MP.printStats(this.liveCheck.calculateInDegreeDiskGraphs(new BucketStatistics("Histogram vertex in-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsInDegree")), this.liveCheck.getOutDegreeStatistics());
            }
            this.cleanup(success);
            this.report("exiting modelCheck()");
            return statesGenerated;
        }
        try {
            block38: {
                result = 0;
                ModelChecker.reportSuccess(this.theFPSet, this.getStatesGenerated());
                break block38;
lbl103:
                // 1 sources

                if (this.keepCallStack) {
                    cTool = new CallStackTool(this.tool);
                    try {
                        this.doNext(cTool, this.predErrState, this.checkLiveness != false ? new SetOfStates() : null, new Worker(4223, this, this.metadir, this.tool.getRootName()));
                    }
                    catch (FingerprintException e) {
                        result = MP.printError(2147, new String[]{e.getTrace(), e.getRootCause().getMessage()});
                    }
                    catch (EvalException e) {
                        MP.printError(2103, cTool.toString());
                        result = e.getErrorCode();
                    }
                    catch (Throwable e) {
                        result = MP.printError(2103, cTool.toString());
                    }
                }
            }
            success = result == 0;
        }
        catch (Exception e) {
            try {
                this.report("TLC terminated with error");
                result = MP.printError(1000, e);
                success = result == 0;
            }
            catch (Throwable var7_21) {
                success = result == 0;
                this.printSummary(success, this.startTime);
                if (this.checkLiveness && ModelChecker.LIVENESS_STATS) {
                    System.gc();
                    MP.printStats(this.liveCheck.calculateInDegreeDiskGraphs(new BucketStatistics("Histogram vertex in-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsInDegree")), this.liveCheck.getOutDegreeStatistics());
                }
                this.cleanup(success);
                this.report("exiting modelCheck()");
                throw var7_21;
            }
            this.printSummary(success, this.startTime);
            if (this.checkLiveness && ModelChecker.LIVENESS_STATS) {
                System.gc();
                MP.printStats(this.liveCheck.calculateInDegreeDiskGraphs(new BucketStatistics("Histogram vertex in-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsInDegree")), this.liveCheck.getOutDegreeStatistics());
            }
            this.cleanup(success);
            this.report("exiting modelCheck()");
        }
        this.printSummary(success, this.startTime);
        if (this.checkLiveness && ModelChecker.LIVENESS_STATS) {
            System.gc();
            MP.printStats(this.liveCheck.calculateInDegreeDiskGraphs(new BucketStatistics("Histogram vertex in-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsInDegree")), this.liveCheck.getOutDegreeStatistics());
        }
        this.cleanup(success);
        this.report("exiting modelCheck()");
        return result;
    }

    public int checkAssumptions() {
        return this.tool.checkAssumptions();
    }

    @Override
    public final int doInit(boolean ignoreCancel) throws Throwable {
        return this.doInit(this.tool, ignoreCancel);
    }

    private final int doInit(ITool tool, boolean ignoreCancel) throws Throwable {
        DoInitFunctor functor = ignoreCancel ? new DoInitFunctor(tool, ignoreCancel) : new DoInitFunctor(tool);
        try {
            tool.getInitStates(functor);
        }
        catch (DoInitFunctor.InvariantViolatedException ive) {
            this.errState = functor.errState;
            return functor.returnValue;
        }
        catch (Assert.TLCRuntimeException e) {
            this.errState = functor.errState;
            throw e;
        }
        if (functor.errState != null) {
            this.errState = functor.errState;
            if (functor.e != null) {
                throw functor.e;
            }
        }
        return functor.returnValue;
    }

    private final boolean doNext(ITool tool, TLCState curState, SetOfStates liveNextStates, Worker worker) throws Throwable {
        boolean deadLocked = true;
        TLCState succState = null;
        try {
            for (int i = 0; i < tool.getActions().length; ++i) {
                Action action = tool.getActions()[i];
                StateVec nextStates = tool.getNextStates(action, curState);
                int sz = nextStates.size();
                worker.incrementStatesGenerated(sz);
                deadLocked = deadLocked && sz == 0;
                for (int j = 0; j < sz; ++j) {
                    succState = nextStates.elementAt(j);
                    if (!tool.isGoodState(succState)) {
                        return this.doNextSetErr(curState, succState, action);
                    }
                    boolean inModel = tool.isInModel(succState) && tool.isInActions(curState, succState);
                    boolean unseen = true;
                    if (inModel) {
                        boolean bl = unseen = !this.isSeenState(curState, succState, action, worker, liveNextStates);
                    }
                    if (unseen && this.doNextCheckInvariants(tool, curState, succState)) {
                        return true;
                    }
                    if (this.doNextCheckImplied(tool, curState, succState)) {
                        return true;
                    }
                    if (!inModel || !unseen) continue;
                    this.theStateQueue.sEnqueue(succState);
                }
                succState = null;
            }
            if (deadLocked && this.checkDeadlock) {
                return this.doNextSetErr(curState, null, false, 2114, null);
            }
            return false;
        }
        catch (Throwable e) {
            this.doNextFailed(curState, succState, e);
            throw e;
        }
    }

    private final boolean isSeenState(TLCState curState, TLCState succState, Action action, Worker worker, SetOfStates liveNextStates) throws IOException {
        long fp = succState.fingerPrint();
        boolean seen = this.theFPSet.put(fp);
        this.allStateWriter.writeState(curState, succState, !seen, action);
        if (!seen) {
            worker.writeState(curState, fp, succState);
            if (coverage) {
                action.cm.incSecondary();
            }
        }
        if (this.checkLiveness) {
            liveNextStates.put(fp, succState);
        }
        return seen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doNextCheckInvariants(ITool tool, TLCState curState, TLCState succState) throws IOException, WorkerException, Exception {
        int k = 0;
        try {
            for (k = 0; k < tool.getInvariants().length; ++k) {
                if (tool.isValid(tool.getInvariants()[k], succState)) continue;
                if (TLCGlobals.continuation) {
                    ModelChecker modelChecker = this;
                    synchronized (modelChecker) {
                        MP.printError(2110, tool.getInvNames()[k]);
                        this.trace.printTrace(curState, succState);
                        return false;
                    }
                }
                return this.doNextSetErr(curState, succState, false, 2110, tool.getInvNames()[k]);
            }
        }
        catch (Exception e) {
            this.doNextEvalFailed(curState, succState, 2111, tool.getInvNames()[k], e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doNextCheckImplied(ITool tool, TLCState curState, TLCState succState) throws IOException, WorkerException, Exception {
        int k = 0;
        try {
            for (k = 0; k < tool.getImpliedActions().length; ++k) {
                if (tool.isValid(tool.getImpliedActions()[k], curState, succState)) continue;
                if (TLCGlobals.continuation) {
                    ModelChecker modelChecker = this;
                    synchronized (modelChecker) {
                        MP.printError(2112, tool.getImpliedActNames()[k]);
                        this.trace.printTrace(curState, succState);
                        return false;
                    }
                }
                return this.doNextSetErr(curState, succState, false, 2112, tool.getImpliedActNames()[k]);
            }
        }
        catch (Exception e) {
            this.doNextEvalFailed(curState, succState, 2113, tool.getImpliedActNames()[k], e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean doNextSetErr(TLCState curState, TLCState succState, boolean keep, int ec, String param) throws IOException, WorkerException {
        ModelChecker modelChecker = this;
        synchronized (modelChecker) {
            if (this.setErrState(curState, succState, keep, ec)) {
                if (param == null) {
                    MP.printError(ec);
                } else {
                    MP.printError(ec, param);
                }
                this.trace.printTrace(curState, succState);
                this.theStateQueue.finishAll();
                this.notify();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean doNextSetErr(TLCState curState, TLCState succState, Action action) throws IOException, WorkerException {
        ModelChecker modelChecker = this;
        synchronized (modelChecker) {
            int errorCode = 2109;
            if (this.setErrState(curState, succState, false, 2109)) {
                Set<OpDeclNode> unassigned = succState.getUnassigned();
                if (this.tool.getActions().length == 1) {
                    MP.printError(2109, new String[]{unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))});
                } else {
                    MP.printError(2109, new String[]{action.getName().toString(), unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))});
                }
                this.trace.printTrace(curState, succState);
                this.theStateQueue.finishAll();
                this.notify();
            }
            return true;
        }
    }

    final void doNextEvalFailed(TLCState curState, TLCState succState, int ec, String param, Exception e) throws IOException, WorkerException, Exception {
        ModelChecker modelChecker = this;
        synchronized (modelChecker) {
            if (this.setErrState(curState, succState, true, ec)) {
                MP.printError(ec, new String[]{param, e.getMessage() == null ? e.toString() : e.getMessage()});
                this.trace.printTrace(curState, succState);
                this.theStateQueue.finishAll();
                this.notify();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doNextFailed(TLCState curState, TLCState succState, Throwable e) throws IOException, WorkerException, Throwable {
        boolean keep = e instanceof StackOverflowError || e instanceof OutOfMemoryError || e instanceof AssertionError;
        ModelChecker modelChecker = this;
        synchronized (modelChecker) {
            int ec = e instanceof StackOverflowError ? 1005 : (e instanceof OutOfMemoryError ? 1001 : (e instanceof AssertionError ? 2128 : (e instanceof EvalException ? ((EvalException)e).getErrorCode() : 1000)));
            if (this.setErrState(curState, succState, !keep, ec)) {
                if (ec != 1000 || e.getMessage() != null) {
                    if (e instanceof EvalException && ((EvalException)e).hasParameters()) {
                        MP.printError(ec, ((EvalException)e).getParameters(), e);
                    } else {
                        MP.printError(ec, e);
                    }
                }
                this.trace.printTrace(curState, succState);
                this.theStateQueue.finishAll();
                this.notify();
            }
        }
    }

    @Override
    public final int doPeriodicWork() throws Exception {
        boolean createCheckPoint = TLCGlobals.doCheckPoint();
        if (!(this.checkLiveness && !(this.runtimeRatio > TLCGlobals.livenessRatio) && this.liveCheck.doLiveCheck() || this.forceLiveCheck || createCheckPoint)) {
            this.updateRuntimeRatio(0L);
            return 0;
        }
        if (this.theStateQueue.suspendAll()) {
            if (this.checkLiveness && (this.runtimeRatio < TLCGlobals.livenessRatio || this.forceLiveCheck)) {
                long preLivenessChecking = System.currentTimeMillis();
                int result = this.liveCheck.check(this.tool, this.forceLiveCheck);
                if (result != 0) {
                    return result;
                }
                this.forceLiveCheck = false;
                this.updateRuntimeRatio(System.currentTimeMillis() - preLivenessChecking);
            } else if (this.runtimeRatio > TLCGlobals.livenessRatio) {
                this.updateRuntimeRatio(0L);
            }
            if (createCheckPoint) {
                this.checkpoint();
            } else {
                this.theStateQueue.resumeAll();
            }
        }
        return 0;
    }

    protected void checkpoint() throws IOException {
        MP.printMessage(2195, this.metadir);
        this.theStateQueue.beginChkpt();
        this.trace.beginChkpt();
        this.theFPSet.beginChkpt();
        this.theStateQueue.resumeAll();
        UniqueString.internTbl.beginChkpt(this.metadir);
        if (this.checkLiveness) {
            this.liveCheck.beginChkpt();
        }
        this.theStateQueue.commitChkpt();
        this.trace.commitChkpt();
        this.theFPSet.commitChkpt();
        UniqueString.internTbl.commitChkpt(this.metadir);
        if (this.checkLiveness) {
            this.liveCheck.commitChkpt();
        }
        MP.printMessage(2196);
    }

    public void forceLiveCheck() {
        this.forceLiveCheck = true;
    }

    protected void updateRuntimeRatio(long delta) {
        assert (delta >= 0L);
        long totalRuntime = System.currentTimeMillis() - this.startTime;
        totalRuntime -= 60000L;
        double absLivenessRuntime = Math.max((double)(totalRuntime -= delta) * this.runtimeRatio, 0.0);
        this.runtimeRatio = ((double)delta + absLivenessRuntime) / (double)(totalRuntime + 60000L + delta);
    }

    public double getRuntimeRatio() {
        return this.runtimeRatio;
    }

    public final boolean recover() throws IOException {
        boolean recovered = false;
        if (this.fromChkpt != null) {
            MP.printMessage(2197, this.fromChkpt);
            this.trace.recover();
            this.theStateQueue.recover();
            this.theFPSet.recover(this.trace);
            if (this.checkLiveness) {
                this.tool.getInitStates(new IStateFunctor(){

                    @Override
                    public Object addElement(TLCState state) {
                        ModelChecker.this.liveCheck.addInitState(ModelChecker.this.tool, state, state.fingerPrint());
                        return true;
                    }
                });
                this.liveCheck.recover();
            }
            MP.printMessage(2198, String.valueOf(this.theFPSet.size()), String.valueOf(this.theStateQueue.size()));
            recovered = true;
            this.numberOfInitialStates = this.theFPSet.size();
        }
        return recovered;
    }

    private final void cleanup(boolean success) throws IOException {
        boolean vetoCleanup = VETO_CLEANUP;
        if (TLCGlobals.chkptExplicitlyEnabled() && !this.theStateQueue.isEmpty() && (this.errState != null || this.isTimeBound())) {
            this.checkpoint();
            vetoCleanup = true;
        }
        this.theFPSet.close();
        this.trace.close();
        if (this.checkLiveness) {
            this.liveCheck.close();
        }
        this.allStateWriter.close();
        if (!vetoCleanup) {
            FileUtil.deleteDir(this.metadir, success);
        }
    }

    public final void printSummary(boolean success) throws IOException {
        this.printSummary(success, this.startTime);
    }

    public final void printSummary(boolean success, long startTime) throws IOException {
        super.reportCoverage(this.workers);
        if (TLCGlobals.tool) {
            this.printProgresStats(startTime, true);
        }
        MP.printMessage(2199, String.valueOf(this.getStatesGenerated()), String.valueOf(this.theFPSet.size()), String.valueOf(this.theStateQueue.size()));
        MP.printMessage(2194, String.valueOf(this.trace.getLevelForReporting()));
        if (success) {
            BucketStatistics aggOutDegree = new BucketStatistics("State Graph OutDegree");
            for (IWorker worker : this.workers) {
                aggOutDegree.add(((Worker)worker).getOutDegree());
            }
            if (aggOutDegree.getObservations() > 0L) {
                MP.printMessage(2268, Integer.toString(aggOutDegree.getMin()), Long.toString(Math.round(aggOutDegree.getMean())), Long.toString(Math.round(aggOutDegree.getPercentile(0.95))), Integer.toString(aggOutDegree.getMax()));
            }
        }
    }

    private final void printProgresStats(long startTime, boolean isFinal) throws IOException {
        double factor;
        long fpSetSize = this.theFPSet.size();
        if (startTime < 0L) {
            factor = 1.0;
        } else {
            this.oldNumOfGenStates = 0L;
            this.oldFPSetSize = 0L;
            factor = (double)(System.currentTimeMillis() - startTime) / 60000.0;
        }
        long l = this.getStatesGenerated();
        this.statesPerMinute = (long)((double)(l - this.oldNumOfGenStates) / factor);
        this.oldNumOfGenStates = l;
        this.distinctStatesPerMinute = (long)((double)(fpSetSize - this.oldFPSetSize) / factor);
        this.oldFPSetSize = fpSetSize;
        MP.printMessage(2200, String.valueOf(this.trace.getLevelForReporting()), MP.format(l), MP.format(fpSetSize), MP.format(this.theStateQueue.size()), MP.format(this.statesPerMinute), MP.format(this.distinctStatesPerMinute));
        TLAFlightRecorder.progress(isFinal, this.trace.getLevelForReporting(), l, fpSetSize, this.theStateQueue.size(), this.statesPerMinute, this.distinctStatesPerMinute);
    }

    public static final void reportSuccess(FPSet anFpSet, long numOfGenStates) throws IOException {
        long numOfDistinctStates = anFpSet.size();
        double optimisticProb = ModelChecker.calculateOptimisticProbability(numOfDistinctStates, numOfGenStates);
        if (optimisticProb < 1.0E-10) {
            ModelChecker.reportSuccess(numOfDistinctStates, numOfGenStates);
        } else {
            ModelChecker.reportSuccess(numOfDistinctStates, anFpSet.checkFPs(), numOfGenStates);
        }
    }

    @Override
    protected IWorker[] startWorkers(AbstractChecker checker, int checkIndex) {
        this.theFPSet.incWorkers(this.workers.length);
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].start();
        }
        return this.workers;
    }

    @Override
    protected void runTLCContinueDoing(int count, int depth) throws Exception {
        int level = this.trace.getLevel();
        this.printProgresStats(-1L, false);
        if (level > depth) {
            this.theStateQueue.finishAll();
            this.done = true;
        } else {
            if (count == 0) {
                super.reportCoverage(this.workers);
            }
            this.wait(60000L);
        }
    }

    private void report(Throwable e) {
        DebugPrinter.print(e);
    }

    private static boolean useByteArrayQueue() {
        return Boolean.getBoolean(ModelChecker.class.getName() + ".BAQueue");
    }

    public static String getStateQueueName() {
        return ModelChecker.useByteArrayQueue() ? "DiskByteArrayQueue" : "DiskStateQueue";
    }

    @Override
    public long getStatesGenerated() {
        long sum = this.numberOfInitialStates;
        for (IWorker worker : this.workers) {
            sum += ((Worker)worker).getStatesGenerated();
        }
        return sum;
    }

    @Override
    public int getProgress() {
        try {
            return this.trace.getLevelForReporting();
        }
        catch (IOException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ModelChecker modelChecker = this;
        synchronized (modelChecker) {
            this.setDone();
            this.theStateQueue.finishAll();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        ModelChecker modelChecker = this;
        synchronized (modelChecker) {
            this.theStateQueue.suspendAll();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        ModelChecker modelChecker = this;
        synchronized (modelChecker) {
            this.theStateQueue.resumeAll();
            this.notifyAll();
        }
    }

    @Override
    public TLCStateInfo[] getTraceInfo(TLCState s) throws IOException {
        return this.trace.getTrace(s);
    }

    @Override
    public TLCStateInfo[] getTraceInfo(TLCState from, TLCState to) throws IOException {
        return this.trace.getTrace(from, to);
    }

    @Override
    public long getStateQueueSize() {
        return this.theStateQueue.size();
    }

    @Override
    public long getDistinctStatesGenerated() {
        return this.theFPSet.size();
    }

    public List<File> getModuleFiles(FilenameToStream resolver) {
        return this.tool.getModuleFiles(resolver);
    }

    private class DoInitFunctor
    implements IStateFunctor {
        private TLCState errState;
        private Throwable e;
        private int returnValue = 0;
        private final boolean forceChecks;
        private final ITool tool;

        public DoInitFunctor(ITool tool) {
            this(tool, false);
        }

        public DoInitFunctor(ITool tool, boolean forceChecks) {
            this.forceChecks = forceChecks;
            this.tool = tool;
        }

        @Override
        public Object addElement(TLCState curState) {
            if (Long.bitCount(ModelChecker.this.numberOfInitialStates) == 1 && ModelChecker.this.numberOfInitialStates > 1L) {
                MP.printMessage(2269, Long.toString(ModelChecker.this.numberOfInitialStates));
            }
            ModelChecker.this.numberOfInitialStates++;
            if (this.errState != null) {
                if (this.returnValue == 0) {
                    this.returnValue = 2102;
                }
                return this.returnValue;
            }
            try {
                long fp;
                if (!this.tool.isGoodState(curState)) {
                    MP.printError(2102, new String[]{"current state is not a legal state", curState.toString()});
                    this.errState = curState;
                    this.returnValue = 2102;
                    throw new InvariantViolatedException();
                }
                boolean inModel = this.tool.isInModel(curState);
                boolean seen = false;
                if (inModel && !(seen = ModelChecker.this.theFPSet.put(fp = curState.fingerPrint()))) {
                    ModelChecker.this.allStateWriter.writeState(curState);
                    ((Worker)ModelChecker.this.workers[0]).writeState(curState, fp);
                    ModelChecker.this.theStateQueue.enqueue(curState);
                    if (ModelChecker.this.checkLiveness) {
                        ModelChecker.this.liveCheck.addInitState(this.tool, curState, fp);
                    }
                }
                if (!seen || this.forceChecks) {
                    int j;
                    for (j = 0; j < this.tool.getInvariants().length; ++j) {
                        if (this.tool.isValid(this.tool.getInvariants()[j], curState)) continue;
                        MP.printError(2107, new String[]{this.tool.getInvNames()[j].toString(), curState.toString()});
                        if (TLCGlobals.continuation) continue;
                        this.errState = curState;
                        this.returnValue = 2107;
                        throw new InvariantViolatedException();
                    }
                    for (j = 0; j < this.tool.getImpliedInits().length; ++j) {
                        if (this.tool.isValid(this.tool.getImpliedInits()[j], curState)) continue;
                        MP.printError(2108, new String[]{this.tool.getImpliedInitNames()[j], curState.toString()});
                        this.errState = curState;
                        this.returnValue = 2108;
                        throw new InvariantViolatedException();
                    }
                }
            }
            catch (EvalException | InvariantViolatedException | Assert.TLCRuntimeException e) {
                this.errState = curState;
                this.e = e;
                throw e;
            }
            catch (OutOfMemoryError e) {
                MP.printError(1002);
                this.returnValue = 1002;
                return this.returnValue;
            }
            catch (Throwable e) {
                this.errState = curState;
                this.e = e;
            }
            return this.returnValue;
        }

        public class InvariantViolatedException
        extends RuntimeException {
        }
    }
}

