/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import util.Assert;

public class MCVariable {
    private final String name;
    private final String valueAsString;
    private String traceExpression;

    public MCVariable(String varName, String value) {
        Assert.check(varName != null, 1000);
        this.name = varName;
        Assert.check(value != null, 1000);
        this.valueAsString = value;
        this.traceExpression = null;
    }

    public String getName() {
        return this.name;
    }

    public String getSingleLineDisplayName() {
        String s = this.isTraceExplorerExpression() ? this.traceExpression : this.name;
        return s.replaceAll("\\n", "").replaceAll("\\r", "");
    }

    public String getValueAsString() {
        return this.valueAsString;
    }

    public String getValueAsStringReIndentedAs(String indent) {
        String[] split = this.valueAsString.split("(\\r\\n|\\r|\\n)");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            sb.append(indent).append(split[i]);
            if (i >= split.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean isTraceExplorerExpression() {
        return this.traceExpression != null;
    }

    public void setTraceExpression(String expression) {
        this.traceExpression = expression;
    }

    public String getTraceExpression() {
        return this.traceExpression;
    }
}

