/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import tla2tex.BuiltInSymbols;
import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.FindAlignments;
import tla2tex.FormatComments;
import tla2tex.LaTeXOutput;
import tla2tex.Misc;
import tla2tex.OutputFileWriter;
import tla2tex.Parameters;
import tla2tex.ResourceFileReader;
import tla2tex.TLA2TexException;
import tla2tex.Token;
import tla2tex.TokenizeSpec;
import tla2tex.VectorCharReader;
import util.ToolIO;

class TeX {
    static final String lastModified = "last modified on Wed 12 Apr 2013 at 16:08:49 PST by lamport";
    static String modDate = "last modified on Wed 12 Apr 2013 at 16:08:49 PST by lamport".substring(21, 33);
    static String version = "tla2tex.TeX Version 1.0 created " + modDate;
    private static long start = Debug.now();

    TeX() {
    }

    public static void main(String[] args) {
        long startTime = Debug.now();
        ToolIO.out.println(version);
        TeX.GetArguments(args);
        TeX.Starting("BuiltInSymbols.Initialize");
        BuiltInSymbols.Initialize();
        TeX.Finished("BuiltInSymbols.Initialize");
        TeX.Starting("FormatComments.Initialize");
        FormatComments.Initialize();
        TeX.Finished("FormatComments.Initialize");
        float[] lineWidths = TeX.ReadLogFile();
        BufferedReader infile = null;
        try {
            infile = new BufferedReader(new FileReader(Parameters.TLAInputFile));
        }
        catch (Exception e) {
            Debug.ReportError("Can't open input file " + Parameters.TLAInputFile);
        }
        OutputFileWriter outfile = null;
        try {
            outfile = new OutputFileWriter(Parameters.LaTeXOutputFile + ".new");
        }
        catch (Exception e) {
            Debug.ReportError("Can't open output file " + Parameters.LaTeXOutputFile + ".new");
        }
        int lineNum = 0;
        Vector<String> preamble = new Vector<String>(200);
        String line = "";
        try {
            line = infile.readLine();
            while (line != null && line.indexOf("\\begin{document}") == -1) {
                ++lineNum;
                outfile.putLine(line);
                preamble.addElement(line);
                line = infile.readLine();
            }
        }
        catch (Exception e) {
            Debug.ReportError("I/O error: " + e.getMessage());
        }
        if (line == null) {
            Debug.ReportError("Input file has no \\begin{document}");
        }
        ++lineNum;
        outfile.putLine(line);
        int begindocPos = line.indexOf("\\begin{document}");
        if (begindocPos != 0) {
            preamble.addElement(line.substring(0, begindocPos));
        }
        try {
            line = infile.readLine();
            int envNum = 0;
            while (line != null) {
                ++lineNum;
                outfile.putLine(line);
                int mode = -1;
                String envName = "";
                if (line.indexOf("\\begin{tla}") != -1) {
                    mode = 2;
                    envName = "tla";
                } else if (line.indexOf("\\begin{pcal}") != -1) {
                    mode = 3;
                    envName = "pcal";
                } else if (line.indexOf("\\begin{ppcal}") != -1) {
                    mode = 4;
                    envName = "ppcal";
                }
                if (mode != -1) {
                    TeX.Starting(envName + " environment number " + (envNum + 1) + " on line " + (lineNum + 1));
                    Vector<String> tla = new Vector<String>(100);
                    int tlaLineNum = lineNum;
                    line = infile.readLine();
                    while (line != null && line.indexOf("\\end{" + envName + "}") == -1) {
                        ++lineNum;
                        outfile.putLine(line);
                        tla.addElement(line);
                        line = infile.readLine();
                    }
                    if (line == null) {
                        Debug.ReportError("Unmatched \\begin{" + envName + "} on line " + (tlaLineNum + 1));
                    }
                    ++lineNum;
                    outfile.putLine(line);
                    line = infile.readLine();
                    if (line == null) {
                        Debug.ReportError("Missing \\end{document}");
                    }
                    if (line.indexOf("\\begin{tlatex}") != -1) {
                        ++lineNum;
                        line = infile.readLine();
                        while (line != null && line.indexOf("\\end{tlatex}") == -1) {
                            ++lineNum;
                            line = infile.readLine();
                        }
                        if (line == null) {
                            Debug.ReportError("Unmatched \\begin{tlatex} on line " + (tlaLineNum + tla.size() + 2));
                        }
                        ++lineNum;
                        line = infile.readLine();
                    }
                    VectorCharReader tlaRdr = new VectorCharReader(tla, tlaLineNum);
                    Token[][] spec2 = TokenizeSpec.Tokenize(tlaRdr, mode);
                    Token.FindPfStepTokens(spec2);
                    TokenizeSpec.FixPlusCal(spec2, true);
                    CommentToken.ProcessComments(spec2);
                    FindAlignments.FindAlignments(spec2);
                    float linewidth = -1.0f;
                    if (envNum < lineWidths.length) {
                        linewidth = lineWidths[envNum];
                    } else if (envNum == lineWidths.length) {
                        ToolIO.out.println("More tla/pcal/ppcal environments than the last time file\n    run through LaTeX");
                    }
                    Parameters.LaTeXtextwidth = (int)linewidth;
                    LaTeXOutput.WriteTeXAlignmentFile(spec2, preamble, linewidth);
                    TeX.Starting("to LaTeX alignment file.");
                    LaTeXOutput.RunLaTeX(Parameters.LaTeXAlignmentFile);
                    TeX.Finished("LaTeXing alignment file");
                    LaTeXOutput.SetDimensions(spec2);
                    LaTeXOutput.WriteTLATeXEnvironment(spec2, outfile);
                    TeX.Finished("tla/pcal/ppcal environment number " + (envNum + 1));
                    ++envNum;
                    continue;
                }
                line = infile.readLine();
            }
            if (envNum < lineWidths.length) {
                ToolIO.out.println("Fewer tla/pcal/ppcal environments than the last time file\n    run through LaTeX");
            }
            infile.close();
            outfile.close();
            File iFile = new File(Parameters.LaTeXOutputFile + ".tex");
            File oFile = new File(Parameters.LaTeXOutputFile + ".new");
            new File(Parameters.LaTeXOutputFile + ".old").delete();
            if (!iFile.renameTo(new File(Parameters.LaTeXOutputFile + ".old")) || !oFile.renameTo(new File(Parameters.LaTeXOutputFile + ".tex"))) {
                Debug.ReportError("Error while renaming files");
            }
        }
        catch (Exception e) {
            Debug.ReportError("I/O error: " + e.getMessage());
        }
        Debug.printElapsedTime(startTime, "Total execution time:");
    }

    private static void GetArguments(String[] args) {
        boolean outOption = false;
        boolean alignOutOption = false;
        boolean psOption = false;
        boolean nopsOption = false;
        int nextArg = 0;
        int maxArg = args.length - 1;
        if (maxArg < 0) {
            TeX.CommandLineError("No arguments specified");
        }
        if (args[maxArg].length() != 0 && args[maxArg].charAt(0) == '-') {
            ++maxArg;
        }
        while (nextArg < maxArg) {
            String option = args[nextArg];
            if (option.equals("-help")) {
                TeX.OutputMessageFile("texhelp.txt");
                System.exit(0);
            } else if (option.equals("-info")) {
                TeX.OutputMessageFile("texinfo.txt");
                System.exit(0);
            } else if (option.equals("-latexCommand")) {
                if (++nextArg >= args.length) {
                    TeX.CommandLineError("No input file specified");
                }
                Parameters.LaTeXCommand = args[nextArg];
            } else if (option.equals("-out")) {
                outOption = true;
                if (++nextArg >= args.length) {
                    TeX.CommandLineError("No input file specified");
                }
                if (TeX.HasPathPrefix(Parameters.LaTeXOutputFile = TeX.RemoveExtension(args[nextArg]))) {
                    TeX.CommandLineError("-out file contains a path specifier.\nIt must be a file in the current directory.");
                }
            } else if (option.equals("-alignOut")) {
                alignOutOption = true;
                if (++nextArg >= args.length) {
                    TeX.CommandLineError("No input file specified");
                }
                if (TeX.HasPathPrefix(Parameters.LaTeXAlignmentFile = TeX.RemoveExtension(args[nextArg]))) {
                    TeX.CommandLineError("-alignOut file contains a path specifier.\nIt must be a file in the current directory.");
                }
            } else if (option.equals("-debug")) {
                Parameters.Debug = true;
            } else {
                TeX.CommandLineError("Unknown option: " + option);
            }
            ++nextArg;
        }
        if (nextArg > maxArg) {
            TeX.CommandLineError("No input file specified");
        }
        Parameters.TLAInputFile = args[maxArg].indexOf(".") == -1 ? args[maxArg] + ".tex" : args[maxArg];
        if (!outOption) {
            Parameters.LaTeXOutputFile = TeX.RemoveExtension(TeX.RemovePathPrefix(Parameters.TLAInputFile));
            if (TeX.HasPathPrefix(Parameters.TLAInputFile)) {
                ToolIO.out.println("Warning: Output file being written to a different directory\n         than input file.");
            }
        }
        if (!alignOutOption) {
            Parameters.LaTeXAlignmentFile = "tlatex";
        }
        if (psOption || Parameters.CommentShading && !nopsOption) {
            Parameters.PSOutput = true;
        }
    }

    private static int GetIntArg(String str, String option) {
        int val = 0;
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            TeX.CommandLineError(option + " option must specify an integer value");
        }
        return val;
    }

    private static String RemoveExtension(String fileName) {
        if (fileName.indexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.indexOf("."));
    }

    private static String RemovePathPrefix(String str) {
        String result = str;
        if (result.indexOf(":") != -1) {
            result = result.substring(result.lastIndexOf(":") + 1);
        }
        if (result.indexOf("/") != -1) {
            result = result.substring(result.lastIndexOf("/") + 1);
        }
        if (result.indexOf("\\") != -1) {
            result = result.substring(result.lastIndexOf("\\") + 1);
        }
        return result;
    }

    private static boolean HasPathPrefix(String str) {
        return str.indexOf(":") != -1 || str.indexOf("/") != -1 || str.indexOf("\\") != -1;
    }

    private static void CommandLineError(String msg) {
        ToolIO.out.println("TLATeX command-line error: " + msg + ".");
        ToolIO.out.println("Use -help option for more information.");
        throw new TLA2TexException("TLATeX command-line error: " + msg + ".Use -help option for more information.");
    }

    private static void OutputMessageFile(String fileName) {
        ResourceFileReader input = new ResourceFileReader(fileName);
        String line = input.getLine();
        while (line != null) {
            ToolIO.out.println(line);
            line = input.getLine();
        }
        input.close();
    }

    private static void Starting(String name) {
        if (Parameters.Debug) {
            start = Debug.now();
            ToolIO.out.println("Starting " + name);
        }
    }

    private static void Finished(String name) {
        if (Parameters.Debug) {
            Debug.printElapsedTime(start, name + " finished in");
        }
    }

    private static float[] ReadLogFile() {
        BufferedReader logfile = null;
        try {
            logfile = new BufferedReader(new FileReader(Parameters.LaTeXOutputFile + ".log"));
        }
        catch (Exception e) {
            ToolIO.out.println("No file " + Parameters.LaTeXOutputFile + ".log");
            return new float[0];
        }
        Vector<String> resultVec = new Vector<String>(50);
        try {
            String inputLine = logfile.readLine();
            while (inputLine != null) {
                if (inputLine.length() > 2 && inputLine.substring(0, 3).equals("\\%{")) {
                    int start = 3;
                    int after = inputLine.indexOf("}", start) - 2;
                    resultVec.addElement(inputLine.substring(start, after));
                }
                inputLine = logfile.readLine();
            }
        }
        catch (Exception e) {
            Debug.ReportError("Error reading file " + Parameters.LaTeXOutputFile + ".log");
        }
        float[] result = new float[resultVec.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Misc.stringToFloat((String)resultVec.elementAt(i));
        }
        return result;
    }
}

