/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.util.Map;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.UniqueString;

public class StringValue
extends Value {
    public final UniqueString val;

    public StringValue(String str) {
        this.val = UniqueString.uniqueStringOf(str);
    }

    public StringValue(UniqueString var) {
        this.val = var;
    }

    public StringValue(UniqueString var, CostModel cm) {
        this(var);
        this.cm = cm;
    }

    @Override
    public final byte getKind() {
        return 3;
    }

    public final UniqueString getVal() {
        return this.val;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof StringValue) {
                return this.val.compareTo(((StringValue)obj).val);
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to compare string " + Values.ppr(this.toString()) + " with non-string:\n" + Values.ppr(obj.toString()));
            }
            return 1;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof StringValue) {
                return this.val.equals(((StringValue)obj).getVal());
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to check equality of string " + Values.ppr(this.toString()) + " with non-string:\n" + Values.ppr(obj.toString()));
            }
            return ((ModelValue)obj).modelValueEquals(this);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of the string " + Values.ppr(this.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the string " + Values.ppr(this.toString()) + " is a finite set.");
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the string " + Values.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the string " + Values.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the string " + Values.ppr(this.toString()) + ".");
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public boolean mutates() {
        return true;
    }

    @Override
    public final Value toTuple() {
        String s = this.val.toString();
        Value[] vals = new Value[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            vals[i] = new StringValue(Character.toString(s.charAt(i)));
        }
        return new TupleValue(vals);
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return val instanceof StringValue && this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final int length() {
        try {
            return this.val.length();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        int index = vos.put(this);
        if (index == -1) {
            vos.writeByte((byte)3);
            this.val.write(vos.getOutputStream());
        } else {
            vos.writeByte((byte)26);
            vos.writeNat(index);
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            fp = FP64.Extend(fp, (byte)3);
            fp = FP64.Extend(fp, this.val.length());
            fp = FP64.Extend(fp, this.val.toString());
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        return this;
    }

    final String PrintVersion(String str) {
        try {
            StringBuffer buf = new StringBuffer(str.length());
            block10: for (int i = 0; i < str.length(); ++i) {
                switch (str.charAt(i)) {
                    case '\"': {
                        buf.append("\\\"");
                        continue block10;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block10;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block10;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block10;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block10;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block10;
                    }
                    default: {
                        buf.append(str.charAt(i));
                    }
                }
            }
            return buf.toString();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            return sb.append("\"" + this.PrintVersion(this.val.toString()) + "\"");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final String toUnquotedString() {
        return this.PrintVersion(this.val.toString());
    }

    public static IValue createFrom(IValueInputStream vos) throws IOException {
        UniqueString str = UniqueString.read(vos.getInputStream());
        StringValue res = new StringValue(str);
        int index = vos.getIndex();
        vos.assign(res, index);
        return res;
    }

    public static IValue createFrom(IValueInputStream vos, Map<String, UniqueString> tbl) throws IOException {
        UniqueString str = UniqueString.read(vos.getInputStream(), tbl);
        StringValue res = new StringValue(str);
        int index = vos.getIndex();
        vos.assign(res, index);
        return res;
    }
}

