/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.PrintWriter;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.Simulator;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.util.IdThread;
import tlc2.util.RandomGenerator;
import util.FileUtil;

public class SimulationWorker
extends IdThread {
    private final RandomGenerator localRng;
    TLCState curState;
    private final StateVec stateTrace;
    private StateVec initStates;
    private final BlockingQueue<SimulationWorkerResult> resultQueue;
    private long traceCnt = 0L;
    private final long maxTraceNum;
    private final int maxTraceDepth;
    private final boolean checkDeadlock;
    private final String traceFile;
    private final LongAdder numOfGenStates;
    private final LongAdder numOfGenTraces;
    private final AtomicLong welfordM2AndMean;
    private final ITool tool;
    private final ILiveCheck liveCheck;
    final long[][] actionStats;

    public SimulationWorker(int id, ITool tool, BlockingQueue<SimulationWorkerResult> resultQueue, long seed, int maxTraceDepth, long maxTraceNum, boolean checkDeadlock, String traceFile, ILiveCheck liveCheck) {
        this(id, tool, resultQueue, seed, maxTraceDepth, maxTraceNum, checkDeadlock, traceFile, liveCheck, new LongAdder(), new LongAdder(), new AtomicLong());
    }

    public SimulationWorker(int id, ITool tool, BlockingQueue<SimulationWorkerResult> resultQueue, long seed, int maxTraceDepth, long maxTraceNum, boolean checkDeadlock, String traceFile, ILiveCheck liveCheck, LongAdder numOfGenStates, LongAdder numOfGenTraces, AtomicLong m2AndMean) {
        super(id);
        this.localRng = new RandomGenerator(seed);
        this.tool = tool;
        this.maxTraceDepth = maxTraceDepth;
        this.maxTraceNum = maxTraceNum;
        this.resultQueue = resultQueue;
        this.checkDeadlock = checkDeadlock;
        this.traceFile = traceFile;
        this.liveCheck = liveCheck;
        this.numOfGenStates = numOfGenStates;
        this.numOfGenTraces = numOfGenTraces;
        this.welfordM2AndMean = m2AndMean;
        this.stateTrace = new StateVec(maxTraceDepth);
        if (Simulator.actionStats) {
            Action[] actions = this.tool.getActions();
            int len = actions.length;
            this.actionStats = new long[len][len];
            for (int i = 0; i < actions.length; ++i) {
                actions[i].setId(i);
            }
        } else {
            this.actionStats = new long[1][1];
        }
    }

    @Override
    public final void run() {
        try {
            do {
                Optional<SimulationWorkerError> res = this.simulateRandomTrace();
                ++this.traceCnt;
                this.numOfGenTraces.increment();
                if (!res.isPresent()) continue;
                SimulationWorkerError err = res.get();
                this.resultQueue.put(SimulationWorkerResult.Error(this.myGetId(), err));
            } while (this.traceCnt < this.maxTraceNum);
            this.resultQueue.put(SimulationWorkerResult.OK(this.myGetId()));
            return;
        }
        catch (InterruptedException e) {
            this.resultQueue.offer(SimulationWorkerResult.OK(this.myGetId()));
            return;
        }
        catch (Exception e) {
            SimulationWorkerError err = new SimulationWorkerError(0, null, this.curState, this.stateTrace, e);
            this.resultQueue.offer(SimulationWorkerResult.Error(this.myGetId(), err));
            return;
        }
    }

    private void checkForInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private final TLCState randomState(RandomGenerator rng, StateVec states) {
        int len = states.size();
        if (len > 0) {
            int index = (int)Math.floor(rng.nextDouble() * (double)len);
            return states.elementAt(index);
        }
        return null;
    }

    private Optional<SimulationWorkerError> simulateRandomTrace() throws Exception {
        this.stateTrace.clear();
        this.curState = this.randomState(this.localRng, this.initStates);
        SimulationWorker.setCurrentState(this.curState);
        boolean inConstraints = this.tool.isInModel(this.curState);
        Action[] actions = this.tool.getActions();
        int len = actions.length;
        for (int traceIdx = 0; traceIdx < this.maxTraceDepth; ++traceIdx) {
            int i;
            this.checkForInterrupt();
            this.stateTrace.addElement(this.curState);
            if (!inConstraints) break;
            StateVec nextStates = null;
            int index = (int)Math.floor(this.localRng.nextDouble() * (double)len);
            int p = this.localRng.nextPrime();
            for (i = 0; i < len && (nextStates = this.tool.getNextStates(actions[index], this.curState)).empty(); ++i) {
                index = (index + p) % len;
            }
            if (nextStates == null || nextStates.empty()) {
                if (!this.checkDeadlock) break;
                return Optional.of(new SimulationWorkerError(2114, null, this.curState, this.stateTrace, null));
            }
            for (i = 0; i < nextStates.size(); ++i) {
                this.numOfGenStates.increment();
                TLCState state = nextStates.elementAt(i);
                state.setPredecessor(this.curState);
                if (!this.tool.isGoodState(state)) {
                    return Optional.of(new SimulationWorkerError(2109, null, state, this.stateTrace, null));
                }
                int idx = 0;
                try {
                    for (idx = 0; idx < this.tool.getInvariants().length; ++idx) {
                        if (this.tool.isValid(this.tool.getInvariants()[idx], state)) continue;
                        return Optional.of(new SimulationWorkerError(2110, new String[]{this.tool.getInvNames()[idx]}, state, this.stateTrace, null));
                    }
                }
                catch (Exception e) {
                    return Optional.of(new SimulationWorkerError(2111, new String[]{this.tool.getInvNames()[idx], e.getMessage()}, state, this.stateTrace, null));
                }
                try {
                    for (idx = 0; idx < this.tool.getImpliedActions().length; ++idx) {
                        if (this.tool.isValid(this.tool.getImpliedActions()[idx], this.curState, state)) continue;
                        return Optional.of(new SimulationWorkerError(2112, new String[]{this.tool.getImpliedActNames()[idx]}, state, this.stateTrace, null));
                    }
                    continue;
                }
                catch (Exception e) {
                    return Optional.of(new SimulationWorkerError(2113, new String[]{this.tool.getImpliedActNames()[idx], e.getMessage()}, state, this.stateTrace, null));
                }
            }
            TLCState s1 = this.randomState(this.localRng, nextStates);
            inConstraints = this.tool.isInModel(s1) && this.tool.isInActions(this.curState, s1);
            s1.setPredecessor(this.curState);
            s1.execCallable();
            if (Simulator.actionStats) {
                long[] lArray = this.actionStats[this.curState.getAction().getId()];
                int n = s1.getAction().getId();
                lArray[n] = lArray[n] + 1L;
            }
            this.curState = s1;
            SimulationWorker.setCurrentState(this.curState);
        }
        this.checkForInterrupt();
        this.liveCheck.checkTrace(this.tool, this.stateTrace);
        this.welfordM2AndMean.accumulateAndGet(this.stateTrace.size(), (acc, tl) -> {
            int mean = (int)(acc & 0xFFFFFFFFL);
            long m2 = acc >>> 32;
            long delta = tl - (long)mean;
            mean = (int)((long)mean + delta / (this.numOfGenTraces.longValue() + 1L));
            return (m2 += delta * (tl - (long)mean)) << 32 | (long)mean & 0xFFFFFFFFL;
        });
        if (this.traceFile != null) {
            String fileName = this.traceFile + "_" + String.valueOf(this.myGetId()) + "_" + this.traceCnt;
            PrintWriter pw = new PrintWriter(FileUtil.newBFOS(fileName));
            pw.println("---------------- MODULE " + fileName + " -----------------");
            for (int idx = 0; idx < this.stateTrace.size(); ++idx) {
                pw.println("STATE_" + (idx + 1) + " == ");
                pw.println(this.stateTrace.elementAt(idx) + "\n");
            }
            pw.println("=================================================");
            pw.close();
        }
        return Optional.empty();
    }

    public final long getTraceCnt() {
        return this.traceCnt + 1L;
    }

    public final StateVec getTrace() {
        return this.stateTrace;
    }

    public final TLCStateInfo[] getTraceInfo() {
        TLCStateInfo[] trace = new TLCStateInfo[this.stateTrace.size()];
        for (int i = 0; i < this.stateTrace.size(); ++i) {
            TLCState s = this.stateTrace.elementAt(i);
            trace[i] = s.isInitial() ? new TLCStateInfo(s) : new TLCStateInfo(s, s.getAction());
        }
        return trace;
    }

    public final TLCStateInfo[] getTraceInfo(int level) {
        assert (0 < level && level <= this.stateTrace.size());
        TLCStateInfo[] trace = new TLCStateInfo[level];
        for (int i = 0; i < trace.length; ++i) {
            TLCState s = this.stateTrace.elementAt(i);
            trace[i] = s.isInitial() ? new TLCStateInfo(s) : new TLCStateInfo(s, s.getAction());
        }
        return trace;
    }

    public void start(StateVec initStates) {
        this.initStates = initStates;
        this.start();
    }

    public final RandomGenerator getRNG() {
        return this.localRng;
    }

    public static class SimulationWorkerResult {
        private int workerId;
        private Optional<SimulationWorkerError> error = Optional.empty();

        static SimulationWorkerResult OK(int workerId) {
            SimulationWorkerResult res = new SimulationWorkerResult();
            res.workerId = workerId;
            return res;
        }

        static SimulationWorkerResult Error(int workerId, SimulationWorkerError err) {
            SimulationWorkerResult res = new SimulationWorkerResult();
            res.error = Optional.of(err);
            res.workerId = workerId;
            return res;
        }

        public boolean isError() {
            return this.error.isPresent();
        }

        public SimulationWorkerError error() {
            return this.error.get();
        }

        public int workerId() {
            return this.workerId;
        }
    }

    public static class SimulationWorkerError {
        public final int errorCode;
        public final String[] parameters;
        public final TLCState state;
        public final StateVec stateTrace;
        public final Exception exception;

        public SimulationWorkerError(int errorCode, String[] parameters, TLCState state, StateVec stateTrace, Exception e) {
            this.errorCode = errorCode;
            this.parameters = parameters;
            this.state = state;
            this.stateTrace = new StateVec(stateTrace);
            this.exception = e;
        }
    }
}

