/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LNAction;
import tlc2.tool.liveness.LNBool;
import tlc2.tool.liveness.LNState;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBPar;

public class LNNeg
extends LiveExprNode {
    private final LiveExprNode body;

    public LNNeg(LiveExprNode body) {
        this.body = body;
    }

    public final LiveExprNode getBody() {
        return this.body;
    }

    @Override
    public final int getLevel() {
        return this.body.getLevel();
    }

    @Override
    public final boolean containAction() {
        return this.body.containAction();
    }

    @Override
    public final boolean eval(ITool tool, TLCState s1, TLCState s2) {
        return !this.body.eval(tool, s1, s2);
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        sb.append("-");
        this.getBody().toString(sb, padding + " ");
    }

    @Override
    public void extractPromises(TBPar promises) {
        this.getBody().extractPromises(promises);
    }

    @Override
    public int tagExpr(int tag) {
        return this.getBody().tagExpr(tag);
    }

    @Override
    public final LiveExprNode makeBinary() {
        return new LNNeg(this.getBody().makeBinary());
    }

    @Override
    public LiveExprNode flattenSingleJunctions() {
        LiveExprNode ln1 = this.getBody();
        if (ln1 instanceof LNNeg) {
            return ((LNNeg)ln1).getBody().flattenSingleJunctions();
        }
        return new LNNeg(ln1.flattenSingleJunctions());
    }

    @Override
    public final LiveExprNode toDNF() {
        LiveExprNode body = this.getBody();
        if (body instanceof LNState || body instanceof LNAction) {
            return this;
        }
        return body.pushNeg().toDNF();
    }

    @Override
    public LiveExprNode simplify() {
        LiveExprNode body1 = this.getBody().simplify();
        if (body1 instanceof LNBool) {
            return new LNBool(!((LNBool)body1).b);
        }
        return new LNNeg(body1);
    }

    @Override
    public boolean isGeneralTF() {
        return this.getBody().isGeneralTF();
    }

    @Override
    public LiveExprNode pushNeg() {
        return this.getBody();
    }

    @Override
    public LiveExprNode pushNeg(boolean hasNeg) {
        LiveExprNode lexpr = this.getBody();
        return lexpr.pushNeg(!hasNeg);
    }

    @Override
    public boolean equals(LiveExprNode exp) {
        if (exp instanceof LNNeg) {
            return this.getBody().equals(((LNNeg)exp).getBody());
        }
        return false;
    }

    @Override
    public String toDotViz() {
        return "-" + this.getBody().toDotViz();
    }
}

