/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import tlc2.TraceExplorationSpecGenerationReport;
import tlc2.TraceExplorer;
import tlc2.input.MCParser;
import tlc2.input.MCParserResults;
import tlc2.model.MCError;
import tlc2.output.ErrorTraceMessagePrinterRecorder;
import tlc2.output.MP;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.impl.ModelConfig;
import tlc2.tool.impl.SpecProcessor;

public class TraceExplorationSpec {
    private final Date timestamp;
    private IStreamProvider streamProvider;
    private final ErrorTraceMessagePrinterRecorder recorder;

    public TraceExplorationSpec(Path outputDirectory, Date timestamp, ErrorTraceMessagePrinterRecorder recorder) {
        this.timestamp = timestamp;
        this.streamProvider = new FileStreamProvider(outputDirectory);
        this.recorder = recorder;
    }

    public Optional<TraceExplorationSpecGenerationReport> generate(ITool specInfo) {
        return this.recorder.getMCErrorTrace().map(errorTrace -> {
            ModelConfig cfg = specInfo.getModelConfig();
            SpecProcessor spec = specInfo.getSpecProcessor();
            String ogModuleName = specInfo.getRootName();
            List<String> variables = Arrays.asList(TLCState.Empty.getVarsAsStrings());
            MCParserResults parserResults = MCParser.generateResultsFromProcessorAndConfig(spec, cfg);
            return this.generate(ogModuleName, parserResults, variables, (MCError)errorTrace);
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TraceExplorationSpecGenerationReport generate(String ogModuleName, MCParserResults parserResults, List<String> variables, MCError errorTrace) {
        String teSpecModuleName = TraceExplorationSpec.deriveTESpecModuleName(ogModuleName);
        try (OutputStream tlaStream = this.streamProvider.getTlaStream(teSpecModuleName);){
            TraceExplorationSpecGenerationReport traceExplorationSpecGenerationReport;
            block14: {
                OutputStream cfgStream = this.streamProvider.getCfgStream(teSpecModuleName);
                try {
                    TraceExplorer.writeSpecTEStreams(teSpecModuleName, ogModuleName, parserResults, variables, errorTrace, tlaStream, cfgStream);
                    TraceExplorationSpecGenerationReport report = new TraceExplorationSpecGenerationReport(errorTrace, this.streamProvider.getTlaPath(teSpecModuleName), this.streamProvider.getCfgPath(teSpecModuleName));
                    MP.printMessage(2501, report.teSpecTlaPath.toString());
                    traceExplorationSpecGenerationReport = report;
                    if (cfgStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (cfgStream != null) {
                        try {
                            cfgStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cfgStream.close();
            }
            return traceExplorationSpecGenerationReport;
        }
        catch (IOException | SecurityException e) {
            MP.printMessage(2502, e.getMessage());
            return null;
        }
    }

    public static String teModuleId(Date timestamp) {
        long secondsSinceEpoch = timestamp.getTime() / 1000L;
        return Long.toString(secondsSinceEpoch);
    }

    public static String deriveTESpecModuleName(String ogModuleName) {
        return String.format("%s_%s", ogModuleName, "TTrace");
    }

    public static boolean isTESpecFile(String tlaFilePath) {
        if (null == tlaFilePath) {
            return false;
        }
        try {
            String filename = Paths.get(tlaFilePath, new String[0]).getFileName().toString();
            return filename.matches("^.*_TTrace_\\d{10}(.tla)?$");
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public class FileStreamProvider
    implements IStreamProvider {
        private Path outputDirectory;

        public FileStreamProvider(Path outputDirectory) {
            this.outputDirectory = outputDirectory;
        }

        @Override
        public Path getTlaPath(String moduleName) {
            return this.outputDirectory.resolve(moduleName + ".tla");
        }

        @Override
        public OutputStream getTlaStream(String moduleName) throws FileNotFoundException, SecurityException {
            this.ensureDirectoryExists();
            File tlaFile = this.getTlaPath(moduleName).toFile();
            return new FileOutputStream(tlaFile);
        }

        @Override
        public Path getCfgPath(String moduleName) {
            return this.outputDirectory.resolve(moduleName + ".cfg");
        }

        @Override
        public OutputStream getCfgStream(String moduleName) throws FileNotFoundException, SecurityException {
            this.ensureDirectoryExists();
            File cfgFile = this.getCfgPath(moduleName).toFile();
            return new FileOutputStream(cfgFile);
        }

        private void ensureDirectoryExists() throws SecurityException {
            for (int i = 1; i <= this.outputDirectory.getNameCount(); ++i) {
                Path subPath = this.outputDirectory.subpath(0, i);
                if (subPath.toFile().exists()) continue;
                subPath.toFile().mkdir();
            }
        }
    }

    public static interface IStreamProvider {
        public Path getTlaPath(String var1);

        public OutputStream getTlaStream(String var1) throws FileNotFoundException, SecurityException;

        public Path getCfgPath(String var1);

        public OutputStream getCfgStream(String var1) throws FileNotFoundException, SecurityException;
    }
}

