/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.util.Map;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.ValueInputStream;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.Reducible;
import tlc2.value.impl.SetCupValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;
import util.UniqueString;

public class SetEnumValue
extends EnumerableValue
implements Enumerable,
Reducible {
    public ValueVec elems;
    private boolean isNorm;
    public static final SetEnumValue EmptySet = new SetEnumValue(new ValueVec(0), true);
    public static final SetEnumValue DummyEnum = new SetEnumValue((ValueVec)null, true);

    public SetEnumValue(Value[] elems, boolean isNorm) {
        this(new ValueVec(elems), isNorm);
    }

    public SetEnumValue(Value[] vals2, boolean isNorm, CostModel cm) {
        this(vals2, isNorm);
        this.cm = cm;
    }

    public SetEnumValue(ValueVec elems, boolean isNorm) {
        this.elems = elems;
        this.isNorm = isNorm;
    }

    public SetEnumValue(ValueVec elems, boolean isNorm, CostModel cm) {
        this(elems, isNorm);
        this.cm = cm;
    }

    public SetEnumValue() {
        this(new ValueVec(0), true);
    }

    public SetEnumValue(Value elem) {
        this(new Value[]{elem}, true);
    }

    public SetEnumValue(CostModel cm) {
        this();
        this.cm = cm;
    }

    public final boolean isSetOfAtoms() {
        int len = this.elems.size();
        for (int i = 0; i < len; ++i) {
            SetEnumValue sev;
            Value v = this.elems.elementAt(i);
            if (!(v instanceof SetEnumValue ? !(sev = (SetEnumValue)v).isSetOfAtoms() : !v.isAtom())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final byte getKind() {
        return 5;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            SetEnumValue set2;
            SetEnumValue setEnumValue = set2 = obj instanceof Value ? (SetEnumValue)((Value)obj).toSetEnum() : null;
            if (set2 == null) {
                if (obj instanceof ModelValue) {
                    return 1;
                }
                Assert.fail("Attempted to compare the set " + Values.ppr(this.toString()) + " with the value:\n" + Values.ppr(obj.toString()));
            }
            this.normalize();
            set2.normalize();
            int sz = this.elems.size();
            int cmp = sz - set2.elems.size();
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < sz; ++i) {
                cmp = this.elems.elementAt(i).compareTo(set2.elems.elementAt(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public final boolean equals(Object obj) {
        try {
            SetEnumValue set2;
            SetEnumValue setEnumValue = set2 = obj instanceof Value ? (SetEnumValue)((Value)obj).toSetEnum() : null;
            if (set2 == null) {
                if (obj instanceof ModelValue) {
                    return ((ModelValue)obj).modelValueEquals(this);
                }
                Assert.fail("Attempted to check equality of the set " + Values.ppr(this.toString()) + " with the value:\n" + Values.ppr(obj.toString()));
            }
            this.normalize();
            set2.normalize();
            int sz = this.elems.size();
            if (sz != set2.elems.size()) {
                return false;
            }
            for (int i = 0; i < sz; ++i) {
                if (this.elems.elementAt(i).equals(set2.elems.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            return this.elems.search(elem, this.isNorm);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final Value diff(Value val2) {
        try {
            int sz = this.elems.size();
            ValueVec diffElems = new ValueVec();
            for (int i = 0; i < sz; ++i) {
                Value elem = this.elems.elementAt(i);
                if (val2.member(elem)) continue;
                diffElems.addElement(elem);
            }
            return new SetEnumValue(diffElems, this.isNormalized(), this.cm);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value cap(Value val2) {
        try {
            int sz = this.elems.size();
            ValueVec capElems = new ValueVec();
            for (int i = 0; i < sz; ++i) {
                Value elem = this.elems.elementAt(i);
                if (!val2.member(elem)) continue;
                capElems.addElement(elem);
            }
            return new SetEnumValue(capElems, this.isNormalized(), this.cm);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value cup(Value set2) {
        try {
            int sz = this.elems.size();
            if (sz == 0) {
                return set2;
            }
            if (set2 instanceof Reducible) {
                Value elem;
                ValueVec cupElems = new ValueVec();
                for (int i = 0; i < sz; ++i) {
                    elem = this.elems.elementAt(i);
                    cupElems.addElement(elem);
                }
                ValueEnumeration Enum2 = ((Enumerable)((Object)set2)).elements();
                while ((elem = Enum2.nextElement()) != null) {
                    if (this.member(elem)) continue;
                    cupElems.addElement(elem);
                }
                return new SetEnumValue(cupElems, false);
            }
            return new SetCupValue(this, set2, this.cm);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + Values.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final int size() {
        try {
            this.normalize();
            return this.elems.size();
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isNormalized() {
        return this.isNorm;
    }

    @Override
    public final Value normalize() {
        try {
            if (!this.isNorm) {
                this.elems.sort(true);
                this.isNorm = true;
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            for (int i = 0; i < this.elems.size(); ++i) {
                this.elems.elementAt(i).deepNormalize();
            }
            this.normalize();
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value toSetEnum() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            int sz = this.elems.size();
            for (int i = 0; i < sz; ++i) {
                defined = defined && this.elems.elementAt(i).isDefined();
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val2) {
        try {
            return this.equals(val2);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        int index2 = vos.put(this);
        if (index2 == -1) {
            vos.writeByte((byte)5);
            int len = this.elems.size();
            vos.writeInt(this.isNormalized() ? len : -len);
            for (int i = 0; i < len; ++i) {
                this.elems.elementAt(i).write(vos);
            }
        } else {
            vos.writeByte((byte)26);
            vos.writeNat(index2);
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.normalize();
            int sz = this.elems.size();
            fp = FP64.Extend(fp, (byte)5);
            fp = FP64.Extend(fp, sz);
            for (int i = 0; i < sz; ++i) {
                Value elem = this.elems.elementAt(i);
                fp = elem.fingerPrint(fp);
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            int sz = this.elems.size();
            Value[] vals2 = new Value[sz];
            boolean changed = false;
            for (int i = 0; i < sz; ++i) {
                vals2[i] = (Value)this.elems.elementAt(i).permute(perm);
                changed = changed || vals2[i] != this.elems.elementAt(i);
            }
            if (changed) {
                return new SetEnumValue(vals2, false);
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            if (!this.isNormalized()) {
                this.normalize();
            }
            int len = this.elems.size();
            sb = sb.append("{");
            if (len > 0) {
                this.elems.elementAt(0).toString(sb, offset, swallow);
            }
            for (int i = 1; i < len; ++i) {
                sb.append(", ");
                this.elems.elementAt(i).toString(sb, offset, swallow);
            }
            sb.append("}");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public final Value randomElement() {
        int sz = this.size();
        int index2 = (int)Math.floor(RandomEnumerableValues.get().nextDouble() * (double)sz);
        return this.elems.elementAt(index2);
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            return new Enumerator();
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public EnumerableValue getRandomSubset(int kOutOfN) {
        ValueVec vec2 = new ValueVec(kOutOfN);
        ValueEnumeration ve = this.elements(kOutOfN);
        Value v = null;
        while ((v = ve.nextElement()) != null) {
            vec2.addElement(v);
        }
        return new SetEnumValue(vec2, false, this.cm);
    }

    @Override
    public ValueEnumeration elements(int k) {
        this.normalize();
        return new EnumerableValue.SubsetEnumerator(k){

            @Override
            public Value nextElement() {
                if (!this.hasNext()) {
                    return null;
                }
                return SetEnumValue.this.elems.elementAt(this.nextIndex());
            }
        };
    }

    public static IValue createFrom(IValueInputStream vos) throws IOException {
        int index2 = vos.getIndex();
        boolean isNorm = true;
        int len = vos.readInt();
        if (len < 0) {
            len = -len;
            isNorm = false;
        }
        Value[] elems = new Value[len];
        for (int i = 0; i < len; ++i) {
            elems[i] = (Value)vos.read();
        }
        SetEnumValue res2 = new SetEnumValue(elems, isNorm);
        vos.assign(res2, index2);
        return res2;
    }

    public static IValue createFrom(ValueInputStream vos, Map<String, UniqueString> tbl) throws IOException {
        int index2 = vos.getIndex();
        boolean isNorm = true;
        int len = vos.readInt();
        if (len < 0) {
            len = -len;
            isNorm = false;
        }
        Value[] elems = new Value[len];
        for (int i = 0; i < len; ++i) {
            elems[i] = (Value)vos.read(tbl);
        }
        SetEnumValue res2 = new SetEnumValue(elems, isNorm);
        vos.assign(res2, index2);
        return res2;
    }

    final class Enumerator
    implements ValueEnumeration {
        int index = 0;

        public Enumerator() {
            SetEnumValue.this.normalize();
        }

        @Override
        public final void reset() {
            this.index = 0;
        }

        @Override
        public final Value nextElement() {
            if (Value.coverage) {
                SetEnumValue.this.cm.incSecondary();
            }
            if (this.index < SetEnumValue.this.elems.size()) {
                return SetEnumValue.this.elems.elementAt(this.index++);
            }
            return null;
        }
    }
}

