/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.ParseAlgorithm;
import pcal.PcalDebug;
import pcal.PcalFixIDs;
import pcal.PcalSymTab;
import pcal.PcalTLAGen;
import pcal.PcalTranslate;
import pcal.exception.PcalFixIDException;
import pcal.exception.PcalSymTabException;
import pcal.exception.PcalTLAGenException;
import pcal.exception.PcalTranslateException;
import pcal.exception.RemoveNameConflictsException;

public class PCalTLAGenerator {
    private PcalSymTab st = null;
    private AST ast = null;

    public PCalTLAGenerator(AST ast) {
        this.ast = ast;
    }

    public void removeNameConflicts() throws RemoveNameConflictsException {
        try {
            this.st = new PcalSymTab(this.ast);
        }
        catch (PcalSymTabException e2) {
            throw new RemoveNameConflictsException(e2.getMessage());
        }
        this.st.Disambiguate();
        if (this.st.disambiguateReport.size() > 0) {
            PcalDebug.reportWarning("symbols were renamed.");
        }
        if (this.st.errorReport.length() > 0) {
            throw new RemoveNameConflictsException(this.st.errorReport);
        }
        try {
            PcalFixIDs.Fix(this.ast, this.st);
        }
        catch (PcalFixIDException e3) {
            throw new RemoveNameConflictsException(e3.getMessage());
        }
    }

    public Vector<String> translate() throws RemoveNameConflictsException {
        Vector<String> result = new Vector<String>();
        AST xast = null;
        for (int i = 0; i < this.st.disambiguateReport.size(); ++i) {
            result.addElement((String)this.st.disambiguateReport.elementAt(i));
        }
        try {
            xast = PcalTranslate.Explode(this.ast, this.st);
        }
        catch (PcalTranslateException e2) {
            throw new RemoveNameConflictsException(e2);
        }
        try {
            PcalTLAGen tlaGenerator = new PcalTLAGen();
            result = tlaGenerator.generate(xast, this.st, result);
        }
        catch (PcalTLAGenException e3) {
            throw new RemoveNameConflictsException(e3);
        }
        try {
            if (ParseAlgorithm.hasDefaultInitialization) {
                this.st.CheckForDefaultInitValue();
            }
        }
        catch (PcalSymTabException e4) {
            throw new RemoveNameConflictsException(e4.getMessage());
        }
        return result;
    }
}

