/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;

public class AssumeProveNode
extends LevelNode {
    protected LevelNode[] assumes = null;
    protected ExprNode prove = null;
    protected boolean[] inScopeOfDecl;
    protected boolean inProof = true;
    protected boolean suffices = false;
    protected boolean isBoxAssumeProve;
    private ThmOrAssumpDefNode goal = null;

    protected boolean isSuffices() {
        return this.suffices;
    }

    void setSuffices() {
        this.suffices = true;
    }

    public boolean getSuffices() {
        return this.suffices;
    }

    public boolean getIsBoxAssumeProve() {
        return this.isBoxAssumeProve;
    }

    protected void setIsBoxAssumeProve(boolean value) {
        this.isBoxAssumeProve = value;
    }

    public AssumeProveNode(TreeNode stn, ThmOrAssumpDefNode gl) {
        super(14, stn);
        this.goal = gl;
    }

    public final SemanticNode[] getAssumes() {
        return this.assumes;
    }

    public final ExprNode getProve() {
        return this.prove;
    }

    public ThmOrAssumpDefNode getGoal() {
        return this.goal;
    }

    @Override
    public boolean levelCheck(int iter) {
        int i;
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        this.levelChecked = iter;
        this.levelCorrect = true;
        for (i = 0; i < this.assumes.length; ++i) {
            if (this.assumes[i] == null || this.assumes[i].levelCheck(iter)) continue;
            this.levelCorrect = false;
        }
        this.prove.levelCheck(iter);
        this.level = this.prove.getLevel();
        for (i = 0; i < this.assumes.length; ++i) {
            this.assumes[i].levelCheck(iter);
            if (this.assumes[i].getLevel() <= this.level) continue;
            this.level = this.assumes[i].getLevel();
        }
        this.levelParams.addAll(this.prove.getLevelParams());
        this.allParams.addAll(this.prove.getAllParams());
        for (i = 0; i < this.assumes.length; ++i) {
            this.levelParams.addAll(this.assumes[i].getLevelParams());
            this.allParams.addAll(this.assumes[i].getAllParams());
        }
        this.levelConstraints.putAll(this.prove.getLevelConstraints());
        for (i = 0; i < this.assumes.length; ++i) {
            this.levelConstraints.putAll(this.assumes[i].getLevelConstraints());
        }
        this.argLevelConstraints.putAll(this.prove.getArgLevelConstraints());
        for (i = 0; i < this.assumes.length; ++i) {
            this.argLevelConstraints.putAll(this.assumes[i].getArgLevelConstraints());
        }
        this.argLevelParams.addAll(this.prove.getArgLevelParams());
        for (i = 0; i < this.assumes.length; ++i) {
            this.argLevelParams.addAll(this.assumes[i].getArgLevelParams());
        }
        if (this.levelCorrect) {
            AssumeProveNode.addTemporalLevelConstraintToConstants(this.levelParams, this.levelConstraints);
        }
        return this.levelCorrect;
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res2 = new SemanticNode[this.assumes.length + 1];
        res2[this.assumes.length] = this.prove;
        for (int i = 0; i < this.assumes.length; ++i) {
            res2[i] = this.assumes[i];
        }
        return res2;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> h, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (h.get(uid) != null) {
            return;
        }
        h.put(uid, this);
        visitor.preVisit(this);
        for (int i = 0; i < this.assumes.length; ++i) {
            this.assumes[i].walkGraph(h, visitor);
        }
        this.prove.walkGraph(h, visitor);
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String assumeStr = "";
        for (int i = 0; i < this.assumes.length; ++i) {
            assumeStr = assumeStr + Strings.indent(4, this.assumes[i].toString(depth - 1));
        }
        String goalStr = "null";
        if (this.goal != null) {
            goalStr = Strings.indent(4, this.goal.toString(1));
        }
        return "\n*AssumeProveNode: " + super.toString(depth) + "\n  " + (this.isBoxAssumeProve ? "[]" : "") + "Assumes: " + assumeStr + "\n  " + (this.isBoxAssumeProve ? "[]" : "") + "Prove: " + Strings.indent(4, this.prove.toString(depth - 1)) + "\n  Goal: " + goalStr + (this.suffices ? "\n  SUFFICES" : "");
    }

    @Override
    public Element getLevelElement(Document doc2, SymbolContext context) {
        Element e2 = doc2.createElement("AssumeProveNode");
        Element antecedent = doc2.createElement("assumes");
        Element succedent = doc2.createElement("prove");
        SemanticNode[] assumes = this.getAssumes();
        for (int i = 0; i < assumes.length; ++i) {
            antecedent.appendChild(assumes[i].export(doc2, context));
        }
        succedent.appendChild(this.getProve().export(doc2, context));
        e2.appendChild(antecedent);
        e2.appendChild(succedent);
        if (this.isSuffices()) {
            e2.appendChild(doc2.createElement("suffices"));
        }
        if (this.isBoxAssumeProve) {
            e2.appendChild(doc2.createElement("boxed"));
        }
        return e2;
    }
}

