/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.lang.reflect.Array;

public final class ObjLongTable<T> {
    private int count;
    private int length;
    private int thresh;
    private T[] keys;
    private long[] elems;

    public ObjLongTable(int size) {
        this.keys = new Object[size];
        this.elems = new long[size];
        this.count = 0;
        this.length = size;
        this.thresh = this.length / 2;
    }

    private final void grow() {
        T[] oldKeys = this.keys;
        long[] oldElems = this.elems;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.keys = new Object[this.length];
        this.elems = new long[this.length];
        for (int i = 0; i < oldKeys.length; ++i) {
            T key2 = oldKeys[i];
            if (key2 == null) continue;
            this.put(key2, oldElems[i]);
        }
    }

    public final int size() {
        return this.count;
    }

    public final int put(T k, long elem) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = (k.hashCode() & Integer.MAX_VALUE) % this.length;
        while (true) {
            T key2;
            if ((key2 = this.keys[loc]) == null) {
                this.keys[loc] = k;
                this.elems[loc] = elem;
                ++this.count;
                return loc;
            }
            if (key2.equals(k)) {
                this.elems[loc] = elem;
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final int add(T k, long elem) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = (k.hashCode() & Integer.MAX_VALUE) % this.length;
        while (true) {
            T key2;
            if ((key2 = this.keys[loc]) == null) {
                this.keys[loc] = k;
                this.elems[loc] = elem;
                ++this.count;
                return loc;
            }
            if (key2.equals(k)) {
                int n = loc;
                this.elems[n] = this.elems[n] + elem;
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final long get(Object k) {
        int loc = (k.hashCode() & Integer.MAX_VALUE) % this.length;
        T key2;
        while ((key2 = this.keys[loc]) != null) {
            if (key2.equals(k)) {
                return this.elems[loc];
            }
            loc = (loc + 1) % this.length;
        }
        return 0L;
    }

    public ObjLongTable<T> mergeInto(ObjLongTable<T> other) {
        T key2;
        Enumerator<T> keys2 = other.keys();
        while ((key2 = keys2.nextElement()) != null) {
            this.add(key2, other.get(key2));
        }
        return this;
    }

    public T[] toArray(T[] a) {
        a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.count);
        Enumerator<T> keys2 = this.keys();
        Object e2 = null;
        int i = 0;
        while (true) {
            T t = keys2.nextElement();
            e2 = t;
            if (t == null) break;
            a[i++] = e2;
        }
        return a;
    }

    public final Enumerator<T> keys() {
        return new Enumerator();
    }

    public final class Enumerator<T> {
        int index = 0;

        public final T nextElement() {
            while (this.index < ObjLongTable.this.keys.length) {
                if (ObjLongTable.this.keys[this.index] != null) {
                    return (T)ObjLongTable.this.keys[this.index++];
                }
                ++this.index;
            }
            return null;
        }
    }
}

