/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed.selector;

import tlc2.tool.distributed.TLCServer;
import tlc2.tool.distributed.TLCWorkerRMI;
import tlc2.tool.distributed.TLCWorkerSmartProxy;
import tlc2.tool.distributed.selector.LimitingBlockSelector;

public class StatisticalBlockSelector
extends LimitingBlockSelector {
    private final double networkOverheadLimit;

    public StatisticalBlockSelector(TLCServer aTLCServer) {
        super(aTLCServer);
        this.networkOverheadLimit = 0.025;
    }

    @Override
    protected long getBlockSize(long size, TLCWorkerRMI aWorker) {
        if (aWorker instanceof TLCWorkerSmartProxy) {
            TLCWorkerSmartProxy proxy2 = (TLCWorkerSmartProxy)aWorker;
            int blockSize = (int)Math.min(Math.max(Math.abs(Math.ceil((double)size * (proxy2.getNetworkOverhead() / this.networkOverheadLimit))), 1.0), (double)this.getMaximum());
            return blockSize;
        }
        return super.getBlockSize(size, aWorker);
    }
}

