/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.util.Date;
import java.util.Vector;
import tla2tex.Misc;
import tla2tex.TLA2TexException;
import util.ToolIO;

public class Debug {
    public static void ReportError(String msg) {
        ToolIO.out.println("");
        ToolIO.out.println("TLATeX unrecoverable error:");
        ToolIO.out.println("");
        ToolIO.out.println(" -- " + msg + ".");
        ToolIO.out.println("");
        throw new TLA2TexException("TLATeX unrecoverable error: -- " + msg + ".");
    }

    public static void Assert(boolean val2) {
        if (!val2) {
            Debug.ReportBug("Assertion failure");
        }
    }

    public static void Assert(boolean val2, String msg) {
        if (!val2) {
            Debug.ReportBug("Failure of assertion: " + msg);
        }
    }

    public static void ReportBug(String msg) {
        ToolIO.out.println("");
        ToolIO.out.println("You have discovered a bug in TLATeX.");
        ToolIO.out.println("Send the following information and the");
        ToolIO.out.println("input file to the current maintainer(s).");
        ToolIO.out.println("");
        ToolIO.out.println(" -- " + msg + ".");
        ToolIO.out.println("");
        throw new Error();
    }

    public static void printArray(Object[] array2, String name2) {
        if (array2 == null) {
            ToolIO.out.println(name2 + " == null");
            return;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] == null) {
                ToolIO.out.println(name2 + "[" + i + "] = null");
                continue;
            }
            ToolIO.out.println(name2 + "[" + i + "] = " + array2[i].toString());
        }
        if (array2.length == 0) {
            ToolIO.out.println(name2 + " = zero-length array");
        }
    }

    public static void print2DArray(Object[][] array2, String name2) {
        if (array2 == null) {
            ToolIO.out.println(name2 + " == null");
            return;
        }
        for (int i = 0; i < array2.length; ++i) {
            for (int j = 0; j < array2[i].length; ++j) {
                ToolIO.out.println(name2 + "[" + i + "][" + j + "] = " + array2[i][j].toString());
            }
            if (array2[i].length != 0) continue;
            ToolIO.out.println(name2 + "[" + i + "] = null");
        }
        if (array2.length == 0) {
            ToolIO.out.println(name2 + " = zero-length array");
        }
    }

    public static void printVector(Vector vec2, String name2) {
        if (vec2 == null) {
            ToolIO.out.println(name2 + " == null");
            return;
        }
        for (int i = 0; i < vec2.size(); ++i) {
            if (vec2.elementAt(i) == null) {
                ToolIO.out.println(name2 + "[" + i + "] = null");
                continue;
            }
            ToolIO.out.println(name2 + "[" + i + "] = " + vec2.elementAt(i).toString());
        }
        if (vec2.size() == 0) {
            ToolIO.out.println(name2 + " = zero-length vec");
        }
    }

    public static String pair(int i, int j) {
        return "(" + i + ", " + j + ")";
    }

    public static void printPair(int i, int j) {
        ToolIO.out.println(Debug.pair(i, j));
    }

    public static long now() {
        Date date = new Date();
        return date.getTime();
    }

    public static void printElapsedTime(long start, String msg) {
        Debug.printTimeDiff(Debug.now() - start, msg);
    }

    public static void printTimeDiff(long diff2, String msg) {
        ToolIO.out.println(msg + " " + Misc.floatToString((float)diff2 / 1000.0f, 2) + " seconds");
    }
}

