/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.IntPair;
import pcal.MappingObject;
import pcal.PCalLocation;
import pcal.PcalDebug;
import pcal.Region;
import pcal.TLAToken;
import pcal.exception.TLAExprException;
import pcal.exception.UnrecoverableException;
import tla2tex.Debug;

public class TLAExpr {
    public Vector tokens = new Vector(4);
    public TLAToken[] anchorTokens = null;
    public int[] anchorTokCol = null;
    private Region origin = null;

    public Region getOrigin() {
        return this.origin;
    }

    public void setOrigin(Region origin) {
        this.origin = origin;
    }

    TLAExpr() {
    }

    TLAExpr(Vector t) {
        this.tokens = t;
        this.anchorTokens = null;
        this.anchorTokCol = null;
    }

    public void addToken(TLAToken tok) {
        ((Vector)this.tokens.elementAt(this.tokens.size() - 1)).addElement(tok);
    }

    public void addTokenOffset(TLAToken tok, int offset) {
        Vector lastLine = (Vector)this.tokens.elementAt(this.tokens.size() - 1);
        int newCol = offset;
        if (lastLine.size() > 0) {
            TLAToken lastTok = (TLAToken)lastLine.elementAt(lastLine.size() - 1);
            newCol = newCol + lastTok.column + lastTok.string.length();
        }
        tok.column = newCol;
        lastLine.addElement(tok);
    }

    public void addLine() {
        this.tokens.addElement(new Vector());
    }

    public void normalize() {
        int i;
        while (this.tokens.size() > 0 && ((Vector)this.tokens.elementAt(0)).size() == 0) {
            this.tokens.removeElementAt(0);
        }
        while (this.tokens.size() > 0 && ((Vector)this.tokens.elementAt(this.tokens.size() - 1)).size() == 0) {
            this.tokens.removeElementAt(this.tokens.size() - 1);
        }
        int minCol = 999999;
        for (i = 0; i < this.tokens.size(); ++i) {
            if (((Vector)this.tokens.elementAt(i)).size() <= 0) continue;
            TLAToken tok = (TLAToken)((Vector)this.tokens.elementAt(i)).elementAt(0);
            if (tok.column >= minCol) continue;
            minCol = tok.column;
        }
        for (i = 0; i < this.tokens.size(); ++i) {
            Vector curLine = (Vector)this.tokens.elementAt(i);
            for (int j = 0; j < curLine.size(); ++j) {
                TLAToken tok = (TLAToken)curLine.elementAt(j);
                tok.column -= minCol;
            }
        }
        this.anchorTokens = new TLAToken[this.tokens.size()];
        this.anchorTokCol = new int[this.tokens.size()];
        for (i = 0; i < this.tokens.size(); ++i) {
            Vector curLine = (Vector)this.tokens.elementAt(i);
            if (curLine.size() <= 0) continue;
            int curLineFirstCol = ((TLAToken)curLine.elementAt((int)0)).column;
            boolean lineNotFound = true;
            for (int j = i - 1; j >= 0 && lineNotFound; --j) {
                TLAToken tok;
                Vector ancLine = (Vector)this.tokens.elementAt(j);
                if (ancLine.size() <= 0 || ((TLAToken)ancLine.elementAt((int)0)).column > curLineFirstCol) continue;
                lineNotFound = false;
                int k = 0;
                while (k + 1 < ancLine.size() && ((TLAToken)ancLine.elementAt((int)(k + 1))).column <= curLineFirstCol) {
                    ++k;
                }
                this.anchorTokens[i] = tok = (TLAToken)ancLine.elementAt(k);
                this.anchorTokCol[i] = tok.column;
            }
        }
    }

    public void renormalize() throws TLAExprException {
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (this.anchorTokens[i] == null) continue;
            Vector line = (Vector)this.tokens.elementAt(i);
            int k = this.anchorTokens[i].column - this.anchorTokCol[i];
            this.anchorTokCol[i] = this.anchorTokens[i].column;
            if (k < 0) {
                throw new TLAExprException("TLAExpr.renormalize() found anchor has moved to left.");
            }
            for (int j = 0; j < line.size(); ++j) {
                TLAToken tok = (TLAToken)line.elementAt(j);
                tok.column += k;
            }
        }
    }

    public Vector toStringVector() {
        Vector<String> result = new Vector<String>(this.tokens.size());
        for (int i = 0; i < this.tokens.size(); ++i) {
            Vector curTokLine = (Vector)this.tokens.elementAt(i);
            String curString = "";
            TLAToken curAncTok = this.anchorTokens[i];
            int curAncCol = this.anchorTokCol[i];
            if (curAncTok != null) {
                curString = TLAExpr.SpacesString(curAncTok.column - curAncCol);
            }
            TLAToken curTok = null;
            TLAToken lastTok = null;
            for (int j = 0; j < curTokLine.size(); ++j) {
                curTok = (TLAToken)curTokLine.elementAt(j);
                curString = j == 0 ? curString + TLAExpr.SpacesString(curTok.column) : curString + TLAExpr.SpacesString(curTok.column - lastTok.column - lastTok.getWidth());
                curString = curTok.type == 3 ? curString + "\"" + curTok.string + "\"" : curString + curTok.string;
                lastTok = curTok;
            }
            result.addElement(curString);
        }
        return result;
    }

    public Vector toMappingVector() {
        Vector result = new Vector(4);
        for (int i = 0; i < this.tokens.size(); ++i) {
            Vector<MappingObject> mapLine = new Vector<MappingObject>();
            Vector expLine = (Vector)this.tokens.elementAt(i);
            MappingObject.SourceToken sourceTok = null;
            for (int j = 0; j < expLine.size(); ++j) {
                int k;
                TLAToken tok = (TLAToken)expLine.elementAt(j);
                int tokEndCol = tok.column + tok.string.length();
                for (k = 0; k < tok.getBeginSubst().size(); ++k) {
                    mapLine.addElement(new MappingObject.LeftParen((PCalLocation)tok.getBeginSubst().elementAt(k)));
                }
                if (tok.source == null) {
                    if (sourceTok == null || !tok.isAppended()) {
                        mapLine.addElement(new MappingObject.BeginTLAToken(tok.column));
                        mapLine.addElement(new MappingObject.EndTLAToken(tokEndCol));
                        sourceTok = null;
                    } else {
                        sourceTok.setEndColumn(tokEndCol);
                    }
                } else {
                    sourceTok = new MappingObject.SourceToken(tok.column, tokEndCol, tok.source);
                    mapLine.addElement(sourceTok);
                }
                for (k = tok.getEndSubst().size() - 1; k >= 0; --k) {
                    mapLine.addElement(new MappingObject.RightParen((PCalLocation)tok.getEndSubst().elementAt(k)));
                }
            }
            result.addElement(mapLine);
        }
        return result;
    }

    public String toString() {
        String result = "<< ";
        boolean nonempty = false;
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (i > 0) {
                result = result + "\n";
            }
            Vector curLine = (Vector)this.tokens.elementAt(i);
            for (int j = 0; j < curLine.size(); ++j) {
                if (nonempty) {
                    result = result + ", ";
                }
                nonempty = true;
                TLAToken tok = (TLAToken)curLine.elementAt(j);
                result = tok.type == 3 ? result + "\"\\\"\", \"" + tok.string + "\", \"\\\"\"" : (tok.string.charAt(0) == '\\' ? result + "\"\\" + tok.string + "\"" : (tok.string.equals("/\\") ? result + "\"/\\\\\"" : result + "\"" + tok.string + "\""));
            }
        }
        return result + " >>";
    }

    public void appendExpr(Vector expr, int spaces) throws UnrecoverableException {
        throw new UnrecoverableException("appendExpr not yet implemented");
    }

    public TLAExpr cloneAndNormalize() {
        TLAExpr result = new TLAExpr();
        result.tokens = new Vector();
        for (int i = 0; i < this.tokens.size(); ++i) {
            Vector<TLAToken> newline2 = new Vector<TLAToken>();
            Vector line = (Vector)this.tokens.elementAt(i);
            for (int j = 0; j < line.size(); ++j) {
                newline2.add(((TLAToken)line.elementAt(j)).Clone());
            }
            result.tokens.add(newline2);
        }
        result.setOrigin(this.getOrigin());
        result.normalize();
        return result;
    }

    public void prepend(TLAExpr expr, int spaces) throws TLAExprException {
        int j;
        int i;
        for (i = 0; i < expr.tokens.size() - 1; ++i) {
            this.tokens.add(i, expr.tokens.elementAt(i));
        }
        Vector exprLine = (Vector)expr.tokens.elementAt(i);
        Vector thisLine = (Vector)this.tokens.elementAt(i);
        TLAToken tok = (TLAToken)exprLine.lastElement();
        int incr = tok.column + tok.getWidth() + spaces;
        for (j = 0; j < thisLine.size(); ++j) {
            tok = (TLAToken)thisLine.elementAt(j);
            tok.column += incr;
        }
        for (j = 0; j < exprLine.size(); ++j) {
            thisLine.add(j, exprLine.elementAt(j));
        }
        TLAToken[] newAToks = new TLAToken[this.tokens.size()];
        int[] newATCol = new int[this.tokens.size()];
        for (j = 0; j < expr.tokens.size(); ++j) {
            newAToks[j] = expr.anchorTokens[j];
            newATCol[j] = expr.anchorTokCol[j];
        }
        while (j < this.tokens.size()) {
            newAToks[j] = this.anchorTokens[j - expr.tokens.size() + 1];
            newATCol[j] = this.anchorTokCol[j - expr.tokens.size() + 1];
            ++j;
        }
        this.anchorTokens = newAToks;
        this.anchorTokCol = newATCol;
        this.renormalize();
    }

    public static Vector SeqSubstituteForAll(Vector expVec, Vector exprs, Vector strs) throws TLAExprException {
        Vector<TLAExpr> result = new Vector<TLAExpr>();
        for (int i = 0; i < expVec.size(); ++i) {
            TLAExpr e2 = ((TLAExpr)expVec.elementAt(i)).cloneAndNormalize();
            e2.substituteForAll(exprs, strs);
            result.add(e2);
        }
        return result;
    }

    public void substituteForAll(Vector exprs, Vector strs) throws TLAExprException {
        this.substituteForAll(exprs, strs, true);
    }

    public void substituteForAll(Vector exprs, Vector strs, boolean parenthesize) throws TLAExprException {
        TLAExpr[] expArray = new TLAExpr[exprs.size()];
        String[] strArray = new String[strs.size()];
        IntPair[] nextArray = new IntPair[expArray.length];
        for (int i = 0; i < nextArray.length; ++i) {
            expArray[i] = (TLAExpr)exprs.elementAt(i);
            strArray[i] = (String)strs.elementAt(i);
            nextArray[i] = this.findNextInstanceIn(strArray[i], new IntPair(0, 0));
        }
        boolean notDone = true;
        while (notDone) {
            IntPair nextPos = null;
            int nextIdx = -1;
            for (int i = 0; i < nextArray.length; ++i) {
                IntPair pos = nextArray[i];
                if (pos == null) continue;
                if (nextPos == null) {
                    nextPos = pos;
                    nextIdx = i;
                    continue;
                }
                if (pos.one >= nextPos.one && (pos.one != nextPos.one || pos.two >= nextPos.two)) continue;
                nextPos = pos;
                nextIdx = i;
            }
            if (nextPos == null) {
                notDone = false;
                continue;
            }
            IntPair afterNextPos = this.stepCoord(nextPos, 1);
            IntPair newPos = this.substituteAt(expArray[nextIdx], nextPos, parenthesize);
            nextArray[nextIdx] = newPos == null ? null : this.findNextInstanceIn(strArray[nextIdx], newPos);
            for (int i = 0; i < nextArray.length; ++i) {
                if (i == nextIdx || nextArray[i] == null) continue;
                Debug.Assert(newPos != null, "Doing substitutions in wrong order.");
                if (afterNextPos.one == newPos.one) {
                    if (nextArray[i].one != nextPos.one) continue;
                    nextArray[i].two += newPos.two - afterNextPos.two;
                    Debug.Assert(nextArray[i].two > nextPos.two, "Wrong substitution order.");
                    continue;
                }
                if (nextArray[i].one == nextPos.one) {
                    nextArray[i].one += newPos.one - afterNextPos.one;
                    Debug.Assert(nextArray[i].two > nextPos.two, "Wrong substitution order.");
                    nextArray[i].two += newPos.two - afterNextPos.two;
                    continue;
                }
                nextArray[i].one += newPos.one - afterNextPos.one;
            }
        }
    }

    public void substituteFor(TLAExpr expr, String id, boolean parenthesize) throws TLAExprException {
        IntPair next2 = new IntPair(0, 0);
        while (next2 != null) {
            if ((next2 = this.findNextInstanceIn(id, next2)) == null) continue;
            next2 = this.substituteAt(expr, next2, parenthesize);
        }
    }

    public IntPair substituteAt(TLAExpr expr, IntPair coord, boolean par) throws TLAExprException {
        TLAToken tok = this.tokenAt(coord);
        Region tokSource = tok.source;
        if (this.isOneToken()) {
            TLAExpr cloned = expr.cloneAndNormalize();
            if (tokSource != null) {
                cloned.firstToken().getBeginSubst().addAll(tok.getBeginSubst());
                cloned.firstToken().getBeginSubst().addElement(tokSource.getBegin());
                cloned.lastToken().getEndSubst().addAll(tok.getEndSubst());
                cloned.lastToken().getEndSubst().addElement(tokSource.getEnd());
            }
            this.tokens = cloned.tokens;
            this.anchorTokens = cloned.anchorTokens;
            this.anchorTokCol = cloned.anchorTokCol;
            return null;
        }
        Vector tokLine = (Vector)this.tokens.elementAt(coord.one);
        int spaces = 0;
        if (coord.two + 1 < tokLine.size()) {
            TLAToken nextTok = (TLAToken)tokLine.elementAt(coord.two + 1);
            spaces = nextTok.column - (tok.column + tok.getWidth());
        }
        Vector restOfLine = new Vector();
        while (coord.two + 1 < tokLine.size()) {
            restOfLine.add(tokLine.elementAt(coord.two + 1));
            tokLine.remove(coord.two + 1);
        }
        int curLine = coord.one;
        Vector line = (Vector)this.tokens.elementAt(curLine);
        if (expr.tokens.size() == 1 && ((Vector)expr.tokens.elementAt(0)).size() == 1) {
            TLAToken etok = (TLAToken)((Vector)expr.tokens.elementAt(0)).elementAt(0);
            tok.string = etok.string;
            tok.type = etok.type;
            tok.source = etok.source;
            if (tokSource != null) {
                tok.getBeginSubst().addElement(tokSource.getBegin());
                tok.getEndSubst().addElement(tokSource.getEnd());
            }
            tok.getBeginSubst().addAll(etok.getBeginSubst());
            tok.getEndSubst().addAll(etok.getEndSubst());
        } else {
            int indent2 = (par ? 1 : 0) + tok.column;
            boolean doInsert = true;
            if (par) {
                tok.string = "(";
                tok.type = 1;
                doInsert = false;
                tok.source = null;
                if (tokSource != null) {
                    tok.getBeginSubst().addElement(tokSource.getBegin());
                }
            }
            int i = 0;
            TLAExpr newExpr = expr.cloneAndNormalize();
            if (!par && tokSource != null) {
                newExpr.firstToken().getBeginSubst().addElement(tokSource.getBegin());
                newExpr.lastToken().getEndSubst().addElement(tokSource.getEnd());
            }
            while (i < newExpr.tokens.size()) {
                Vector eline = (Vector)newExpr.tokens.elementAt(i);
                for (int j = 0; j < eline.size(); ++j) {
                    TLAToken nextTok = (TLAToken)eline.elementAt(j);
                    nextTok.column += indent2;
                    if (doInsert) {
                        tok.string = nextTok.string;
                        tok.type = nextTok.type;
                        tok.getBeginSubst().addAll(nextTok.getBeginSubst());
                        newExpr.lastToken().getEndSubst().addAll(tok.getEndSubst());
                        tok.setEndSubst(nextTok.getEndSubst());
                        doInsert = false;
                        continue;
                    }
                    line.add(nextTok);
                }
                if (++i >= newExpr.tokens.size()) continue;
                indent2 = 0;
                this.tokens.insertElementAt(new Vector(), ++curLine);
                line = (Vector)this.tokens.elementAt(curLine);
                TLAToken[] aTok = new TLAToken[this.tokens.size()];
                int[] aTCol = new int[this.tokens.size()];
                for (int k = 0; k < this.tokens.size(); ++k) {
                    if (k < curLine) {
                        aTok[k] = this.anchorTokens[k];
                        aTCol[k] = this.anchorTokCol[k];
                        continue;
                    }
                    if (k == curLine) {
                        aTok[k] = newExpr.anchorTokens[i];
                        aTCol[k] = newExpr.anchorTokCol[i];
                        continue;
                    }
                    aTok[k] = this.anchorTokens[k - 1];
                    aTCol[k] = this.anchorTokCol[k - 1];
                }
                this.anchorTokens = aTok;
                this.anchorTokCol = aTCol;
            }
            TLAToken lastTok = (TLAToken)line.elementAt(line.size() - 1);
            int nextTokColumn = lastTok.column + lastTok.getWidth();
            if (par) {
                TLAToken rParen = new TLAToken(")", lastTok.column + lastTok.getWidth(), 1);
                rParen.setEndSubst(tok.getEndSubst());
                if (tokSource != null) {
                    rParen.getEndSubst().addElement(tokSource.getEnd());
                }
                tok.setEndSubst(new Vector(2));
                line.add(rParen);
                ++nextTokColumn;
            }
        }
        IntPair result = new IntPair(curLine, line.size() - 1);
        if (restOfLine.size() > 0) {
            TLAToken prevTok = (TLAToken)line.elementAt(line.size() - 1);
            TLAToken firstTok = (TLAToken)restOfLine.elementAt(0);
            int indent3 = prevTok.column + prevTok.getWidth() + spaces - firstTok.column;
            for (int i = 0; i < restOfLine.size(); ++i) {
                TLAToken oldTok = (TLAToken)restOfLine.elementAt(i);
                oldTok.column += indent3;
                line.add(oldTok);
            }
        }
        this.renormalize();
        return this.stepCoord(result, 1);
    }

    public IntPair findNextInstanceIn(String id, IntPair start) {
        IntPair result = new IntPair(start.one, start.two);
        if (this.isEmpty()) {
            result = null;
        }
        while (result != null) {
            TLAToken tok = this.tokenAt(result);
            if (tok.type == 3) {
                result = this.stepCoord(result, 1);
                continue;
            }
            if (tok.string.equals(".")) {
                result = this.stepCoord(result, 2);
                continue;
            }
            if ((tok.string.equals("[") || tok.string.equals(",")) && this.stepCoord(result, 2) != null && this.tokenAt((IntPair)this.stepCoord((IntPair)result, (int)2)).type != 3 && (this.tokenAt((IntPair)this.stepCoord((IntPair)result, (int)2)).string.equals(":") || this.tokenAt((IntPair)this.stepCoord((IntPair)result, (int)2)).string.equals("|->"))) {
                result = this.stepCoord(result, 3);
                continue;
            }
            if (tok.string.equals(id)) {
                return result;
            }
            result = this.stepCoord(result, 1);
        }
        return null;
    }

    public TLAToken tokenAt(IntPair coord) {
        return (TLAToken)((Vector)this.tokens.elementAt(coord.one)).elementAt(coord.two);
    }

    public IntPair stepCoord(IntPair coord, int incr) {
        Vector line;
        if (this.tokens.size() <= coord.one) {
            PcalDebug.ReportBug("TLAExpr.StepCoord called with line too big");
        }
        if ((line = (Vector)this.tokens.elementAt(coord.one)).size() <= coord.two) {
            PcalDebug.ReportBug("TLAExpr.StepCoord called with col too big");
        }
        IntPair result = new IntPair(coord.one, coord.two);
        for (int i = 0; i < incr; ++i) {
            ++result.two;
            if (line.size() != result.two) continue;
            result.two = 0;
            ++result.one;
            while (result.one < this.tokens.size() && ((Vector)this.tokens.elementAt(result.one)).size() == 0) {
                ++result.one;
            }
            if (result.one == this.tokens.size()) {
                return null;
            }
            line = (Vector)this.tokens.elementAt(result.one);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.tokens == null || this.tokens.size() == 0;
    }

    public boolean isOneToken() {
        return !this.isEmpty() && this.tokens.size() == 1 && ((Vector)this.tokens.elementAt(0)).size() == 1;
    }

    public TLAToken firstToken() {
        Vector line = (Vector)this.tokens.elementAt(0);
        return (TLAToken)line.elementAt(0);
    }

    public TLAToken lastToken() {
        Vector line = (Vector)this.tokens.elementAt(this.tokens.size() - 1);
        return (TLAToken)line.elementAt(line.size() - 1);
    }

    private static String SpacesString(int n) {
        int i = 0;
        String result = "";
        if (i < 0) {
            PcalDebug.ReportBug("SpacesString called with negative argument");
        }
        while (i < n) {
            result = result + " ";
            ++i;
        }
        return result;
    }

    public void print(String name2) {
        PcalDebug.print2DVector(this.tokens, name2 + ".tokens");
        PcalDebug.printObjectArray(this.anchorTokens, name2 + ".anchorTokens");
        PcalDebug.printIntArray(this.anchorTokCol, name2 + ".anchorTokCol");
    }
}

