/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.exception.UnrecoverableException;
import pcal.exception.UnrecoverablePositionedException;
import util.ToolIO;

public class PcalDebug {
    public static final String UNRECOVERABLE_ERROR = "\nUnrecoverable error:\n -- ";
    public static final String WARNING = "Warning: ";
    public static final String ERROR_POSTFIX = ".\n";

    public static void reportError(UnrecoverableException e2) {
        if (e2 instanceof UnrecoverablePositionedException) {
            PcalDebug.reportError(e2.getMessage(), ((UnrecoverablePositionedException)e2).getPosition());
        } else {
            PcalDebug.reportError(e2.getMessage());
        }
    }

    public static void reportWarning(String warningText) {
        ToolIO.out.println(new StringBuffer(WARNING).append(warningText));
    }

    public static void reportInfo(String infoText) {
        ToolIO.out.println(infoText);
    }

    public static void reportError(String message) {
        ToolIO.out.println(new StringBuffer(UNRECOVERABLE_ERROR).append(message).append(ERROR_POSTFIX).toString());
    }

    public static void reportError(String message, AST ast) {
        if (ast == null || ast.line == 0) {
            PcalDebug.reportError(message);
        } else {
            PcalDebug.reportError(message + "\n    at " + ast.location());
        }
    }

    public static void Assert(boolean val2) {
        if (!val2) {
            PcalDebug.ReportBug("Assertion failure");
        }
    }

    public static void Assert(boolean val2, String msg) {
        if (!val2) {
            PcalDebug.ReportBug("Failure of assertion: " + msg);
        }
    }

    public static void ReportBug(String msg) {
        StringBuilder sb = new StringBuilder("You have discovered a bug in pcal.trans.\n");
        sb.append("Send the following information and the\ninput file to the current maintainer(s).\n\n -- ");
        sb.append(msg).append(".");
        ToolIO.out.println("");
        ToolIO.out.println(sb.toString());
        ToolIO.out.println("");
        throw new Error(sb.toString());
    }

    public static void printObjectArray(Object[] array2, String name2) {
        if (array2 == null) {
            ToolIO.out.println(name2 + " == null");
            return;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (array2[i] == null) {
                ToolIO.out.println(name2 + "[" + i + "] = null");
                continue;
            }
            ToolIO.out.println(name2 + "[" + i + "] = " + array2[i].toString());
        }
        if (array2.length == 0) {
            ToolIO.out.println(name2 + " = zero-length array");
        }
    }

    public static void printIntArray(int[] array2, String name2) {
        if (array2 == null) {
            ToolIO.out.println(name2 + " == null");
            return;
        }
        for (int i = 0; i < array2.length; ++i) {
            ToolIO.out.println(name2 + "[" + i + "] = " + array2[i]);
        }
        if (array2.length == 0) {
            ToolIO.out.println(name2 + " = zero-length array");
        }
    }

    public static void print2DArray(Object[][] array2, String name2) {
        if (array2 == null) {
            ToolIO.out.println(name2 + " == null");
            return;
        }
        for (int i = 0; i < array2.length; ++i) {
            for (int j = 0; j < array2[i].length; ++j) {
                ToolIO.out.println(name2 + "[" + i + "][" + j + "] = " + array2[i][j].toString());
            }
            if (array2[i].length != 0) continue;
            ToolIO.out.println(name2 + "[" + i + "] = null");
        }
        if (array2.length == 0) {
            ToolIO.out.println(name2 + " = zero-length array");
        }
    }

    public static void printVector(Vector vec2, String name2) {
        if (vec2 == null) {
            ToolIO.out.println(name2 + " == null");
            return;
        }
        for (int i = 0; i < vec2.size(); ++i) {
            if (vec2.elementAt(i) == null) {
                ToolIO.out.println(name2 + "[" + i + "] = null");
                continue;
            }
            ToolIO.out.println(name2 + "[" + i + "] = " + vec2.elementAt(i).toString());
        }
        if (vec2.size() == 0) {
            ToolIO.out.println(name2 + " = zero-length vec");
        }
    }

    public static void print2DVector(Vector vec2, String name2) {
        if (vec2 == null) {
            ToolIO.out.println(name2 + " == null");
            return;
        }
        for (int i = 0; i < vec2.size(); ++i) {
            if (vec2.elementAt(i) == null) {
                ToolIO.out.println(name2 + "[" + i + "] = null");
                continue;
            }
            PcalDebug.printVector((Vector)vec2.elementAt(i), name2 + "[" + i + "]");
        }
        if (vec2.size() == 0) {
            ToolIO.out.println(name2 + " = zero-length vec");
        }
    }

    public static String pair(int i, int j) {
        return "(" + i + ", " + j + ")";
    }

    public static void printPair(int i, int j) {
        ToolIO.out.println(PcalDebug.pair(i, j));
    }
}

