/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util.statistics;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.BooleanSupplier;

public abstract class CounterStatistic {
    public static CounterStatistic getInstance(BooleanSupplier s) {
        if (s.getAsBoolean()) {
            return new LongAdderCounterStatistic();
        }
        return new NoopCounterStatistic();
    }

    public abstract void increment();

    public abstract void add(long var1);

    public abstract long getCount();

    private CounterStatistic() {
    }

    /* synthetic */ CounterStatistic(CounterStatistic counterStatistic) {
        this();
    }

    private static class LongAdderCounterStatistic
    extends CounterStatistic {
        private final LongAdder adder = new LongAdder();

        private LongAdderCounterStatistic() {
            super(null);
        }

        @Override
        public final long getCount() {
            return this.adder.sum();
        }

        @Override
        public final void increment() {
            this.adder.increment();
        }

        @Override
        public void add(long evalCount) {
            this.adder.add(evalCount);
        }

        public String toString() {
            return this.adder.toString();
        }
    }

    private static class NoopCounterStatistic
    extends CounterStatistic {
        private NoopCounterStatistic() {
            super(null);
        }

        @Override
        public final long getCount() {
            return 0L;
        }

        @Override
        public final void increment() {
        }

        @Override
        public void add(long evalCount) {
        }
    }
}

