/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import org.junit.Test;
import tlc2.TLC;
import tlc2.TLCGlobals;

public class RunTwiceWireTest {
    @Test
    public void testModuleASTCacheClearing() throws Exception {
        System.out.println("\n=== MODULE AST CACHE CLEARING TEST ===\n");
        System.out.println("RUN 1 - Starting ModelWire1 (uses Wire1Invariant)...");
        int exitCode1 = RunTwiceWireTest.runTLC("test-model/ModelWire1.tla");
        System.out.println("RUN 1 - ModelWire1 completed with exit code: " + exitCode1);
        if (exitCode1 != 0) {
            throw new AssertionError((Object)("ModelWire1 should pass, but failed with exit code: " + exitCode1));
        }
        System.out.println("\u2713 RUN 1 - ModelWire1 PASSED\n");
        System.out.println("RUN 2 - Starting ModelWire2 WITHOUT reset (uses Wire2Invariant)...");
        System.out.println("        Expected: Should FAIL if bug exists (cache not cleared)");
        int exitCode2WithoutReset = RunTwiceWireTest.runTLC("test-model/ModelWire2.tla");
        System.out.println("RUN 2 - ModelWire2 completed with exit code: " + exitCode2WithoutReset);
        if (exitCode2WithoutReset != 0) {
            System.out.println("\u2713 RUN 2 - ModelWire2 FAILED without reset (bug reproduced!)");
            System.out.println("   This demonstrates the Module AST cache persistence bug\n");
        } else {
            System.out.println("\u26a0 RUN 2 - ModelWire2 PASSED without reset");
            System.out.println("   The bug may already be fixed, or the test needs adjustment\n");
        }
        System.out.println("RESET - Calling TLCGlobals.reset()...");
        TLCGlobals.reset();
        System.out.println("RESET - Module AST cache cleared (via ModuleASTCacheManager)\n");
        System.out.println("RUN 3 - Starting ModelWire2 WITH reset...");
        int exitCode3 = RunTwiceWireTest.runTLC("test-model/ModelWire2.tla");
        System.out.println("RUN 3 - ModelWire2 completed with exit code: " + exitCode3);
        if (exitCode3 != 0) {
            throw new AssertionError((Object)("ModelWire2 should pass after reset, but failed with exit code: " + exitCode3));
        }
        System.out.println("\u2713 RUN 3 - ModelWire2 PASSED after reset\n");
        System.out.println("=== VERIFICATION SUMMARY ===");
        System.out.println("RUN 1 - ModelWire1 (Wire1Invariant): PASSED");
        System.out.println("RUN 2 - ModelWire2 (Wire2Invariant) without reset: " + (exitCode2WithoutReset == 0 ? "PASSED (cache may be working)" : "FAILED (bug demonstrated)"));
        System.out.println("RESET - Cache cleared");
        System.out.println("RUN 3 - ModelWire2 (Wire2Invariant) with reset: PASSED");
        System.out.println("\n\u2713 TEST DEMONSTRATES: Module AST cache behavior");
        System.out.println("\u2713 TEST VERIFIES: TLCGlobals.reset() enables successful runs");
    }

    private static int runTLC(String modelPath) throws Exception {
        TLC tlc = new TLC();
        String[] args = new String[]{"-workers", "1", "-deadlock", "-metadir", "states/RunTwiceWireTest", modelPath};
        tlc.handleParameters(args);
        return tlc.process();
    }
}

