/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Random;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsOrRcdsValue;
import tlc2.value.impl.TLCVariable;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class SetOfFcnsValue
extends SetOfFcnsOrRcdsValue
implements Enumerable {
    public final Value domain;
    public final Value range;
    protected SetEnumValue fcnSet;

    public SetOfFcnsValue(Value domain, Value range) {
        this.domain = domain;
        this.range = range;
        this.fcnSet = null;
    }

    public SetOfFcnsValue(Value domain, Value range, CostModel cm) {
        this(domain, range);
        this.cm = cm;
    }

    @Override
    public final byte getKind() {
        return 13;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.fcnSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof SetOfFcnsValue) {
                SetOfFcnsValue fcns = (SetOfFcnsValue)obj;
                return this.domain.equals(fcns.domain) && this.range.equals(fcns.range);
            }
            this.convertAndCache();
            return this.fcnSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean member(Value elem) {
        try {
            FcnRcdValue fcn = (FcnRcdValue)elem.toFcnRcd();
            if (fcn == null) {
                if (elem instanceof ModelValue) {
                    return ((ModelValue)elem).modelValueMember(this);
                }
                Assert.fail("Attempted to check if \n" + elem + "\nwhich is not a TLC function" + " value, is in the set of functions:\n" + Values.ppr(this.toString()), this.getSource());
            }
            if (fcn.intv == null) {
                fcn.normalize();
                SetEnumValue fdom = new SetEnumValue(fcn.domain, true);
                if (this.domain.equals(fdom)) {
                    int i = 0;
                    while (i < fcn.values.length) {
                        if (!this.range.member(fcn.values[i])) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            } else if (fcn.intv.equals(this.domain)) {
                int i = 0;
                while (i < fcn.values.length) {
                    if (!this.range.member(fcn.values[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            return this.domain.isFinite() && this.range.isFinite();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set of functions:\n" + Values.ppr(this.toString()), this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set of functions:\n" + Values.ppr(this.toString()), this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            int dsz = this.domain.size();
            int rsz = this.range.size();
            long sz = 1L;
            int i = 0;
            while (i < dsz) {
                if ((sz *= (long)rsz) < Integer.MIN_VALUE || sz > Integer.MAX_VALUE) {
                    Assert.fail("Overflow when computing the number of elements in:\n" + Values.ppr(this.toString()), this.getSource());
                }
                ++i;
            }
            return (int)sz;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    protected boolean needBigInteger() {
        int rsz = this.range.size();
        int dsz = this.domain.size();
        long sz = 1L;
        int i = 0;
        while (i < dsz) {
            if ((sz *= (long)rsz) < Integer.MIN_VALUE || sz > Integer.MAX_VALUE) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public final boolean isNormalized() {
        try {
            if (this.fcnSet == null || this.fcnSet == SetEnumValue.DummyEnum) {
                return this.domain.isNormalized() && this.range.isNormalized();
            }
            return this.fcnSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.fcnSet == null || this.fcnSet == SetEnumValue.DummyEnum) {
                this.domain.normalize();
                this.range.normalize();
            } else {
                this.fcnSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            this.domain.deepNormalize();
            this.range.deepNormalize();
            if (this.fcnSet == null) {
                this.fcnSet = SetEnumValue.DummyEnum;
            } else if (this.fcnSet != SetEnumValue.DummyEnum) {
                this.fcnSet.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.domain.isDefined() && this.range.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.fcnSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.convertAndCache();
            return this.fcnSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final void convertAndCache() {
        if (this.fcnSet == null) {
            this.fcnSet = (SetEnumValue)this.toSetEnum();
        } else if (this.fcnSet == SetEnumValue.DummyEnum) {
            SetEnumValue val = (SetEnumValue)this.toSetEnum();
            val.deepNormalize();
            this.fcnSet = val;
        }
    }

    @Override
    public final Value toSetEnum() {
        Value elem;
        if (this.fcnSet != null && this.fcnSet != SetEnumValue.DummyEnum) {
            return this.fcnSet;
        }
        ValueVec vals = new ValueVec();
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, this.isNormalized(), this.cm);
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        this.fcnSet.write(vos);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            boolean unlazy = TLCGlobals.expand;
            try {
                if (unlazy) {
                    int dsz = this.domain.size();
                    int rsz = this.range.size();
                    long sz = 1L;
                    int i = 0;
                    while (i < dsz) {
                        if ((sz *= (long)rsz) < Integer.MIN_VALUE || sz > Integer.MAX_VALUE) {
                            unlazy = false;
                            break;
                        }
                        ++i;
                    }
                    unlazy = sz < (long)TLCGlobals.enumBound;
                }
            }
            catch (Throwable e) {
                if (swallow) {
                    unlazy = false;
                }
                throw e;
            }
            if (unlazy) {
                Value val = this.toSetEnum();
                return val.toString(sb, offset, swallow);
            }
            sb.append("[");
            this.domain.toString(sb, offset, swallow);
            sb.append(" -> ");
            this.range.toString(sb, offset, swallow);
            sb.append("]");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.fcnSet == null || this.fcnSet == SetEnumValue.DummyEnum) {
                if (this.domain instanceof IntervalValue) {
                    return new DomIVEnumerator();
                }
                return new Enumerator();
            }
            return this.fcnSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    protected SetOfFcnsOrRcdsValue.SubsetEnumerator getSubsetEnumerator(int k, int n) {
        return new SubsetEnumerator(k, n);
    }

    @Override
    protected SetOfFcnsOrRcdsValue.BigIntegerSubsetEnumerator getBigSubsetEnumerator(int k) {
        return new BigIntegerSubsetEnumerator(k);
    }

    @Override
    public TLCVariable toTLCVariable(TLCVariable variable, Random rnd) {
        return super.toTLCVariable(variable, rnd);
    }

    class BigIntegerSubsetEnumerator
    extends SetOfFcnsOrRcdsValue.BigIntegerSubsetEnumerator {
        private final SetEnumValue domSet;
        private final SetEnumValue rangeSet;
        private final BigInteger bMod;
        private final int mod;

        public BigIntegerSubsetEnumerator(int k) {
            super(k);
            this.domSet = (SetEnumValue)SetOfFcnsValue.this.domain.toSetEnum();
            this.domSet.normalize();
            this.rangeSet = (SetEnumValue)SetOfFcnsValue.this.range.toSetEnum();
            this.mod = SetOfFcnsValue.this.range.size();
            this.bMod = BigInteger.valueOf(this.mod);
            this.sz = this.bMod.pow(this.domSet.size());
        }

        @Override
        protected Value elementAt(BigInteger idx) {
            Value[] range = new Value[this.domSet.size()];
            int i = 0;
            while (i < this.domSet.size()) {
                long scale = (long)Math.pow(this.mod, i);
                BigInteger bScale = BigInteger.valueOf(scale);
                BigInteger idx2 = idx.divide(bScale);
                int elementAt = idx2.mod(this.bMod).intValueExact();
                range[range.length - 1 - i] = this.rangeSet.elems.elementAt(elementAt);
                ++i;
            }
            return new FcnRcdValue(this.domSet.elems, range, true);
        }
    }

    final class DomIVEnumerator
    implements ValueEnumeration {
        protected ValueEnumeration[] enums;
        protected Value[] currentElems;
        protected boolean isDone = false;

        public DomIVEnumerator() {
            int sz = SetOfFcnsValue.this.domain.size();
            if (SetOfFcnsValue.this.range instanceof Enumerable) {
                this.enums = new ValueEnumeration[sz];
                this.currentElems = new Value[sz];
                int i = 0;
                while (i < sz) {
                    this.enums[i] = ((Enumerable)((Object)SetOfFcnsValue.this.range)).elements();
                    this.currentElems[i] = this.enums[i].nextElement();
                    if (this.currentElems[i] == null) {
                        this.enums = null;
                        this.isDone = true;
                        break;
                    }
                    ++i;
                }
            } else {
                Assert.fail("Attempted to enumerate a set of the form [D -> R],but the range R:\n" + Values.ppr(SetOfFcnsValue.this.range.toString()) + "\ncannot be enumerated.", SetOfFcnsValue.this.getSource());
            }
        }

        @Override
        public final void reset() {
            if (this.enums != null) {
                int i = 0;
                while (i < this.enums.length) {
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                    ++i;
                }
                this.isDone = false;
            }
        }

        @Override
        public final Value nextElement() {
            if (this.isDone) {
                return null;
            }
            if (this.currentElems.length == 0) {
                if (coverage) {
                    SetOfFcnsValue.this.cm.incSecondary();
                }
                this.isDone = true;
                return new FcnRcdValue((IntervalValue)SetOfFcnsValue.this.domain, new Value[this.currentElems.length], SetOfFcnsValue.this.cm);
            }
            Value[] elems = new Value[this.currentElems.length];
            System.arraycopy(this.currentElems, 0, elems, 0, this.currentElems.length);
            if (coverage) {
                SetOfFcnsValue.this.cm.incSecondary(this.currentElems.length);
            }
            int i = this.currentElems.length - 1;
            while (i >= 0) {
                this.currentElems[i] = this.enums[i].nextElement();
                if (this.currentElems[i] != null) break;
                if (i == 0) {
                    this.isDone = true;
                    break;
                }
                this.enums[i].reset();
                this.currentElems[i] = this.enums[i].nextElement();
                --i;
            }
            return new FcnRcdValue((IntervalValue)SetOfFcnsValue.this.domain, elems, SetOfFcnsValue.this.cm);
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        private Value[] dom;
        private ValueEnumeration[] enums;
        private Value[] currentElems;
        private boolean isDone = false;

        public Enumerator() {
            SetEnumValue domSet = (SetEnumValue)SetOfFcnsValue.this.domain.toSetEnum();
            if (domSet == null) {
                Assert.fail("Attempted to enumerate a set of the form [D -> R],but the domain D:\n" + Values.ppr(SetOfFcnsValue.this.domain.toString()) + "\ncannot be enumerated.", SetOfFcnsValue.this.getSource());
            }
            domSet.normalize();
            ValueVec elems = domSet.elems;
            int sz = elems.size();
            if (SetOfFcnsValue.this.range instanceof Enumerable) {
                this.dom = new Value[sz];
                this.enums = new ValueEnumeration[sz];
                this.currentElems = new Value[sz];
                int i = 0;
                while (i < sz) {
                    this.dom[i] = elems.elementAt(i);
                    this.enums[i] = ((Enumerable)((Object)SetOfFcnsValue.this.range)).elements();
                    this.currentElems[i] = this.enums[i].nextElement();
                    if (this.currentElems[i] == null) {
                        this.enums = null;
                        this.isDone = true;
                        break;
                    }
                    ++i;
                }
            } else {
                Assert.fail("Attempted to enumerate a set of the form [D -> R],but the range R:\n" + Values.ppr(SetOfFcnsValue.this.range.toString()) + "\ncannot be enumerated.", SetOfFcnsValue.this.getSource());
            }
        }

        @Override
        public final void reset() {
            if (this.enums != null) {
                int i = 0;
                while (i < this.enums.length) {
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                    ++i;
                }
                this.isDone = false;
            }
        }

        @Override
        public final Value nextElement() {
            if (this.isDone) {
                return null;
            }
            if (this.currentElems.length == 0) {
                if (coverage) {
                    SetOfFcnsValue.this.cm.incSecondary();
                }
                this.isDone = true;
                return new FcnRcdValue(this.dom, new Value[this.currentElems.length], true, SetOfFcnsValue.this.cm);
            }
            Value[] elems = new Value[this.currentElems.length];
            System.arraycopy(this.currentElems, 0, elems, 0, this.currentElems.length);
            if (coverage) {
                SetOfFcnsValue.this.cm.incSecondary(this.currentElems.length);
            }
            int i = this.currentElems.length - 1;
            while (i >= 0) {
                this.currentElems[i] = this.enums[i].nextElement();
                if (this.currentElems[i] != null) break;
                if (i == 0) {
                    this.isDone = true;
                    break;
                }
                this.enums[i].reset();
                this.currentElems[i] = this.enums[i].nextElement();
                --i;
            }
            return new FcnRcdValue(this.dom, elems, true, SetOfFcnsValue.this.cm);
        }
    }

    class SubsetEnumerator
    extends SetOfFcnsOrRcdsValue.SubsetEnumerator {
        private final SetEnumValue domSet;
        private final SetEnumValue rangeSet;
        private final int mod;

        SubsetEnumerator(int k, int n) {
            super(k, n);
            this.domSet = (SetEnumValue)SetOfFcnsValue.this.domain.toSetEnum();
            this.domSet.normalize();
            this.rangeSet = (SetEnumValue)SetOfFcnsValue.this.range.toSetEnum();
            this.mod = SetOfFcnsValue.this.range.size();
        }

        @Override
        protected Value elementAt(int idx) {
            assert (idx >= 0 && idx < SetOfFcnsValue.this.size());
            Value[] range = new Value[this.domSet.size()];
            int i = 0;
            while (i < this.domSet.size()) {
                int elementAt = (int)(Math.floor((double)idx / Math.pow(this.mod, i)) % (double)this.mod);
                range[range.length - 1 - i] = this.rangeSet.elems.elementAt(elementAt);
                ++i;
            }
            return new FcnRcdValue(this.domSet.elems, range, true);
        }
    }
}

