/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import java.io.IOException;
import java.io.Writer;
import tlc2.module.AnySet;
import tlc2.output.MP;
import tlc2.tool.EvalException;
import tlc2.tool.impl.TLARegistry;
import tlc2.value.IBoolValue;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsValue;
import tlc2.value.impl.SetOfRcdsValue;
import tlc2.value.impl.SetOfTuplesValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueVec;
import util.Assert;
import util.ToolIO;

public class TLC
implements ValueConstants {
    public static final long serialVersionUID = 20160822L;
    public static Writer OUTPUT;

    static {
        Assert.check(TLARegistry.put("MakeFcn", ":>") == null, 2131, "MakeFcn");
        Assert.check(TLARegistry.put("CombineFcn", "@@") == null, 2131, "CombineFcn");
    }

    public static Value Print(Value v1, Value v2) {
        Value v1c = (Value)v1.deepCopy();
        Value v2c = (Value)v2.deepCopy();
        v1c.deepNormalize();
        v2c.deepNormalize();
        if (OUTPUT == null) {
            ToolIO.out.println(String.valueOf(Values.ppr(v1c.toStringUnchecked())) + "  " + Values.ppr(v2c.toStringUnchecked()));
        } else {
            try {
                OUTPUT.write(String.valueOf(Values.ppr(v1c.toStringUnchecked())) + "  " + Values.ppr(v2c.toStringUnchecked()) + "\n");
            }
            catch (IOException e) {
                MP.printError(1000, e);
            }
        }
        return v2;
    }

    public static Value PrintT(Value v1) {
        Value v1c = (Value)v1.deepCopy();
        v1c.deepNormalize();
        if (OUTPUT == null) {
            String ppr = Values.ppr(v1c.toStringUnchecked());
            ToolIO.out.println(ppr);
        } else {
            try {
                OUTPUT.write(Values.ppr(v1c.toStringUnchecked("\n")));
            }
            catch (IOException e) {
                MP.printError(1000, e);
            }
        }
        return BoolValue.ValTrue;
    }

    public static Value ToString(Value v) {
        return new StringValue(v.toStringUnchecked());
    }

    public static Value Assert(Value v1, Value v2) {
        if (v1 instanceof IBoolValue && ((BoolValue)v1).val) {
            return v1;
        }
        throw new EvalException(2132, Values.ppr(v2.toString()));
    }

    public static Value JavaTime() {
        int t = (int)(System.currentTimeMillis() / 1000L);
        return IntValue.gen(t & Integer.MAX_VALUE);
    }

    public static Value MakeFcn(Value d, Value e) {
        Value[] dom = new Value[1];
        Value[] vals = new Value[1];
        dom[0] = d;
        vals[0] = e;
        return new FcnRcdValue(dom, vals, true);
    }

    public static Value CombineFcn(Value f1, Value f2) {
        FcnRcdValue fcn1 = (FcnRcdValue)f1.toFcnRcd();
        FcnRcdValue fcn2 = (FcnRcdValue)f2.toFcnRcd();
        if (fcn1 == null) {
            throw new EvalException(2169, new String[]{"first", "@@", "function", Values.ppr(f1.toString())});
        }
        if (fcn2 == null) {
            throw new EvalException(2169, new String[]{"second", "@@", "function", Values.ppr(f2.toString())});
        }
        ValueVec dom = new ValueVec();
        ValueVec vals = new ValueVec();
        Value[] vals1 = fcn1.values;
        Value[] vals2 = fcn2.values;
        Value[] dom1 = fcn1.domain;
        if (dom1 == null) {
            IntervalValue intv1 = fcn1.intv;
            int i = intv1.low;
            while (i <= intv1.high) {
                dom.addElement(IntValue.gen(i));
                vals.addElement(vals1[i - intv1.low]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < dom1.length) {
                dom.addElement(dom1[i]);
                vals.addElement(vals1[i]);
                ++i;
            }
        }
        int len1 = dom.size();
        Value[] dom2 = fcn2.domain;
        if (dom2 == null) {
            IntervalValue intv2 = fcn2.intv;
            int i = intv2.low;
            while (i <= intv2.high) {
                IntValue val = IntValue.gen(i);
                boolean found = false;
                int j = 0;
                while (j < len1) {
                    if (((Object)val).equals(dom.elementAt(j))) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    dom.addElement(val);
                    vals.addElement(vals2[i - intv2.low]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < dom2.length) {
                Value val = dom2[i];
                boolean found = false;
                int j = 0;
                while (j < len1) {
                    if (val.equals(dom.elementAt(j))) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    dom.addElement(val);
                    vals.addElement(vals2[i]);
                }
                ++i;
            }
        }
        Value[] domain = new Value[dom.size()];
        Value[] values = new Value[dom.size()];
        int i = 0;
        while (i < domain.length) {
            domain[i] = dom.elementAt(i);
            values[i] = vals.elementAt(i);
            ++i;
        }
        return new FcnRcdValue(domain, values, false);
    }

    public static Value SortSeq(Value s, Value cmp) {
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq == null) {
            throw new EvalException(2169, new String[]{"first", "SortSeq", "natural number", Values.ppr(s.toString())});
        }
        if (!(cmp instanceof OpValue)) {
            throw new EvalException(2169, new String[]{"second", "SortSeq", "operator", Values.ppr(cmp.toString())});
        }
        OpValue fcmp = (OpValue)cmp;
        Value[] elems = seq.elems;
        int len = elems.length;
        if (len == 0) {
            return seq;
        }
        Value[] args = new Value[2];
        Value[] newElems = new Value[len];
        newElems[0] = elems[0];
        int i = 1;
        while (i < len) {
            int j = i;
            args[0] = elems[i];
            args[1] = newElems[j - 1];
            while (TLC.compare(fcmp, args)) {
                newElems[j] = newElems[j - 1];
                if (--j == 0) break;
                args[1] = newElems[j - 1];
            }
            newElems[j] = args[0];
            ++i;
        }
        return new TupleValue(newElems);
    }

    private static boolean compare(OpValue fcmp, Value[] args) {
        Value res = fcmp.eval(args, 0);
        if (res instanceof IBoolValue) {
            return ((BoolValue)res).val;
        }
        throw new EvalException(2169, new String[]{"second", "SortSeq", "boolean function", Values.ppr(res.toString())});
    }

    public static Value Permutations(Value s) {
        SetEnumValue s1 = (SetEnumValue)s.toSetEnum();
        if (s1 == null) {
            throw new EvalException(2176, new String[]{"Permutations", "a finite set", Values.ppr(s.toString())});
        }
        s1.normalize();
        ValueVec elems = s1.elems;
        int len = elems.size();
        if (len == 0) {
            Value[] elems1 = new Value[]{FcnRcdValue.EmptyFcn};
            return new SetEnumValue(elems1, true);
        }
        int factorial = 1;
        Value[] domain = new Value[len];
        int[] idxArray = new int[len];
        boolean[] inUse = new boolean[len];
        int i = 0;
        while (i < len) {
            domain[i] = elems.elementAt(i);
            idxArray[i] = i;
            inUse[i] = true;
            factorial *= i + 1;
            ++i;
        }
        ValueVec fcns = new ValueVec(factorial);
        block1: while (true) {
            Value[] vals = new Value[len];
            int i2 = 0;
            while (i2 < len) {
                vals[i2] = domain[idxArray[i2]];
                ++i2;
            }
            fcns.addElement(new FcnRcdValue(domain, vals, true));
            i2 = len - 1;
            while (i2 >= 0) {
                boolean found = false;
                int j = idxArray[i2] + 1;
                while (j < len) {
                    if (!inUse[j]) {
                        inUse[j] = true;
                        inUse[idxArray[i2]] = false;
                        idxArray[i2] = j;
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (found) break;
                if (i2 == 0) break block1;
                inUse[idxArray[i2]] = false;
                --i2;
            }
            int j = i2 + 1;
            while (true) {
                if (j >= len) continue block1;
                int k = 0;
                while (k < len) {
                    if (!inUse[k]) {
                        inUse[k] = true;
                        idxArray[j] = k;
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            break;
        }
        return new SetEnumValue(fcns, false);
    }

    public static Value RandomElement(Value val) {
        switch (val.getKind()) {
            case 13: {
                SetOfFcnsValue sfv = (SetOfFcnsValue)val;
                sfv.normalize();
                SetEnumValue domSet = (SetEnumValue)sfv.domain.toSetEnum();
                if (domSet == null) {
                    throw new EvalException(2176, new String[]{"RandomElement", "a finite set", Values.ppr(val.toString())});
                }
                domSet.normalize();
                ValueVec elems = domSet.elems;
                Value[] dom = new Value[elems.size()];
                Value[] vals = new Value[elems.size()];
                int i = 0;
                while (i < dom.length) {
                    dom[i] = elems.elementAt(i);
                    vals[i] = TLC.RandomElement(sfv.range);
                    ++i;
                }
                return new FcnRcdValue(dom, vals, true);
            }
            case 14: {
                SetOfRcdsValue srv = (SetOfRcdsValue)val;
                srv.normalize();
                Value[] vals = new Value[srv.names.length];
                int i = 0;
                while (i < vals.length) {
                    vals[i] = TLC.RandomElement(srv.values[i]);
                    ++i;
                }
                return new RecordValue(srv.names, vals, true);
            }
            case 15: {
                SetOfTuplesValue stv = (SetOfTuplesValue)val;
                stv.normalize();
                Value[] vals = new Value[stv.sets.length];
                int i = 0;
                while (i < vals.length) {
                    vals[i] = TLC.RandomElement(stv.sets[i]);
                    ++i;
                }
                return new TupleValue(vals);
            }
            case 23: {
                IntervalValue iv = (IntervalValue)val;
                return iv.randomElement();
            }
        }
        SetEnumValue enumVal = (SetEnumValue)val.toSetEnum();
        if (enumVal == null) {
            throw new EvalException(2176, new String[]{"RandomElement", "a finite set", Values.ppr(val.toString())});
        }
        return enumVal.randomElement();
    }

    public static Value Any() {
        return AnySet.ANY();
    }
}

