/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.utilities;

import java.util.Enumeration;
import tla2sany.utilities.VectorEnumeration;

public class Vector<E> {
    static int defaultSize = 10;
    protected Object[] info;
    protected int size = 0;
    protected int capacity;
    protected int increment;

    public Vector() {
        this.info = new Object[defaultSize];
        this.capacity = defaultSize;
        this.increment = defaultSize;
    }

    public Vector(int initialSize) {
        this.info = new Object[initialSize];
        this.capacity = initialSize;
        this.increment = initialSize;
    }

    public final int size() {
        return this.size;
    }

    public final void addElement(E obj) {
        if (this.size == this.capacity) {
            Object[] next2 = new Object[this.capacity + this.increment];
            System.arraycopy(this.info, 0, next2, 0, this.capacity);
            this.capacity += this.increment;
            this.info = next2;
        }
        this.info[this.size] = obj;
        ++this.size;
    }

    public final E firstElement() {
        return (E)this.info[0];
    }

    public final E lastElement() {
        return (E)this.info[this.size - 1];
    }

    public final E elementAt(int i) {
        if (i < 0 || i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (E)this.info[i];
    }

    public final void removeAllElements() {
        for (int lvi = 0; lvi < this.size; ++lvi) {
            this.info[lvi] = null;
        }
        this.size = 0;
    }

    public final void removeElementAt(int i) {
        if (i < 0 || i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int lvi = i + 1; lvi < this.size; ++lvi) {
            this.info[lvi - 1] = this.info[lvi];
        }
        --this.size;
        this.info[this.size] = null;
    }

    public final void insertElementAt(E obj, int i) {
        if (i < 0 || i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.size == this.capacity) {
            Object[] next2 = new Object[this.capacity + this.increment];
            System.arraycopy(this.info, 0, next2, 0, i);
            next2[i] = obj;
            System.arraycopy(this.info, i, next2, i + 1, this.capacity - i);
            this.capacity += this.increment;
            this.info = next2;
        } else {
            for (int lvi = this.size; lvi > i; --lvi) {
                this.info[lvi] = this.info[lvi - 1];
            }
            this.info[i] = obj;
        }
        ++this.size;
    }

    public final void setElementAt(E obj, int i) {
        if (i < 0 || i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.info[i] = obj;
    }

    public final boolean contains(E obj) {
        for (int i = 0; i < this.size; ++i) {
            if (this.info[i] != obj) continue;
            return true;
        }
        return false;
    }

    public final Enumeration<E> elements() {
        return new VectorEnumeration(this.info, this.size);
    }

    public final void append(Vector<E> v) {
        if (v.size + this.size > this.capacity) {
            Object[] neo = new Object[this.capacity + v.capacity];
            this.capacity += v.capacity;
            System.arraycopy(this.info, 0, neo, 0, this.size);
            this.info = neo;
        }
        System.arraycopy(v.info, 0, this.info, this.size, v.size);
        this.size += v.size;
    }

    public final void appendNoRepeats(Vector<E> v) {
        for (int i = 0; i < v.size(); ++i) {
            if (this.contains(v.elementAt(i))) continue;
            this.addElement(v.elementAt(i));
        }
    }

    public final String toString() {
        String ret = "[ ";
        if (this.size() > 0) {
            ret = ret + this.elementAt(0).toString();
        }
        for (int i = 1; i < this.size(); ++i) {
            ret = ret + ", " + this.elementAt(i).toString();
        }
        return ret + " ]";
    }
}

